/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.zip;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import jpos.PosUtils;
import jpos.SP;
import jpos.pay.PayDialog;
import jpos.pay.zip.ZipPay;
import jpos.pay.zip.ZipPayTran;
import jpos.pay.zip.ZipStatus;
import jpos.ui.LabelSubHeading;

public class DlgWaitingForConfirmation
extends JDialog {
    protected JPanel panelAll = new JPanel();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private LabelSubHeading lWaitingForConfirmation = new LabelSubHeading();
    private LabelSubHeading lCountdown = new LabelSubHeading();
    protected boolean result = false;
    int kedCount = 0;
    protected static final int PAD0 = 0;
    protected static final int PAD1 = 5;
    protected static final int PAD2 = 10;
    protected static final int PAD3 = 20;
    Component initComp;
    private Timer timer;
    private int timeOutSecs = 60;
    ZipPay zipPay;
    ZipPayTran zipTran;
    ReentrantLock lock = new ReentrantLock();
    StringBuilder retMessage = new StringBuilder();
    PollingRunnable polling;

    public DlgWaitingForConfirmation(PayDialog parent, String title, ZipPayTran zipTran) {
        super(parent, title, true);
        this.zipPay = SP.sParams.getZipPay();
        this.zipTran = zipTran;
        try {
            this.jbInit();
            this.pack();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() {
        this.panelAll.setLayout(this.gridBagLayout1);
        this.lWaitingForConfirmation.setText(SP.getRS("zippay_waiting_for_confirmation"));
        this.lCountdown.setText(String.valueOf(this.timeOutSecs));
        this.getContentPane().add(this.panelAll);
        this.panelAll.add((Component)this.lWaitingForConfirmation, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 20, 5, 20), 0, 0));
        this.panelAll.add((Component)this.lCountdown, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 20, 5, 20), 0, 0));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DlgWaitingForConfirmation.this.cancelDialog();
            }

            @Override
            public void windowActivated(WindowEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DlgWaitingForConfirmation.this.timer = new Timer();
                        DlgWaitingForConfirmation.this.timer.schedule(new TimerTask(){

                            @Override
                            public void run() {
                                DlgWaitingForConfirmation.this.lCountdown.setText(String.valueOf(DlgWaitingForConfirmation.this.timeOutSecs));
                                DlgWaitingForConfirmation.this.getContentPane().repaint();
                                if (DlgWaitingForConfirmation.this.timeOutSecs > 0) {
                                    DlgWaitingForConfirmation.this.timeOutSecs--;
                                }
                                if (DlgWaitingForConfirmation.this.polling != null && DlgWaitingForConfirmation.this.polling.finished) {
                                    DlgWaitingForConfirmation.this.lock.lock();
                                    try {
                                        if (DlgWaitingForConfirmation.this.zipTran.getZipStatus() != ZipStatus.Pending) {
                                            DlgWaitingForConfirmation.this.timer.cancel();
                                            if (DlgWaitingForConfirmation.this.zipTran.getZipStatus() == ZipStatus.Approved) {
                                                DlgWaitingForConfirmation.this.okDialog();
                                            } else {
                                                DlgWaitingForConfirmation.this.cancelDialog();
                                            }
                                            return;
                                        }
                                    }
                                    finally {
                                        DlgWaitingForConfirmation.this.lock.unlock();
                                    }
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        DlgWaitingForConfirmation.this.startPolling();
                                    }
                                });
                            }
                        }, 0L, 1000L);
                    }
                });
            }
        });
    }

    @Override
    public void dispose() {
        super.dispose();
    }

    @Override
    public void setVisible(boolean visible) {
        this.setLocationRelativeTo(null);
        super.setVisible(visible);
    }

    public void cancelDialog() {
        if (this.timer != null) {
            this.timer.cancel();
        }
        this.lock.lock();
        try {
            if (this.polling != null) {
                this.polling.enabled = false;
            }
            if (this.zipTran.getZipStatus() != ZipStatus.Cancelled && this.zipTran.getZipStatus() != ZipStatus.Expired && this.zipTran.getZipStatus() != ZipStatus.Declined) {
                StringBuilder processMsg = new StringBuilder();
                try {
                    this.zipPay.ReversePaymentRequest(this.zipTran, processMsg);
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        this.result = false;
        this.setVisible(false);
    }

    public void okDialog() {
        this.result = true;
        this.setVisible(false);
    }

    public boolean getResult() {
        return this.result;
    }

    private void startPolling() {
        if (this.zipTran.getZipStatus() == ZipStatus.Pending) {
            if (this.polling == null) {
                this.polling = new PollingRunnable();
            }
            if (this.polling.finished && this.polling.enabled) {
                new Thread(this.polling).start();
            }
        }
    }

    public String getPollingMessage() {
        return this.retMessage.toString();
    }

    public class PollingRunnable
    implements Runnable {
        boolean enabled = true;
        boolean finished = true;

        @Override
        public void run() {
            if (this.enabled) {
                DlgWaitingForConfirmation.this.lock.lock();
                try {
                    this.finished = false;
                    DlgWaitingForConfirmation.this.retMessage.setLength(0);
                    DlgWaitingForConfirmation.this.zipPay.PollRequestStatus(DlgWaitingForConfirmation.this.zipTran, DlgWaitingForConfirmation.this.retMessage);
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
                finally {
                    this.finished = true;
                    DlgWaitingForConfirmation.this.lock.unlock();
                }
            }
        }
    }
}

