/*
 * Decompiled with CFR 0.152.
 */
package jpos.pay.zip;

import JCP.JcpApi;
import JCP.JcpRequestResult;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.annotations.SerializedName;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.logging.RollingLog;
import jpos.pay.RetTranP;
import jpos.pay.zip.Order;
import jpos.pay.zip.ZipPayTran;
import jpos.pay.zip.ZipStatus;

public class ZipPay {
    StoreParams sParams;
    String apiUrl;
    String apiKey;
    String locationId;

    public ZipPay(StoreParams sParams, String apiUrl, String apiKey, String locationId) {
        this.sParams = sParams;
        this.apiUrl = apiUrl;
        this.apiKey = apiKey;
        this.locationId = locationId;
    }

    public boolean RequestPayment(RetTranP retTranP, StringBuilder processMsg) throws Exception {
        long vhidx = 0L;
        if (retTranP.vhIdx.isNotNull()) {
            vhidx = retTranP.vhIdx.longValue();
        }
        ZipPayTran zipTran = (ZipPayTran)retTranP.getETran();
        PaymentRequest paymentRequest = new PaymentRequest(this.apiUrl, this.apiKey, this.locationId, vhidx, zipTran.getOrder(), zipTran.getSalesRepName(), retTranP.getAmount(), zipTran.getShopInStoreCode());
        this.saveRequest(paymentRequest);
        RollingLog.log(RollingLog.LogType.ZIP, Level.INFO, "Zip Payment Request" + System.lineSeparator() + this.requestLogging(paymentRequest));
        zipTran.setReference(paymentRequest.TranReference);
        Gson json = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();
        String resultJson = ZipPay.processReqeustViaProvider(paymentRequest.requestType, json.toJson((Object)paymentRequest));
        PaymentResult paymentResult = (PaymentResult)json.fromJson(resultJson, PaymentResult.class);
        paymentResult.tranReference = paymentRequest.TranReference;
        if (paymentResult.status != null) {
            zipTran.setZipStatus(paymentResult.status);
        }
        RollingLog.log(RollingLog.LogType.ZIP, Level.INFO, "Zip Payment Result" + System.lineSeparator() + this.resultLogging(paymentResult));
        this.updateResponse(paymentResult);
        if (paymentResult.status == ZipStatus.Pending) {
            zipTran.setStan(String.valueOf(paymentResult.PaymentId));
            return true;
        }
        if (paymentResult.ErrorMessage != null && !paymentResult.ErrorMessage.isEmpty()) {
            processMsg.append(paymentResult.ErrorMessage);
            processMsg.append("\r\n");
        }
        if (paymentResult.ErrorDetails != null && !paymentResult.ErrorMessage.isEmpty()) {
            processMsg.append(paymentResult.ErrorDetails);
        }
        return false;
    }

    public ZipStatus PollRequestStatus(ZipPayTran zipTran, StringBuilder processMsg) throws Exception {
        Gson json = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();
        PollingRequest pollingRequest = new PollingRequest(this.apiUrl, this.apiKey, Long.parseLong(zipTran.getStan()));
        RollingLog.log(RollingLog.LogType.ZIP, Level.INFO, "Zip Poll Payment Request" + System.lineSeparator() + this.requestLogging(pollingRequest));
        String resultJson = ZipPay.processReqeustViaProvider(pollingRequest.requestType, json.toJson((Object)pollingRequest));
        PollingResult pollingResult = (PollingResult)json.fromJson(resultJson, PollingResult.class);
        pollingResult.tranReference = zipTran.getReference();
        if (pollingResult.status != null) {
            zipTran.setZipStatus(pollingResult.status);
        }
        RollingLog.log(RollingLog.LogType.ZIP, Level.INFO, "Zip Poll Payment Result" + System.lineSeparator() + this.resultLogging(pollingResult));
        this.updateResponse(pollingResult);
        this.SetProcessMessage(processMsg, pollingResult);
        return pollingResult.status;
    }

    public boolean ReversePaymentRequest(ZipPayTran zipTran, StringBuilder processMsg) throws Exception {
        if (zipTran.getReference() != null && !zipTran.getReference().isEmpty()) {
            Gson json = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();
            VoidPaymentRequest voidRequest = new VoidPaymentRequest(this.apiUrl, this.apiKey, this.locationId, zipTran.getSalesRepName(), zipTran.getReference());
            RollingLog.log(RollingLog.LogType.ZIP, Level.INFO, "Zip Reverse Payment Request" + System.lineSeparator() + this.requestLogging(voidRequest));
            String resultJson = ZipPay.processReqeustViaProvider(voidRequest.requestType, json.toJson((Object)voidRequest));
            VoidPaymentResult voidResult = (VoidPaymentResult)json.fromJson(resultJson, VoidPaymentResult.class);
            voidResult.tranReference = zipTran.getReference();
            if (voidResult.status != null) {
                zipTran.setZipStatus(voidResult.status);
            }
            RollingLog.log(RollingLog.LogType.ZIP, Level.INFO, "Zip Reverse Payment Result" + System.lineSeparator() + this.resultLogging(voidResult));
            this.updateResponse(voidResult);
            if (voidResult.status == ZipStatus.Cancelled) {
                return true;
            }
            this.SetProcessMessage(processMsg, voidResult);
        } else {
            processMsg.append("Original payment reference is empty");
        }
        return false;
    }

    public boolean RefundPayment(RetTranP retTranP, StringBuilder processMsg) throws Exception {
        ZipPayTran zipTran = (ZipPayTran)retTranP.getETran();
        RefundRequest refundRequest = new RefundRequest(this.apiUrl, this.apiKey, this.locationId, Long.parseLong(zipTran.getOrigStan()), retTranP.vhIdx.longValue(), zipTran.getSalesRepName(), Math.abs(retTranP.getAmount()));
        this.saveRequest(refundRequest);
        RollingLog.log(RollingLog.LogType.ZIP, Level.INFO, "Zip Refund Request" + System.lineSeparator() + this.requestLogging(refundRequest));
        Gson json = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();
        String resultJson = ZipPay.processReqeustViaProvider(refundRequest.requestType, json.toJson((Object)refundRequest));
        RefundResult refundResult = (RefundResult)json.fromJson(resultJson, RefundResult.class);
        refundResult.tranReference = refundRequest.TranReference;
        this.updateResponse(refundResult);
        if (refundResult.status != null) {
            zipTran.setZipStatus(refundResult.status);
        }
        RollingLog.log(RollingLog.LogType.ZIP, Level.INFO, "Zip Refund Result" + System.lineSeparator() + this.resultLogging(refundResult));
        if (refundResult.IsSucess()) {
            zipTran.setReference(refundResult.tranReference);
            return true;
        }
        this.SetProcessMessage(processMsg, refundResult);
        return false;
    }

    public boolean RefundPaymentWhenVoidFails(ZipPayTran zipTran, StringBuilder processMsg) throws Exception {
        if (zipTran.getOrigStan() != null && !zipTran.getOrigStan().isEmpty()) {
            RefundRequest refundRequest = new RefundRequest(this.apiUrl, this.apiKey, this.locationId, Long.parseLong(zipTran.getOrigStan()), 0L, zipTran.getSalesRepName(), zipTran.getAmount());
            RollingLog.log(RollingLog.LogType.ZIP, Level.INFO, "Zip Refund Result When Void Fails" + System.lineSeparator() + this.requestLogging(refundRequest));
            Gson json = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();
            String resultJson = ZipPay.processReqeustViaProvider(refundRequest.requestType, json.toJson((Object)refundRequest));
            VoidPaymentResult refundResult = (VoidPaymentResult)json.fromJson(resultJson, VoidPaymentResult.class);
            refundResult.tranReference = zipTran.getReference();
            RollingLog.log(RollingLog.LogType.ZIP, Level.INFO, "Zip Refund Result When Void Fails" + System.lineSeparator() + this.resultLogging(refundResult));
            if (refundResult.status == ZipStatus.Approved) {
                refundResult.status = ZipStatus.Cancelled;
            }
            this.updateResponse(refundResult);
            if (refundResult.IsSucess()) {
                return true;
            }
            this.SetProcessMessage(processMsg, refundResult);
        } else {
            processMsg.append("Original payment id is empty");
        }
        return false;
    }

    public boolean ReverseRefundRequest(ZipPayTran zipTran, StringBuilder processMsg) throws Exception {
        if (zipTran.getOrigStan() != null && !zipTran.getOrigStan().isEmpty() && zipTran.getReference() != null && !zipTran.getReference().isEmpty()) {
            Gson json = new GsonBuilder().excludeFieldsWithModifiers(new int[]{128}).create();
            VoidRefundRequest voidRequest = new VoidRefundRequest(this.apiUrl, this.apiKey, this.locationId, zipTran.getSalesRepName(), Long.parseLong(zipTran.getOrigStan()), zipTran.getReference());
            RollingLog.log(RollingLog.LogType.ZIP, Level.INFO, "Zip Reverse Refund Request" + System.lineSeparator() + this.requestLogging(voidRequest));
            String resultJson = ZipPay.processReqeustViaProvider(voidRequest.requestType, json.toJson((Object)voidRequest));
            VoidRefundResult voidResult = (VoidRefundResult)json.fromJson(resultJson, VoidRefundResult.class);
            voidResult.tranReference = zipTran.getReference();
            if (voidResult.status != null) {
                zipTran.setZipStatus(voidResult.status);
            }
            RollingLog.log(RollingLog.LogType.ZIP, Level.INFO, "Zip Reverse Refund Result" + System.lineSeparator() + this.resultLogging(voidResult));
            this.updateResponse(voidResult);
            if (voidResult.status == ZipStatus.Cancelled) {
                return true;
            }
            if (voidResult.ErrorMessage != null && !voidResult.ErrorMessage.isEmpty()) {
                processMsg.append(voidResult.ErrorMessage);
                processMsg.append("\r\n");
            }
            if (voidResult.ErrorDetails != null && !voidResult.ErrorMessage.isEmpty()) {
                processMsg.append(voidResult.ErrorDetails);
            }
        } else {
            processMsg.append("Original payment reference is empty");
        }
        return false;
    }

    public void ReverseIncompleteZipTrans() throws Exception {
        ZipPayTran zipTran = null;
        try (PreparedStatement getRequestStmt = SP.sParams.conn.prepareStatement("SELECT Z.REQUEST_ID, Z.REQUEST_TYPE, Z.ORIGINAL_PAYMENT_ID, Z.RESPONSE_ID, Z.AMOUNT FROM ZIPPAY_REQUEST Z WHERE Z.NEED_REVERSE = 1 ORDER BY Z.VHIDX DESC");
             ResultSet result = getRequestStmt.executeQuery();){
            while (result.next()) {
                StringBuilder processMessage = new StringBuilder();
                String tranReference = result.getString(1);
                String requestType = result.getString(2);
                String paymentId = result.getString(3);
                String responseId = result.getString(4);
                double amount = result.getDouble(5);
                if (!requestType.equals("REFUND")) {
                    zipTran = new ZipPayTran(false, 0.0);
                    zipTran.setReference(tranReference);
                    zipTran.setSalesRepName("POS");
                    if (this.ReversePaymentRequest(zipTran, processMessage)) continue;
                    zipTran.setAmount(amount);
                    zipTran.setOrigStan(responseId);
                    this.RefundPaymentWhenVoidFails(zipTran, processMessage);
                    continue;
                }
                zipTran = new ZipPayTran(true, 0.0);
                zipTran.setReference(tranReference);
                zipTran.setSalesRepName("POS");
                zipTran.setOrigStan(paymentId);
                this.ReverseRefundRequest(zipTran, processMessage);
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    private void saveRequest(ZipPayRequest request) throws SQLException {
        if (request.requestType == RequestType.Payment || request.requestType == RequestType.Refund) {
            try (PreparedStatement stmt = this.sParams.conn.prepareStatement("INSERT INTO ZIPPAY_REQUEST(REQUEST_ID, REQUEST_TIME, LOCATION_ID, VHIDX, AMOUNT, REQUEST_TYPE, TILL_NAME, IN_PROGRESS, ORIGINAL_PAYMENT_ID) VALUES(?, ?, ?, ?, ?, ?, ?, 1, ?)");){
                long vhidx = request.requestType == RequestType.Payment ? ((PaymentRequest)request).Vhidx : ((RefundRequest)request).Vhidx;
                String tranReference = request.requestType == RequestType.Payment ? ((PaymentRequest)request).TranReference : ((RefundRequest)request).TranReference;
                double amount = request.requestType == RequestType.Payment ? ((PaymentRequest)request).payAmount : ((RefundRequest)request).Amount;
                stmt.setString(1, tranReference);
                stmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                stmt.setString(3, this.locationId);
                stmt.setLong(4, vhidx);
                stmt.setDouble(5, amount);
                stmt.setString(6, request.requestType == RequestType.Payment ? "PURCHASEPAYMENT" : "REFUND");
                stmt.setString(7, this.sParams.tillnum);
                stmt.setString(8, request.requestType == RequestType.Payment ? "" : String.valueOf(((RefundRequest)request).PaymentId));
                stmt.execute();
                if (!this.sParams.conn.getAutoCommit()) {
                    PosUtils.endTrans(this.sParams.conn);
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void updateResponse(RequestResult result) throws SQLException {
        if (result.getRequestType() == RequestType.Payment || result.getRequestType() == RequestType.Refund) {
            try (PreparedStatement stmt = this.sParams.conn.prepareStatement("UPDATE ZIPPAY_REQUEST SET RESPONSE_HTTP_STATUS = ?, RESPONSE_ID = ?, RESPONSE_TIME = ?, RESPONSE_ERROR_CODE = ?, RESPONSE_ERROR_MESSAGE = ?, NEED_REVERSE = ?, IN_PROGRESS = ?, REQUEST_STATUS = ? WHERE REQUEST_ID = ?");){
                stmt.setInt(1, result.HttpStatusCode);
                stmt.setString(2, result.getRequestType() == RequestType.Payment ? String.valueOf(((PaymentResult)result).PaymentId) : null);
                stmt.setTimestamp(3, new Timestamp(System.currentTimeMillis()));
                if (result.ErrorMessage != null && !result.ErrorMessage.isEmpty()) {
                    stmt.setString(4, result.ErrorMessage.substring(0, Math.min(result.ErrorMessage.length(), 249)));
                } else {
                    stmt.setString(4, null);
                }
                if (result.ErrorDetails != null && !result.ErrorDetails.isEmpty()) {
                    stmt.setString(5, result.ErrorDetails.substring(0, Math.min(result.ErrorDetails.length(), 1999)));
                } else {
                    stmt.setString(5, null);
                }
                stmt.setInt(6, result.IsSucess() ? 1 : 0);
                stmt.setInt(7, result.status == ZipStatus.Pending ? 1 : 0);
                stmt.setString(8, result.status != null ? result.status.name() : "");
                stmt.setString(9, result.tranReference);
                stmt.execute();
                if (this.sParams.conn.getAutoCommit()) return;
                PosUtils.endTrans(this.sParams.conn);
                return;
            }
        }
        if (result.getRequestType() == RequestType.Polling) {
            try (PreparedStatement stmt = this.sParams.conn.prepareStatement("UPDATE ZIPPAY_REQUEST SET RESPONSE_HTTP_STATUS = ?, RESPONSE_TIME = ?,RESPONSE_ERROR_CODE = ?, RESPONSE_ERROR_MESSAGE = ?, NEED_REVERSE = ?, IN_PROGRESS = ?, REQUEST_STATUS = ? WHERE REQUEST_ID = ?");){
                stmt.setInt(1, result.HttpStatusCode);
                stmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
                if (result.ErrorMessage != null && !result.ErrorMessage.isEmpty()) {
                    stmt.setString(3, result.ErrorMessage.substring(0, Math.min(result.ErrorMessage.length(), 249)));
                } else {
                    stmt.setString(3, null);
                }
                if (result.ErrorDetails != null && !result.ErrorDetails.isEmpty()) {
                    stmt.setString(4, result.ErrorDetails.substring(0, Math.min(result.ErrorDetails.length(), 1999)));
                } else {
                    stmt.setString(4, null);
                }
                stmt.setInt(5, result.status != ZipStatus.Cancelled && result.status != ZipStatus.Declined && result.status != ZipStatus.Expired ? 1 : 0);
                stmt.setInt(6, result.status == ZipStatus.Pending ? 1 : 0);
                stmt.setString(7, result.status != null ? result.status.name() : null);
                stmt.setString(8, result.tranReference);
                stmt.execute();
                if (this.sParams.conn.getAutoCommit()) return;
                PosUtils.endTrans(this.sParams.conn);
                return;
            }
        }
        try (PreparedStatement stmt = this.sParams.conn.prepareStatement("UPDATE ZIPPAY_REQUEST SET REVERSE_RESPONSE_HTTP_STATUS = ?, REVERSE_RESPONSE_TIME = ?, REVERSE_RESPONSE_ERROR_CODE = ?, REVERSE_RESPONSE_ERROR_MESSAGE = ?, NEED_REVERSE = ?, IN_PROGRESS = ? WHERE REQUEST_ID = ?");){
            stmt.setInt(1, result.HttpStatusCode);
            stmt.setTimestamp(2, new Timestamp(System.currentTimeMillis()));
            if (result.ErrorMessage != null && !result.ErrorMessage.isEmpty()) {
                stmt.setString(3, result.ErrorMessage.substring(0, Math.min(result.ErrorMessage.length(), 249)));
            } else {
                stmt.setString(3, null);
            }
            if (result.ErrorDetails != null && !result.ErrorDetails.isEmpty()) {
                stmt.setString(4, result.ErrorDetails.substring(0, Math.min(result.ErrorDetails.length(), 1999)));
            } else {
                stmt.setString(4, null);
            }
            stmt.setInt(5, result.status == ZipStatus.Cancelled ? 0 : 1);
            stmt.setInt(6, result.IsSucess() ? 0 : 1);
            stmt.setString(7, result.tranReference);
            stmt.execute();
            if (this.sParams.conn.getAutoCommit()) return;
            PosUtils.endTrans(this.sParams.conn);
            return;
        }
    }

    private static String processReqeustViaProvider(RequestType requestType, String json) throws Exception {
        String command;
        switch (requestType) {
            case Payment: {
                command = "SendPaymentRequest";
                break;
            }
            case Refund: {
                command = "SendRefundRequest";
                break;
            }
            case VoidPayment: {
                command = "SendVoidPaymentRequest";
                break;
            }
            case VoidRefund: {
                command = "SendVoidRefundRequest";
                break;
            }
            default: {
                command = "SendPollingRequest";
            }
        }
        JcpRequestResult result = JcpApi.InvokeStaticMethod((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (String)"Bass.Ap21.Pos.PosPlatformExchange.ZipPayProvider", (String)command, (Object[])new Object[]{json});
        if (result.getSuccess()) {
            return result.getRequestResultAsString();
        }
        throw new Exception(result.getErrorMessage());
    }

    private void SetProcessMessage(StringBuilder processMsg, RequestResult result) {
        if (result.ErrorMessage != null && !result.ErrorMessage.isEmpty()) {
            processMsg.append(result.ErrorMessage);
            processMsg.append("\r\n");
        }
        if (result.ErrorDetails != null && !result.ErrorMessage.isEmpty()) {
            processMsg.append(result.ErrorDetails);
        }
    }

    private String requestLogging(ZipPayRequest request) {
        Gson prettyJson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
        return prettyJson.toJson((Object)request).replace(this.apiKey, PosUtils.HashData(this.apiKey));
    }

    private String resultLogging(RequestResult result) {
        try {
            if (result == null) {
                return "null";
            }
            Gson prettyJson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            for (String key : result.RequestResponseLog.keySet()) {
                if (!key.toLowerCase().contains("body") && !key.toLowerCase().equals("delete response")) continue;
                JsonElement jElement = (JsonElement)prettyJson.fromJson((String)result.RequestResponseLog.get(key), JsonElement.class);
                result.RequestResponseLog.replace(key, jElement);
            }
            return prettyJson.toJson((Object)result).replace(this.apiKey, PosUtils.HashData(this.apiKey));
        }
        catch (Exception e) {
            return new Gson().toJson((Object)result);
        }
    }

    public static void removeNeedReverseFlag(long vhidx) {
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("UPDATE ZIPPAY_REQUEST SET NEED_REVERSE = 0 WHERE VHIDX = ? AND REQUEST_STATUS = 'Approved'");){
            stmt.setLong(1, vhidx);
            stmt.execute();
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    public class VoidRefundResult
    extends RequestResult {
        @Override
        protected RequestType getRequestType() {
            return RequestType.VoidRefund;
        }
    }

    public class VoidPaymentResult
    extends RequestResult {
        @Override
        protected RequestType getRequestType() {
            return RequestType.VoidPayment;
        }
    }

    public class RefundResult
    extends RequestResult {
        @Override
        protected RequestType getRequestType() {
            return RequestType.Refund;
        }
    }

    public class PollingResult
    extends RequestResult {
        @Override
        protected RequestType getRequestType() {
            return RequestType.Polling;
        }
    }

    public class PaymentResult
    extends RequestResult {
        @SerializedName(value="receipt_number")
        public long PaymentId;

        @Override
        protected RequestType getRequestType() {
            return RequestType.Payment;
        }
    }

    public abstract class RequestResult {
        protected transient String tranReference;
        public int HttpStatusCode;
        public ZipStatus status;
        public Map<String, Object> RequestResponseLog;
        public String ErrorMessage;
        public String ErrorDetails;

        public boolean IsSucess() {
            return this.HttpStatusCode >= 200 && this.HttpStatusCode <= 299;
        }

        protected RequestType getRequestType() {
            return RequestType.VoidPayment;
        }
    }

    public class VoidRefundRequest
    extends ZipPayRequest {
        public long PaymentId;
        @SerializedName(value="refCode")
        public String TranReference;
        public Originator originator;

        public VoidRefundRequest(String apiUrl, String apiKey, String locationId, String salesRep, long paymentId, String tranReference) {
            super(apiUrl, apiKey);
            this.requestType = RequestType.VoidRefund;
            this.PaymentId = paymentId;
            this.TranReference = tranReference;
            this.originator = new Originator(locationId, ZipPay.this.sParams.tillnum, salesRep);
        }
    }

    public class VoidPaymentRequest
    extends ZipPayRequest {
        @SerializedName(value="refCode")
        public String TranReference;
        public Originator originator;

        public VoidPaymentRequest(String apiUrl, String apiKey, String locationId, String salesRep, String tranReference) {
            super(apiUrl, apiKey);
            this.requestType = RequestType.VoidPayment;
            this.TranReference = tranReference;
            this.originator = new Originator(locationId, ZipPay.this.sParams.tillnum, salesRep);
        }
    }

    public class RefundRequest
    extends ZipPayRequest {
        public long PaymentId;
        @SerializedName(value="refCode")
        public String TranReference;
        @SerializedName(value="refundAmount")
        public double Amount;
        private transient long Vhidx;
        public Originator originator;

        public RefundRequest(String apiUrl, String apiKey, String locationId, long paymentId, long vhidx, String salesRep, double amount) {
            super(apiUrl, apiKey);
            this.requestType = RequestType.Refund;
            this.originator = new Originator(locationId, ZipPay.this.sParams.tillnum, salesRep);
            this.PaymentId = paymentId;
            this.Vhidx = vhidx;
            this.Amount = amount;
            this.TranReference = UUID.randomUUID().toString();
        }
    }

    public class PollingRequest
    extends ZipPayRequest {
        public long PaymentId;

        public PollingRequest(String apiUrl, String apiKey, long paymentId) {
            super(apiUrl, apiKey);
            this.requestType = RequestType.Polling;
            this.PaymentId = paymentId;
            this.Timeout = 5000;
        }
    }

    public class PaymentRequest
    extends ZipPayRequest {
        @SerializedName(value="refCode")
        public String TranReference;
        private transient long Vhidx;
        public double payAmount;
        public AccountIdentifier accountIdentifier;
        public Originator originator;
        public Order order;

        public PaymentRequest(String apiUrl, String apiKey, String locationId, long vhidx, Order order, String salesRep, double amount, String shopInStoreCode) {
            super(apiUrl, apiKey);
            this.requestType = RequestType.Payment;
            this.Vhidx = vhidx;
            this.accountIdentifier = new AccountIdentifier(shopInStoreCode);
            this.originator = new Originator(locationId, ZipPay.this.sParams.tillnum, salesRep);
            this.TranReference = UUID.randomUUID().toString();
            this.payAmount = amount;
            this.order = order;
        }
    }

    public class ZipPayRequest {
        public String ApiUrl;
        public String ApiKey;
        public Integer Timeout;
        protected transient RequestType requestType;

        public ZipPayRequest(String apiUrl, String apiKey) {
            this.ApiUrl = apiUrl;
            this.ApiKey = apiKey;
            this.Timeout = 20000;
        }
    }

    public class AccountIdentifier {
        public String Value;

        public AccountIdentifier(String shopInStoreCode) {
            this.Value = shopInStoreCode;
        }
    }

    public class Originator {
        public String locationId;
        public String deviceRefCode;
        public StaffActor staffActor;

        public Originator(String locationId, String deviceName, String salesRep) {
            this.locationId = locationId;
            this.deviceRefCode = deviceName;
            this.staffActor = new StaffActor();
            this.staffActor.refCode = salesRep;
        }

        public class StaffActor {
            public String refCode;
        }
    }

    public static enum RequestType {
        Payment,
        Refund,
        VoidPayment,
        VoidRefund,
        Polling;

    }
}

