/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import jpos.PosDouble;
import jpos.PosScrollPane;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.person.LegacyPersonDlg;
import jpos.person.TranDetail;
import jpos.person.TranHist;
import jpos.ui.Colours;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;

public class LegacyFrCustomerHistory
extends JPanel {
    private static final int TRANSNUM_COLUMN = 0;
    private static final int DATE_TIME_COLUMN = 1;
    private static final int STORE_COLUMN = 2;
    private static final int TYPE_COLUMN = 3;
    private static final int TOTAL_COLUMN = 4;
    private static final int DOCKET_COLUMN = 5;
    private static final int TRTYPE_COLUMN = 6;
    private static final int VHIDX_COLUMN = 0;
    private static final int VSHIDX_COLUMN = 1;
    private static final int SKU_COLUMN = 2;
    private static final int DESCRIPTION_COLUMN = 3;
    private static final int QTY_COLUMN = 4;
    private static final int NET_COLUMN = 5;
    private static final int COL_TRANS_COUNT = 7;
    private static final int COL_DETAIL_COUNT = 6;
    private static final String DATETIME = SP.getRS("DateTime");
    private static final String STORE = SP.getRS("Store");
    private static final String TYPE = SP.getRS("Type");
    private static final String TOTAL = SP.getRS("Total");
    private static final String SKU = SP.getRS("Style_Colour_Size");
    private static final String Description = SP.getRS("Description");
    private static final String Qty = SP.getRS("Qty");
    private static final String Net = SP.getRS("Net");
    private static final int MAX_COLUMN_WIDTH = 700;
    private static final int MIN_COLUMN_WIDTH = 35;
    private static final int PREFERRED_COLUMN_WIDTH = 200;
    private static final int PREFERRED_NET_COLUMN_WIDTH = 90;
    private static final int PREFERRED_NUM_COLUMN_WIDTH = 35;
    private static final int PREFERRED_TEXT_COLUMN_WIDTH = 300;
    private static final int PREFERRED_SKU_COLUMN_WIDTH = 375;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private PosScrollPane scrollPaneTrans = new PosScrollPane();
    private PosScrollPane scrollPaneDetail = new PosScrollPane();
    private TransactionModel transModel;
    private PosTable tblTransactions;
    private DetailModel detailModel;
    private PosTable tblDetails;
    private LegacyPersonDlg dlgParentPerson;
    private LabelSubHeading lTransHeader = new LabelSubHeading();
    private LabelSubHeading lTransDetail = new LabelSubHeading();
    private Vector<TranDetail> detailData = new Vector();
    private DialogButton bViewTransaction = new DialogButton("");

    public LegacyFrCustomerHistory(LegacyPersonDlg pfrParent) {
        try {
            this.dlgParentPerson = pfrParent;
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    private void jbInit() throws Exception {
        this.setLayout(this.gridBagLayout);
        this.transModel = new TransactionModel();
        this.tblTransactions = new PosTable(this.dlgParentPerson, this.transModel);
        this.detailModel = new DetailModel();
        this.tblDetails = new PosTable(this.dlgParentPerson, this.detailModel);
        this.tblInit();
        this.scrollPaneTrans.setMinimumSize(new Dimension(400, 100));
        this.scrollPaneTrans.setPreferredSize(new Dimension(400, 100));
        this.scrollPaneDetail.setMinimumSize(new Dimension(400, 100));
        this.scrollPaneDetail.setPreferredSize(new Dimension(400, 100));
        this.scrollPaneTrans.getViewport().add((Component)this.tblTransactions, null);
        this.scrollPaneDetail.getViewport().add((Component)this.tblDetails, null);
        this.lTransHeader.setText("  " + StoreParams.res.getString("Transactions"));
        this.lTransHeader.setForeground(Colours.WHITE);
        this.lTransHeader.setBackground(Colours.BLACK);
        this.lTransHeader.setOpaque(true);
        this.lTransHeader.setLabelWidth(400);
        this.lTransDetail.setText("  " + StoreParams.res.getString("Detail"));
        this.lTransDetail.setForeground(Colours.WHITE);
        this.lTransDetail.setBackground(Colours.BLACK);
        this.lTransDetail.setOpaque(true);
        this.lTransDetail.setLabelWidth(400);
        this.bViewTransaction.setText(StoreParams.res.getString("View_Transaction"));
        this.bViewTransaction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LegacyFrCustomerHistory.this.bViewTran_actionPerformed(e);
            }
        });
        this.add((Component)this.lTransHeader, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.scrollPaneTrans, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.lTransDetail, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 0), 0, 0));
        this.add((Component)this.scrollPaneDetail, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 5, 5, 5), 0, 0));
        this.add((Component)this.bViewTransaction, new GridBagConstraints(0, 4, 0, 0, 0.0, 0.0, 13, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.transModel.fireTableDataChanged();
    }

    private void tblInit() {
        this.tblTransactions.getColumnModel().getColumn(1).setHeaderRenderer(this.tblTransactions.headerLeftRen);
        this.tblTransactions.getColumnModel().getColumn(2).setHeaderRenderer(this.tblTransactions.headerLeftRen);
        this.tblTransactions.getColumnModel().getColumn(3).setHeaderRenderer(this.tblTransactions.headerLeftRen);
        this.tblTransactions.getColumnModel().getColumn(4).setHeaderRenderer(this.tblTransactions.headerRightRen);
        this.tblDetails.getColumnModel().getColumn(2).setHeaderRenderer(this.tblDetails.headerLeftRen);
        this.tblDetails.getColumnModel().getColumn(3).setHeaderRenderer(this.tblDetails.headerLeftRen);
        this.tblDetails.getColumnModel().getColumn(4).setHeaderRenderer(this.tblDetails.headerRightRen);
        this.tblDetails.getColumnModel().getColumn(5).setHeaderRenderer(this.tblDetails.headerRightRen);
        this.tblTransactions.renderer.setColumnFormat(4, SP.sParams.currFormat, 4);
        this.tblDetails.renderer.setColumnFormat(4, SP.sParams.currTotFormat, 4);
        this.tblDetails.renderer.setColumnFormat(5, SP.sParams.currFormat, 4);
        this.setColumnSizes(true);
        this.tblTransactions.getTableHeader().setResizingAllowed(true);
        this.tblDetails.getTableHeader().setResizingAllowed(true);
        this.tblTransactions.setSelectionMode(0);
        ListSelectionModel rowSM = this.tblTransactions.getSelectionModel();
        rowSM.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    ((LegacyFrCustomerHistory)LegacyFrCustomerHistory.this).detailModel.data.removeAllElements();
                    int selectedRow = lsm.getMinSelectionIndex();
                    int trans_num = Integer.parseInt(LegacyFrCustomerHistory.this.tblTransactions.getModel().getValueAt(selectedRow, 0).toString());
                    for (int i = 0; i < LegacyFrCustomerHistory.this.detailData.size(); ++i) {
                        if (((TranDetail)LegacyFrCustomerHistory.this.detailData.get(i)).getVhidx() != trans_num) continue;
                        ((LegacyFrCustomerHistory)LegacyFrCustomerHistory.this).detailModel.data.add((TranDetail)LegacyFrCustomerHistory.this.detailData.get(i));
                    }
                    LegacyFrCustomerHistory.this.detailModel.fireTableDataChanged();
                }
            }
        });
    }

    private void setColumnSizes(boolean showVariance) {
        this.tblTransactions.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.tblTransactions.getColumnModel().getColumn(0).setMinWidth(0);
        this.tblTransactions.getColumnModel().getColumn(0).setMaxWidth(0);
        this.tblTransactions.getColumnModel().getColumn(1).setPreferredWidth(300);
        this.tblTransactions.getColumnModel().getColumn(1).setMinWidth(35);
        this.tblTransactions.getColumnModel().getColumn(1).setMaxWidth(700);
        this.tblTransactions.getColumnModel().getColumn(2).setPreferredWidth(300);
        this.tblTransactions.getColumnModel().getColumn(2).setMinWidth(35);
        this.tblTransactions.getColumnModel().getColumn(2).setMaxWidth(700);
        this.tblTransactions.getColumnModel().getColumn(3).setPreferredWidth(showVariance ? 200 : 0);
        this.tblTransactions.getColumnModel().getColumn(3).setMinWidth(showVariance ? 35 : 0);
        this.tblTransactions.getColumnModel().getColumn(3).setMaxWidth(showVariance ? 700 : 0);
        this.tblTransactions.getColumnModel().getColumn(4).setPreferredWidth(showVariance ? 200 : 0);
        this.tblTransactions.getColumnModel().getColumn(4).setMinWidth(showVariance ? 35 : 0);
        this.tblTransactions.getColumnModel().getColumn(4).setMaxWidth(showVariance ? 700 : 0);
        this.tblTransactions.getColumnModel().getColumn(5).setPreferredWidth(0);
        this.tblTransactions.getColumnModel().getColumn(5).setMinWidth(0);
        this.tblTransactions.getColumnModel().getColumn(5).setMaxWidth(0);
        this.tblTransactions.getColumnModel().getColumn(6).setPreferredWidth(0);
        this.tblTransactions.getColumnModel().getColumn(6).setMinWidth(0);
        this.tblTransactions.getColumnModel().getColumn(6).setMaxWidth(0);
        this.tblDetails.getColumnModel().getColumn(0).setPreferredWidth(0);
        this.tblDetails.getColumnModel().getColumn(0).setMinWidth(0);
        this.tblDetails.getColumnModel().getColumn(0).setMaxWidth(0);
        this.tblDetails.getColumnModel().getColumn(1).setPreferredWidth(0);
        this.tblDetails.getColumnModel().getColumn(1).setMinWidth(0);
        this.tblDetails.getColumnModel().getColumn(1).setMaxWidth(0);
        this.tblDetails.getColumnModel().getColumn(2).setPreferredWidth(375);
        this.tblDetails.getColumnModel().getColumn(2).setMinWidth(35);
        this.tblDetails.getColumnModel().getColumn(2).setMaxWidth(700);
        this.tblDetails.getColumnModel().getColumn(3).setPreferredWidth(300);
        this.tblDetails.getColumnModel().getColumn(3).setMinWidth(35);
        this.tblDetails.getColumnModel().getColumn(3).setMaxWidth(700);
        this.tblDetails.getColumnModel().getColumn(4).setPreferredWidth(showVariance ? 35 : 0);
        this.tblDetails.getColumnModel().getColumn(4).setMinWidth(showVariance ? 35 : 0);
        this.tblDetails.getColumnModel().getColumn(4).setMaxWidth(showVariance ? 700 : 0);
        this.tblDetails.getColumnModel().getColumn(5).setPreferredWidth(showVariance ? 90 : 0);
        this.tblDetails.getColumnModel().getColumn(5).setMinWidth(showVariance ? 35 : 0);
        this.tblDetails.getColumnModel().getColumn(5).setMaxWidth(showVariance ? 700 : 0);
    }

    public void populateTransTable(Vector<TranHist> trans, int showingFirst) {
        if (showingFirst > 0) {
            this.lTransHeader.setText("  " + MessageFormat.format(StoreParams.res.getString("Transactions_Showing_First_X"), showingFirst));
        } else {
            this.lTransHeader.setText("  " + StoreParams.res.getString("Transactions"));
        }
        this.transModel.data.removeAllElements();
        for (int i = 0; i < trans.size(); ++i) {
            this.transModel.data.add(trans.get(i));
        }
        this.transModel.fireTableDataChanged();
    }

    public void populateDetailData(Vector<TranDetail> details) {
        this.detailData = details;
    }

    public void reset() {
        this.lTransHeader.setText("  " + StoreParams.res.getString("Transactions"));
        this.transModel.data.removeAllElements();
        this.transModel.fireTableDataChanged();
        this.detailModel.data.removeAllElements();
        this.detailModel.fireTableDataChanged();
    }

    public boolean isRowSelected() {
        return this.tblTransactions.getSelectedRow() != -1;
    }

    public String getSelectedTransDocket() {
        int selectedRow = this.tblTransactions.getSelectedRow();
        if (selectedRow > -1) {
            return this.tblTransactions.getModel().getValueAt(selectedRow, 5).toString();
        }
        return null;
    }

    public int getSelectedTrType() {
        int selectedRow = this.tblTransactions.getSelectedRow();
        if (selectedRow > -1) {
            return Integer.parseInt(this.tblTransactions.getModel().getValueAt(selectedRow, 6).toString());
        }
        return 0;
    }

    void bViewTran_actionPerformed(ActionEvent e) {
        this.dlgParentPerson.ViewTransaction();
    }

    private class DetailModel
    extends AbstractTableModel {
        Vector<TranDetail> data = new Vector();

        private DetailModel() {
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 6;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.data.elementAt(row).getVhidx();
                }
                case 1: {
                    return this.data.elementAt(row).getVshidx();
                }
                case 2: {
                    return this.data.elementAt(row).getSku();
                }
                case 3: {
                    return this.data.elementAt(row).getDescription();
                }
                case 4: {
                    return this.data.elementAt(row).getQty();
                }
                case 5: {
                    return new PosDouble(this.data.elementAt(row).getNet());
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 2: {
                    return SKU;
                }
                case 3: {
                    return Description;
                }
                case 4: {
                    return Qty;
                }
                case 5: {
                    return Net;
                }
            }
            return "";
        }
    }

    private class TransactionModel
    extends AbstractTableModel {
        Vector<TranHist> data = new Vector();

        private TransactionModel() {
        }

        @Override
        public int getRowCount() {
            return this.data.size();
        }

        @Override
        public int getColumnCount() {
            return 7;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            switch (col) {
                case 0: {
                    return this.data.elementAt(row).getTransNum();
                }
                case 1: {
                    return this.data.elementAt(row).getTransDate();
                }
                case 2: {
                    return this.data.elementAt(row).getStore();
                }
                case 3: {
                    return this.data.elementAt(row).getType();
                }
                case 4: {
                    return new PosDouble(this.data.elementAt(row).getTotal());
                }
                case 5: {
                    return this.data.elementAt(row).getDocket();
                }
                case 6: {
                    return this.data.elementAt(row).getTrType();
                }
            }
            return "";
        }

        @Override
        public String getColumnName(int col) {
            switch (col) {
                case 1: {
                    return DATETIME;
                }
                case 2: {
                    return STORE;
                }
                case 3: {
                    return TYPE;
                }
                case 4: {
                    return TOTAL;
                }
            }
            return "";
        }
    }
}

