/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import com.google.gson.Gson;
import com.teamdev.jxbrowser.js.JsAccessible;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import jpos.PosUtils;
import jpos.SP;
import jpos.Settings;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.SystemSettings;
import jpos.browser.ListWrapper;
import jpos.person.Country;
import jpos.person.Location;

public class PersonAttributes {
    private ListWrapper<String> referenceOrds = new ListWrapper(new ArrayList());
    private Map<String, ReferenceGroup> referenceGroups = new HashMap<String, ReferenceGroup>();
    private ListWrapper<CustomDataTemplate> customDataTemplates = new ListWrapper(new ArrayList());
    private Map<String, CustomDataField> customDataFields = new HashMap<String, CustomDataField>();
    private ArrayList<ListValue> countries = new ArrayList();
    private Map<String, String> countryCodes = new HashMap<String, String>();
    private ArrayList<ListValue> genders = new ArrayList();
    private ArrayList<ListValue> taxExemptionReasons = new ArrayList();
    private Map<String, String> taxExemptionReasonCodes = new HashMap<String, String>();

    public PersonAttributes() throws SQLException {
        Throwable throwable;
        Object defaultRcidx;
        String[] grps;
        HashMap<Long, Integer> paramGrps = new HashMap<Long, Integer>();
        String posPersonRefs = SystemSettings.getInstance().getText(SystemSettings.SystemSetting.POS_PERSON_REFERENCES);
        if (posPersonRefs != null && posPersonRefs.length() > 0 && (grps = posPersonRefs.split("@")) != null && grps.length > 0) {
            for (int i = 0; i < grps.length; ++i) {
                String[] vals = grps[i].split(",");
                paramGrps.put(PosUtils.longVal(vals[0]), PosUtils.IntegerVal(vals[1]));
            }
        }
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT T.RG_ORD, T.RGIDX, G.S_NAME, G.L_NAME, WT.RG_ORD AS WHSE_RG_ORD FROM REFTBL T JOIN REFGRP G ON T.RGIDX = G.RGIDX LEFT JOIN REFTBL WT ON WT.TBLIDX = 18 AND T.RGIDX = WT.RGIDX WHERE T.TBLIDX = 12 ORDER BY T.RG_ORD");){
            while (sql.next()) {
                long rgIdx = sql.getLong("RGIDX");
                if (!paramGrps.containsKey(rgIdx)) continue;
                defaultRcidx = "";
                int whseOrd = sql.getInt("WHSE_RG_ORD");
                if (whseOrd > 0) {
                    throwable = null;
                    try (SqlQuery innerSql = new SqlQuery(SP.sParams.conn, "SELECT REF" + whseOrd + " AS RCIDX FROM WHSE WHERE WIDX = ?", SP.sParams.getStoreIdx());){
                        if (innerSql.next()) {
                            defaultRcidx = innerSql.getString("RCIDX");
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                ListValue defaultValue = null;
                Vector<ListValue> references = new Vector<ListValue>();
                try (SqlQuery innerSql = new SqlQuery(SP.sParams.conn, "SELECT RCIDX, CODE, NAME FROM REFCODE WHERE RGIDX = ? AND \"ACTIVE\" = 1 ORDER BY NAME", rgIdx);){
                    while (innerSql.next()) {
                        ListValue value = new ListValue(innerSql.getString("RCIDX"), innerSql.getString("NAME"), innerSql.getString("NAME"));
                        references.add(value);
                        if (defaultValue != null || StringUtils.isNullOrEmpty((String)defaultRcidx) || !((String)defaultRcidx).equals(value.getId())) continue;
                        defaultValue = value;
                    }
                }
                ReferenceGroup grp = new ReferenceGroup(rgIdx, sql.getString("L_NAME"), (Integer)paramGrps.get(rgIdx) == 2, new ArrayList<ListValue>(references), defaultValue);
                this.referenceGroups.put(sql.getString("RG_ORD"), grp);
                this.referenceOrds.getList().add(sql.getString("RG_ORD"));
            }
        }
        ArrayList<CustomDataField> fields = null;
        String currentTemplateIdx = "";
        String currentTemplateName = "";
        SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT T.DDMTEMPLATEIDX, T.NAME, F.DDMFIELDIDX, F.LABEL, F.TYPE, F.TAG_LIST_CONTROL_TYPE, F.MULTI_SELECT, F.TAG_LIST_RGIDX, F.TAG_LIST_CUSTOMIDX, F.FIELD_LENGTH, F.MIN_VALUE, F.MAX_VALUE FROM PERSON_DDM_TEMPLATE T JOIN PERSON_DDM_FIELD F ON T.DDMTEMPLATEIDX = F.DDMTEMPLATEIDX WHERE T.AVAILABLE_TO_POS = 1 AND F.ACTIVE = 1 ORDER BY T.SEQ, T.DDMTEMPLATEIDX, F.SEQ, F.DDMFIELDIDX");
        defaultRcidx = null;
        try {
            while (sql.next()) {
                String templateIdx = sql.getString("DDMTEMPLATEIDX");
                if (!currentTemplateIdx.equals(templateIdx)) {
                    if (fields != null) {
                        this.customDataTemplates.getList().add(new CustomDataTemplate(currentTemplateIdx, currentTemplateName, new ListWrapper<CustomDataField>(fields)));
                    }
                    fields = new ArrayList<CustomDataField>();
                    currentTemplateIdx = templateIdx;
                    currentTemplateName = sql.getString("NAME");
                }
                String type = sql.getString("TYPE");
                String tagListControlType = sql.getString("TAG_LIST_CONTROL_TYPE");
                String rgIdx = sql.getString("TAG_LIST_RGIDX");
                String customListIdx = sql.getString("TAG_LIST_CUSTOMIDX");
                ArrayList<ListValue> values = null;
                if ("TagList".equals(type)) {
                    Throwable throwable3;
                    SqlQuery listSql;
                    values = new ArrayList<ListValue>();
                    if ("predefined".equals(tagListControlType) || "adhoc".equals(tagListControlType)) {
                        listSql = new SqlQuery(SP.sParams.conn, "SELECT I.IDX, I.ITEM_VALUE, I.TRANSLATED_VALUE FROM PERSON_DDM_CUSTOM_LIST_ITEM I WHERE I.LISTIDX = ? AND I.ACTIVE = 1 ORDER BY COALESCE(I.TRANSLATED_VALUE, I.ITEM_VALUE)", customListIdx);
                        throwable3 = null;
                        try {
                            while (listSql.next()) {
                                values.add(new ListValue(listSql.getString("IDX"), listSql.getString("ITEM_VALUE"), listSql.getString("TRANSLATED_VALUE")));
                            }
                        }
                        catch (Throwable throwable4) {
                            throwable3 = throwable4;
                            throw throwable4;
                        }
                        finally {
                            if (listSql != null) {
                                if (throwable3 != null) {
                                    try {
                                        listSql.close();
                                    }
                                    catch (Throwable throwable5) {
                                        throwable3.addSuppressed(throwable5);
                                    }
                                } else {
                                    listSql.close();
                                }
                            }
                        }
                    }
                    if ("refcode".equals(tagListControlType)) {
                        listSql = new SqlQuery(SP.sParams.conn, "SELECT R.RCIDX, R.NAME, R.TRANSLATED_NAME FROM PERSON_DDM_REFERENCE R WHERE R.RGIDX = ? AND R.ACTIVE = 1 ORDER BY COALESCE(R.TRANSLATED_NAME, R.NAME)", rgIdx);
                        throwable3 = null;
                        try {
                            while (listSql.next()) {
                                values.add(new ListValue(listSql.getString("RCIDX"), listSql.getString("NAME"), listSql.getString("TRANSLATED_NAME")));
                            }
                        }
                        catch (Throwable throwable6) {
                            throwable3 = throwable6;
                            throw throwable6;
                        }
                        finally {
                            if (listSql != null) {
                                if (throwable3 != null) {
                                    try {
                                        listSql.close();
                                    }
                                    catch (Throwable throwable7) {
                                        throwable3.addSuppressed(throwable7);
                                    }
                                } else {
                                    listSql.close();
                                }
                            }
                        }
                    }
                }
                CustomDataField field = new CustomDataField(sql.getString("DDMFIELDIDX"), sql.getString("LABEL"), type, tagListControlType, sql.getBoolean("MULTI_SELECT"), rgIdx, customListIdx, sql.getInt("FIELD_LENGTH"), sql.getDouble("MIN_VALUE"), sql.getDouble("MAX_VALUE"), new ArrayList<ListValue>(values != null ? values : new ArrayList<ListValue>()));
                fields.add(field);
                this.customDataFields.put(field.getId(), field);
            }
            if (fields != null) {
                this.customDataTemplates.getList().add(new CustomDataTemplate(currentTemplateIdx, currentTemplateName, new ListWrapper<CustomDataField>(fields)));
            }
        }
        catch (Throwable templateIdx) {
            defaultRcidx = templateIdx;
            throw templateIdx;
        }
        finally {
            if (sql != null) {
                if (defaultRcidx != null) {
                    try {
                        sql.close();
                    }
                    catch (Throwable templateIdx) {
                        ((Throwable)defaultRcidx).addSuppressed(templateIdx);
                    }
                } else {
                    sql.close();
                }
            }
        }
        Vector<Country> countryList = Country.getCountryList();
        for (Country country : countryList) {
            if (StringUtils.isNullOrEmpty(country.getName())) continue;
            this.countries.add(new ListValue(country.getCode(), country.getName(), null));
            this.countryCodes.put(country.getName().toUpperCase(Locale.ROOT), country.getCode());
        }
        ArrayList<ListValue> genderList = this.genders;
        genderList.add(new ListValue("M", SP.getRS("Male"), null));
        genderList.add(new ListValue("F", SP.getRS("Female"), null));
        genderList.add(new ListValue("NS", SP.getRS("Non-specific"), null));
        ArrayList<ListValue> taxExemptReasonList = this.taxExemptionReasons;
        throwable = null;
        try (SqlQuery sqlTaxExempt = new SqlQuery(SP.sParams.conn, "SELECT EXEMPTIDX, DESCRIPT FROM TAX_EXEMPT_REASONS ORDER BY DESCRIPT ");){
            while (sqlTaxExempt.next()) {
                taxExemptReasonList.add(new ListValue(sqlTaxExempt.getString("EXEMPTIDX"), sqlTaxExempt.getString("DESCRIPT"), sqlTaxExempt.getString("DESCRIPT")));
                this.taxExemptionReasonCodes.put(sqlTaxExempt.getString("EXEMPTIDX"), sqlTaxExempt.getString("DESCRIPT"));
            }
        }
        catch (Throwable throwable8) {
            throwable = throwable8;
            throw throwable8;
        }
    }

    @JsAccessible
    public ListWrapper<String> getReferenceOrds() {
        return this.referenceOrds;
    }

    @JsAccessible
    public ReferenceGroup getReferenceGroup(String ord) {
        return this.referenceGroups.get(ord);
    }

    @JsAccessible
    public ListWrapper<CustomDataTemplate> getCustomDataTemplates() {
        return this.customDataTemplates;
    }

    @JsAccessible
    public CustomDataField getField(String fieldIdx) {
        return this.customDataFields.get(fieldIdx);
    }

    @JsAccessible
    public String getCountriesJSON() {
        Gson gson = new Gson();
        String json = gson.toJson(this.countries);
        return json;
    }

    @JsAccessible
    public String getCitiesJSON(String countryName) {
        Gson gson = new Gson();
        String json = gson.toJson(Location.getLocationList(countryName));
        return json;
    }

    @JsAccessible
    public String getCountryCode(String countryName) {
        if (StringUtils.isNullOrEmpty(countryName)) {
            return "";
        }
        return StringUtils.nullToEmpty(this.countryCodes.get(countryName.toUpperCase(Locale.ROOT)));
    }

    @JsAccessible
    public String getDefaultCountry() {
        return Settings.getCountry().getName();
    }

    @JsAccessible
    public String getTaxExemptionReasonCode(String taxExemptionReasonIdx) {
        if (StringUtils.isNullOrEmpty(taxExemptionReasonIdx)) {
            return "";
        }
        return StringUtils.nullToEmpty(this.taxExemptionReasonCodes.get(taxExemptionReasonIdx.toUpperCase(Locale.ROOT)));
    }

    @JsAccessible
    public String getGendersJSON() {
        Gson gson = new Gson();
        String json = gson.toJson(this.genders);
        return json;
    }

    @JsAccessible
    public String getTaxExemptionReasonsJSON() {
        Gson gson = new Gson();
        String json = gson.toJson(this.taxExemptionReasons);
        return json;
    }

    public class CustomDataField {
        public static final String TYPE_TAGLIST = "TagList";
        public static final String TYPE_TEXT = "Text";
        public static final String TYPE_CHECKBOX = "Checkbox";
        public static final String TYPE_DATE = "Date";
        public static final String TYPE_NUMBER = "Number";
        public static final String TYPE_MEMO = "Memo";
        public static final String LIST_CONTROL_TYPE_PREDEFINED = "predefined";
        public static final String LIST_CONTROL_TYPE_ADHOC = "adhoc";
        public static final String LIST_CONTROL_TYPE_REFCODE = "refcode";
        private String id;
        private String name;
        private String type;
        private String listControlType;
        private boolean multiSelect;
        private String rgIdx;
        private String customListIdx;
        private int fieldLength;
        private double minValue;
        private double maxValue;
        private ArrayList<ListValue> values;

        public CustomDataField(String id, String name, String type, String listControlType, boolean multiSelect, String rgIdx, String customListIdx, int fieldLength, double minValue, double maxValue, ArrayList<ListValue> values) {
            this.id = id;
            this.name = name;
            this.type = type;
            this.listControlType = listControlType;
            this.multiSelect = multiSelect;
            this.rgIdx = rgIdx;
            this.customListIdx = customListIdx;
            this.fieldLength = fieldLength;
            this.minValue = minValue;
            this.maxValue = maxValue;
            this.values = values;
        }

        @JsAccessible
        public String getId() {
            return this.id;
        }

        @JsAccessible
        public String getName() {
            return this.name;
        }

        @JsAccessible
        public String getType() {
            return this.type;
        }

        @JsAccessible
        public String getListControlType() {
            return this.listControlType;
        }

        @JsAccessible
        public String getRgIdx() {
            return this.rgIdx;
        }

        @JsAccessible
        public String getCustomListIdx() {
            return this.customListIdx;
        }

        @JsAccessible
        public int getFieldLength() {
            return this.fieldLength;
        }

        @JsAccessible
        public boolean isMultiSelect() {
            return this.multiSelect;
        }

        @JsAccessible
        public double getMinValue() {
            return this.minValue;
        }

        @JsAccessible
        public double getMaxValue() {
            return this.maxValue;
        }

        @JsAccessible
        public String getValuesJSON() {
            Gson gson = new Gson();
            String json = gson.toJson(this.values);
            return json;
        }
    }

    public class CustomDataTemplate {
        private String id;
        private String name;
        private ListWrapper<CustomDataField> fields;

        public CustomDataTemplate(String id, String name, ListWrapper<CustomDataField> fields) {
            this.id = id;
            this.name = name;
            this.fields = fields;
        }

        @JsAccessible
        public String getId() {
            return this.id;
        }

        @JsAccessible
        public String getName() {
            return this.name;
        }

        @JsAccessible
        public ListWrapper<CustomDataField> getFields() {
            return this.fields;
        }
    }

    public class ReferenceGroup {
        private long rgIdx;
        private String name;
        private boolean editable;
        private ArrayList<ListValue> references;
        private ListValue defaultValue;

        public ReferenceGroup(long rgIdx, String name, boolean editable, ArrayList<ListValue> references, ListValue defaultValue) {
            this.rgIdx = rgIdx;
            this.name = name;
            this.editable = editable;
            this.references = references;
            this.defaultValue = defaultValue;
        }

        @JsAccessible
        public long getRgIdx() {
            return this.rgIdx;
        }

        @JsAccessible
        public String getName() {
            return this.name;
        }

        @JsAccessible
        public boolean isEditable() {
            return this.editable;
        }

        @JsAccessible
        public String getValuesJSON() {
            Gson gson = new Gson();
            String json = gson.toJson(this.references);
            return json;
        }

        @JsAccessible
        public ListValue getDefault() {
            return this.defaultValue;
        }
    }

    public class ListValue {
        private String id;
        private String value;
        private String displayValue;

        public ListValue(String id, String value, String displayValue) {
            this.id = StringUtils.nullToEmpty(id);
            this.value = StringUtils.nullToEmpty(value);
            this.displayValue = StringUtils.nullToEmpty(displayValue);
        }

        @JsAccessible
        public String getId() {
            return this.id;
        }

        @JsAccessible
        public String getValue() {
            return this.value;
        }

        @JsAccessible
        public String getDisplayValue() {
            return this.displayValue.isEmpty() ? this.value : this.displayValue;
        }
    }
}

