/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import jpos.PosFrame;
import jpos.SP;
import jpos.Settings;
import jpos.person.LegacyPersonDlg;
import jpos.person.PersonDlg;
import org.jdom.Element;

public class PersonDlgProxy
implements AutoCloseable {
    private boolean useLegacyDlg = Settings.useLegacyPersonMaintenance();
    private PersonDlg dlg;
    private LegacyPersonDlg legacyDlg;

    public PersonDlgProxy(PosFrame frame, String title, Element pPerson, boolean[] pLoyalSec, boolean[] pSalesRepSec, long accountCustidx, boolean loadPersonFromElement) throws Exception {
        this(frame, title, pPerson, pLoyalSec, pSalesRepSec, accountCustidx, loadPersonFromElement, SP.getRS("Attach"));
    }

    public PersonDlgProxy(PosFrame frame, String title, Element pPerson, boolean[] pLoyalSec, boolean[] pSalesRepSec, long accountCustidx, boolean loadPersonFromElement, String attachButtonLabel) throws Exception {
        if (this.useLegacyDlg) {
            this.legacyDlg = new LegacyPersonDlg(frame, title, pPerson, pLoyalSec, pSalesRepSec, accountCustidx);
            if (loadPersonFromElement) {
                this.legacyDlg.loadActivePerson(false);
            }
        } else {
            this.dlg = new PersonDlg(frame, title, pPerson, pLoyalSec, pSalesRepSec, accountCustidx, loadPersonFromElement, attachButtonLabel);
        }
    }

    public void suppressOmneoPersonMaint(boolean suppress) {
        if (this.useLegacyDlg) {
            this.legacyDlg.suppressOmneoPersonMaint(suppress);
        } else {
            this.dlg.suppressOmneoPersonMaint(suppress);
        }
    }

    public void setVisible(boolean visible) {
        if (this.useLegacyDlg) {
            this.legacyDlg.setVisible(visible);
        } else {
            this.dlg.setVisible(visible);
        }
    }

    public boolean isAttachRequested() {
        if (this.useLegacyDlg) {
            return this.legacyDlg.isAcceptPressed();
        }
        return this.dlg.isAttachRequested();
    }

    @Override
    public void close() throws Exception {
        if (this.dlg != null) {
            this.dlg.close();
            this.dlg = null;
        }
        if (this.legacyDlg != null) {
            this.legacyDlg = null;
        }
    }
}

