/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import com.teamdev.jxbrowser.js.JsAccessible;
import jpos.PosFrame;
import jpos.SP;
import jpos.Security;
import jpos.Settings;
import jpos.SystemSettings;
import jpos.User;
import jpos.rewards.RewardsProgram;
import jpos.rewards.RewardsUtils;

public class PersonSecurity {
    private boolean[] personMaintSec;
    private boolean[] loyaltySec;
    private boolean[] salesRepSec;
    private boolean[] historyAllStoresSec;
    private boolean[] fingerPrintSec;
    private boolean fingerPrintsInUse;
    private boolean[] modifyTaxExempSec;
    private boolean[] rewardsHistorySec;
    private boolean[] rewardsAssignSec;
    private boolean usingExtendedTax;
    private boolean usingTaxLookup;
    private boolean enforcePhoneValidation;
    private boolean extendedLoyaltyProgram;
    private long emailMandatory;
    private long emailMandatoryWhenMarketingTicked;
    private boolean showHistory;
    private boolean editLoyaltyAtStore;
    private boolean usingRewards;
    private int rewardsProgramCount;
    private boolean stateAndPostcodeMandatory;
    private boolean hidePrivacyCheckbox;
    private long sendMarketingDefaultValue;
    private boolean enforceFormattingDefault;
    private boolean enforceRewardSecurityPrompt;
    private PosFrame parent;
    private User member;

    public PersonSecurity(User member, PosFrame parent) {
        this(member, member.getSecurity(11106L), member.getSecurity(11104L), parent);
    }

    public PersonSecurity(User member, boolean[] loyaltySec, boolean[] salesRepSec, PosFrame parent) {
        this.fingerPrintsInUse = SP.sParams.bUsingFingerprintLogin && SP.sParams.FingerprintProvider != null;
        this.enforcePhoneValidation = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.ENFORCE_PHONE_NUM_VALIDATION);
        this.extendedLoyaltyProgram = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.EXTENDED_LOYALTY_PROGRAM);
        this.emailMandatory = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.MANDATORY_PERSON_EMAIL);
        this.emailMandatoryWhenMarketingTicked = SystemSettings.getInstance().getNumber(SystemSettings.SystemSetting.EMAIL_MANDATORY_WHEN_MARKETING_TICKED);
        this.showHistory = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.DISPLAY_POS_PERSON_SPENDING);
        this.editLoyaltyAtStore = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.EDIT_LOALTY_AT_STORE);
        this.usingRewards = RewardsUtils.usingAp21RetailRewards();
        this.rewardsProgramCount = RewardsProgram.getAllPrograms().size();
        this.stateAndPostcodeMandatory = Settings.isPostcodeMandatory();
        this.hidePrivacyCheckbox = SP.sParams.bHidePrivateCheckBox;
        this.sendMarketingDefaultValue = SP.sParams.bDefaultPrivateOn;
        this.enforceFormattingDefault = SP.sParams.bEnforceFormatting;
        this.enforceRewardSecurityPrompt = SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.PROMPT_MANAGER_OVERRIDE_FOR_REWARDS_PROGRAM);
        this.personMaintSec = member.getSecurity(11160L);
        this.historyAllStoresSec = member.getSecurity(11151L);
        this.fingerPrintSec = member.getSecurity(11141L);
        this.modifyTaxExempSec = member.getSecurity(11166L);
        this.rewardsHistorySec = member.getSecurity(11179L);
        this.rewardsAssignSec = member.getSecurity(11181L);
        this.loyaltySec = loyaltySec;
        this.salesRepSec = salesRepSec;
        this.usingExtendedTax = SP.sParams.bUsingExtendedTax;
        this.usingTaxLookup = SP.sParams.bUsingTaxLookup;
        this.member = member;
        this.parent = parent;
    }

    private static boolean getSecurityFromArray(boolean[] array, int level) {
        if (level >= 0 && level <= 3) {
            return array[level];
        }
        return false;
    }

    @JsAccessible
    public boolean getPersonMaintSec(int level) {
        return PersonSecurity.getSecurityFromArray(this.personMaintSec, level);
    }

    @JsAccessible
    public boolean getLoyaltySec(int level) {
        return PersonSecurity.getSecurityFromArray(this.loyaltySec, level);
    }

    @JsAccessible
    public boolean getSalesRepSec(int level) {
        return PersonSecurity.getSecurityFromArray(this.salesRepSec, level);
    }

    @JsAccessible
    public boolean canEditFingerPrints() {
        return this.fingerPrintsInUse && this.fingerPrintSec[2];
    }

    @JsAccessible
    public boolean areFingerPrintsInUse() {
        return this.fingerPrintsInUse;
    }

    @JsAccessible
    public boolean getHistoryAllStoresSec(int level) {
        return PersonSecurity.getSecurityFromArray(this.historyAllStoresSec, level);
    }

    @JsAccessible
    public boolean getEnforcePhoneNumValidation() {
        return this.enforcePhoneValidation;
    }

    @JsAccessible
    public boolean getModifyTaxExempSec(int level) {
        return PersonSecurity.getSecurityFromArray(this.modifyTaxExempSec, level);
    }

    @JsAccessible
    public boolean isExtendedTaxInUse() {
        return this.usingExtendedTax;
    }

    @JsAccessible
    public boolean isTaxLookupInUse() {
        return this.usingTaxLookup;
    }

    @JsAccessible
    public boolean isExtendedLoyaltyProgram() {
        return this.extendedLoyaltyProgram;
    }

    @JsAccessible
    public long isEmailMandatory() {
        return this.emailMandatory;
    }

    @JsAccessible
    public long isEmailMandatoryWhenMarketingTicked() {
        return this.emailMandatoryWhenMarketingTicked;
    }

    @JsAccessible
    public boolean getEnforceFormattingDefault() {
        return this.enforceFormattingDefault;
    }

    @JsAccessible
    public boolean canEditLoyaltyAtStore() {
        return this.editLoyaltyAtStore;
    }

    @JsAccessible
    public boolean isUsingRewards() {
        return this.usingRewards;
    }

    @JsAccessible
    public int getRewardProgramCount() {
        return this.rewardsProgramCount;
    }

    @JsAccessible
    public boolean getRewardsHistorySec(int level) {
        return PersonSecurity.getSecurityFromArray(this.rewardsHistorySec, level);
    }

    @JsAccessible
    public boolean hasRewardsAssignSec(int level) {
        Security.OverrideUser overrideUser = new Security.OverrideUser();
        return this.member.hasSecurity(this.parent, 11181L, level, true, overrideUser);
    }

    @JsAccessible
    public boolean getRewardsAssignSec(int level) {
        return PersonSecurity.getSecurityFromArray(this.rewardsAssignSec, level);
    }

    @JsAccessible
    public boolean getHidePrivacyFlag() {
        return this.hidePrivacyCheckbox;
    }

    @JsAccessible
    public long getSendMarketingDefaultValue() {
        return this.sendMarketingDefaultValue;
    }

    @JsAccessible
    public boolean getStateAndPostcodeMandatory() {
        return this.stateAndPostcodeMandatory;
    }

    @JsAccessible
    public boolean canShowHistory() {
        return this.showHistory;
    }

    @JsAccessible
    public boolean getEnforceRewardSecurityPrompt() {
        return this.enforceRewardSecurityPrompt;
    }
}

