/*
 * Decompiled with CFR 0.152.
 */
package jpos.person;

import com.google.i18n.phonenumbers.AsYouTypeFormatter;
import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import jpos.SP;
import jpos.StringField;
import jpos.person.Country;

public abstract class PhoneNumberField
extends StringField {
    private String countryCode;
    private PhoneNumberUtil phoneUtil = PhoneNumberUtil.getInstance();
    private AsYouTypeFormatter formatter;
    private boolean applyValidation;
    private String message;

    public PhoneNumberField(Country country) {
        this.init(country, false);
    }

    public PhoneNumberField(Country country, int length) {
        super(length);
        this.init(country, false);
    }

    public PhoneNumberField(Country country, int length, boolean applyValidation) {
        super(length);
        this.init(country, applyValidation);
    }

    private void init(Country country, boolean applyValidation) {
        this.applyValidation = applyValidation;
        this.setCountryCode(country);
        if (applyValidation) {
            AbstractDocument document = (AbstractDocument)this.getDocument();
            document.setDocumentFilter(new PhoneNumDocumentFilter());
            this.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void removeUpdate(DocumentEvent e) {
                    PhoneNumberField.this.refreshValidIndicator();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    PhoneNumberField.this.refreshValidIndicator();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    PhoneNumberField.this.refreshValidIndicator();
                }
            });
            this.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                }

                @Override
                public void focusLost(FocusEvent e) {
                    PhoneNumberField.this.setText(PhoneNumberField.this.formatPhoneNumber(PhoneNumberField.this.getText()));
                }
            });
            this.refreshValidIndicator();
        }
    }

    public void setCountryCode(Country country) {
        this.countryCode = country.getCode();
        this.formatter = this.phoneUtil.getAsYouTypeFormatter(this.countryCode == null || this.countryCode.isEmpty() ? "AU" : this.countryCode);
        this.message = MessageFormat.format(SP.getRS("Invalid_Contact"), country.getName());
        this.refreshValidIndicator();
    }

    public void refreshValidIndicator() {
        if (this.applyValidation) {
            if (this.isValidNumber()) {
                this.validationPassed();
            } else {
                this.validationFailed(this.message);
            }
        }
    }

    public boolean isValidNumber() {
        if (!this.applyValidation) {
            return true;
        }
        if (this.countryCode == null || this.countryCode.isEmpty()) {
            return true;
        }
        String text = this.getText();
        if (text == null || text.isEmpty()) {
            return true;
        }
        try {
            Phonenumber.PhoneNumber number = this.phoneUtil.parse((CharSequence)text, this.countryCode);
            return this.phoneUtil.isValidNumber(number);
        }
        catch (NumberParseException e) {
            return false;
        }
    }

    private String cleanPhoneNumber(String text) {
        return text.replaceAll("[^+\\d.]", "");
    }

    public String getCleanText() {
        if (this.applyValidation) {
            return this.cleanPhoneNumber(this.getText());
        }
        return this.getText();
    }

    private String formatPhoneNumber(String text) {
        if (this.countryCode == null || this.countryCode.isEmpty()) {
            return text;
        }
        String formattedPhoneNumber = "";
        if (text.length() > 0) {
            String unformattedPhoneNumber = this.cleanPhoneNumber(text);
            this.formatter.clear();
            for (int i = 0; i < unformattedPhoneNumber.length(); ++i) {
                formattedPhoneNumber = this.formatter.inputDigit(unformattedPhoneNumber.charAt(i));
            }
            this.formatter.clear();
        }
        return formattedPhoneNumber;
    }

    public String formatThenCleanTextPhoneNumber(String phoneNum) {
        return this.cleanPhoneNumber(this.formatPhoneNumber(phoneNum));
    }

    public String getPhoneNumberWithInternationalPrefix(String phoneNum) {
        if (this.countryCode == null || this.countryCode.isEmpty()) {
            return phoneNum;
        }
        try {
            Phonenumber.PhoneNumber numberProto = this.phoneUtil.parse((CharSequence)phoneNum, this.countryCode);
            return this.phoneUtil.format(numberProto, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
        }
        catch (NumberParseException e) {
            return phoneNum;
        }
    }

    public abstract void validationPassed();

    public abstract void validationFailed(String var1);

    private class PhoneNumDocumentFilter
    extends DocumentFilter {
        private PhoneNumDocumentFilter() {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String inputTextValue, AttributeSet attrs) throws BadLocationException {
            Document doc = fb.getDocument();
            boolean cursorIsAtEnd = offset + 1 >= doc.getLength();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.insert(offset, inputTextValue);
            if (cursorIsAtEnd) {
                String formattedValue = PhoneNumberField.this.formatPhoneNumber(sb.toString());
                super.replace(fb, 0, doc.getLength(), formattedValue, attrs);
            } else {
                String formattedValue = PhoneNumberField.this.cleanPhoneNumber(inputTextValue);
                if (!formattedValue.isEmpty()) {
                    super.insertString(fb, offset, formattedValue, attrs);
                }
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String inputTextValue, AttributeSet attrs) throws BadLocationException {
            Document doc = fb.getDocument();
            boolean cursorIsAtEnd = offset + length >= doc.getLength();
            StringBuilder sb = new StringBuilder();
            sb.append(doc.getText(0, doc.getLength()));
            sb.replace(offset, offset + length, inputTextValue);
            if (cursorIsAtEnd) {
                String formattedValue = PhoneNumberField.this.formatPhoneNumber(sb.toString());
                super.replace(fb, 0, doc.getLength(), formattedValue, attrs);
            } else {
                String formattedValue = PhoneNumberField.this.cleanPhoneNumber(inputTextValue);
                if (!formattedValue.isEmpty()) {
                    super.replace(fb, offset, length, formattedValue, attrs);
                }
            }
        }

        @Override
        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            Document doc = fb.getDocument();
            String textToRemove = doc.getText(offset, length);
            boolean cursorIsAtEnd = offset + length >= doc.getLength();
            fb.remove(offset, length);
            if (cursorIsAtEnd && !textToRemove.equals(" ")) {
                doc = fb.getDocument();
                String formattedValue = PhoneNumberField.this.formatPhoneNumber(doc.getText(0, doc.getLength()));
                super.replace(fb, 0, doc.getLength(), formattedValue, null);
            }
        }
    }
}

