/*
 * Decompiled with CFR 0.152.
 */
package jpos.pointspartner;

import jpos.Barcode;
import jpos.SP;

public class PointsPartner {
    private long partnerIdx;
    private String partnerName;
    private String[] cardPrefixes;
    private Barcode.BarcodeType barcodeType;
    private boolean alwaysPrompt;
    private boolean overrideDocketText;
    private String docketText;
    private String displayText;
    private boolean overrideDisplayText;

    public long getPartnerIdx() {
        return this.partnerIdx;
    }

    public String getPartnerName() {
        return this.partnerName != null ? this.partnerName : "";
    }

    public String[] getCardPrefixes() {
        return this.cardPrefixes;
    }

    public Barcode.BarcodeType getBarcodeType() {
        return this.barcodeType;
    }

    public boolean isAlwaysPrompt() {
        return this.alwaysPrompt;
    }

    public boolean isOverrideDocketText() {
        return this.overrideDocketText;
    }

    public String getOverrideText() {
        return this.docketText;
    }

    public String GetDisplayText() {
        return this.displayText;
    }

    public boolean isOverrideDisplayText() {
        return this.overrideDisplayText;
    }

    public PointsPartner(long partnerIdx, String partnerName, String[] cardPrefixes, Barcode.BarcodeType barcodeType, boolean alwaysPrompt, boolean overrideDocketText, String docketText, String displayText, boolean overrideDisplayText) {
        this.partnerIdx = partnerIdx;
        this.partnerName = partnerName;
        this.cardPrefixes = cardPrefixes;
        this.barcodeType = barcodeType;
        this.alwaysPrompt = alwaysPrompt;
        this.overrideDocketText = overrideDocketText;
        this.docketText = docketText;
        this.displayText = displayText;
        this.overrideDisplayText = overrideDisplayText;
    }

    public boolean validateMembership(String membershipNum) {
        return this.validateMembership(membershipNum, true, null);
    }

    public boolean validateMembership(String membershipNum, boolean checkPrefix) {
        return this.validateMembership(membershipNum, checkPrefix, null);
    }

    public boolean validateMembership(String membershipNum, boolean checkPrefix, StringBuilder error) {
        if (checkPrefix && !this.validatePrefix(membershipNum)) {
            if (error != null) {
                error.append(SP.getRS("points_partner_error_prefix", this.partnerName));
            }
            return false;
        }
        if (this.barcodeType != Barcode.BarcodeType.NONE && !Barcode.isValid(membershipNum, this.barcodeType)) {
            if (error != null) {
                error.append(SP.getRS("points_partner_error_barcode", this.partnerName));
            }
            return false;
        }
        return true;
    }

    public boolean validatePrefix(String membershipNum) {
        for (String prefix : this.cardPrefixes) {
            if (prefix.length() <= 0 || !membershipNum.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

