/*
 * Decompiled with CFR 0.152.
 */
package jpos.quickreceipts;

import java.text.MessageFormat;
import jpos.PosDouble;
import jpos.PosUtils;
import jpos.SP;
import jpos.quickreceipts.Carton;

public class QuickReceiptsLine {
    private final String x_of_y = SP.getRS("x_of_y");
    private Carton carton;

    protected QuickReceiptsLine(Carton carton) {
        this.carton = carton;
    }

    protected Object getVal(int colIndex) {
        Object val;
        try {
            switch (colIndex) {
                case 0: {
                    val = this.carton.getBarcode();
                    break;
                }
                case 1: {
                    val = this.carton.getTransDescription();
                    break;
                }
                case 2: {
                    val = this.carton.getDeliveryNumber();
                    break;
                }
                case 3: {
                    val = this.carton.getFromName();
                    break;
                }
                case 4: {
                    val = PosDouble.valueOf(this.carton.getTotalQty());
                    break;
                }
                case 5: {
                    val = MessageFormat.format(this.x_of_y, String.valueOf(this.carton.getCartonNumber()), String.valueOf(this.carton.getTotalNumberCartons()));
                    break;
                }
                default: {
                    val = null;
                    break;
                }
            }
        }
        catch (Exception e) {
            val = null;
            PosUtils.logError(e);
        }
        return val;
    }

    protected Carton getCarton() {
        return this.carton;
    }
}

