/*
 * Decompiled with CFR 0.152.
 */
package jpos.reservation;

import java.sql.Connection;
import java.sql.SQLException;
import jpos.SqlQuery;

public class ReservationHandler {
    private Connection conn;
    private String reservationTypeIdx;
    private String reservationNote;
    private boolean autoGrantedPirntDocket = false;
    private boolean autoGrantedPirntLabel = false;
    private static final String LABEL_CODE = "LBLCODE";
    private static final String DOCKET_PRINT = "DCKTPRNT";
    private static final String LABEL_PRINT = "LBLPRNT";

    public ReservationHandler(Connection conn) {
        this.conn = conn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean checkReservationTypeEnabled() {
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT RCIDX, NAME FROM REFCODE WHERE RGIDX = " + String.valueOf(466) + " AND ACTIVE = 1");){
            if (!sql.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getLblCode(String resIdx) {
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT DCKTPRNT, LBLPRNT, LBLCODE FROM RESVBUCKET WHERE RESVTYPE = ? AND ACTIVE = 1;", resIdx);){
            if (sql.next()) {
                String string2 = sql.getString(LABEL_CODE);
                return string2;
            }
            String string = null;
            return string;
        }
        catch (SQLException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean allowDocketPrint(String resIdx) {
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT DCKTPRNT, LBLPRNT, LBLCODE FROM RESVBUCKET WHERE RESVTYPE = ? AND ACTIVE = 1;", resIdx);){
            if (sql.next()) {
                boolean bl2 = sql.getInt(DOCKET_PRINT) == 1;
                return bl2;
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean allowLabelPrint(String resIdx) {
        try (SqlQuery sql = new SqlQuery(this.conn, "SELECT DCKTPRNT, LBLPRNT, LBLCODE FROM RESVBUCKET WHERE RESVTYPE = ? AND ACTIVE = 1;", resIdx);){
            if (sql.next()) {
                boolean bl2 = sql.getInt(LABEL_PRINT) == 1;
                return bl2;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            return false;
        }
    }

    public String getReservationTypeIdx() {
        return this.reservationTypeIdx;
    }

    public void setReservationTypeIdx(String reservationTypeIdx) {
        this.reservationTypeIdx = reservationTypeIdx;
    }

    public String getReservationNote() {
        return this.reservationNote;
    }

    public void setReservationNote(String reservationNote) {
        this.reservationNote = reservationNote;
    }

    public boolean isAutoGrantedPirntDocket() {
        return this.autoGrantedPirntDocket;
    }

    public void setAutoGrantedPirntDocket(boolean autoGrantedPirntDocket) {
        this.autoGrantedPirntDocket = autoGrantedPirntDocket;
    }

    public boolean isAutoGrantedPirntLabel() {
        return this.autoGrantedPirntLabel;
    }

    public void setAutoGrantedPirntLabel(boolean autoGrantedPirntLabel) {
        this.autoGrantedPirntLabel = autoGrantedPirntLabel;
    }

    public void resetReservationDetails() {
        this.reservationTypeIdx = null;
        this.reservationNote = "";
    }
}

