/*
 * Decompiled with CFR 0.152.
 */
package jpos.reservation.auto;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import jpos.FrSales;
import jpos.StoreParams;
import jpos.labelprinting.ReservationLabel;
import jpos.reservation.model.ResvTranDetail;
import jpos.reservation.model.ResvTranHeader;

public abstract class AutoReservation {
    StoreParams sParams;
    private FrSales frSales;

    public AutoReservation(FrSales frSales) {
        this.frSales = frSales;
        this.sParams = frSales.sParams;
    }

    public abstract void executeReservation(List<ResvTranDetail> var1);

    public abstract void setTranH(ResvTranHeader var1);

    private void printReservation(long vhidx) {
        try (PreparedStatement ps = this.sParams.conn.prepareStatement("SELECT r.DCKTPRNT, r.LBLPRNT, r.LBLCODE FROM RESVBUCKET r JOIN RET_TRANH rt ON rt.RESRVETYPEIDX = r.RESVTYPE WHERE rt.VHIDX = ? AND r.ACTIVE = 1 AND rt.ACTIVE = 1");){
            ps.setLong(1, vhidx);
            try (ResultSet rs = ps.executeQuery();){
                if (rs.next()) {
                    if (rs.getInt("DCKTPRNT") == 1) {
                        this.frSales.printReceipt(false, vhidx);
                    }
                    if (rs.getInt("LBLPRNT") == 1) {
                        String lblCode = rs.getString("LBLCODE");
                        ReservationLabel rsvLabel = new ReservationLabel(this.sParams.conn, this.sParams.getStore().getStoreNo(), lblCode, vhidx);
                        rsvLabel.writeLabelToFile();
                    }
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Error retrieving print configurations", e);
        }
    }

    public void finalizeReservation(long vhidx) {
        this.sParams.yTabInsert("RET_TRANH", "VHIDX", "" + vhidx);
        this.printReservation(vhidx);
    }
}

