/*
 * Decompiled with CFR 0.152.
 */
package jpos.reservation.auto;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jpos.FrSales;
import jpos.PosMenuController;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.reservation.auto.AutoReservation;
import jpos.reservation.auto.ReservationDetail;
import jpos.reservation.model.ResvTranDetail;
import jpos.reservation.model.ResvTranHeader;

public class ReAssignReservation
extends AutoReservation {
    private Map<Integer, Long> reAssignResrv;
    private int reasonIdx;
    private ResvTranHeader retTranH;
    private static final String reassignReasonTemplate = "D%s%s - (Auto Reserved due to Re-assignment)";

    public ReAssignReservation(FrSales frSale, int reasonIdx) {
        super(frSale);
        this.reasonIdx = reasonIdx;
        this.reAssignResrv = this.getReAssignMapping();
    }

    private Map<Integer, Long> getReAssignMapping() {
        this.reAssignResrv = new HashMap<Integer, Long>();
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT RESVTYPE, REASSIGN_REASON FROM RESV_REASSIGNMENT rr JOIN REFCODE r ON rr.RESVTYPE = r.RCIDX WHERE r.ACTIVE = 1 AND rr.ACTIVE = 1");){
            while (sql.next()) {
                this.reAssignResrv.put(sql.getInt("REASSIGN_REASON"), sql.getLong("RESVTYPE"));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return this.reAssignResrv;
    }

    @Override
    public void executeReservation(List<ResvTranDetail> retrDetails) {
        Long resvType = this.reAssignResrv.get(this.reasonIdx);
        if (resvType != null) {
            try {
                String docNum = PosUtils.padZeroes(this.sParams.getNextDocketNum("PosFrame.setDocketnum, Screen " + PosMenuController.getScreenName(11)), 8);
                SP.sParams.bDoingNewSave = true;
                ReservationDetail resvDetail = this.addRetTransHeader(resvType, docNum);
                if (resvDetail != null) {
                    for (ResvTranDetail transactionDetail : retrDetails) {
                        resvDetail = this.addRetTransDetail(resvDetail, transactionDetail);
                    }
                    SP.sParams.bDoingNewSave = false;
                    this.updateRetTransHeader(resvDetail);
                    super.finalizeReservation(resvDetail.getVhidx());
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private ReservationDetail addRetTransHeader(Long resvType, String docNum) {
        Throwable throwable;
        ReservationDetail resvDetail = null;
        try {
            throwable = null;
            try (PreparedStatement prepStmt = this.sParams.conn.prepareStatement("INSERT INTO RET_TRANH ( VHIDX, TR_TYPE, WIDX, SREPIDX, DOCKET_NUMBER, MEMBER_GENERATEDIDX, REF1, REF2, REF3, STAFF_SALE_FLAG, TILL_NUMBER, TRAND, TRANS_NUMBER, \"ACTIVE\", COMPLETE, COUNTRY_CODE, TRANSMEMIDX, TRANSSREPIDX, SALE_DATE, TILL_BALANCE_TYPE, SELFFIT, RESRVETYPEIDX, RESERVE_NOTES) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
                long newVhidx = this.sParams.nextVal("XRET_TRANH");
                String reservNote = String.format(reassignReasonTemplate, this.sParams.getStore().getStoreNo(), this.retTranH.getDocketNumber());
                prepStmt.setLong(1, newVhidx);
                prepStmt.setInt(2, 614);
                prepStmt.setLong(3, this.sParams.getStoreIdx());
                prepStmt.setLong(4, this.retTranH.getSrepidx());
                prepStmt.setString(5, docNum);
                prepStmt.setLong(6, this.retTranH.getMemberGeneratedidx());
                prepStmt.setString(7, this.retTranH.getRef1().isEmpty() ? null : this.retTranH.getRef1());
                prepStmt.setString(8, this.retTranH.getRef2().isEmpty() ? null : this.retTranH.getRef2());
                prepStmt.setString(9, this.retTranH.getRef3().isEmpty() ? null : this.retTranH.getRef3());
                prepStmt.setInt(10, 0);
                prepStmt.setString(11, this.sParams.tillnum);
                prepStmt.setTimestamp(12, new Timestamp(System.currentTimeMillis()));
                prepStmt.setString(13, docNum);
                prepStmt.setInt(14, 1);
                prepStmt.setInt(15, 0);
                prepStmt.setString(16, this.retTranH.getCountryCode().isEmpty() ? null : this.retTranH.getCountryCode());
                prepStmt.setLong(17, this.retTranH.getTransmemidx());
                prepStmt.setLong(18, this.retTranH.getTranssrepidx());
                prepStmt.setTimestamp(19, this.retTranH.getSaleDate());
                prepStmt.setInt(20, this.retTranH.getTillBalanceType());
                prepStmt.setInt(21, 0);
                prepStmt.setLong(22, resvType);
                prepStmt.setString(23, reservNote);
                prepStmt.executeUpdate();
                resvDetail = new ReservationDetail(newVhidx);
                resvDetail.setResvtypeidx(resvType);
                resvDetail.setResvnotes(reservNote);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (SQLException e) {
            return resvDetail;
        }
        try {
            throwable = null;
            try (SqlQuery sqlConf = new SqlQuery(this.sParams.conn, "SELECT DCKTPRNT, LBLPRNT, LBLCODE FROM RESVBUCKET WHERE RESVTYPE = ? AND ACTIVE = 1;", resvType);){
                if (sqlConf.next()) {
                    resvDetail.setDcktpnt(sqlConf.getInt("DCKTPRNT"));
                    resvDetail.setLblprnt(sqlConf.getInt("LBLPRNT"));
                    resvDetail.setLblcode(sqlConf.getString("LBLCODE"));
                }
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (SQLException e) {
            return null;
        }
        return resvDetail;
    }

    private ReservationDetail addRetTransDetail(ReservationDetail resvDetail, ResvTranDetail transactionDetail) {
        Object sql = null;
        try (PreparedStatement prepStmt = this.sParams.conn.prepareStatement("INSERT INTO RET_TRAND (VSHIDX, VHIDX, GROSS, LINE_CODE, LINE_TYPE, NET, PRICE, SEQUENCE_NUMBER, SKUIDX, STKFLAG, TAXPER, ACTIVE, QTY, ORIG_PRICE, POS_MKDMSGIDX, EXT_TAXRATE, TAKEN, PACKED, OLD_HELD_VALUE, TAX_DONOTREFRESH_FLAG, GVGATE_ISDIGITAL, SREPIDX) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");){
            prepStmt.setLong(1, this.sParams.nextVal("XRET_TRAND"));
            prepStmt.setLong(2, resvDetail.getVhidx());
            prepStmt.setBigDecimal(3, transactionDetail.getGross());
            prepStmt.setString(4, transactionDetail.getLineCode());
            prepStmt.setLong(5, transactionDetail.getLineType());
            prepStmt.setBigDecimal(6, transactionDetail.getNet());
            prepStmt.setBigDecimal(7, transactionDetail.getPrice());
            prepStmt.setLong(8, transactionDetail.getSequenceNumber());
            prepStmt.setInt(9, transactionDetail.getSkuidx());
            prepStmt.setBigDecimal(10, transactionDetail.getStkflag());
            prepStmt.setBigDecimal(11, transactionDetail.getTaxper());
            prepStmt.setInt(12, 1);
            prepStmt.setBigDecimal(13, transactionDetail.getQty());
            prepStmt.setString(14, null);
            prepStmt.setLong(15, transactionDetail.getMkdwnReasidx());
            prepStmt.setString(16, null);
            prepStmt.setInt(17, 0);
            prepStmt.setLong(18, 0L);
            prepStmt.setLong(19, 0L);
            prepStmt.setInt(20, 0);
            prepStmt.setInt(21, 0);
            prepStmt.setLong(22, transactionDetail.getSrepidx());
            prepStmt.executeUpdate();
        }
        catch (Exception e) {
            // empty catch block
        }
        return resvDetail;
    }

    private void updateRetTransHeader(ReservationDetail resvDetail) {
        try (PreparedStatement prepStmt = this.sParams.conn.prepareStatement("UPDATE RET_TRANH SET COMPLETE = 1 WHERE VHIDX = ?");){
            prepStmt.setLong(1, resvDetail.getVhidx());
            prepStmt.executeUpdate();
        }
        catch (SQLException e) {
            return;
        }
    }

    public void setReasonIdx(int reasonIdx) {
        this.reasonIdx = reasonIdx;
    }

    @Override
    public void setTranH(ResvTranHeader tranh) {
        this.retTranH = tranh;
    }
}

