/*
 * Decompiled with CFR 0.152.
 */
package jpos.rewards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import jpos.DlgList;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.PaSales;
import jpos.PosDialog;
import jpos.SP;
import jpos.person.LegacyPersonDlg;
import jpos.rewards.IRewardsApiManager;
import jpos.rewards.RewardsAccount;
import jpos.rewards.RewardsApiFactory;
import jpos.rewards.RewardsProgram;
import jpos.rewards.RewardsProgressBar;
import jpos.rewards.RewardsUtils;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;

public class LegacyRewardsProgramPanel
extends JPanel {
    private LabelSubHeading labelProgram = new LabelSubHeading("");
    private LabelNormal labelTier = new LabelNormal("");
    private LabelNormal labelRewardsBalance = new LabelNormal("");
    private LabelNormal labelGifts = new LabelNormal("");
    private DialogButton btnSignUp = new DialogButton("");
    private RewardsProgressBar progressBar = new RewardsProgressBar(RewardsProgressBar.DisplayType.NEAREST_MILESTONE);
    private LabelNormal labelImage = new LabelNormal();
    private JPanel panelImage = new JPanel(new GridBagLayout());
    private PosDialog parentDlg;
    private long peridx;
    private RewardsAccount customerRewardsProgram;
    private boolean signupRequested;
    private RewardsProgram requestedProgram;

    public LegacyRewardsProgramPanel(PosDialog parentDlg) {
        super(new GridBagLayout());
        this.parentDlg = parentDlg;
        this.init();
    }

    private void init() {
        this.setBackground(Color.WHITE);
        this.progressBar.setBackground(Color.WHITE);
        this.panelImage.setBackground(Color.WHITE);
        this.progressBar.setPreferredSize(new Dimension(132, 132));
        this.panelImage.setPreferredSize(new Dimension(132, 132));
        this.labelProgram.setMaxWidth(230);
        this.labelTier.setMaxWidth(230);
        this.labelImage.setIcon(new ImageIcon(SP.sParams.imagepath + "RewardsIcon.png"));
        this.labelImage.setHorizontalAlignment(0);
        this.btnSignUp.setEnabled(!this.parentDlg.frParent.getUser().isTraningUser());
        this.btnSignUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (LegacyRewardsProgramPanel.this.peridx == 0L && !((LegacyRewardsProgramPanel)LegacyRewardsProgramPanel.this).parentDlg.frParent.hasSecurity(11160L, 1)) {
                    DlgMessage.showMessage(LegacyRewardsProgramPanel.this.parentDlg, SP.getRS("No_Add_Person_Security"), SP.getRS("Stop"), 0);
                    return;
                }
                if (LegacyRewardsProgramPanel.this.peridx != 0L && !((LegacyRewardsProgramPanel)LegacyRewardsProgramPanel.this).parentDlg.frParent.hasSecurity(11160L, 2)) {
                    DlgMessage.showMessage(LegacyRewardsProgramPanel.this.parentDlg, SP.getRS("No_Edit_Person_Security"), SP.getRS("Stop"), 0);
                    return;
                }
                if (LegacyRewardsProgramPanel.this.parentDlg instanceof LegacyPersonDlg && ((LegacyPersonDlg)LegacyRewardsProgramPanel.this.parentDlg).isGuestAccount()) {
                    DlgMessage.showMessage(LegacyRewardsProgramPanel.this.parentDlg, SP.getRS("No_Edit_Guest_Person"), SP.getRS("Stop"), 0);
                    return;
                }
                LegacyRewardsProgramPanel.this.signUp();
            }
        });
        this.panelImage.add((Component)this.labelImage, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.progressBar, new GridBagConstraints(0, 0, 1, 5, 0.0, 1.0, 17, 0, new Insets(10, 10, 5, 5), 0, 0));
        this.add((Component)this.panelImage, new GridBagConstraints(0, 0, 1, 5, 0.0, 1.0, 17, 0, new Insets(10, 10, 5, 5), 0, 0));
        this.add((Component)this.labelProgram, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 16, 0, new Insets(10, 5, 0, 5), 0, 0));
        this.add((Component)this.labelTier, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.labelRewardsBalance, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.labelGifts, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(0, 5, 0, 5), 0, 0));
        this.add((Component)this.btnSignUp, new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 18, 0, new Insets(10, 5, 5, 5), 0, 0));
        this.reset();
    }

    private boolean signUp() {
        Vector<RewardsProgram> programs = RewardsProgram.getAllPrograms();
        if (programs.size() > 0) {
            RewardsProgram program;
            if (programs.size() == 1) {
                program = programs.elementAt(0);
            } else {
                Object[] programsArray = programs.toArray();
                program = (RewardsProgram)DlgList.showDialog(this.parentDlg.frParent, SP.getRS("Select_Rewards_Program"), SP.getRS("Rewards_Program"), programsArray, programsArray[0], true);
            }
            if (program != null) {
                if (this.peridx == 0L) {
                    this.signupRequested = true;
                    this.requestedProgram = program;
                    this.updateDisplay();
                    return true;
                }
                return this.signUp(this.peridx, program);
            }
        }
        return false;
    }

    private boolean signUp(long peridx, RewardsProgram program) {
        IRewardsApiManager apiManager = RewardsApiFactory.getApiManager();
        if (apiManager.signUp(peridx, program.getId(), this.parentDlg.frParent.getUser())) {
            this.signupRequested = false;
            this.requestedProgram = null;
            this.populateRewards(peridx, apiManager.getAccount());
            return true;
        }
        DlgMessage.showMessage(this.parentDlg, apiManager.getLastError(), SP.getRS("Rewards_Sign_up"));
        return false;
    }

    public boolean completeRequestedSignup(long peridx) {
        if (this.signupRequested && this.requestedProgram != null) {
            return this.signUp(peridx, this.requestedProgram);
        }
        return false;
    }

    public void populateRewards(long peridx, RewardsAccount customerRewardsProgram) {
        this.peridx = peridx;
        this.customerRewardsProgram = customerRewardsProgram;
        this.updateDisplay();
    }

    public void reset() {
        this.peridx = 0L;
        this.customerRewardsProgram = null;
        this.signupRequested = false;
        this.requestedProgram = null;
        this.updateDisplay();
    }

    private void updateDisplay() {
        if (this.signupRequested && this.requestedProgram != null) {
            this.labelProgram.setText(this.requestedProgram.toString());
            this.labelTier.setText(SP.getRS("Rewards_Sign_Up_On_Save"));
            this.labelRewardsBalance.setText("");
            this.labelGifts.setText("");
            this.showProgress(false);
            this.btnSignUp.setText(SP.getRS("Rewards_Program_Change_Button"));
        } else if (this.customerRewardsProgram == null || this.customerRewardsProgram.getAccountState() == RewardsAccount.AccountState.NO_ACCOUNT) {
            this.labelProgram.setText(SP.getRS("Rewards_Program"));
            this.labelTier.setText("");
            this.labelRewardsBalance.setText("");
            this.labelGifts.setText("");
            this.showProgress(false);
            this.btnSignUp.setText(SP.getRS("Rewards_Sign_Up_Button"));
        } else if (this.customerRewardsProgram.getAccountState() == RewardsAccount.AccountState.PENDING_OFFLINE) {
            this.labelProgram.setText(this.customerRewardsProgram.getRewardsProgram().toString());
            this.labelTier.setText(SP.getRS("Rewards_Pending_Not_Available"));
            this.labelRewardsBalance.setText("");
            this.labelGifts.setText("");
            this.showProgress(false);
            this.btnSignUp.setText(SP.getRS("Rewards_Program_Change_Button"));
        } else {
            this.labelProgram.setText(this.customerRewardsProgram.getRewardsProgram().toString());
            this.labelTier.setText(MessageFormat.format(SP.getRS("Rewards_Tier"), this.customerRewardsProgram.getCurrentTier().toString()));
            this.labelRewardsBalance.setText(MessageFormat.format(SP.getRS("Rewards_Balance"), SP.sParams.checkIConn() ? SP.sParams.storeCurrency.prependSymbol(SP.sParams.storeCurrency.formatDetail(this.customerRewardsProgram.getCurrentRewardsBalance())) : SP.getRS("Offline")));
            this.labelGifts.setText(MessageFormat.format(SP.getRS("Available_Gifts"), SP.sParams.checkIConn() ? Integer.valueOf(Math.max(this.customerRewardsProgram.getAvailableGifts().size(), 0)) : SP.getRS("Offline")));
            this.updateProgressBar();
            this.btnSignUp.setText(SP.getRS("Rewards_Program_Change_Button"));
        }
    }

    private void updateProgressBar() {
        double saleTotal = 0.0;
        if (this.parentDlg.frParent instanceof FrSales) {
            FrSales frSales = (FrSales)this.parentDlg.frParent;
            PaSales paSales = (PaSales)frSales.paBody;
            saleTotal = paSales.tblStyles.getDueApplicableForRewardsAccrual();
        }
        this.showProgress(this.progressBar.updateProgressBar(this.customerRewardsProgram, saleTotal, false));
    }

    private void showProgress(boolean show) {
        this.progressBar.setVisible(show);
        this.panelImage.setVisible(!show);
    }

    public boolean isSignupRequested() {
        return this.signupRequested;
    }

    public boolean signUpIfRequired() {
        if (this.signupRequested || this.customerRewardsProgram != null && this.customerRewardsProgram.getAccountState() != RewardsAccount.AccountState.NO_ACCOUNT) {
            return true;
        }
        if (RewardsUtils.isAutoSignup() || DlgMessage.showMessage(this.parentDlg, SP.getRS("Rewards_Sign_Up_Prompt_Message"), SP.getRS("Rewards_Sign_Up_Prompt_Title"), 0, 3) == 0) {
            return this.signUp();
        }
        return !RewardsUtils.isAutoSignup();
    }
}

