/*
 * Decompiled with CFR 0.152.
 */
package jpos.rewards;

import java.awt.Color;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import jpos.SP;
import jpos.rewards.RewardsAccount;
import jpos.ui.CircularProgressBar;
import jpos.ui.Colours;

public class RewardsProgressBar
extends CircularProgressBar {
    private DisplayType displayType;
    private static String tierProgressText = String.format("<html>%s</html>", SP.getRS("Rewards_Progress_Next_Tier_Html"));
    private static String rewardProgressText = String.format("<html>%s</html>", SP.getRS("Rewards_Progress_Next_Reward_Html"));

    public RewardsProgressBar(DisplayType displayType) {
        this.displayType = displayType;
        this.init();
    }

    private void init() {
        this.setBarColors(new Color[]{Colours.PROGRESS_GREEN, Colours.PROGRESS_LIGHT_GREEN});
    }

    public boolean updateProgressBar(RewardsAccount rewardsAccount, double currentSaleTotal, boolean pointsCapped) {
        int saleTotal = (int)Math.round(currentSaleTotal);
        if (rewardsAccount != null && rewardsAccount.getAccountState() == RewardsAccount.AccountState.LOADED_ONLINE) {
            double tierQualifySpend = rewardsAccount.getNextTierQualifySpend();
            double spendToNextTier = rewardsAccount.getSpendToNextTier();
            int tierProgress = (int)Math.round(tierQualifySpend) - Math.max(0, (int)Math.round(spendToNextTier));
            double spendToRewardTotal = rewardsAccount.getSpendToRewardTotal();
            double spendToNextReward = rewardsAccount.getSpendToNextReward();
            int rewardProgress = (int)Math.round(spendToRewardTotal) - Math.max(0, (int)Math.round(spendToNextReward));
            DisplayType finalDisplay = DisplayType.NONE;
            if (this.displayType == DisplayType.NEAREST_MILESTONE) {
                if (tierQualifySpend > 0.0 && rewardsAccount.getNextTier().getId() > 0L && (spendToNextTier <= spendToNextReward || spendToRewardTotal <= 0.0)) {
                    finalDisplay = DisplayType.NEXT_TIER;
                } else if (spendToRewardTotal > 0.0) {
                    finalDisplay = DisplayType.NEXT_REWARD;
                }
            } else if (this.displayType == DisplayType.NEXT_TIER && tierQualifySpend > 0.0 && rewardsAccount.getNextTier().getId() > 0L) {
                finalDisplay = DisplayType.NEXT_TIER;
            } else if (this.displayType == DisplayType.NEXT_REWARD && spendToRewardTotal > 0.0) {
                finalDisplay = DisplayType.NEXT_REWARD;
            }
            if (finalDisplay == DisplayType.NEXT_TIER) {
                this.setRange(0, (int)Math.round(tierQualifySpend));
                int intValue = (int)Math.max(0.0, spendToNextTier - currentSaleTotal);
                double doubleValue = spendToNextTier - currentSaleTotal;
                String value = "--";
                if (!pointsCapped) {
                    if (doubleValue - (double)intValue > 0.0) {
                        DecimalFormat df = new DecimalFormat("#0.00");
                        value = df.format(doubleValue);
                    } else {
                        value = NumberFormat.getInstance().format(intValue);
                    }
                }
                this.updateProgress(new int[]{tierProgress, saleTotal}, MessageFormat.format(tierProgressText, rewardsAccount.getRewardsProgram().getCurrency().prependSymbol(value), rewardsAccount.getNextTier().getName()));
                return true;
            }
            if (finalDisplay == DisplayType.NEXT_REWARD) {
                this.setRange(0, (int)Math.round(spendToRewardTotal));
                int intValue = (int)Math.max(0.0, spendToNextReward - currentSaleTotal);
                double doubleValue = spendToNextReward - currentSaleTotal;
                String value = "--";
                if (!pointsCapped) {
                    if (doubleValue - (double)intValue > 0.0) {
                        DecimalFormat df = new DecimalFormat("#0.00");
                        value = df.format(doubleValue);
                    } else {
                        value = NumberFormat.getInstance().format(intValue);
                    }
                }
                this.updateProgress(new int[]{rewardProgress, saleTotal}, MessageFormat.format(rewardProgressText, rewardsAccount.getRewardsProgram().getCurrency().prependSymbol(value)));
                return true;
            }
        }
        return false;
    }

    public static enum DisplayType {
        NONE,
        NEXT_TIER,
        NEXT_REWARD,
        NEAREST_MILESTONE;

    }
}

