/*
 * Decompiled with CFR 0.152.
 */
package jpos.stockreceipt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.StoreParams;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;

public class DlgCosting
extends PosDialog {
    JPanel panel = new JPanel();
    DialogButton bOk = new DialogButton("");
    DialogButton bCancel = new DialogButton("");
    LabelSubHeading lTitle = new LabelSubHeading();
    GridBagLayout gridBagLayout = new GridBagLayout();
    public boolean canceled = false;
    PosFrame parentFrame;
    public String cost = "00.0000";
    JTextField costInput = new JTextField(5);

    public DlgCosting(PosFrame frame) {
        super(frame, StoreParams.res.getString("StkRecCost"), true);
        this.parentFrame = frame;
        this.init();
        this.resizeDialog(this.parentFrame);
        this.setResizable(false);
    }

    private void init() {
        this.bOk.setText(StoreParams.res.getString("OK"));
        this.bOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgCosting.this.okDialog();
            }
        });
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgCosting.this.cancelDialog();
            }
        });
        this.costInput.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                if (!Character.isDigit(c) && c != '.' && c != '\b') {
                    e.consume();
                }
                String text = DlgCosting.this.costInput.getText();
                if (c == '.' && text.contains(".")) {
                    e.consume();
                }
            }
        });
        this.costInput.setPreferredSize(new Dimension(300, 30));
        this.costInput.setMinimumSize(new Dimension(300, 30));
        this.costInput.setMaximumSize(new Dimension(300, 30));
        JPanel controlPanel = new JPanel(new GridBagLayout());
        controlPanel.add((Component)this.bOk, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        controlPanel.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        controlPanel.setPreferredSize(new Dimension(controlPanel.getPreferredSize().width, controlPanel.getPreferredSize().height));
        JPanel panelMain = new JPanel(new GridBagLayout());
        panelMain.add((Component)this.costInput, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        panelMain.add((Component)controlPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add(panelMain);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.costInput);
        v.add(this.bOk);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private void resizeDialog(Window frParent) {
        Rectangle parentRect = frParent.getBounds();
        int width = 300;
        int height = 150;
        int x = parentRect.x + (parentRect.width - width) / 2;
        int y = parentRect.y + (parentRect.height - height) / 2;
        this.setBounds(x, y, width, height);
    }

    @Override
    public void cancelDialog() {
        this.canceled = true;
        this.dispose();
    }

    @Override
    public void okDialog() {
        boolean canProceed = true;
        String input = this.costInput.getText();
        boolean decimalFormat = true;
        if (input.length() < 5 || input.charAt(input.length() - 5) != '.') {
            if (input.length() >= 4 && input.charAt(input.length() - 4) == '.') {
                input = input + "0";
            } else if (input.length() >= 3 && input.charAt(input.length() - 3) == '.') {
                input = input + "00";
            } else if (input.length() >= 2 && input.charAt(input.length() - 2) == '.') {
                input = input + "000";
            } else if (input.length() >= 1 && input.charAt(input.length() - 1) == '.') {
                input = input + "0000";
            } else if (input.length() == 0) {
                input = "0.0000";
            } else if (!input.contains(".")) {
                input = input + ".0000";
            } else {
                DlgMessage.showMessage(this, StoreParams.res.getString("cost_error"), StoreParams.res.getString("cost_error_header"), -1, 0);
                canProceed = false;
            }
        }
        if (input.length() > 15 && canProceed) {
            DlgMessage.showMessage(this, StoreParams.res.getString("cost_error"), StoreParams.res.getString("cost_error_header"), -1, 0);
            canProceed = false;
        }
        if (canProceed) {
            this.cost = input;
            this.dispose();
        }
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }
}

