/*
 * Decompiled with CFR 0.152.
 */
package jpos.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import jpos.FadeLabel;
import jpos.ui.Colours;
import jpos.ui.Fonts;

public class NotificationLabel
extends FadeLabel {
    private static final double SHADOW_DARKEN_FACTOR = 0.49;
    private static final double SHADOW_START_ALPHA_FACTOR = 0.4;
    private int displayTimeMilliseconds = 2500;
    private int labelHeight = 54;

    public NotificationLabel(int fadeMilliseconds, int refreshRateMilliseconds) {
        super(fadeMilliseconds, refreshRateMilliseconds);
        this.setFont(Fonts.H2);
    }

    private Image createBackgroundImage(int width, Color colour) {
        BufferedImage image = new BufferedImage(width, this.labelHeight, 2);
        Graphics2D g = image.createGraphics();
        g.setColor(colour);
        g.fillRect(0, 0, image.getWidth(), image.getHeight() - 2);
        int shadowRed = (int)((double)colour.getRed() * 0.49);
        int shadowGreen = (int)((double)colour.getGreen() * 0.49);
        int shadowBlue = (int)((double)colour.getBlue() * 0.49);
        int shadowAlpha = (int)((double)colour.getAlpha() * 0.4);
        g.setColor(new Color(shadowRed, shadowGreen, shadowBlue, shadowAlpha));
        g.drawLine(0, image.getHeight() - 2, image.getWidth(), image.getHeight() - 2);
        g.setColor(new Color(shadowRed, shadowGreen, shadowBlue, shadowAlpha /= 2));
        g.drawLine(0, image.getHeight() - 1, image.getWidth(), image.getHeight() - 1);
        return image;
    }

    public void showSuccess(Component parent, String text) {
        this.showNotification(parent, text, Colours.NOTIFICATION_SUCCESS);
    }

    public void showError(Component parent, String text) {
        this.showNotification(parent, text, Colours.NOTIFICATION_FAILURE);
    }

    private void showNotification(Component parent, String text, Color colour) {
        Image image = this.createBackgroundImage(parent.getWidth(), colour);
        this.setIcon(new ImageIcon(image));
        this.setText(text);
        this.fadeIn(this.displayTimeMilliseconds);
    }

    public int getTotalDisplayTimeMilliseconds() {
        return this.displayTimeMilliseconds + this.getFadeMilliseconds() * 2;
    }

    public int getDisplayTimeMilliseconds() {
        return this.displayTimeMilliseconds;
    }

    public void setDisplayTimeMilliseconds(int displayTimeMilliseconds) {
        this.displayTimeMilliseconds = displayTimeMilliseconds;
    }

    public int getLabelHeight() {
        return this.labelHeight;
    }

    public void setLabelHeight(int labelHeight) {
        this.labelHeight = labelHeight;
    }
}

