/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher;

import java.sql.Date;
import java.sql.Timestamp;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.voucher.BaseVoucher;

public class CreditNote
extends BaseVoucher {
    private String creditNoteNumber;
    private boolean issued = false;
    private long gvcnidx = -1L;
    private double originalAmount = 0.0;
    private double usedAmount = 0.0;
    private Date expiryDate = null;
    private Timestamp issuedDate = null;
    private String issuedStore = "";
    private Timestamp lastUsedDate = null;
    private String lastUsedStore = "";
    private boolean posted = false;
    private String currencyIdx = "";
    private String currencyCode = "";

    public CreditNote(String creditNoteNumber) {
        this.creditNoteNumber = creditNoteNumber;
        try {
            this.loadDetails();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    @Override
    public String getNumber() {
        return this.creditNoteNumber;
    }

    @Override
    public boolean isIssued() {
        return this.issued;
    }

    @Override
    public long getGvcnidx() {
        return this.gvcnidx;
    }

    @Override
    public Date getExpiryDate() {
        return this.expiryDate;
    }

    @Override
    public double getOriginalAmount() {
        return this.originalAmount;
    }

    @Override
    public double getUsedAmount() {
        return this.usedAmount;
    }

    @Override
    public double getAvailableAmount() {
        return this.originalAmount - this.usedAmount;
    }

    @Override
    protected void loadDetails() throws Exception {
        this.originalAmount = 0.0;
        this.usedAmount = 0.0;
        this.issued = false;
        this.expiryDate = null;
        this.gvcnidx = -1L;
        this.issuedDate = null;
        this.issuedStore = "";
        this.lastUsedDate = null;
        this.lastUsedStore = "";
        this.posted = false;
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT G.GVCNIDX, COALESCE(G.AMT,0), COALESCE(G.USED_AMT,0), G.EXPIRY_DATE, G.ISSUED_DATE, ISS_W.NAME, G.LAST_REDEEMED_DATE, RED_W.NAME, COALESCE(G.POSTED,0),G.CURRENCY_IDX, CURR.CODE AS CURRENCY_CODE FROM GVCN_MAINT G LEFT JOIN REFCODE ISS_W ON G.ISSUED_WIDX = ISS_W.RCIDX LEFT JOIN REFCODE RED_W ON G.LAST_REDEEMED_WIDX = RED_W.RCIDX LEFT JOIN REFCODE CURR ON G.CURRENCY_IDX = CURR.RCIDX WHERE G.\"TYPE\" = 1 AND G.\"ACTIVE\" = 1 AND G.NUM = " + PosUtils.StringToSqlString(this.creditNoteNumber));){
            if (sql.next()) {
                this.issued = true;
                this.gvcnidx = sql.getLong(1);
                this.originalAmount = sql.getDouble(2);
                this.usedAmount = sql.getDouble(3);
                this.expiryDate = sql.getDate(4);
                this.issuedDate = sql.getTimestamp(5);
                this.issuedStore = sql.getString(6);
                this.lastUsedDate = sql.getTimestamp(7);
                this.lastUsedStore = sql.getString(8);
                this.posted = sql.getBoolean(9);
                this.currencyIdx = sql.getString("CURRENCY_IDX") == null ? "" : sql.getString("CURRENCY_IDX");
                this.currencyCode = sql.getString("CURRENCY_CODE") == null ? "" : sql.getString("CURRENCY_CODE");
            } else {
                this.issued = false;
                this.gvcnidx = -1L;
                this.originalAmount = 0.0;
                this.usedAmount = 0.0;
                this.expiryDate = PosUtils.calcExpiryDate(SP.sParams.nCreditNoteExpiryMonths);
            }
        }
    }

    @Override
    public Timestamp getIssuedDate() {
        return this.issuedDate;
    }

    @Override
    public String getIssuedStore() {
        return this.issuedStore;
    }

    @Override
    public Timestamp getLastUsedDate() {
        return this.lastUsedDate;
    }

    @Override
    public String getLastUsedStore() {
        return this.lastUsedStore;
    }

    @Override
    public boolean isPosted() {
        return this.posted;
    }

    @Override
    public String getCurrencyIdx() {
        return this.currencyIdx;
    }

    @Override
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    @Override
    public void setExpiryDate(Date expiryDate) {
        this.expiryDate = expiryDate;
    }
}

