/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher;

import java.awt.Frame;
import jpos.DlgMessage;
import jpos.PosFrame;
import jpos.SP;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.pay.VoucherPinDlg;
import jpos.voucher.DlgStatusDetails;
import jpos.voucher.IVoucherGateway;
import jpos.voucher.VoucherAdapter;
import jpos.voucher.VoucherGatewayException;
import jpos.voucher.VoucherGatewayManager;
import jpos.voucher.VoucherType;
import jpos.voucher.VoucherUtils;

public class VoucherBalanceAdapter
extends VoucherAdapter {
    private PosFrame parentWindow;

    public VoucherBalanceAdapter(PosFrame parentWindow) {
        this.parentWindow = parentWindow;
    }

    @Override
    public boolean processNumber(String voucherNumber) {
        String mappedVoucher;
        VoucherType voucherType;
        if (voucherNumber.length() > 0 && voucherNumber.toUpperCase().startsWith("CN")) {
            voucherNumber = voucherNumber.substring(2);
        }
        if ((voucherType = VoucherUtils.getVoucherType(voucherNumber)) != null && !StringUtils.isNullOrEmpty(mappedVoucher = VoucherGatewayManager.getMappedVoucher(voucherNumber))) {
            voucherNumber = mappedVoucher;
            voucherType = null;
        }
        if (voucherType == null && VoucherGatewayManager.isGatewayInUse()) {
            block17: {
                try {
                    IVoucherGateway digGatewayCheck = VoucherGatewayManager.getInstance().getGateway();
                    if (!digGatewayCheck.hasDigitalVouchers() && VoucherGatewayManager.getInstance().isValidGatewayVoucher(voucherNumber) && !VoucherGatewayManager.isGatewayReady(this.parentWindow)) {
                        return false;
                    }
                }
                catch (Exception e) {
                    if (!VoucherGatewayManager.getInstance().isValidGatewayVoucher(voucherNumber) || VoucherGatewayManager.isGatewayReady(this.parentWindow)) break block17;
                    return false;
                }
            }
            VoucherPinDlg voucherPinDlg = new VoucherPinDlg((Frame)this.parentWindow, SP.getRS("enter_pin"));
            while (true) {
                voucherPinDlg.setVisible(true);
                if (!voucherPinDlg.getResult()) {
                    return false;
                }
                try {
                    this.setGatewayVoucher(VoucherGatewayManager.getInstance().getGateway().getBalance(voucherNumber, voucherPinDlg.getPin()));
                }
                catch (VoucherGatewayException e) {
                    DlgMessage.showMessage(this.parentWindow, e.getMessage(), StoreParams.res.getString("Gift_Voucher"), 0);
                    continue;
                }
                break;
            }
            voucherPinDlg.dispose();
            this.displayCardDetails();
            return false;
        }
        if (voucherType == null) {
            if ((voucherNumber = VoucherUtils.getInternalNum(voucherNumber)) != null) {
                voucherType = VoucherUtils.getVoucherType(voucherNumber);
            }
            if (voucherType == null) {
                DlgMessage.showMessage(this.parentWindow, StoreParams.res.getString("voucher_number_not_valid"), StoreParams.res.getString("Gift_Voucher"), 0);
                return false;
            }
        }
        if (voucherType.useCheckDigit() && !VoucherUtils.verifyCheckDigit(voucherNumber)) {
            DlgMessage.showMessage(this.parentWindow, StoreParams.res.getString("voucher_number_not_valid"), StoreParams.res.getString("Stop"), 0);
            return false;
        }
        this.createVoucher(voucherType, voucherNumber);
        if (this.getVoucher().getVoucherType().getIssueType() == VoucherType.IssueType.SOLD && !this.getVoucher().isIssued()) {
            DlgMessage.showMessage(this.parentWindow, StoreParams.res.getString("GV_NotIssued"), this.getVoucher().getVoucherType().getName(), 1);
            return false;
        }
        if (this.getVoucher().getVoucherType().getIssueType() == VoucherType.IssueType.PROMO && SP.sParams.storeCurrency.round(this.getVoucher().getAvailableAmount()) == 0.0) {
            DlgMessage.showMessage(this.parentWindow, StoreParams.res.getString("GV_AlreadyRedeemed"), this.getVoucher().getVoucherType().getName(), 1);
        } else {
            this.displayCardDetails();
        }
        return false;
    }

    private void displayCardDetails() {
        DlgStatusDetails dlgStatusDetails = new DlgStatusDetails(this.parentWindow, StoreParams.res.getString("Gift_Voucher_Balance_Enquiry"), true);
        dlgStatusDetails.loadDetails(this);
        dlgStatusDetails.setVisible(true);
    }
}

