/*
 * Decompiled with CFR 0.152.
 */
package jpos.voucher.vii;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import jpos.voucher.vii.Request;
import jpos.voucher.vii.ViiConfig;

@XmlRootElement(name="Request")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class GetTransactionHistoryRequest
extends Request {
    @XmlElement(name="CardNumber")
    private String cardNumber;
    @XmlElement(name="PIN")
    private String pin;
    @XmlElement(name="PageNumber")
    private String pageNumber;
    @XmlElement(name="ResultsPerPage")
    private String resultsPerPage;
    @XmlElement(name="NewestFirst")
    private String newestFirst;

    public String getCardNumber() {
        return this.cardNumber;
    }

    public String getPIN() {
        return this.pin;
    }

    public int getPageNumber() {
        try {
            return Integer.parseInt(this.pageNumber);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public Integer getResultsPerPage() {
        if (this.resultsPerPage == null) {
            return null;
        }
        try {
            return Integer.parseInt(this.resultsPerPage);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public boolean isNewestFirst() {
        return "1".equals(this.newestFirst);
    }

    protected GetTransactionHistoryRequest() {
    }

    public GetTransactionHistoryRequest(ViiConfig config, String cardNumber, String pin, Integer resultsPerPage, boolean newestFirst, int pageNumber) {
        super(config, "GetTransactionHistory");
        this.cardNumber = cardNumber;
        this.pin = pin;
        this.pageNumber = String.valueOf(pageNumber);
        this.resultsPerPage = resultsPerPage != null ? String.valueOf(resultsPerPage) : null;
        this.newestFirst = newestFirst ? "1" : "0";
    }
}

