/*
 * Decompiled with CFR 0.152.
 */
package ReceiptPrinter;

import ReceiptPrinter.ImagePrinter;
import java.sql.Connection;
import jpos.PosUtils;
import jpos.Settings;
import jpos.SqlQuery;

public class Gen {
    private static boolean bNumCopiesLoaded = false;
    protected static int SALES_COPIES;
    protected static int CREDIT_NOTES_COPIES;
    protected static int LAYBYS_STORE_COPIES;
    protected static int LAYBYS_CUST_COPIES;
    protected static int TRANSFERS_IN_COPIES;
    protected static int TRANSFERS_OUT_COPIES;
    protected static int EOD_COPIES;
    protected static int DEBTOR_SALES_COPIES;
    protected static int RESERVATIONS_STORE_COPIES;
    protected static int RESERVATIONS_CUST_COPIES;
    protected static int SPECIAL_ORDERS_STORE_COPIES;
    protected static int SPECIAL_ORDERS_CUST_COPIES;
    protected static int CUST_ORDERS_STORE_COPIES;
    protected static int CUST_ORDERS_CUST_COPIES;
    protected static int RETURNS_STORE_COPIES;
    protected static int RETURNS_CUST_COPIES;
    protected static int CUST_ORD_COMPL_DISPATCH_SALES_COPIES;
    protected static int CUST_ORD_COMPL_DISPATCH_STORE_COPIES;
    protected static int CUST_ORD_COMPL_DISPATCH_CUST_COPIES;
    protected static int CUST_ORD_COMPL_PICKUP_SALES_COPIES;
    protected static int CUST_ORD_COMPL_PICKUP_STORE_COPIES;
    protected static int CUST_ORD_COMPL_PICKUP_CUST_COPIES;

    public static boolean PrintImage(String sPort, String sImagePath) {
        ImagePrinter ip = new ImagePrinter(sPort, sImagePath + Settings.getDocketImage());
        boolean bResult = ip.PrintImage();
        return bResult;
    }

    public static double RoundNumber(double d, int nPrec) {
        return PosUtils.scale(d, nPrec);
    }

    public static String GetSysParam(int nParIdx, Connection conn) {
        String sParStr = null;
        try (SqlQuery sql = new SqlQuery(conn, "SELECT PARSTR FROM SYSPARAM WHERE PARIDX = " + nParIdx);){
            if (sql.next()) {
                sParStr = sql.getString(1);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return sParStr;
    }

    private static void arrayFill(String[] spArray, String spFill) {
        for (int nCnt = 0; nCnt < spArray.length; ++nCnt) {
            spArray[nCnt] = spFill;
        }
    }

    public static int stringTokenize(String strSource, String strDelim, String[] saToken) {
        int cnt;
        Gen.arrayFill(saToken, "");
        if (strSource == null) {
            return 0;
        }
        int nPrevTmp = 0 - strDelim.length();
        int nTmp = strSource.indexOf(strDelim);
        for (cnt = 0; nTmp > -1 && nTmp < strSource.length() && saToken.length > cnt; ++cnt) {
            saToken[cnt] = nTmp == nPrevTmp + strDelim.length() ? "" : strSource.substring(nPrevTmp + strDelim.length(), nTmp);
            nPrevTmp = nTmp;
            nTmp = strSource.indexOf(strDelim, nPrevTmp + strDelim.length());
        }
        if (nTmp == -1 & nPrevTmp + strDelim.length() < strSource.length()) {
            saToken[cnt] = strSource.substring(nPrevTmp + strDelim.length());
            ++cnt;
        }
        return cnt;
    }

    public static String getRefName(long nRcIdx, Connection conn) {
        if (nRcIdx == 0L) {
            return "";
        }
        String sName = "";
        try (SqlQuery sql = new SqlQuery(conn, "SELECT NAME FROM REFCODE WHERE RCIDX = " + nRcIdx);){
            if (sql.next()) {
                sName = Gen.NVLString(sql.getString(1), "");
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return sName;
    }

    public static String getPayTypeName(String sRcIdx, Connection conn) {
        String sName = null;
        try (SqlQuery sql = new SqlQuery(conn, "SELECT COALESCE(PT.ALT_CODE, R.NAME) FROM REFCODE R LEFT OUTER JOIN RET_PAY_TYPES PT ON R.RCIDX = PT.RCIDX WHERE R.RCIDX = " + sRcIdx);){
            if (sql.next()) {
                sName = sql.getString(1);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return sName;
    }

    public static double getTotalCost(long nTrIdx, Connection conn) {
        double nTotal = 0.0;
        try (SqlQuery sql = new SqlQuery(conn, "SELECT SUM(D.NET) FROM RET_TRAND D WHERE D.\"ACTIVE\" = 1 AND D.LINE_TYPE in (0,2) AND D.VHIDX = " + nTrIdx);){
            if (sql.next()) {
                nTotal = sql.getDouble(1);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return nTotal;
    }

    public static String NullToEmpty(String value) {
        return Gen.NVLString(value, "");
    }

    public static String NVLString(String sOrig, String sChangeTo) {
        if (sOrig == null) {
            return sChangeTo;
        }
        return sOrig;
    }

    public static void getCurrencyFmt(Connection conn, StringBuffer sTot, StringBuffer sDet, StringBuffer sPrec) {
        try (SqlQuery sql = new SqlQuery(conn, "SELECT COALESCE(A.POSTOTFMT, ''), COALESCE(A.POSDETFMT, ''), COALESCE(A.PRECN, 0) FROM AXCUR A, WHSE W, STOREPARAMS S WHERE W.CURRIDX = A.RCIDX AND W.STORENO = S.STORENO ");){
            if (sql.next()) {
                sTot.append(sql.getString(1));
                sDet.append(sql.getString(2));
                sPrec.append(sql.getString(3));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public static void getCurrencyFmt(Connection conn, long widx, StringBuffer sTot, StringBuffer sDet, StringBuffer sPrec) {
        try (SqlQuery sql = new SqlQuery(conn, "SELECT COALESCE(A.POSTOTFMT, ''), COALESCE(A.POSDETFMT, ''), COALESCE(A.PRECN, 0) FROM AXCUR A, WHSE W, STOREPARAMS S WHERE W.CURRIDX = A.RCIDX AND W.WIDX = " + widx);){
            if (sql.next()) {
                sTot.append(sql.getString(1));
                sDet.append(sql.getString(2));
                sPrec.append(sql.getString(3));
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public static boolean openTillRequired(Connection conn, long nVhIdx) {
        boolean bRet = false;
        try (SqlQuery sql = new SqlQuery(conn, "SELECT 1 FROM RET_TRANP P, RET_PAY_TYPES T WHERE P.VHIDX = " + nVhIdx + " " + "AND P.PAYMENT_TYPEIDX = T.RCIDX AND P.\"ACTIVE\" = 1 AND T.OPEN_TILL = 1");){
            if (sql.next()) {
                bRet = true;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return bRet;
    }

    public static void getAddress(Connection conn, long nLocnIdx, String[] sArray) {
        try (SqlQuery sql = new SqlQuery(conn, "SELECT TRADENAME, ADRS1, ADRS2, CITY, STATE, POSTCODE, COUNTRY, CONTACT FROM LOCN WHERE LOCNIDX = " + nLocnIdx);){
            if (sql.next()) {
                sArray[0] = sql.getString(1);
                sArray[1] = sql.getString(2);
                sArray[2] = sql.getString(3);
                sArray[3] = sql.getString(4);
                sArray[4] = sql.getString(5);
                sArray[5] = sql.getString(6);
                sArray[6] = sql.getString(7);
                sArray[7] = sql.getString(8);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public static void populateNumCopies(Connection conn) {
        if (!bNumCopiesLoaded) {
            bNumCopiesLoaded = true;
            String sCode = null;
            int nCopies = 0;
            try (SqlQuery sql = new SqlQuery(conn, "SELECT CODE, NUM FROM NUM_POS_DOCKETS");){
                while (sql.next()) {
                    sCode = sql.getString(1);
                    nCopies = sql.getInt(2);
                    if (sCode.equals("SALES")) {
                        SALES_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("CREDIT_NOTES")) {
                        CREDIT_NOTES_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("LAYBYS_STORE")) {
                        LAYBYS_STORE_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("LAYBYS_CUST")) {
                        LAYBYS_CUST_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("TRANSFERS_IN")) {
                        TRANSFERS_IN_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("TRANSFERS_OUT")) {
                        TRANSFERS_OUT_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("EOD")) {
                        EOD_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("DEBTOR_SALES")) {
                        DEBTOR_SALES_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("RESERVATIONS_STORE")) {
                        RESERVATIONS_STORE_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("RESERVATIONS_CUST")) {
                        RESERVATIONS_CUST_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("SPECIAL_ORDERS_STORE")) {
                        SPECIAL_ORDERS_STORE_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("SPECIAL_ORDERS_CUST")) {
                        SPECIAL_ORDERS_CUST_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("CUST_ORDERS_STORE")) {
                        CUST_ORDERS_STORE_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("CUST_ORDERS_CUST")) {
                        CUST_ORDERS_CUST_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("RETURNS_STORE")) {
                        RETURNS_STORE_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("RETURNS_CUST")) {
                        RETURNS_CUST_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("COMPLETE_STOREDESP_SALES")) {
                        CUST_ORD_COMPL_DISPATCH_SALES_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("COMPLETE_STOREDESP_STORE")) {
                        CUST_ORD_COMPL_DISPATCH_STORE_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("COMPLETE_STOREDESP_CUST")) {
                        CUST_ORD_COMPL_DISPATCH_CUST_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("COMPLETE_CUSTPICKUP_SALES")) {
                        CUST_ORD_COMPL_PICKUP_SALES_COPIES = nCopies;
                        continue;
                    }
                    if (sCode.equals("COMPLETE_CUSTPICKUP_STORE")) {
                        CUST_ORD_COMPL_PICKUP_STORE_COPIES = nCopies;
                        continue;
                    }
                    if (!sCode.equals("COMPLETE_CUSTPICKUP_CUST")) continue;
                    CUST_ORD_COMPL_PICKUP_CUST_COPIES = nCopies;
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    public static enum DocketType {
        SALE,
        LAYBY,
        TRANSFER_IN,
        TRANSFER_OUT,
        STOCKTAKE,
        WITHDRAWAL,
        EXPENSE,
        CUSTRES,
        STORERES,
        GIFT_PURCHASE_DOCKET,
        TRANSFER_CHECKLIST,
        SPECIAL_ORDER,
        ACCOUNT_PAYMENT,
        PRINT_TEXT,
        CUST_ORDER,
        CUST_ORDER_PICKLIST,
        OPEN_TILL_DOCKET,
        STOCK_RECEIPT_UNEXPECTED;

    }
}

