/*
 * Decompiled with CFR 0.152.
 */
package ReceiptPrinter;

import java.awt.Image;
import java.awt.image.ImageObserver;
import java.awt.image.PixelGrabber;
import java.io.DataOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import javax.swing.ImageIcon;
import jpos.PosUtils;

public class ImagePrinter
implements ImageObserver {
    private static final String jLeft = "\u001ba\u0000";
    private static final String jCentre = "\u001ba\u0001";
    private String fileName = null;
    private String port = null;

    public ImagePrinter(String port, String fileName) {
        this.port = port;
        this.fileName = fileName;
    }

    public boolean PrintImage() {
        try {
            FileInputStream fin = new FileInputStream(this.fileName);
            Throwable throwable = null;
            if (fin != null) {
                if (throwable != null) {
                    try {
                        fin.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    fin.close();
                }
            }
        }
        catch (Exception e) {
            return false;
        }
        Image i = new ImageIcon(this.fileName).getImage();
        i.flush();
        int w = i.getWidth(this);
        int h = (i.getHeight(this) / 24 + 1) * 24;
        int[] rgbs = new int[w * h];
        for (int count = 0; count < w * h; ++count) {
            rgbs[count] = 255;
        }
        PixelGrabber pg = new PixelGrabber(i, 0, 0, w, h, rgbs, 0, w);
        try {
            pg.grabPixels();
            pg.getPixels();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        try (FileOutputStream fw = new FileOutputStream(this.port);){
            try (DataOutputStream outImage = new DataOutputStream(fw);){
                int n = 0;
                outImage.writeBytes(jCentre);
                outImage.write(27);
                outImage.write(51);
                outImage.write(24);
                int Fullh = h / 24 * 24 - 1;
                for (int hc = 0; hc < Fullh; hc += 24) {
                    outImage.write(27);
                    outImage.write(42);
                    outImage.write(33);
                    outImage.write(w);
                    outImage.write(w / 256);
                    for (int wc = 0; wc < w; ++wc) {
                        n = 0;
                        if ((rgbs[hc * w + wc] & 0xFF) < 128) {
                            n += 128;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 64;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 32;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 16;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 8;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 4;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 2;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            ++n;
                        }
                        outImage.write(n);
                        n = 0;
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 128;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 64;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 32;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 16;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 8;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 4;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 2;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            ++n;
                        }
                        outImage.write(n);
                        n = 0;
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 128;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 64;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 32;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 16;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 8;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 4;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            n += 2;
                        }
                        if ((rgbs[++hc * w + wc] & 0xFF) < 128) {
                            ++n;
                        }
                        outImage.write(n);
                        hc -= 23;
                    }
                    outImage.write(13);
                    outImage.write(10);
                }
                outImage.write(27);
                outImage.write(50);
                outImage.writeBytes(jLeft);
                outImage.flush();
            }
            fw.flush();
        }
        catch (IOException e2) {
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        rgbs = null;
        i.flush();
        i = null;
        return true;
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        throw new UnsupportedOperationException("Method imageUpdate() not yet implemented.");
    }
}

