/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jpos.Clr;
import jpos.PosDouble;
import jpos.PosUtils;
import jpos.Sku;
import jpos.StoreParams;
import jpos.Style;

public class ClrSizeTableModel
extends AbstractTableModel {
    Vector<Style> styles = new Vector();
    StoreParams sParams;
    int type;
    boolean editable = true;
    boolean allowInvalid = false;
    boolean showPrice;
    int numDescripCols = 3;
    private int populateMethod = 2;
    String[] colNames = new String[]{StoreParams.res.getString("Code"), StoreParams.res.getString("Colour"), StoreParams.res.getString("Description"), StoreParams.res.getString("Price")};
    int currentRow;
    int styleRow;
    int clrRow;
    boolean sizeHeadings;

    protected ClrSizeTableModel(int ptype, boolean pShowPrice, StoreParams psParams) {
        this.sParams = psParams;
        this.showPrice = pShowPrice;
        if (this.showPrice) {
            ++this.numDescripCols;
        }
        this.type = ptype;
    }

    protected void clear() {
        this.styles.clear();
        this.fireTableDataChanged();
    }

    public void setPopulateMethod(int type) {
        this.populateMethod = type;
    }

    protected int add_EAN(String EAN, double pqty, boolean consolidateOnly) {
        if (this.editable) {
            for (int i = this.styles.size() - 1; i >= 0; --i) {
                Sku sku;
                if (!(this.styles.elementAt(i) instanceof Style) || (sku = this.styles.elementAt(i).getSku(EAN)) == null) continue;
                sku.setQty(sku.getQty() + pqty);
                this.fireTableCellUpdated(this.getRowNum(i, this.styles.elementAt((int)i).clrs.indexOf(sku.clr), false), sku.clr.indexOf(sku) + this.numDescripCols);
                return i;
            }
            if (!consolidateOnly) {
                Style newline = new Style(EAN, pqty, this.populateMethod, this.sParams);
                for (int i = this.styles.size() - 1; i >= 0; --i) {
                    if (this.styles.elementAt((int)i).idx != newline.idx) continue;
                    this.styles.elementAt(i).addClr(newline.clrs.elementAt(0));
                    int row = this.getRowNum(i, this.styles.elementAt((int)i).clrs.size(), false);
                    this.fireTableRowsInserted(row, row);
                    return row;
                }
                if (newline.hasEAN(EAN) || this.allowInvalid) {
                    this.styles.add(newline);
                    int row = this.getRowCount();
                    this.fireTableRowsInserted(row - 1, row - 1);
                    return row - 1;
                }
            }
            return -1;
        }
        return -2;
    }

    protected Sku getSku(long skuidx) {
        for (int i = 0; i < this.styles.size(); ++i) {
            Sku sku = this.styles.elementAt(i).getSku(skuidx);
            if (sku == null) continue;
            return sku;
        }
        return null;
    }

    protected int add_sku(long skuidx, double qty, boolean consolidate) {
        if (this.editable) {
            for (int i = this.styles.size() - 1; i >= 0 && consolidate; --i) {
                if (!(this.styles.elementAt(i) instanceof Style) || this.styles.elementAt(i).getSku(skuidx) == null) continue;
                Sku sku = this.styles.elementAt(i).getSku(skuidx);
                sku.setQty(sku.getQty() + qty);
                return i;
            }
            Style style = new Style(skuidx, qty, this.populateMethod, this.sParams);
            Sku sku = style.getSku(skuidx);
            if (sku != null) {
                for (int i = this.styles.size() - 1; i >= 0; --i) {
                    Style tempStyle = this.styles.elementAt(i);
                    if (tempStyle.idx != style.idx) continue;
                    for (int j = tempStyle.clrs.size() - 1; j >= 0 && consolidate; --j) {
                        if (tempStyle.clrs.elementAt((int)j).idx != sku.clr.idx) continue;
                        tempStyle.clrs.elementAt(j).addSku(sku, sku.clr.style.sizes.elementAt(0));
                        int row = this.getRowNum(i, j, false);
                        this.fireTableRowsUpdated(row, row);
                        return row;
                    }
                    if (this.populateMethod != 1) {
                        Clr newClr = new Clr(tempStyle, sku.clr.idx, sku.clr.code, sku.clr.name);
                        tempStyle.addClr(newClr);
                        for (int j = 0; j < style.sizes.size(); ++j) {
                            newClr.addSku(sku.clr.getSku(j), style.sizes.elementAt(j));
                        }
                    } else {
                        tempStyle.addClr(sku.clr);
                    }
                    int row = this.getRowNum(i, tempStyle.clrs.size(), false);
                    this.fireTableRowsInserted(row, row);
                    return row;
                }
                if (this.type == 3) {
                    sku.setQty(0.0);
                    sku.setReqqty(qty);
                }
                this.styles.add(style);
                int row = this.getRowCount();
                this.fireTableRowsInserted(row - 1, row - 1);
                return row - 1;
            }
            return -1;
        }
        return -2;
    }

    protected double getQty(int row) {
        this.setRowCnts(row);
        if (this.styles.elementAt(this.styleRow) instanceof Style) {
            return this.styles.elementAt((int)this.styleRow).clrs.elementAt(this.clrRow).getTotQty();
        }
        return 0.0;
    }

    protected Object getItemAt(int row) {
        this.setRowCnts(row);
        if (this.sizeHeadings) {
            return this.styles.elementAt((int)this.styleRow).sizes;
        }
        return this.styles.elementAt((int)this.styleRow).clrs.elementAt(this.clrRow);
    }

    @Override
    public int getColumnCount() {
        return 30 + this.numDescripCols;
    }

    @Override
    public int getRowCount() {
        this.setRowCnts(Integer.MAX_VALUE);
        return this.currentRow + 1;
    }

    @Override
    public String getColumnName(int col) {
        if (col >= this.numDescripCols) {
            return "";
        }
        return this.colNames[col];
    }

    private void setRowCnts(int newRow) {
        if (this.currentRow != newRow) {
            this.styleRow = 0;
            this.clrRow = 0;
            this.sizeHeadings = true;
            if (this.styles.size() > 0) {
                this.currentRow = 0;
                Style currentStyle = this.styles.elementAt(0);
                while (this.currentRow < newRow) {
                    if (this.sizeHeadings) {
                        this.sizeHeadings = false;
                    } else if (this.clrRow == currentStyle.clrs.size() - 1) {
                        if (this.styleRow == this.styles.size() - 1) break;
                        this.clrRow = 0;
                        ++this.styleRow;
                        currentStyle = this.styles.elementAt(this.styleRow);
                        if (!currentStyle.sizes.containsAll(this.styles.elementAt((int)(this.styleRow - 1)).sizes) || !this.styles.elementAt((int)(this.styleRow - 1)).sizes.containsAll(currentStyle.sizes)) {
                            this.sizeHeadings = true;
                        }
                    } else {
                        ++this.clrRow;
                    }
                    ++this.currentRow;
                }
            } else {
                this.currentRow = -1;
            }
        }
    }

    private int getRowNum(int newStyle, int newClr, boolean newSizeHeadings) {
        if (this.styleRow != newStyle || this.clrRow != newClr || this.sizeHeadings != newSizeHeadings) {
            this.styleRow = 0;
            this.clrRow = 0;
            this.sizeHeadings = true;
            if (this.styles.size() > 0) {
                this.currentRow = 0;
                Style currentStyle = this.styles.elementAt(0);
                while (this.styleRow < newStyle || this.clrRow < newClr || this.sizeHeadings != newSizeHeadings) {
                    if (this.sizeHeadings) {
                        this.sizeHeadings = false;
                    } else if (this.clrRow == currentStyle.clrs.size() - 1) {
                        if (this.styleRow == this.styles.size() - 1) break;
                        this.clrRow = 0;
                        ++this.styleRow;
                        currentStyle = this.styles.elementAt(this.styleRow);
                        if (!currentStyle.sizes.containsAll(this.styles.elementAt((int)(this.styleRow - 1)).sizes) || !this.styles.elementAt((int)(this.styleRow - 1)).sizes.containsAll(currentStyle.sizes)) {
                            this.sizeHeadings = true;
                        }
                    } else {
                        ++this.clrRow;
                    }
                    ++this.currentRow;
                }
            } else {
                this.currentRow = -1;
            }
        }
        return this.currentRow;
    }

    @Override
    public Object getValueAt(int row, int col) {
        this.setRowCnts(row);
        Style style = this.styles.elementAt(this.styleRow);
        if (this.sizeHeadings) {
            if (col < this.numDescripCols) {
                return "";
            }
            return col - this.numDescripCols >= style.sizes.size() ? "" : style.sizes.elementAt(col - this.numDescripCols);
        }
        Clr clr = style.clrs.elementAt(this.clrRow);
        switch (col) {
            case 0: {
                if (this.clrRow == 0) {
                    return style.code;
                }
                return "";
            }
            case 1: {
                return clr.code;
            }
            case 2: {
                return clr.descripChanged ? clr.name : style.name + " " + clr.name;
            }
        }
        if (col == 3 && this.showPrice) {
            for (int i = 0; i < style.sizes.size(); ++i) {
                if (clr.getSku(i) == null) continue;
                return PosDouble.valueOf(clr.getSku(i).getPrice());
            }
            return "";
        }
        if (col >= style.sizes.size() + this.numDescripCols) {
            return "";
        }
        Sku sku = clr.getSku(col - this.numDescripCols);
        if (sku == null) {
            return "X";
        }
        if (sku.getQty() == 0.0) {
            return "";
        }
        return new PosDouble(sku.getQty());
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        if (!this.editable) {
            return false;
        }
        if (col < this.numDescripCols) {
            return false;
        }
        this.setRowCnts(row);
        return !this.sizeHeadings && col <= this.styles.elementAt((int)this.styleRow).sizes.size() + this.numDescripCols - 1 && this.styles.elementAt((int)this.styleRow).clrs.elementAt(this.clrRow).getSku(col - this.numDescripCols) != null;
    }

    @Override
    public void setValueAt(Object value, int row, int col) {
        try {
            this.setRowCnts(row);
            Style style = this.styles.elementAt(this.styleRow);
            if (style != null) {
                Clr clr = style.clrs.elementAt(this.clrRow);
                if (clr != null) {
                    if (col == 2) {
                        clr.setDecrip((String)value);
                    } else {
                        Sku sku = clr.getSku(col - this.numDescripCols);
                        if (sku != null) {
                            sku.setQty(PosUtils.doubleValFormatted(value.toString()));
                        }
                    }
                }
                this.fireTableCellUpdated(row, col);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    protected boolean isEditable() {
        return this.editable;
    }

    protected void setEditable(boolean ed) {
        this.editable = ed;
    }

    public void setAllowInvalid(boolean pallowInvalid) {
        this.allowInvalid = pallowInvalid;
    }

    public double getTotQty() {
        double totQty = 0.0;
        for (int i = 0; i < this.styles.size(); ++i) {
            totQty += this.styles.elementAt(i).getTotQty();
        }
        return totQty;
    }
}

