/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Statement;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.User;
import jpos.basscom.utils.Utils;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchPasswordField;
import jpos.ui.TouchTextField;
import org.jdom.Element;

public class DlgChangePassword
extends PosDialog {
    private ImageIcon image;
    private LabelSubHeading heading;
    private JTextField fieldLogin;
    private TouchPasswordField fieldPassword;
    private TouchPasswordField fieldNewPassword;
    private TouchPasswordField fieldVerifyPassword;
    private JLabel labelLength;
    private JLabel labelUpper;
    private JLabel labelLower;
    private JLabel labelNumeric;
    private JLabel labelSpecial;
    private int length;
    private int uppercase;
    private int lowercase;
    private int numeric;
    private int special;
    private int history;
    private boolean success;
    private boolean passwordMeetsReqs;
    private String errorMessage;
    private DialogButton bSignIn;
    private DialogButton bCancel;
    private static final Color Condition_Reached = new Color(82, 196, 26);
    private static final Color Condition_required = new Color(255, 77, 79);
    private User userToLogin;

    public DlgChangePassword(PosFrame frame, User loginUser, String length, String upper, String lower, String numeric, String special, String history, boolean expired) {
        super(frame, "", true);
        this.image = new ImageIcon(SP.sParams.imagepath + "sign_in.png");
        this.heading = new LabelSubHeading();
        this.labelLength = new JLabel();
        this.labelUpper = new JLabel();
        this.labelLower = new JLabel();
        this.labelNumeric = new JLabel();
        this.labelSpecial = new JLabel();
        this.length = 0;
        this.uppercase = 0;
        this.lowercase = 0;
        this.numeric = 0;
        this.special = 0;
        this.history = 0;
        this.success = false;
        this.errorMessage = "";
        this.userToLogin = loginUser;
        this.length = Integer.parseInt(length);
        this.uppercase = Integer.parseInt(upper);
        this.lowercase = Integer.parseInt(lower);
        this.numeric = Integer.parseInt(numeric);
        this.special = Integer.parseInt(special);
        this.history = Integer.parseInt(history);
        try {
            if (expired) {
                DlgMessage.showMessage(this, SP.getRS("password_expired"), SP.getRS("password_valid_header"), -1, 1);
            } else {
                DlgMessage.showMessage(this, SP.getRS("password_valid"), SP.getRS("password_valid_header"), -1, 1);
            }
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.setTitle(this.getDialogTitle());
        this.heading.setHorizontalAlignment(0);
        this.fieldLogin = new TouchTextField(TouchTextField.FontSize.LARGE);
        this.fieldLogin.setText(this.userToLogin.getMemName());
        this.fieldLogin.setEnabled(false);
        this.fieldPassword = new TouchPasswordField(TouchTextField.FontSize.LARGE);
        this.fieldPassword.setHint("Old Password");
        this.fieldNewPassword = new TouchPasswordField(TouchTextField.FontSize.LARGE);
        this.fieldNewPassword.setHint("New Password");
        this.fieldNewPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                this.checkValidation();
            }

            private void checkValidation() {
                DlgChangePassword.this.labelSpecial.setForeground(Condition_required);
                DlgChangePassword.this.labelLength.setForeground(Condition_required);
                DlgChangePassword.this.labelUpper.setForeground(Condition_required);
                DlgChangePassword.this.labelLower.setForeground(Condition_required);
                DlgChangePassword.this.labelNumeric.setForeground(Condition_required);
                int countLength = 0;
                int countUppercase = 0;
                int countLowercase = 0;
                int countNumeric = 0;
                int countSpecial = 0;
                DlgChangePassword.this.passwordMeetsReqs = true;
                DlgChangePassword.this.errorMessage = "";
                String allowedSpecialCharacters = "!@#$%^&*()_+-={}[]|\\:;\"'<>,.?/";
                char[] currentPassword = DlgChangePassword.this.fieldNewPassword.getPassword();
                if (currentPassword.length > 0) {
                    countLength = currentPassword.length;
                    for (int i = 0; i < currentPassword.length; ++i) {
                        if (Character.isUpperCase(currentPassword[i])) {
                            ++countUppercase;
                        }
                        if (Character.isLowerCase(currentPassword[i])) {
                            ++countLowercase;
                        }
                        if (Character.isDigit(currentPassword[i])) {
                            ++countNumeric;
                        }
                        if (allowedSpecialCharacters.indexOf(currentPassword[i]) == -1) continue;
                        ++countSpecial;
                    }
                    if (countLength >= DlgChangePassword.this.length) {
                        DlgChangePassword.this.labelLength.setForeground(Condition_Reached);
                    } else {
                        DlgChangePassword.this.passwordMeetsReqs = false;
                        if (DlgChangePassword.this.errorMessage.equals("") || DlgChangePassword.this.errorMessage == null) {
                            DlgChangePassword.this.errorMessage = SP.getRS("length_error", DlgChangePassword.this.length);
                        }
                    }
                    if (countUppercase >= DlgChangePassword.this.uppercase) {
                        DlgChangePassword.this.labelUpper.setForeground(Condition_Reached);
                    } else {
                        DlgChangePassword.this.passwordMeetsReqs = false;
                        if (DlgChangePassword.this.errorMessage.equals("") || DlgChangePassword.this.errorMessage == null) {
                            DlgChangePassword.this.errorMessage = SP.getRS("upper_error", DlgChangePassword.this.uppercase);
                        }
                    }
                    if (countLowercase >= DlgChangePassword.this.lowercase) {
                        DlgChangePassword.this.labelLower.setForeground(Condition_Reached);
                    } else {
                        DlgChangePassword.this.passwordMeetsReqs = false;
                        if (DlgChangePassword.this.errorMessage.equals("") || DlgChangePassword.this.errorMessage == null) {
                            DlgChangePassword.this.errorMessage = SP.getRS("lower_error", DlgChangePassword.this.lowercase);
                        }
                    }
                    if (countNumeric >= DlgChangePassword.this.numeric) {
                        DlgChangePassword.this.labelNumeric.setForeground(Condition_Reached);
                    } else {
                        DlgChangePassword.this.passwordMeetsReqs = false;
                        if (DlgChangePassword.this.errorMessage.equals("") || DlgChangePassword.this.errorMessage == null) {
                            DlgChangePassword.this.errorMessage = SP.getRS("numeric_error", DlgChangePassword.this.numeric);
                        }
                    }
                    if (countSpecial >= DlgChangePassword.this.special) {
                        DlgChangePassword.this.labelSpecial.setForeground(Condition_Reached);
                    } else {
                        DlgChangePassword.this.passwordMeetsReqs = false;
                        if (DlgChangePassword.this.errorMessage.equals("") || DlgChangePassword.this.errorMessage == null) {
                            DlgChangePassword.this.errorMessage = SP.getRS("special_error", DlgChangePassword.this.special);
                        }
                    }
                }
            }
        });
        this.fieldVerifyPassword = new TouchPasswordField(TouchTextField.FontSize.LARGE);
        this.fieldVerifyPassword.setHint("Verify Password");
        this.bSignIn = new DialogButton("");
        this.bSignIn.setText(this.getActionButtonTitle());
        this.bSignIn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgChangePassword.this.okDialog();
            }
        });
        this.bCancel = new DialogButton("");
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgChangePassword.this.cancelDialog();
            }
        });
        JPanel panelMain = new JPanel(new GridBagLayout());
        this.getContentPane().add(panelMain);
        panelMain.add((Component)this.heading, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panelMain.add((Component)this.fieldLogin, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panelMain.add((Component)this.fieldPassword, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panelMain.add((Component)this.fieldNewPassword, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panelMain.add((Component)this.fieldVerifyPassword, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        JPanel panelButtons = new JPanel(new GridBagLayout());
        panelMain.add((Component)panelButtons, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelButtons.add((Component)this.bSignIn, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 5), 0, 0));
        panelButtons.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        int currentPosition = 7;
        if (this.length > 0) {
            this.labelLength.setText("Minimum Length required: " + this.length);
            this.labelLength.setForeground(Condition_required);
            panelMain.add((Component)this.labelLength, new GridBagConstraints(0, currentPosition, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            ++currentPosition;
        }
        if (this.uppercase > 0) {
            this.labelUpper.setText("Minimum uppercase characters required: " + this.uppercase);
            this.labelUpper.setForeground(Condition_required);
            panelMain.add((Component)this.labelUpper, new GridBagConstraints(0, currentPosition, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            ++currentPosition;
        }
        if (this.lowercase > 0) {
            this.labelLower.setText("Minimum lowercase characters required: " + this.lowercase);
            this.labelLower.setForeground(Condition_required);
            panelMain.add((Component)this.labelLower, new GridBagConstraints(0, currentPosition, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            ++currentPosition;
        }
        if (this.numeric > 0) {
            this.labelNumeric.setText("Minimum numeric characters required: " + this.numeric);
            this.labelNumeric.setForeground(Condition_required);
            panelMain.add((Component)this.labelNumeric, new GridBagConstraints(0, currentPosition, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            ++currentPosition;
        }
        if (this.special > 0) {
            this.labelSpecial.setText("Minimum special characters required: " + this.special);
            this.labelSpecial.setForeground(Condition_required);
            panelMain.add((Component)this.labelSpecial, new GridBagConstraints(0, currentPosition, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
            ++currentPosition;
        }
        this.pack();
        this.setSize(this.getSize().width + 10, this.getSize().height);
        PosUtils.centreWindow(this);
        this.setVisible(true);
        this.setResizable(false);
    }

    @Override
    public void cancelDialog() {
        this.userToLogin = null;
        this.success = false;
        this.setVisible(false);
    }

    @Override
    public void okDialog() {
        if (!this.passwordMeetsReqs) {
            this.success = false;
            if (!this.errorMessage.equals("")) {
                DlgMessage.showMessage(this, this.errorMessage, SP.getRS("pass_change_unsuccess"), -1, 0);
            } else {
                DlgMessage.showMessage(this, SP.getRS("blank_pass"), SP.getRS("pass_change_unsuccess"), -1, 0);
            }
            return;
        }
        if (!String.valueOf(this.fieldPassword.getPassword()).equals(this.userToLogin.getMemPass())) {
            DlgMessage.showMessage(this, SP.getRS("old_pass_wrong"), SP.getRS("pass_change_unsuccess"), -1, 0);
            return;
        }
        if (!String.valueOf(this.fieldNewPassword.getPassword()).equals(String.valueOf(this.fieldVerifyPassword.getPassword()))) {
            DlgMessage.showMessage(this, SP.getRS("pass_missmatch"), SP.getRS("pass_missmatch_header"), -1, 0);
            return;
        }
        SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("change_password", String.format("%s,%s,%s,%s,%s", this.userToLogin.getMemName(), this.userToLogin.getMemPass(), String.valueOf(this.fieldPassword.getPassword()), String.valueOf(this.fieldNewPassword.getPassword()), String.valueOf(this.fieldVerifyPassword.getPassword()))).getXML();
        if (SP.sParams.root != null) {
            Element root = (Element)SP.sParams.root.clone();
            if (root.getAttribute("status") != null) {
                String status = root.getAttribute("status").getValue();
                if (status.equals("1")) {
                    DlgMessage.showMessage(this, SP.getRS("old_pass_wrong"), SP.getRS("pass_change_unsuccess"), -1, 0);
                    return;
                }
                if (status.equals("2")) {
                    this.success = false;
                    DlgMessage.showMessage(this, SP.getRS("pass_policy_change"), SP.getRS("pass_change_unsuccess"), -1, 0);
                } else {
                    if (status.equals("3")) {
                        DlgMessage.showMessage(this, SP.getRS("password_blacklisted"), SP.getRS("pass_change_unsuccess"), -1, 0);
                        return;
                    }
                    if (status.equals("4")) {
                        DlgMessage.showMessage(this, SP.getRS("password_in_history", this.history), SP.getRS("pass_change_unsuccess"), -1, 0);
                        return;
                    }
                    if (status.equals("5")) {
                        String oldPassword = Utils.encrypt(String.valueOf(this.fieldPassword.getPassword()).toUpperCase());
                        String newPassword = root.getAttribute("new_password").getValue();
                        try (Statement stmt = SP.sParams.conn.createStatement();){
                            stmt.executeUpdate("UPDATE MEMBER SET MEMPWD = '" + oldPassword + "' WHERE MEMIDX = " + this.userToLogin.getMemidx());
                        }
                        catch (Exception e) {
                            PosUtils.logError(e);
                        }
                        this.success = true;
                    } else {
                        if (status.equals("6")) {
                            DlgMessage.showMessage(this, SP.getRS("pass_missmatch"), SP.getRS("pass_change_unsuccess"), -1, 0);
                            return;
                        }
                        if (status.equals("-2")) {
                            DlgMessage.showMessage(this, root.getAttribute("errormessage").getValue(), SP.getRS("pass_change_unsuccess"), -1, 0);
                            this.success = false;
                        } else if (root.getAttribute("error_message") != null) {
                            this.errorMessage = root.getAttribute("error_message").getValue();
                            this.success = false;
                        }
                    }
                }
            } else {
                this.success = false;
            }
        } else {
            this.success = false;
        }
        this.setVisible(false);
    }

    private String getDialogTitle() {
        return SP.getRS("change_pass_header");
    }

    private String getActionButtonTitle() {
        return SP.getRS("change_pass_button");
    }

    public boolean getSuccess() {
        return this.success;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }
}

