/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import jpos.DlgMessage;
import jpos.PosDateFormatter;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.StoreParams;
import jpos.User;
import jpos.ui.DialogButton;

public class DlgClockAll
extends PosDialog {
    GridBagLayout gridBagLayout = new GridBagLayout();
    PosScrollPane scrollPane = new PosScrollPane();
    DialogButton bOK = new DialogButton("");
    DialogButton bSelectAll = new DialogButton("");
    DialogButton bCancel = new DialogButton("");
    PosTable tblUsers;
    boolean bFingerprint;
    private static final int COL_NAME = 0;
    private static final int COL_CLOCK_ON_TIME = 1;
    private static final int COL_NOTES = 2;
    private static final int COL_LOGOUT = 3;
    private static final int NUM_COLUMNS = 4;

    public DlgClockAll(PosFrame frame, String title, boolean modal, boolean bFingerprint) {
        super(frame, title, modal);
        this.bFingerprint = bFingerprint;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    void jbInit() throws Exception {
        this.getContentPane().setLayout(this.gridBagLayout);
        this.tblUsers = new PosTable(this, new ClockModel());
        this.tblUsers.getColumnModel().getColumn(0).setMinWidth(120);
        this.tblUsers.getColumnModel().getColumn(1).setMinWidth(155);
        this.tblUsers.getColumnModel().getColumn(2).setMinWidth(300);
        this.tblUsers.getColumnModel().getColumn(3).setMinWidth(80);
        this.bOK.setText(StoreParams.res.getString("OK"));
        this.bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgClockAll.this.okDialog();
            }
        });
        this.bSelectAll.setText(StoreParams.res.getString("F8_Select_All"));
        this.bSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgClockAll.this.bSelectAll_actionPerformed(e);
            }
        });
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgClockAll.this.cancelDialog();
            }
        });
        this.scrollPane.setMinimumSize(new Dimension(800, 26));
        this.scrollPane.setPreferredSize(new Dimension(800, 200));
        this.getContentPane().add((Component)this.scrollPane, new GridBagConstraints(0, 0, 3, 1, 2.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.getContentPane().add((Component)this.bOK, new GridBagConstraints(0, 1, 1, 1, 0.5, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.getContentPane().add((Component)this.bSelectAll, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.getContentPane().add((Component)this.bCancel, new GridBagConstraints(2, 1, 1, 1, 0.5, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.scrollPane.getViewport().add((Component)this.tblUsers, null);
        this.pack();
        PosUtils.centreWindow(this);
    }

    @Override
    public boolean myKeyPressed(KeyEvent e) {
        if (e.getKeyCode() == 119) {
            this.bSelectAll_actionPerformed(null);
            return true;
        }
        return false;
    }

    void bSelectAll_actionPerformed(ActionEvent e) {
        if (this.tblUsers.isEditing()) {
            this.tblUsers.getCellEditor().stopCellEditing();
        }
        for (int i = 0; i < this.tblUsers.getRowCount(); ++i) {
            this.tblUsers.setValueAt(new Boolean(true), i, 3);
            ((AbstractTableModel)this.tblUsers.getModel()).fireTableCellUpdated(i, 3);
        }
    }

    @Override
    public void okDialog() {
        if (this.tblUsers.isEditing()) {
            this.tblUsers.getCellEditor().stopCellEditing();
        }
        String users = "";
        for (int i = 0; i < this.tblUsers.getRowCount(); ++i) {
            if (!((Boolean)this.tblUsers.getValueAt(i, 3)).booleanValue()) continue;
            if (users.length() > 0) {
                users = users + ",";
            }
            users = users + this.tblUsers.getValueAt(i, 0);
        }
        if (users.length() > 0) {
            Object[] objs = new Object[]{"\n", users};
            if (DlgMessage.showMessage(this, MessageFormat.format(StoreParams.res.getString("confirm_clock_off"), objs), StoreParams.res.getString("Clock_Off"), 2, 3) == 0) {
                for (int i = 0; i < this.tblUsers.getRowCount(); ++i) {
                    if (!((Boolean)this.tblUsers.getValueAt(i, 3)).booleanValue()) continue;
                    this.frParent.menu.logoff(((ClockModel)this.tblUsers.getModel()).clockOff(i));
                }
                this.dispose();
            }
        }
    }

    @Override
    public void cancelDialog() {
        this.dispose();
    }

    private class ClockModel
    extends AbstractTableModel {
        Vector<User> users = new Vector();
        Vector<String> notes = new Vector();
        Vector<Boolean> clockoff = new Vector();
        PosDateFormatter dateFormatter = new PosDateFormatter(null);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClockModel() {
            try {
                try {
                    this.dateFormatter.setFormat(3, 3, 2);
                }
                catch (Exception e) {
                    // empty catch block
                }
                this.notes.add("");
                this.clockoff.add(false);
                Statement stmt = null;
                ResultSet result = null;
                try {
                    stmt = DlgClockAll.this.sParams.getStmt();
                    result = stmt.executeQuery("SELECT M.MEMIDX, P.PERIDX, M.MEMNAME, COALESCE(P.FIRSTNAME, ''), COALESCE(P.SURNAME, ''), H.TRAND FROM MEMBER M, PERSON P, RET_TRANH H WHERE M.CLOCKEDON = H.VHIDX AND M.MEMIDX = P.MEMIDX ");
                    while (result.next()) {
                        User user = new User(result.getLong(1), result.getLong(2), result.getString(3), result.getString(4), result.getString(5), result.getTimestamp(6), DlgClockAll.this.sParams);
                        if (DlgClockAll.this.frParent.getUser().isTraningUser()) {
                            user.setTrainingUser(true);
                        } else {
                            user.checkAndSetTrainingUser();
                        }
                        this.users.add(user);
                        this.notes.add("");
                        this.clockoff.add(false);
                    }
                }
                catch (Throwable throwable) {
                    PosUtils.closeResultSet(result);
                    PosUtils.closeStatement(stmt);
                    throw throwable;
                }
                PosUtils.closeResultSet(result);
                PosUtils.closeStatement(stmt);
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
        }

        @Override
        public int getRowCount() {
            return this.users.size();
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return StoreParams.res.getString("Name");
                }
                case 1: {
                    return StoreParams.res.getString("Clock_On");
                }
                case 2: {
                    return StoreParams.res.getString("Notes");
                }
                case 3: {
                    return StoreParams.res.getString("Clock_Off");
                }
            }
            return "";
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 3) {
                return Boolean.class;
            }
            return String.class;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 2 || columnIndex == 3;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.users.elementAt(rowIndex).getLoginName();
                }
                case 1: {
                    this.dateFormatter.setTimestamp(this.users.elementAt(rowIndex).clockedOnTime());
                    return this.dateFormatter.toString();
                }
                case 2: {
                    return this.notes.elementAt(rowIndex);
                }
                case 3: {
                    return this.clockoff.elementAt(rowIndex);
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 2) {
                this.notes.setElementAt((String)aValue, rowIndex);
            } else if (columnIndex == 3) {
                this.clockoff.setElementAt((Boolean)aValue, rowIndex);
            }
        }

        public long clockOff(int row) {
            if (DlgClockAll.this.bFingerprint && this.users.elementAt(row).getMemidx() == DlgClockAll.this.frParent.getUser().getMemidx()) {
                this.users.elementAt(row).clockOff(this.notes.elementAt(row), true);
            } else {
                this.users.elementAt(row).clockOff(this.notes.elementAt(row), false);
            }
            return this.users.elementAt(row).getMemidx();
        }
    }
}

