/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.KeyEventDispatcher;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.Security;
import jpos.StoreParams;
import jpos.ui.DialogButton;

public final class DlgReturnOverride
extends PosDialog
implements KeyEventDispatcher {
    private final long OVERRETURN_SECURITY = 12652L;
    private boolean result = false;
    private JPanel mainPanel = new JPanel(new GridBagLayout());
    private JPanel headerPanel = new JPanel(new GridBagLayout());
    private JPanel returnsPanel = new JPanel(new GridBagLayout());
    private JPanel proceedPanel = new JPanel(new GridBagLayout());
    private JPanel buttonPanel = new JPanel(new GridBagLayout());
    private DialogButton bYes = new DialogButton("");
    private DialogButton bNo = new DialogButton("");
    private Map<String, Vector<String>> returns;

    public DlgReturnOverride(PosFrame parent, Map<String, Vector<String>> returns) {
        super(parent, "Error", true);
        this.returns = returns;
        try {
            this.Init();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void Init() throws Exception {
        this.setAcceptOnEnter(false);
        this.setResizable(false);
        this.SetupHeadingPanel();
        this.SetupReturnPanel();
        this.SetupProceedPanel();
        this.SetupButtonPanel();
        this.getContentPane().add(this.mainPanel);
        this.mainPanel.add((Component)this.headerPanel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.mainPanel.add((Component)this.returnsPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 1, 1));
        this.mainPanel.add((Component)this.proceedPanel, new GridBagConstraints(0, 3, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 1, 1));
        this.mainPanel.add((Component)this.buttonPanel, new GridBagConstraints(0, 4, 2, 1, 0.0, 1.0, 10, 0, new Insets(0, 0, 0, 0), 1, 1));
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.bYes);
        v.add(this.bNo);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
    }

    private void SetupHeadingPanel() {
        JLabel lImage = new JLabel();
        lImage.setIcon(new ImageIcon("images/Warn.gif"));
        lImage.paint(lImage.getGraphics());
        JLabel heading = new JLabel(SP.getRS("Return_Header"));
        heading.setBackground(UIManager.getColor("Panel.background"));
        this.headerPanel.add((Component)lImage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.headerPanel.add((Component)heading, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 1, 1));
    }

    private void SetupReturnPanel() {
        Iterator<Map.Entry<String, Vector<String>>> iterator = this.returns.entrySet().iterator();
        int rowCounter = 0;
        while (iterator.hasNext()) {
            JLabel subheading;
            Map.Entry<String, Vector<String>> entry = iterator.next();
            String key = entry.getKey();
            Vector<String> values = entry.getValue();
            if (values.isEmpty()) {
                subheading = new JLabel(SP.getRS("Item_Over_Returned_Header", key));
                this.returnsPanel.add((Component)subheading, new GridBagConstraints(0, rowCounter, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 0, 0), 0, 0));
                ++rowCounter;
                continue;
            }
            subheading = new JLabel(SP.getRS("Item_Already_Returned_Header", key));
            this.returnsPanel.add((Component)subheading, new GridBagConstraints(0, rowCounter, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 0, 0), 0, 0));
            ++rowCounter;
            for (String ret : values) {
                JLabel label = new JLabel(ret);
                this.returnsPanel.add((Component)label, new GridBagConstraints(0, rowCounter, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 20, 0, 0), 0, 0));
                ++rowCounter;
            }
            JLabel label = new JLabel();
            this.returnsPanel.add((Component)label, new GridBagConstraints(0, rowCounter, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 20, 0, 0), 0, 0));
            ++rowCounter;
        }
    }

    private void SetupProceedPanel() {
        JLabel proceedLabel = new JLabel(StoreParams.res.getString("Proceed"));
        this.proceedPanel.add((Component)proceedLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 0, 0), 0, 0));
    }

    private void SetupButtonPanel() {
        this.bYes.setText(StoreParams.res.getString("Yes"));
        this.bYes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgReturnOverride.this.okDialog();
            }
        });
        this.bNo.setText(StoreParams.res.getString("No"));
        this.bNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgReturnOverride.this.cancelDialog();
            }
        });
        this.buttonPanel.add((Component)this.bYes, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonPanel.add((Component)this.bNo, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    @Override
    public void cancelDialog() {
        this.result = false;
        this.dispose();
    }

    @Override
    public void okDialog() {
        if (Security.hasSecurity(this.frParent, 12652L, this.frParent.getUser().getMemidx(), 0, true)) {
            this.result = true;
            this.dispose();
        } else {
            DlgMessage.showMessage(this, SP.getRS("no_security"), SP.getRS("Insufficient_security"), -1, 0);
            this.result = false;
        }
    }

    public boolean getResult() {
        return this.result;
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }
}

