/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import java.sql.SQLException;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTextField;
import jpos.DlgChangePassword;
import jpos.DlgMessage;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.SignInSettings;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.UareU.IUareUFingerprintListener;
import jpos.User;
import jpos.ui.DialogButton;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchPasswordField;
import jpos.ui.TouchTextField;
import org.jdom.Element;

public abstract class DlgUserValidation
extends PosDialog
implements IUareUFingerprintListener {
    private ImageIcon image;
    private LabelSubHeading heading;
    private JTextField fieldLogin;
    private TouchPasswordField fieldPassword;
    private DialogButton bOK;
    private DialogButton bCancel;
    private PosFrame frameToPass;
    private User validatedUser;

    public DlgUserValidation(PosFrame frame) {
        this(frame, false);
    }

    public DlgUserValidation(PosFrame frame, boolean showLastUsername) {
        super(frame, "", true);
        this.image = new ImageIcon(SP.sParams.imagepath + "sign_in.png");
        this.heading = new LabelSubHeading();
        this.validatedUser = null;
        try {
            this.frameToPass = frame;
            this.jbInit();
            if (showLastUsername) {
                this.setUsername(frame.getLastLoggedInUser());
            }
            if (!SignInSettings.getInstance().isUsernameOnly() && !StringUtils.isNullOrEmpty(this.fieldLogin.getText())) {
                this.fieldPassword.requestFocus();
            } else {
                this.fieldLogin.requestFocus();
            }
            this.setVisible(true);
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        if (this.sParams.bUsingFingerprintLogin) {
            if (!this.sParams.FingerprintProvider.registerFingerprintListener(this)) {
                DlgMessage.showMessage(this, StoreParams.res.getString("Fingerprint_Scanner_Registration_failed"), StoreParams.res.getString("Registration"), -1, 0);
            } else {
                this.addWindowStateListener(new WindowStateListener(){

                    @Override
                    public void windowStateChanged(WindowEvent e) {
                        if (e.getNewState() == 202) {
                            DlgUserValidation.this.sParams.FingerprintProvider.unregisterFingerprintListener(DlgUserValidation.this);
                        }
                    }
                });
            }
        }
        this.setTitle(this.getDialogTitle());
        this.heading.setHorizontalAlignment(0);
        this.heading.setIcon(this.image);
        if (!SignInSettings.getInstance().isUsernameOnly()) {
            this.fieldLogin = new TouchTextField(TouchTextField.FontSize.LARGE);
            ((TouchTextField)this.fieldLogin).setHint(SP.getRS("Login_User_Name"));
        } else {
            this.fieldLogin = new TouchPasswordField(TouchTextField.FontSize.LARGE);
            ((TouchPasswordField)this.fieldLogin).setHint(SP.getRS("Login_User_ID"));
        }
        this.fieldPassword = new TouchPasswordField(TouchTextField.FontSize.LARGE);
        this.fieldPassword.setHint(SP.getRS("Login_Password"));
        this.bOK = new DialogButton("");
        this.bOK.setText(this.getActionButtonTitle());
        this.bOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgUserValidation.this.okDialog();
            }
        });
        this.bCancel = new DialogButton("");
        this.bCancel.setText(StoreParams.res.getString("Cancel"));
        this.bCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DlgUserValidation.this.cancelDialog();
            }
        });
        JPanel panelMain = new JPanel(new GridBagLayout());
        this.getContentPane().add(panelMain);
        panelMain.add((Component)this.heading, new GridBagConstraints(0, 0, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        panelMain.add((Component)this.fieldLogin, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        if (!SignInSettings.getInstance().isUsernameOnly()) {
            panelMain.add((Component)this.fieldPassword, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        }
        JPanel panelButtons = new JPanel(new GridBagLayout());
        panelMain.add((Component)panelButtons, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        panelButtons.add((Component)this.bOK, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 5, 5), 0, 0));
        panelButtons.add((Component)this.bCancel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 5, 5), 0, 0));
        this.pack();
        PosUtils.centreWindow(this);
        this.setResizable(false);
    }

    public User getValidatedUser() {
        return this.validatedUser;
    }

    @Override
    public void cancelDialog() {
        this.validatedUser = null;
        this.setVisible(false);
    }

    @Override
    public void okDialog() {
        this.attemptLogin(!SignInSettings.getInstance().isUsernameOnly(), false);
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    @Override
    public void onFingerPrintScanned(String key) {
        if (this.isActive()) {
            if (key == null || key.length() == 0) {
                DlgMessage.showMessage(this.frParent, StoreParams.res.getString("fingerprint_not_recognised"));
                this.fieldLogin.requestFocusInWindow();
                return;
            }
            this.fieldLogin.setText(key);
            this.attemptLogin(false, true);
        }
    }

    private boolean offlineLoginCheck(Element root) {
        if (SP.sParams.root == null) {
            return true;
        }
        if (root.getAttribute("filledInfo") == null) {
            return true;
        }
        String informationFilledIn = root.getAttribute("filledInfo").getValue();
        if (informationFilledIn.equals("true")) {
            return true;
        }
        if (root.getAttribute("canLogin") == null) {
            return true;
        }
        return root.getAttribute("status") == null;
    }

    private void attemptLogin(boolean passwordRequired, boolean isFingerprintLogin) {
        Throwable throwable;
        SqlQuery sql;
        String user = !SignInSettings.getInstance().isUsernameOnly() ? ((TouchTextField)this.fieldLogin).getText() : String.valueOf(((TouchPasswordField)this.fieldLogin).getPassword());
        String password = String.valueOf(this.fieldPassword.getPassword());
        String length = "0";
        String upper = "0";
        String lower = "0";
        String numeric = "0";
        String special = "0";
        String history = "0";
        boolean offlineLogin = false;
        this.validatedUser = new User(this.sParams);
        long widx = SP.sParams.store.getWidx();
        String user_workgroups = null;
        try {
            sql = new SqlQuery(SP.sParams.conn, "SELECT USER_WORKGROUPS FROM WHSE WHERE WIDX = " + Long.toString(widx));
            throwable = null;
            try {
                if (sql.next()) {
                    user_workgroups = sql.getString("USER_WORKGROUPS");
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (sql != null) {
                    if (throwable != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
        }
        catch (SQLException ex) {
            PosUtils.logError(ex);
        }
        if (user_workgroups != null) {
            try {
                sql = new SqlQuery(SP.sParams.conn, "SELECT DISTINCT(M.MEMIDX) FROM MEMBER M JOIN PERSON P ON P.MEMIDX = M.MEMIDX JOIN GRPMEM G ON G.MEMIDX = P.MEMIDX WHERE UPPER(M.MEMNAME) = '" + user.toUpperCase() + "' " + "AND P.RETAIL_REP = 1 " + "AND P.ACTIVE = 1  " + "AND M.ACTIVE = 1 " + "AND G.GRPIDX IN (" + user_workgroups + ")");
                throwable = null;
                try {
                    if (!sql.next()) {
                        DlgMessage.showMessage(this, SP.getRS("Invalid_Login_Details"), SP.getRS("Login_Failed"), -1, 0);
                        return;
                    }
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (sql != null) {
                        if (throwable != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                PosUtils.logError(ex);
            }
        }
        SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("confirm_login", String.format("%s,%s", user, password)).getXML();
        if (SP.sParams.root == null) {
            offlineLogin = true;
        } else {
            Element root = (Element)SP.sParams.root.clone();
            boolean offlineCheck = this.offlineLoginCheck(root);
            if (!offlineCheck) {
                String polEnabled = root.getAttribute("canLogin").getValue();
                String status = root.getAttribute("status").getValue();
                if (!polEnabled.equals("true")) {
                    if (status.equals("-4")) {
                        offlineLogin = true;
                    } else if (status.equals("-3")) {
                        DlgMessage.showMessage(this, root.getAttribute("errormessage").getValue(), "Error", -1, 0);
                        offlineLogin = true;
                    } else {
                        DlgMessage.showMessage(this, SP.getRS("Invalid_Login_Details"), SP.getRS("Login_Failed"), -1, 0);
                        offlineLogin = true;
                    }
                } else if (!status.equals("0")) {
                    if (status.equals("-2")) {
                        DlgMessage.showMessage(this, root.getAttribute("errormessage").getValue(), "Issue validating login credentials via headoffice continuing locally", -1, 0);
                        offlineLogin = true;
                    } else if (status.equals("1")) {
                        length = root.getAttribute("length").getValue();
                        upper = root.getAttribute("upper").getValue();
                        lower = root.getAttribute("lower").getValue();
                        numeric = root.getAttribute("numeric").getValue();
                        special = root.getAttribute("special").getValue();
                        history = root.getAttribute("history").getValue();
                        this.validatedUser.attemptLogin(user, password, 0L, passwordRequired, isFingerprintLogin, true);
                        DlgChangePassword changePassword = new DlgChangePassword(this.frameToPass, this.validatedUser, length, upper, lower, numeric, special, history, true);
                        if (!changePassword.getSuccess()) {
                            DlgMessage.showMessage(this, SP.getRS("unsuccess_login"), SP.getRS("unsuccess_login_header"), -1, 0);
                            return;
                        }
                        DlgMessage.showMessage(this, SP.getRS("succesful_login"), SP.getRS("succesful_login_header"), -1, 1);
                    } else if (status.equals("2")) {
                        length = root.getAttribute("length").getValue();
                        upper = root.getAttribute("upper").getValue();
                        lower = root.getAttribute("lower").getValue();
                        numeric = root.getAttribute("numeric").getValue();
                        special = root.getAttribute("special").getValue();
                        history = root.getAttribute("history").getValue();
                        this.validatedUser.attemptLogin(user, password, 0L, passwordRequired, isFingerprintLogin, true);
                        DlgChangePassword changePassword = new DlgChangePassword(this.frameToPass, this.validatedUser, length, upper, lower, numeric, special, history, false);
                        if (!changePassword.getSuccess()) {
                            DlgMessage.showMessage(this, SP.getRS("unsuccess_login"), SP.getRS("unsuccess_login_header"), -1, 0);
                            return;
                        }
                        DlgMessage.showMessage(this, SP.getRS("succesful_login"), SP.getRS("succesful_login_header"), -1, 1);
                    } else {
                        if (status.equals("3")) {
                            this.validatedUser = null;
                            DlgMessage.showMessage(this, StoreParams.res.getString("Invalid_Login_Details"), StoreParams.res.getString("Login_Failed"), -1, 0);
                            return;
                        }
                        offlineLogin = true;
                    }
                }
            } else {
                offlineLogin = true;
            }
        }
        if (offlineLogin) {
            if (!this.validatedUser.attemptLogin(user, password, 0L, passwordRequired, isFingerprintLogin)) {
                this.validatedUser = null;
                DlgMessage.showMessage(this, StoreParams.res.getString("Invalid_Login_Details"), StoreParams.res.getString("Login_Failed"), -1, 0);
                return;
            }
        } else {
            this.validatedUser.attemptLogin(user, password, 0L, passwordRequired, isFingerprintLogin, true);
        }
        this.setVisible(false);
    }

    private void setUsername(User user) {
        if (!SignInSettings.getInstance().isUsernameOnly() && user != null && !StringUtils.isNullOrEmpty(user.getMemName())) {
            this.fieldLogin.setText(user.getMemName());
        }
    }

    public abstract String getDialogTitle();

    public abstract String getActionButtonTitle();
}

