/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import jpos.Settings;

public class ExceptionInjector {
    public static final String EXCEPTION_MESSAGE = "Injected Exception";

    private static boolean needInject(Process process) {
        if (Settings.needInjectException()) {
            try {
                String jarDir = new File(Settings.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getParentFile().getPath();
                Path path = Paths.get(jarDir, "..", "ExceptionInjector.txt");
                List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
                for (String line : lines) {
                    for (String pos : line.split(",")) {
                        if (pos == null || !pos.trim().toUpperCase().equals(process.name())) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static void Inject(Process process) throws Exception {
        ExceptionInjector.Inject(process, new Exception(EXCEPTION_MESSAGE));
    }

    public static <T extends Throwable> void Inject(Process position, T exception) throws T {
        if (exception != null && ExceptionInjector.needInject(position)) {
            throw exception;
        }
    }

    public static enum Process {
        AFTERPAYGATEWAY_GET_REFUND_FAILURE,
        AFTERPAYGATEWAY_GET_REFUND_UNKNOWN,
        AFTERPAYGATEWAY_CREATE_REFUND_FAILURE,
        AFTERPAYGATEWAY_CREATE_REFUND_UNKNOWN_FAILURE,
        AFTERPAYGATEWAY_CREATE_REFUND_UNKNOWN_SUCCESS,
        PAYMENTDLG_END_OF_COMPLETE,
        VII_LOAD_VOUCHER,
        VII_REDEEM_VOUCHER,
        VII_UNDO,
        VII_VERIFY_STORE,
        VII_BALANCE_ENQUIRY,
        VII_NEWORDER_VOUCHER;

    }
}

