/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.Connection;
import java.sql.SQLException;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.TranslatedException;
import jpos.XMLUtils;
import org.jdom.Element;

public class OmniChannel {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getDocketNumber(Connection conn, long ownerWidx) throws TranslatedException {
        try (SqlQuery query = new SqlQuery(conn, "SELECT DOCKET_NUMBER FROM OMNI_DOCKET_ALLOC A WHERE A.TILL_NUMBER = ? AND A.OWNER_WIDX = ?", SP.sParams.tillnum, ownerWidx);){
            String existingDocket;
            if (query.next() && !StringUtils.isNullOrEmpty(existingDocket = query.getString("DOCKET_NUMBER"))) {
                String string = existingDocket;
                return string;
            }
        }
        catch (SQLException e) {
            throw new TranslatedException("Omni_Docket_Error_Local", "\n", e.getMessage());
        }
        if (!SP.sParams.checkIConn()) {
            throw new TranslatedException("Omni_Docket_Offline", new Object[0]);
        }
        Element docketElement = SP.sParams.OnlineQueryProvider.getOnlineQuery("omni_docket", String.valueOf(ownerWidx)).getXML();
        if (docketElement == null) {
            throw new TranslatedException("Omni_Docket_Error_No_Response", new Object[0]);
        }
        if (!"true".equals(XMLUtils.getValue(docketElement, "success"))) {
            String error = XMLUtils.getValue(docketElement, "error");
            if (StringUtils.isNullOrEmpty(error)) throw new TranslatedException("Omni_Docket_Error_Unknown", new Object[0]);
            throw new TranslatedException("Omni_Docket_Error", "\n", error);
        }
        String docket = XMLUtils.getValue(docketElement, "docket_number");
        try {
            int updated = SP.sParams.executeSequenceUpdate("UPDATE OMNI_DOCKET_ALLOC A SET A.DOCKET_NUMBER = ?, RETRIEVED_DATE = CURRENT_TIMESTAMP WHERE A.TILL_NUMBER = ? AND A.OWNER_WIDX = ?", docket, SP.sParams.tillnum, ownerWidx);
            if (updated != 0) return docket;
            SP.sParams.executeSequenceUpdate("INSERT INTO OMNI_DOCKET_ALLOC (TILL_NUMBER, OWNER_WIDX, DOCKET_NUMBER, RETRIEVED_DATE) VALUES (?, ?, ?, CURRENT_TIMESTAMP)", SP.sParams.tillnum, ownerWidx, docket);
            return docket;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        return docket;
    }

    public static void consumeDocketNumber(Connection conn, long ownerWidx, String docketNumber) throws SQLException {
        SqlQuery.executeUpdate(conn, "UPDATE OMNI_DOCKET_ALLOC A SET A.DOCKET_NUMBER = NULL, RETRIEVED_DATE = NULL WHERE A.TILL_NUMBER = ? AND A.OWNER_WIDX = ? AND A.DOCKET_NUMBER = ?", SP.sParams.tillnum, ownerWidx, docketNumber);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean warehouseExistsLocally(long widx) {
        try (SqlQuery query = new SqlQuery(SP.sParams.conn, "SELECT 1 FROM REFCODE R WHERE R.RCIDX = ? AND R.RGIDX = 7 AND R.ACTIVE = 1", widx);){
            if (!query.next()) return false;
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        return false;
    }

    public static String encodeDocketNumber(long ownerWidx, String ownerDocketNumber) {
        return "D" + SP.sParams.getStore(ownerWidx).getStoreNo() + ownerDocketNumber;
    }

    public static long assignSaleToOwner(Connection conn, long vhIdx, long ownerWidx, String ownerDocketNumber) {
        try {
            double totalPayment = 0.0;
            int numPayments = 0;
            try (SqlQuery query = new SqlQuery(conn, "SELECT SUM(PAYMENT_AMOUNT) AS TOTAL_PAYMENT, COUNT(VSHIDX) AS NUM_PAYMENTS FROM RET_TRANP WHERE VHIDX = ? AND ACTIVE = 1", vhIdx);){
                if (query.next()) {
                    totalPayment = query.getDouble("TOTAL_PAYMENT");
                    numPayments = query.getInt("NUM_PAYMENTS");
                }
            }
            SqlQuery.executeUpdate(conn, "UPDATE RET_TRANH SET DESPATCH_WIDX = WIDX, WIDX = ? WHERE VHIDX = ?", ownerWidx, vhIdx);
            if (numPayments > 0) {
                long newVhidx = SP.sParams.nextVal("XRET_TRANH");
                SqlQuery.executeUpdate(conn, "INSERT INTO RET_TRANH(VHIDX, TR_TYPE, DOCKET_NUMBER, WIDX, SREPIDX, CLIENTIDX, MEMBER_GENERATEDIDX, NOTES1, REF1, REF2, REF3, REF4, REF5, REF6, REF7, REF8, REF9, REF10, STAFF_SALE_FLAG, TILL_NUMBER, TRAND, TRANS_NUMBER, \"ACTIVE\", COMPLETE, ORIG_TRANIDX, NOTES2, CORDER, TRANSMEMIDX, TRANSSREPIDX, SALE_DATE, CONNUM, CARRIERIDX, CARRIER_CODE, SERVICETYPE_IDX, DELIVERY_LOCNIDX, BILLING_LOCNIDX, ORIGIN, POINTS_PARTNER_RCIDX, POINTS_PARTNER_NUM, COUNTRY_CODE, PAYMENT_FOR_VHIDX) SELECT ?, H.TR_TYPE, ?, ?, H.SREPIDX, H.CLIENTIDX, H.MEMBER_GENERATEDIDX, H.NOTES1, H.REF1, H.REF2, H.REF3, H.REF4, H.REF5, H.REF6, H.REF7, H.REF8, H.REF9, H.REF10, H.STAFF_SALE_FLAG, H.TILL_NUMBER, H.TRAND, ?, H.\"ACTIVE\", H.COMPLETE, H.VHIDX, H.NOTES2, H.CORDER, H.TRANSMEMIDX, H.TRANSSREPIDX, H.SALE_DATE, H.CONNUM, H.CARRIERIDX, H.CARRIER_CODE, H.SERVICETYPE_IDX, H.DELIVERY_LOCNIDX, H.BILLING_LOCNIDX, H.ORIGIN, H.POINTS_PARTNER_RCIDX, H.POINTS_PARTNER_NUM, H.COUNTRY_CODE, H.VHIDX FROM RET_TRANH H WHERE H.VHIDX = ?", newVhidx, PosUtils.padZeroes(SP.sParams.getNextDocketNum("OmniChannel.assignSaleToOwner"), 8), SP.sParams.getStoreIdx(), OmniChannel.encodeDocketNumber(ownerWidx, ownerDocketNumber), vhIdx);
                SqlQuery.executeUpdate(conn, "UPDATE RET_TRANP SET VHIDX = ?, SEQUENCE_NUMBER = SEQUENCE_NUMBER + 1 WHERE VHIDX = ?", newVhidx, vhIdx);
                if (totalPayment != 0.0) {
                    SqlQuery.executeUpdate(conn, "INSERT INTO RET_TRANP(VSHIDX, VHIDX, \"ACTIVE\", PAYMENT_AMOUNT, PAYMENT_TYPEIDX, SEQUENCE_NUMBER, CASHOUT_AMOUNT, CRDT) VALUES(?, ?, 1, ?, 716, 0, 0, CURRENT_TIMESTAMP)", SP.sParams.nextVal("XRET_TRANP"), newVhidx, SP.sParams.rnd(totalPayment * -1.0));
                    SqlQuery.executeUpdate(conn, "INSERT INTO RET_TRANP(VSHIDX, VHIDX, \"ACTIVE\", PAYMENT_AMOUNT, PAYMENT_TYPEIDX, SEQUENCE_NUMBER, CASHOUT_AMOUNT, CRDT) VALUES(?, ?, 1, ?, 730, 0, 0, CURRENT_TIMESTAMP)", SP.sParams.nextVal("XRET_TRANP"), vhIdx, totalPayment);
                }
                return newVhidx;
            }
            return -1L;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return -1L;
        }
    }
}

