/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import jpos.DlgMessage;
import jpos.FrReservations;
import jpos.PaReserveFoot;
import jpos.PosDouble;
import jpos.PosFrame;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.SP;
import jpos.SkuReservation;
import jpos.SqlQuery;
import jpos.StoreParams;
import jpos.StringField;
import jpos.TotalsTable;
import jpos.TotalsTableModel;
import jpos.person.PersonUtils;
import jpos.ui.Colours;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class PaReservations
extends JPanel {
    GridBagLayout gridBagLayout = new GridBagLayout();
    public static final int ReservationType_GrpIdx = 466;
    ReserveTable tblReserve;
    private TotalsTable tblTotals;
    LabelSubHeading lCustFilter = new LabelSubHeading();
    StringField tfPerName = new StringField();
    StringField tfPerPhone = new StringField();
    LabelSubHeading lProdFilter = new LabelSubHeading();
    StringField tfStyleCode = new StringField();
    StringField tfClrCode = new StringField();
    StringField tfSize = new StringField();
    LabelNormal lPerName = new LabelNormal();
    LabelNormal lStyleCode = new LabelNormal();
    LabelNormal lPhone = new LabelNormal();
    LabelNormal lClrCode = new LabelNormal();
    LabelNormal lSize = new LabelNormal();
    LabelSubHeading lResvFilter = new LabelSubHeading();
    LabelNormal lDocket = new LabelNormal();
    LabelNormal lResType = new LabelNormal();
    LabelNormal lbarcode = new LabelNormal();
    StringField tfDocket = new StringField();
    StringField tfResType = new StringField();
    StringField tfbarcode = new StringField();
    PosFrame frParent;
    StoreParams sParams;

    public PaReservations(PosFrame pparent) {
        try {
            this.frParent = pparent;
            this.sParams = this.frParent.sParams;
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    private void jbInit() throws Exception {
        this.tblReserve = new ReserveTable(this.frParent, new ReserveTableModel());
        this.tblReserve.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                PaReservations.this.update();
            }
        });
        TotalsTableModel totalsTableModel = new TotalsTableModel(this.tblReserve.getModel()){

            @Override
            public Object getValueAt(int row, int col) {
                if (row != 0) {
                    return "";
                }
                switch (col) {
                    case 0: {
                        return StoreParams.totalText;
                    }
                    case 10: {
                        return new PosDouble(PaReservations.this.tblReserve.getTotQty());
                    }
                    case 11: {
                        return new PosDouble(PaReservations.this.tblReserve.getTotValue());
                    }
                }
                return "";
            }
        };
        this.tblTotals = new TotalsTable(this.frParent, this.tblReserve, totalsTableModel);
        this.setLayout(this.gridBagLayout);
        this.lCustFilter.setText(StoreParams.res.getString("Customer_Filter"));
        this.lResvFilter.setText(StoreParams.res.getString("Reservation_Filter"));
        this.tfPerPhone.setFieldWidth(100);
        this.tfPerPhone.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PaReservations.this.tblReserve.filter(PaReservations.this.tfPerName.getText(), PaReservations.this.tfPerPhone.getText(), PaReservations.this.tfStyleCode.getText(), PaReservations.this.tfClrCode.getText(), PaReservations.this.tfSize.getText(), PaReservations.this.tfDocket.getText(), PaReservations.this.tfResType.getText(), PaReservations.this.tfbarcode.getText());
            }
        });
        this.tfPerPhone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaReservations.this.tblReserve.filter(PaReservations.this.tfPerName.getText(), PaReservations.this.tfPerPhone.getText(), PaReservations.this.tfStyleCode.getText(), PaReservations.this.tfClrCode.getText(), PaReservations.this.tfSize.getText(), PaReservations.this.tfDocket.getText(), PaReservations.this.tfResType.getText(), PaReservations.this.tfbarcode.getText());
            }
        });
        this.tfPerName.setFieldWidth(100);
        this.tfPerName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaReservations.this.tblReserve.filter(PaReservations.this.tfPerName.getText(), PaReservations.this.tfPerPhone.getText(), PaReservations.this.tfStyleCode.getText(), PaReservations.this.tfClrCode.getText(), PaReservations.this.tfSize.getText(), PaReservations.this.tfDocket.getText(), PaReservations.this.tfResType.getText(), PaReservations.this.tfbarcode.getText());
            }
        });
        this.tfPerName.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PaReservations.this.tblReserve.filter(PaReservations.this.tfPerName.getText(), PaReservations.this.tfPerPhone.getText(), PaReservations.this.tfStyleCode.getText(), PaReservations.this.tfClrCode.getText(), PaReservations.this.tfSize.getText(), PaReservations.this.tfDocket.getText(), PaReservations.this.tfResType.getText(), PaReservations.this.tfbarcode.getText());
            }
        });
        this.lProdFilter.setText(StoreParams.res.getString("Product_Filter"));
        this.tfStyleCode.setFieldWidth(100);
        this.tfStyleCode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PaReservations.this.tblReserve.filter(PaReservations.this.tfPerName.getText(), PaReservations.this.tfPerPhone.getText(), PaReservations.this.tfStyleCode.getText(), PaReservations.this.tfClrCode.getText(), PaReservations.this.tfSize.getText(), PaReservations.this.tfDocket.getText(), PaReservations.this.tfResType.getText(), PaReservations.this.tfbarcode.getText());
            }
        });
        this.tfStyleCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaReservations.this.tblReserve.filter(PaReservations.this.tfPerName.getText(), PaReservations.this.tfPerPhone.getText(), PaReservations.this.tfStyleCode.getText(), PaReservations.this.tfClrCode.getText(), PaReservations.this.tfSize.getText(), PaReservations.this.tfDocket.getText(), PaReservations.this.tfResType.getText(), PaReservations.this.tfbarcode.getText());
            }
        });
        this.tfClrCode.setFieldWidth(100);
        this.tfClrCode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PaReservations.this.tblReserve.filter(PaReservations.this.tfPerName.getText(), PaReservations.this.tfPerPhone.getText(), PaReservations.this.tfStyleCode.getText(), PaReservations.this.tfClrCode.getText(), PaReservations.this.tfSize.getText(), PaReservations.this.tfDocket.getText(), PaReservations.this.tfResType.getText(), PaReservations.this.tfbarcode.getText());
            }
        });
        this.tfClrCode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaReservations.this.tblReserve.filter(PaReservations.this.tfPerName.getText(), PaReservations.this.tfPerPhone.getText(), PaReservations.this.tfStyleCode.getText(), PaReservations.this.tfClrCode.getText(), PaReservations.this.tfSize.getText(), PaReservations.this.tfDocket.getText(), PaReservations.this.tfResType.getText(), PaReservations.this.tfbarcode.getText());
            }
        });
        this.tfSize.setFieldWidth(100);
        this.tfSize.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PaReservations.this.tblReserve.filter(PaReservations.this.tfPerName.getText(), PaReservations.this.tfPerPhone.getText(), PaReservations.this.tfStyleCode.getText(), PaReservations.this.tfClrCode.getText(), PaReservations.this.tfSize.getText(), PaReservations.this.tfDocket.getText(), PaReservations.this.tfResType.getText(), PaReservations.this.tfbarcode.getText());
            }
        });
        this.tfDocket.setFieldWidth(150);
        this.tfDocket.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PaReservations.this.tblReserve.filter(PaReservations.this.tfPerName.getText(), PaReservations.this.tfPerPhone.getText(), PaReservations.this.tfStyleCode.getText(), PaReservations.this.tfClrCode.getText(), PaReservations.this.tfSize.getText(), PaReservations.this.tfDocket.getText(), PaReservations.this.tfResType.getText(), PaReservations.this.tfbarcode.getText());
            }
        });
        this.tfDocket.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaReservations.this.tblReserve.filter(PaReservations.this.tfPerName.getText(), PaReservations.this.tfPerPhone.getText(), PaReservations.this.tfStyleCode.getText(), PaReservations.this.tfClrCode.getText(), PaReservations.this.tfSize.getText(), PaReservations.this.tfDocket.getText(), PaReservations.this.tfResType.getText(), PaReservations.this.tfbarcode.getText());
            }
        });
        this.tfResType.setFieldWidth(150);
        this.tfResType.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PaReservations.this.tblReserve.filter(PaReservations.this.tfPerName.getText(), PaReservations.this.tfPerPhone.getText(), PaReservations.this.tfStyleCode.getText(), PaReservations.this.tfClrCode.getText(), PaReservations.this.tfSize.getText(), PaReservations.this.tfDocket.getText(), PaReservations.this.tfResType.getText(), PaReservations.this.tfbarcode.getText());
            }
        });
        this.tfResType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaReservations.this.tblReserve.filter(PaReservations.this.tfPerName.getText(), PaReservations.this.tfPerPhone.getText(), PaReservations.this.tfStyleCode.getText(), PaReservations.this.tfClrCode.getText(), PaReservations.this.tfSize.getText(), PaReservations.this.tfDocket.getText(), PaReservations.this.tfResType.getText(), PaReservations.this.tfbarcode.getText());
            }
        });
        this.tfbarcode.setFieldWidth(150);
        this.tfbarcode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                PaReservations.this.tblReserve.filter(PaReservations.this.tfPerName.getText(), PaReservations.this.tfPerPhone.getText(), PaReservations.this.tfStyleCode.getText(), PaReservations.this.tfClrCode.getText(), PaReservations.this.tfSize.getText(), PaReservations.this.tfDocket.getText(), PaReservations.this.tfResType.getText(), PaReservations.this.tfbarcode.getText());
            }
        });
        this.tfbarcode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaReservations.this.tblReserve.filter(PaReservations.this.tfPerName.getText(), PaReservations.this.tfPerPhone.getText(), PaReservations.this.tfStyleCode.getText(), PaReservations.this.tfClrCode.getText(), PaReservations.this.tfSize.getText(), PaReservations.this.tfDocket.getText(), PaReservations.this.tfResType.getText(), PaReservations.this.tfbarcode.getText());
            }
        });
        this.lPerName.setText(StoreParams.res.getString("Name"));
        this.lStyleCode.setText(StoreParams.res.getString("Product"));
        this.lPhone.setText(StoreParams.res.getString("Phone_Number"));
        this.lClrCode.setText(StoreParams.res.getString("Colour"));
        this.lSize.setText(StoreParams.res.getString("Size"));
        this.lDocket.setText(StoreParams.res.getString("Docket_"));
        this.lResType.setText(StoreParams.res.getString("Reservation_Type"));
        this.lbarcode.setText(StoreParams.res.getString("Barcode"));
        this.add((Component)this.tblReserve.getScrollPane(), new GridBagConstraints(0, 3, 8, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 397, 297));
        this.add((Component)this.tblTotals.getScrollPane(), new GridBagConstraints(0, 4, 8, 1, 1.0, 0.0, 15, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.lCustFilter, new GridBagConstraints(0, 0, 8, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.tfPerName, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 5, 0), 0, 0));
        this.add((Component)this.tfPerPhone, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 40), 0, 0));
        this.add((Component)this.lProdFilter, new GridBagConstraints(2, 0, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.tfStyleCode, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.tfClrCode, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.tfSize, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.tfbarcode, new GridBagConstraints(5, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 40), 0, 0));
        this.add((Component)this.lResvFilter, new GridBagConstraints(6, 0, 7, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.tfDocket, new GridBagConstraints(6, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.tfResType, new GridBagConstraints(7, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 5, 0), 0, 0));
        this.add((Component)this.lPerName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0));
        this.add((Component)this.lStyleCode, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.lPhone, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.lClrCode, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.lSize, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.lbarcode, new GridBagConstraints(5, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.lDocket, new GridBagConstraints(6, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.add((Component)this.lResType, new GridBagConstraints(7, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
    }

    public void populate(String extraWhere) {
        this.tblReserve.populate(extraWhere);
        this.tblReserve.filter(this.tfPerName.getText(), this.tfPerPhone.getText(), this.tfStyleCode.getText(), this.tfClrCode.getText(), this.tfSize.getText(), this.tfDocket.getText(), this.tfResType.getText(), this.tfbarcode.getText());
    }

    public void clear() {
        this.tblReserve.clear();
    }

    protected void update() {
        ((PaReserveFoot)this.frParent.paFoot).bSave.setEnabled(false);
        for (int i = 0; i < this.tblReserve.getRowCount(); ++i) {
            if (!this.tblReserve.getReservation(i).getStyleLine().isAvailQtyChanged()) continue;
            ((PaReserveFoot)this.frParent.paFoot).bSave.setEnabled(true);
        }
    }

    public class ReserveTable
    extends PosTable {
        ReserveTableModel model;

        public ReserveTable(PosFrame pfrParent, ReserveTableModel pmodel) {
            super(pfrParent, pmodel);
            this.model = pmodel;
            this.setAutoResizeMode(0);
            this.setSelectionMode(0);
            this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    SkuReservation res = ReserveTable.this.getReservation(ReserveTable.this.getSelectedRow());
                    PaReservations.this.frParent.setVhidx(res == null ? -1L : res.getVhidx());
                    ReserveTable.this.RefreshImage();
                }
            });
            for (int i = 0; i < 7; ++i) {
                if (i == 2) continue;
                this.getColumnModel().getColumn(i).setHeaderRenderer(this.headerLeftRen);
            }
            this.getColumnModel().getColumn(0).setPreferredWidth(150);
            this.getColumnModel().getColumn(1).setPreferredWidth(150);
            this.getColumnModel().getColumn(2).setPreferredWidth(90);
            this.getColumnModel().getColumn(3).setPreferredWidth(100);
            this.renderer.setColumnFormat(3, null, 0);
            this.getColumnModel().getColumn(4).setPreferredWidth(105);
            this.getColumnModel().getColumn(5).setPreferredWidth(150);
            this.getColumnModel().getColumn(6).setPreferredWidth(120);
            this.getColumnModel().getColumn(7).setPreferredWidth(80);
            this.renderer.setColumnFormat(7, null, 0);
            this.renderer.setColumnFormat(8, StoreParams.qtyFormat, 0);
            this.getColumnModel().getColumn(8).setMaxWidth(80);
            this.getColumnModel().getColumn(8).setMinWidth(100);
            this.getColumnModel().getColumn(8).setPreferredWidth(80);
            this.renderer.setColumnFormat(9, StoreParams.qtyFormat, 0);
            this.getColumnModel().getColumn(9).setCellEditor(this.qtyEd);
            this.getColumnModel().getColumn(9).setMaxWidth(80);
            this.getColumnModel().getColumn(9).setMinWidth(80);
            this.getColumnModel().getColumn(9).setPreferredWidth(80);
            this.renderer.setColumnFormat(10, StoreParams.qtyFormat, 0);
            this.getColumnModel().getColumn(10).setHeaderRenderer(this.headerLeftRen);
            this.getColumnModel().getColumn(10).setMaxWidth(90);
            this.getColumnModel().getColumn(10).setMinWidth(90);
            this.getColumnModel().getColumn(10).setPreferredWidth(90);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1) {
                        ((FrReservations)PaReservations.this.frParent).sellItem();
                    }
                }
            });
        }

        @Override
        public Color getDisplayForegroundAt(Object value, int row, int column) {
            if (row >= 0 && (column == 0 ? this.getReservation(row).getPerson().getChildren("note").size() > 0 : column == 4 && this.getReservation(row).getNotesXML().size() > 0)) {
                return Colours.RED;
            }
            return this.renderer.defaultColour;
        }

        public void populate(String extraWhere) {
            this.model.populate(extraWhere);
        }

        public void clear() {
            this.model.clear();
        }

        public double getTotValue() {
            return this.model.getTotValue();
        }

        public double getTotQty() {
            return this.model.getTotQty();
        }

        public SkuReservation removeReservation(int row) {
            return this.model.removeReservation(row);
        }

        public SkuReservation getReservation(int row) {
            return this.model.getReservation(row);
        }

        public void filter(String PName, String Phone, String SCode, String CCode, String Size, String Docket, String ResType, String Barcode2) {
            this.model.filter(PName, Phone, SCode, CCode, Size, Docket, ResType, Barcode2);
        }

        public void RefreshImage() {
            if (this.getSelectedRow() > -1 && this.model.getReservation(this.getSelectedRow()).getStyleLine() != null) {
                PaReservations.this.frParent.ChangeImage(this.model.getReservation((int)this.getSelectedRow()).getStyleLine().stylecode, this.model.getReservation((int)this.getSelectedRow()).getStyleLine().styledesc);
            } else {
                PaReservations.this.frParent.ChangeImage("", "");
            }
        }
    }

    public class ReserveTableModel
    extends AbstractTableModel {
        Vector<Object> data = new Vector();
        Vector<Integer> rowNums = new Vector();
        String[] colNames = new String[]{StoreParams.res.getString("Reservation_Type"), StoreParams.res.getString("Customer"), StoreParams.res.getString("Phone_hash"), StoreParams.res.getString("Date"), StoreParams.res.getString("Sales_Person"), StoreParams.res.getString("Reservation_"), StoreParams.res.getString("Code"), StoreParams.res.getString("Colour"), StoreParams.res.getString("Size"), StoreParams.res.getString("Available"), StoreParams.res.getString("Qty"), StoreParams.res.getString("Net")};

        public void populate(String extraWhere) {
            try {
                String peridxs = ",";
                Vector<String> invalids = new Vector<String>();
                try (SqlQuery sql = new SqlQuery(PaReservations.this.sParams.conn, "SELECT H.TRANS_NUMBER, MAX(H.CLIENTIDX), D.SKUIDX FROM RET_TRANH H, RET_TRAND D WHERE H.VHIDX = D.VHIDX AND H.TR_TYPE = 614 AND H.WIDX = ? GROUP BY H.TRANS_NUMBER, D.SKUIDX HAVING SUM(D.QTY) > 0 ORDER BY MIN(H.TRAND)", PaReservations.this.sParams.getStoreIdx());){
                    while (sql.next()) {
                        SkuReservation reservation = new SkuReservation(sql.getString(1), sql.getLong(3), PaReservations.this.sParams, false);
                        if (!reservation.getStyleLine().isValid()) {
                            invalids.add(sql.getString(1));
                        }
                        this.data.add(reservation);
                        this.rowNums.add(new Integer(this.data.size() - 1));
                        if (sql.getString(2) == null || peridxs.indexOf("," + sql.getString(2) + ",") != -1) continue;
                        peridxs = peridxs + sql.getString(2) + ",";
                    }
                }
                for (String invalid : invalids) {
                    DlgMessage.showMessage(PaReservations.this.frParent, MessageFormat.format(StoreParams.res.getString("reservation_unaccessible"), "\n", "\n"), StoreParams.res.getString("Reservation_") + " " + invalid, 0);
                }
                PaReservations.this.sParams.root = PaReservations.this.sParams.OnlineQueryProvider.getOnlineQuery("people", peridxs).getXML();
                if (PaReservations.this.sParams.root != null) {
                    List persons = PaReservations.this.sParams.root.getChildren("person");
                    for (int i = persons.size() - 1; i >= 0; --i) {
                        Element person = (Element)((Element)persons.get(i)).detach();
                        if (person.getAttribute("peridx") == null) continue;
                        for (int j = 0; j < this.data.size(); ++j) {
                            try {
                                if (((SkuReservation)this.data.elementAt(j)).getPeridx() != person.getAttribute("peridx").getLongValue()) continue;
                                ((SkuReservation)this.data.elementAt(j)).setPerson(person);
                                continue;
                            }
                            catch (DataConversionException e) {
                                PosUtils.logError(e);
                            }
                        }
                    }
                }
                this.fireTableDataChanged();
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
        }

        @Override
        public int getRowCount() {
            return this.rowNums.size();
        }

        @Override
        public int getColumnCount() {
            return this.colNames.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            return this.colNames[columnIndex];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 9 && ((SkuReservation)this.data.elementAt(this.rowNums.elementAt(rowIndex))).getStyleLine().isValid();
        }

        public SkuReservation removeReservation(int row) {
            int actualRow = this.rowNums.elementAt(row);
            SkuReservation res = (SkuReservation)this.data.remove(actualRow);
            this.rowNums.remove(row);
            for (int i = row; i < this.rowNums.size(); ++i) {
                this.rowNums.set(i, new Integer(this.rowNums.elementAt(i) - 1));
            }
            this.fireTableRowsDeleted(actualRow, actualRow);
            return res;
        }

        public SkuReservation getReservation(int row) {
            if (row >= 0 && row < this.rowNums.size()) {
                return (SkuReservation)this.data.elementAt(this.rowNums.elementAt(row));
            }
            return null;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            rowIndex = this.rowNums.elementAt(rowIndex);
            SkuReservation reservation = (SkuReservation)this.data.elementAt(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return reservation.getResType();
                }
                case 1: {
                    return PersonUtils.getPerName(reservation.getPerson());
                }
                case 2: {
                    return PersonUtils.getPhoneNum(reservation.getPerson(), PersonUtils.PhoneType.MAIN);
                }
                case 3: {
                    return reservation.getDateFormatter();
                }
                case 4: {
                    return reservation.getSalesRep().getName();
                }
                case 5: {
                    return reservation.getTransnum();
                }
                case 6: {
                    return reservation.getStyleLine().stylecode;
                }
                case 7: {
                    return reservation.getStyleLine().clrcode;
                }
                case 8: {
                    return reservation.getStyleLine().size;
                }
                case 9: {
                    return new PosDouble(reservation.getStyleLine().getQty(5));
                }
                case 10: {
                    return new PosDouble(reservation.getStyleLine().getQty());
                }
                case 11: {
                    return new PosDouble(reservation.getStyleLine().getNet());
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (rowIndex < this.rowNums.size()) {
                double availQty = PosUtils.doubleValFormatted(aValue.toString());
                SkuReservation res = (SkuReservation)this.data.elementAt(this.rowNums.elementAt(rowIndex));
                double originalAvailQty = res.getStyleLine().getQty(5);
                if (availQty > res.getStyleLine().getQty()) {
                    availQty = res.getStyleLine().getQty();
                }
                if (availQty < 0.0) {
                    availQty = 0.0;
                }
                if (availQty != originalAvailQty) {
                    if (!PaReservations.this.frParent.lockTransaction(res.getTransnum(), res.getTransnum(), 614)) {
                        return;
                    }
                    if (!res.isUpToDate(true)) {
                        DlgMessage.showMessage(PaReservations.this.frParent, MessageFormat.format(StoreParams.res.getString("reservation_modified"), "\n"), StoreParams.res.getString("Reservation_") + " " + res.getTransnum(), 0);
                        return;
                    }
                }
                res.getStyleLine().setQty(5, availQty);
                this.fireTableRowsUpdated(rowIndex, rowIndex);
            }
        }

        public void clear() {
            this.data.clear();
            this.rowNums.clear();
            this.fireTableDataChanged();
        }

        public double getTotValue() {
            double value = 0.0;
            for (int i = 0; i < this.rowNums.size(); ++i) {
                value += ((SkuReservation)this.data.elementAt(this.rowNums.elementAt(i))).getStyleLine().getNet();
            }
            return value;
        }

        public double getTotQty() {
            double qty = 0.0;
            for (int i = 0; i < this.rowNums.size(); ++i) {
                qty += ((SkuReservation)this.data.elementAt(this.rowNums.elementAt(i))).getStyleLine().getQty();
            }
            return qty;
        }

        public void filter(String PName, String Phone, String SCode, String CCode, String Size, String Docket, String ResType, String Barcode2) {
            this.rowNums.clear();
            for (int i = 0; i < this.data.size(); ++i) {
                boolean personMatches;
                SkuReservation res = (SkuReservation)this.data.elementAt(i);
                String perName = PersonUtils.getPerName(res.getPerson()).toUpperCase();
                String phonenum = PersonUtils.getPhoneNum(res.getPerson(), PersonUtils.PhoneType.MAIN).toUpperCase();
                String styleCode = res.getStyleLine().stylecode.toUpperCase();
                String clrCode = res.getStyleLine().clrcode.toUpperCase();
                String size = res.getStyleLine().size.toUpperCase();
                String docket = res.getTransnum().toUpperCase();
                String resType = res.getResType().toUpperCase();
                String barcode = res.getBarcode().toUpperCase();
                PName = PName.toUpperCase();
                Phone = Phone.toUpperCase();
                SCode = SCode.toUpperCase();
                CCode = CCode.toUpperCase();
                Size = Size.toUpperCase();
                ResType = ResType.toUpperCase();
                Barcode2 = Barcode2.toUpperCase();
                if (Docket != null && !Docket.isEmpty()) {
                    String storeNo;
                    if (Docket.toUpperCase().startsWith("D")) {
                        Docket = Docket.substring(1);
                    }
                    if (Docket.startsWith(storeNo = SP.sParams.getStore().getStoreNo())) {
                        Docket = Docket.substring(storeNo.length());
                    }
                }
                Docket = Docket.toUpperCase();
                if (PName.isEmpty() && Phone.isEmpty()) {
                    personMatches = true;
                } else {
                    boolean bl = personMatches = perName.indexOf(PName) > -1 && phonenum.indexOf(Phone) > -1;
                }
                if (styleCode.indexOf(SCode) <= -1 || clrCode.indexOf(CCode) <= -1 || size.indexOf(Size) <= -1 || docket.indexOf(Docket) <= -1 || resType.indexOf(ResType) <= -1 || barcode.indexOf(Barcode2) <= -1 || !personMatches) continue;
                this.rowNums.add(new Integer(i));
            }
            this.fireTableDataChanged();
        }
    }
}

