/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import jpos.Carrier;
import jpos.DlgMessage;
import jpos.FrSales;
import jpos.FrStkEnquiry;
import jpos.Link;
import jpos.PaSales;
import jpos.PaStkEnquiryFoot;
import jpos.PosComboBox;
import jpos.PosDateFormatter;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosTable;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.SkuPrice;
import jpos.SkuReservation;
import jpos.SqlQuery;
import jpos.StatusBar;
import jpos.StkEnquirySettings;
import jpos.StkEnquiryStore;
import jpos.StockAdjustmentDlg;
import jpos.StoreParams;
import jpos.StringUtils;
import jpos.StyleLine;
import jpos.SubstituteProductsPanel;
import jpos.SystemSettings;
import jpos.TotalsTable;
import jpos.TotalsTableModel;
import jpos.XMLUtils;
import jpos.basscom.swing.BJTextField;
import jpos.custorder.DeliveryInfo;
import jpos.custorder.DeliveryMethods;
import jpos.person.PersonUtils;
import jpos.searchfields.BarcodeSearchField;
import jpos.searchfields.SearchPanel;
import jpos.transreq.PaTransferRequest;
import jpos.ui.Colours;
import jpos.ui.Fonts;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class PaStkEnquiry
extends JPanel {
    private static final int TOT_TABLE_TOTAL_ROW = 0;
    private static final int TOT_TABLE_FTD_ROW = 1;
    private PosDateFormatter dateFormatter = new PosDateFormatter(null);
    private boolean skipProductValidation = false;
    private boolean populating = false;
    private String strStoreFilter = "";
    private boolean usingFloorToDoor = DeliveryMethods.deliveryMethodsExist() && SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.CREATE_FLOOR_TO_DOOR_ORDERS);
    BarcodeSearchField tfBarcode = new BarcodeSearchField(TouchTextField.FontSize.LARGE){

        @Override
        public void actionSearch() {
            if (PaStkEnquiry.this.frParent.isLoggedIn(true)) {
                super.actionSearch();
                if (this.getidx() == 0L || this.getidx() == -1L) {
                    this.actionValidate();
                }
            }
        }

        @Override
        public void actionValidate() {
            if (PaStkEnquiry.this.frParent.isLoggedIn(false)) {
                if (!PaStkEnquiry.this.skipProductValidation) {
                    super.actionValidate();
                }
                PaStkEnquiry.this.skipProductValidation = false;
                PaStkEnquiry.this.reset();
                PaStkEnquiry.this.setClrs(0L);
                if (PaStkEnquiry.this.cbClr.isEnabled()) {
                    PaStkEnquiry.this.cbClr.requestFocus();
                }
            }
        }
    };
    private SearchPanel barcodeSearchPanel = new SearchPanel(this.tfBarcode);
    BJTextField txtStoreFilter = new BJTextField(TouchTextField.FontSize.LARGE){

        @Override
        public void actionSearch() {
            if (PaStkEnquiry.this.frParent.isLoggedIn(true)) {
                String filter = PaStkEnquiry.this.txtStoreFilter.getText();
                PaStkEnquiry.this.filterByStores(filter);
            }
        }

        @Override
        public void actionValidate() {
        }
    };
    private SearchPanel storeSearchPanel = new SearchPanel(this.txtStoreFilter);
    private PosTable tblStk;
    private TotalsTable tblTotals;
    private SubstituteProductsPanel substitutePanel = new SubstituteProductsPanel();
    GridBagLayout gridBagLayout = new GridBagLayout();
    LabelSubHeading lProd = new LabelSubHeading();
    PosComboBox<Clr> cbClr = new PosComboBox(TouchTextField.FontSize.LARGE);
    LabelSubHeading lClr = new LabelSubHeading();
    LabelSubHeading lStyleDesc = new LabelSubHeading();
    LabelSubHeading lPrice = new LabelSubHeading();
    LabelSubHeading lStkType = new LabelSubHeading();
    Border border;
    TransTable tblSec;
    String sStyleCode = null;
    String sStyleName = null;
    long prevskuidx;
    long prevwidx;
    boolean search = true;
    FrStkEnquiry.StockType currentStockType = FrStkEnquiry.StockType.NONE;
    private StkEnquirySettings settings;
    private StkEnquiryStore ownStore;
    PosFrame frParent;
    StoreParams sParams;

    public PaStkEnquiry(PosFrame pfrParent) {
        this.frParent = pfrParent;
        this.sParams = this.frParent.sParams;
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    private void jbInit() throws Exception {
        this.settings = new StkEnquirySettings();
        this.ownStore = new StkEnquiryStore(this.sParams.getStoreIdx(), this.settings);
        this.dateFormatter.setFormat(3, 0);
        this.tblStk = new PosTable(this.frParent, new StkEnquiryTableModel()){

            private boolean isSkuSelected(Object value, int row, int column) {
                return value != null && !value.equals("") && row == PaStkEnquiry.this.tblStk.getSelectedRow() && column == PaStkEnquiry.this.tblStk.getSelectedColumn() && column < this.getColumnCount() - 1 && column >= 3;
            }

            @Override
            public Color getDisplayForegroundAt(Object value, int row, int column) {
                if (this.isSkuSelected(value, row, column)) {
                    return Colours.BLUE;
                }
                return this.renderer.defaultColour;
            }

            @Override
            public Font getDisplayFontAt(Object value, int row, int column) {
                if (this.isSkuSelected(value, row, column)) {
                    return Fonts.BoldText;
                }
                return this.renderer.getFont();
            }
        };
        this.tblStk.renderer.setShowSelectedCellBorder(true);
        this.tblSec = new TransTable(this.frParent);
        this.reset();
        TotalsTableModel totalsTableModel = new TotalsTableModel(this.tblStk.getModel()){

            @Override
            public Object getValueAt(int row, int col) {
                if (row == 0) {
                    return ((StkEnquiryTableModel)PaStkEnquiry.this.tblStk.getModel()).getColumnTotal(col);
                }
                if (row == 1) {
                    return ((StkEnquiryTableModel)PaStkEnquiry.this.tblStk.getModel()).getColumnFloorToDoor(col);
                }
                return "";
            }

            @Override
            public int getRowCount() {
                return PaStkEnquiry.this.currentStockType == FrStkEnquiry.StockType.SOH && PaStkEnquiry.this.usingFloorToDoor ? 2 : 1;
            }
        };
        this.tblTotals = new TotalsTable(this.frParent, this.tblStk, totalsTableModel){

            @Override
            public Color getDisplayForegroundAt(Object value, int row, int column) {
                if (value != null && !value.equals("") && row == PaStkEnquiry.this.tblTotals.getSelectedRow() && column == PaStkEnquiry.this.tblTotals.getSelectedColumn() && column < this.getColumnCount() - 1 && column >= 3 && row == 1) {
                    return Colours.BLUE;
                }
                return this.renderer.defaultColour;
            }
        };
        this.tblTotals.setFocusable(true);
        this.tblTotals.setRowSelectionAllowed(true);
        this.tblTotals.renderer.setShowSelectedCellBorder(true);
        this.substitutePanel.setSelectedSubstituteHandler(sub -> this.populateClr(sub.getClrIdx()));
        this.border = BorderFactory.createLineBorder(Colours.GREY, 1);
        this.tfBarcode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaStkEnquiry.this.tfBarcode_focusGained(e);
            }
        });
        this.tfBarcode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaStkEnquiry.this.tfBarcode_actionPerformed(e);
            }
        });
        this.tfBarcode.setRequestFocusEnabled(true);
        this.lProd.setText(StoreParams.res.getString("Product") + " ");
        this.setLayout(this.gridBagLayout);
        this.lClr.setText(StoreParams.res.getString("Colour") + " ");
        this.cbClr.setFieldWidth(200);
        this.cbClr.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PaStkEnquiry.this.cbClr_itemStateChanged(e);
            }
        });
        this.cbClr.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaStkEnquiry.this.cbClr_focusGained(e);
            }
        });
        this.cbClr.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                PaStkEnquiry.this.cbClr_mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                PaStkEnquiry.this.cbClr_mouseExited(e);
            }
        });
        this.lStkType.setBorder(this.border);
        this.lStkType.setMaximumSize(new Dimension(180, 40));
        this.lStkType.setMinimumSize(new Dimension(180, 40));
        this.lStkType.setPreferredSize(new Dimension(180, 40));
        this.lStkType.setHorizontalAlignment(0);
        this.lPrice.setHorizontalAlignment(4);
        this.txtStoreFilter.setFieldWidth(200);
        this.txtStoreFilter.setHint(SP.getRS("Store_Address_Filter"));
        this.add((Component)this.storeSearchPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.lProd, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.barcodeSearchPanel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.lClr, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add(this.cbClr, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        this.add((Component)this.lStyleDesc, new GridBagConstraints(5, 0, 1, 1, 1.0, 0.0, 17, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.lPrice, new GridBagConstraints(6, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 0), 0, 0));
        this.add((Component)this.lStkType, new GridBagConstraints(7, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 10, 0, 10), 0, 0));
        JPanel tblPanel = new JPanel(new GridBagLayout());
        tblPanel.add((Component)this.tblStk.getScrollPane(), new GridBagConstraints(0, 0, 1, 1, 1.0, 2.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        tblPanel.add((Component)this.tblTotals.getScrollPane(), new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 15, 1, new Insets(0, 0, 0, 0), 0, 0));
        tblPanel.add((Component)this.tblSec.getScrollPane(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(5, 0, 0, 0), 0, 0));
        tblPanel.add((Component)this.substitutePanel, new GridBagConstraints(1, 0, 1, 3, 0.0, 3.0, 13, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)tblPanel, new GridBagConstraints(0, 1, 7, 1, 1.0, 1.0, 10, 1, new Insets(10, 10, 0, 10), 0, 0));
        this.lStkType.setText("");
        this.currentStockType = FrStkEnquiry.StockType.SOH;
        this.reset();
        this.tblSec.getScrollPane().setVisible(false);
        this.tblSec.setVisible(false);
        this.tblStk.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PaStkEnquiry.this.getTransactionInfo();
                if (e.getValueIsAdjusting() && PaStkEnquiry.this.currentStockType == FrStkEnquiry.StockType.SOH) {
                    ((PaStkEnquiryFoot)PaStkEnquiry.this.frParent.paFoot).bLink.setText(StoreParams.res.getString("F7_Sell"));
                    PaStkEnquiry.this.tblTotals.clearSelection();
                }
            }
        });
        this.tblStk.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PaStkEnquiry.this.showPrice(PaStkEnquiry.this.tblStk.getSelectedColumn());
                PaStkEnquiry.this.getTransactionInfo();
            }
        });
        this.tblStk.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PaStkEnquiry.this.currentStockType == FrStkEnquiry.StockType.SOH && e.getClickCount() > 1) {
                    ((FrStkEnquiry)PaStkEnquiry.this.frParent).openItem();
                }
            }
        });
        this.tblStk.setSelectionMode(0);
        this.tblTotals.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    if (PaStkEnquiry.this.currentStockType == FrStkEnquiry.StockType.SOH) {
                        if (PaStkEnquiry.this.tblTotals.getSelectedRow() == 1) {
                            ((PaStkEnquiryFoot)PaStkEnquiry.this.frParent.paFoot).bLink.setText(StoreParams.res.getString("F7_Order"));
                            PaStkEnquiry.this.tblStk.clearSelection();
                        } else {
                            ((PaStkEnquiryFoot)PaStkEnquiry.this.frParent.paFoot).bLink.setText(StoreParams.res.getString("F7_Sell"));
                            PaStkEnquiry.this.tblTotals.clearSelection();
                        }
                    } else {
                        PaStkEnquiry.this.tblTotals.clearSelection();
                    }
                }
            }
        });
        this.tblTotals.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (PaStkEnquiry.this.currentStockType == FrStkEnquiry.StockType.SOH) {
                    PaStkEnquiry.this.showPrice(PaStkEnquiry.this.tblTotals.getSelectedColumn());
                }
            }
        });
        this.tblTotals.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (PaStkEnquiry.this.currentStockType == FrStkEnquiry.StockType.SOH && e.getClickCount() > 1 && PaStkEnquiry.this.tblTotals.getSelectedRow() == 1) {
                    ((FrStkEnquiry)PaStkEnquiry.this.frParent).openItem();
                }
            }
        });
        this.tblTotals.setSelectionMode(0);
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tfBarcode);
        v.add(this.cbClr);
        v.add(this.tblStk);
        v.add(this.tblSec);
        v.add(this.tfBarcode);
        v.add(this.frParent.paHead.signInButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private void filterByStores(String filter) {
        this.strStoreFilter = filter.toUpperCase();
        this.reset();
        FrStkEnquiry.StockType stockType = FrStkEnquiry.StockType.SOH;
        String strStcokType = this.lStkType.getText();
        if (strStcokType.equals(StoreParams.res.getString("In_Transit"))) {
            stockType = FrStkEnquiry.StockType.IN_TRANSIT;
        } else if (strStcokType.equals(StoreParams.res.getString("Layby"))) {
            stockType = FrStkEnquiry.StockType.LAYBY;
        } else if (strStcokType.equals(StoreParams.res.getString("Reserved"))) {
            stockType = FrStkEnquiry.StockType.RESERVED;
        } else if (strStcokType.equals(StoreParams.res.getString("Inc_Orders"))) {
            stockType = FrStkEnquiry.StockType.INCOMING_ORDERS;
        } else if (strStcokType.equals(StoreParams.res.getString("Cust_Orders"))) {
            stockType = FrStkEnquiry.StockType.CUST_ORDERS;
        } else if (strStcokType.equals(StoreParams.res.getString("Cust_Orders_Packed"))) {
            stockType = FrStkEnquiry.StockType.CUST_ORDERS_PACKED;
        }
        this.populate(stockType, false);
    }

    private void setupTable() {
        if (this.tblStk.getColumnCount() > 3) {
            this.tblStk.getColumnModel().getColumn(0).setHeaderRenderer(this.tblStk.headerLeftRen);
            this.tblStk.getColumnModel().getColumn(1).setHeaderRenderer(this.tblStk.headerLeftRen);
            this.tblStk.getColumnModel().getColumn(2).setHeaderRenderer(this.tblStk.headerLeftRen);
            if (this.settings.isShowWhseCode()) {
                this.tblStk.getColumnModel().getColumn(0).setMinWidth(100);
                this.tblStk.getColumnModel().getColumn(0).setPreferredWidth(140);
            } else {
                this.tblStk.getColumnModel().getColumn(0).setMinWidth(0);
                this.tblStk.getColumnModel().getColumn(0).setMaxWidth(0);
            }
            if (this.settings.isShowWhseName()) {
                this.tblStk.getColumnModel().getColumn(1).setMinWidth(100);
                this.tblStk.getColumnModel().getColumn(1).setPreferredWidth(180);
            } else {
                this.tblStk.getColumnModel().getColumn(1).setMinWidth(0);
                this.tblStk.getColumnModel().getColumn(1).setMaxWidth(0);
            }
            if (this.settings.isShowWhseRef()) {
                this.tblStk.getColumnModel().getColumn(2).setMinWidth(100);
                this.tblStk.getColumnModel().getColumn(2).setPreferredWidth(180);
            } else {
                this.tblStk.getColumnModel().getColumn(2).setMinWidth(0);
                this.tblStk.getColumnModel().getColumn(2).setMaxWidth(0);
            }
            for (int i = 3; i < this.tblStk.getColumnModel().getColumnCount() - 1; ++i) {
                this.tblStk.getColumnModel().getColumn(i).setHeaderRenderer(this.tblStk.headerCenterRen);
                this.tblStk.renderer.setColumnFormat(i, StoreParams.qtyFormat, 0);
                this.tblStk.getColumnModel().getColumn(i).setMinWidth(50);
            }
            this.tblStk.getColumnModel().getColumn(this.tblStk.getColumnCount() - 1).setHeaderRenderer(this.tblStk.headerRightRen);
            this.tblStk.renderer.setColumnFormat(this.tblStk.getColumnCount() - 1, StoreParams.qtyFormat, 4);
            this.tblStk.getColumnModel().getColumn(this.tblStk.getColumnCount() - 1).setMinWidth(50);
            if (this.tblTotals != null) {
                this.tblStk.renderer.copyContents(this.tblTotals.renderer);
            }
        }
    }

    public void populate(FrStkEnquiry.StockType pstkType) {
        this.populate(pstkType, false);
    }

    public void populate(FrStkEnquiry.StockType pstkType, boolean forceRefresh) {
        try {
            if (this.cbClr.getSelectedItem() != null) {
                this.currentStockType = pstkType;
                this.prevskuidx = -1L;
                this.prevwidx = -1L;
                this.tblStk.setAutoResizeMode(0);
                ((PaStkEnquiryFoot)this.frParent.paFoot).bLink.setEnabled(true);
                if (this.currentStockType == FrStkEnquiry.StockType.SOH) {
                    this.lStkType.setText(StoreParams.res.getString("Stock_on_Hand"));
                    ((PaStkEnquiryFoot)this.frParent.paFoot).bLink.setText(StoreParams.res.getString("F7_Sell"));
                    this.tblSec.getScrollPane().setVisible(false);
                    this.tblSec.setVisible(false);
                } else {
                    this.tblSec.getScrollPane().setVisible(true);
                    this.tblSec.setVisible(true);
                    this.tblSec.setup(this.currentStockType);
                    if (this.currentStockType == FrStkEnquiry.StockType.IN_TRANSIT) {
                        this.lStkType.setText(StoreParams.res.getString("In_Transit"));
                        ((PaStkEnquiryFoot)this.frParent.paFoot).bLink.setText(StoreParams.res.getString("F7_Sell"));
                        ((PaStkEnquiryFoot)this.frParent.paFoot).bLink.setEnabled(false);
                    } else if (this.currentStockType == FrStkEnquiry.StockType.LAYBY) {
                        this.lStkType.setText(StoreParams.res.getString("Layby"));
                        ((PaStkEnquiryFoot)this.frParent.paFoot).bLink.setText(StoreParams.res.getString("F7_Layby_Update"));
                    } else if (this.currentStockType == FrStkEnquiry.StockType.RESERVED) {
                        this.lStkType.setText(StoreParams.res.getString("Reserved"));
                        ((PaStkEnquiryFoot)this.frParent.paFoot).bLink.setText(StoreParams.res.getString("F7_Sell"));
                    } else if (this.currentStockType == FrStkEnquiry.StockType.INCOMING_ORDERS) {
                        this.lStkType.setText(StoreParams.res.getString("Inc_Orders"));
                        ((PaStkEnquiryFoot)this.frParent.paFoot).bLink.setText(StoreParams.res.getString("F7_Sell"));
                        ((PaStkEnquiryFoot)this.frParent.paFoot).bLink.setEnabled(false);
                    } else if (this.currentStockType == FrStkEnquiry.StockType.CUST_ORDERS) {
                        this.lStkType.setText(StoreParams.res.getString("Cust_Orders"));
                        ((PaStkEnquiryFoot)this.frParent.paFoot).bLink.setText(StoreParams.res.getString("F7_Sell"));
                        ((PaStkEnquiryFoot)this.frParent.paFoot).bLink.setEnabled(false);
                    } else if (this.currentStockType == FrStkEnquiry.StockType.CUST_ORDERS_PACKED) {
                        this.lStkType.setText(StoreParams.res.getString("Cust_Orders_Packed"));
                        ((PaStkEnquiryFoot)this.frParent.paFoot).bLink.setText(StoreParams.res.getString("F7_Sell"));
                        ((PaStkEnquiryFoot)this.frParent.paFoot).bLink.setEnabled(false);
                    }
                }
                ((StkEnquiryTableModel)this.tblStk.getModel()).populate(this.currentStockType, forceRefresh);
                this.setSubstitutes(((StkEnquiryTableModel)this.tblStk.getModel()).getSubstituteClrs());
                ((FrStkEnquiry)this.frParent).controlStockAdjustmentButton(this.currentStockType);
            }
        }
        finally {
            this.populating = false;
        }
    }

    void tfBarcode_focusGained(FocusEvent e) {
        this.tfBarcode.selectAll();
        this.frParent.setStatusMsg(StatusBar.status_EANSearch);
    }

    void cbClr_mouseEntered(MouseEvent e) {
        this.frParent.setStatusText(StatusBar.status_Clr);
    }

    void cbClr_mouseExited(MouseEvent e) {
        this.frParent.resetStatus();
    }

    void cbClr_focusGained(FocusEvent e) {
        this.frParent.setStatusMsg(StatusBar.status_Clr);
    }

    void cbClr_itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1 && this.search) {
            this.reset();
            FrStkEnquiry.StockType tempstkType = this.currentStockType;
            this.currentStockType = FrStkEnquiry.StockType.NONE;
            this.populate(tempstkType);
        }
    }

    public void reset() {
        this.tblStk.setAutoResizeMode(4);
        ((StkEnquiryTableModel)this.tblStk.getModel()).reset(0L);
        this.tblSec.clearRows();
        this.substitutePanel.setProducts(null);
    }

    private void getTransactionInfo() {
        if (this.tblSec.getScrollPane().isVisible()) {
            int row = this.tblStk.getSelectedRow();
            int col = this.tblStk.getSelectedColumn();
            if (row >= 0 && col >= 3) {
                long widx;
                long skuidx = ((StkEnquiryTableModel)this.tblStk.getModel()).getSkuidx(col);
                StkEnquiryStore whse = ((StkEnquiryTableModel)this.tblStk.getModel()).getWhse(row);
                long l = widx = whse != null ? whse.getWidx() : 0L;
                if (skuidx != this.prevskuidx || widx != this.prevwidx || this.currentStockType != this.tblSec.tableStockType) {
                    this.prevskuidx = skuidx;
                    this.prevwidx = widx;
                    this.tblSec.clearRows();
                    if (skuidx > 0L && widx > 0L && !this.tblStk.getValueAt(row, col).equals("")) {
                        FrStkEnquiry.StockType tranType = ((FrStkEnquiry)this.frParent).getEffectiveStockType(this.currentStockType);
                        SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("stktrans", skuidx + "," + widx + "," + (Object)((Object)tranType) + "," + this.frParent.getUser().getMemidx()).getXML();
                        if (SP.sParams.root != null) {
                            this.tblSec.populate(this.sParams.root);
                        }
                    }
                }
            }
        }
    }

    private void showPrice(int col) {
        this.lPrice.setText("");
        if (this.currentStockType == FrStkEnquiry.StockType.SOH) {
            double price = 0.0;
            price = ((StkEnquiryTableModel)this.tblStk.getModel()).getSkuPrice(col);
            if (price > 0.0) {
                this.lPrice.setText(SP.sParams.storeCurrency.formatTotal(price));
            }
        }
    }

    public void setClrs(long initialClrIdx) {
        try {
            this.search = false;
            Clr initialItem = null;
            this.cbClr.removeAllItems();
            if (this.tfBarcode.getidx() > 0L) {
                try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT STYLECODE, NAME FROM STYLE WHERE STYLEIDX = " + this.tfBarcode.getidx() + " AND \"ACTIVE\" = 1 ");){
                    if (sql.next()) {
                        this.sStyleCode = sql.getString(1);
                        this.sStyleName = sql.getString(2);
                        this.lStyleDesc.setText(this.sStyleName);
                    } else {
                        this.sStyleCode = null;
                        this.sStyleName = null;
                        this.lStyleDesc.setText("");
                    }
                }
                sql = new SqlQuery(this.sParams.conn, "SELECT C.CLRIDX, C.CLRCODE, C.CLRNAME FROM CLR C WHERE C.STYLEIDX = " + this.tfBarcode.getidx() + " AND C.\"ACTIVE\" = 1 AND exists (select 1 from sku k where k.clridx = c.clridx and k.\"ACTIVE\" = 1 AND EXISTS (SELECT 1 FROM BARCODE B WHERE B.SKUIDX = K.SKUIDX AND B.CODE IS NOT NULL)) ORDER BY C.CLRCODE");
                var5_5 = null;
                try {
                    while (sql.next()) {
                        Clr clr = new Clr(sql.getLong("CLRIDX"), sql.getString("CLRCODE"), sql.getString("CLRNAME"));
                        this.cbClr.addItem(clr);
                        if (initialClrIdx <= 0L || initialClrIdx != clr.clridx) continue;
                        initialItem = clr;
                    }
                }
                catch (Throwable throwable) {
                    var5_5 = throwable;
                    throw throwable;
                }
                finally {
                    if (sql != null) {
                        if (var5_5 != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable throwable) {
                                var5_5.addSuppressed(throwable);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
            }
            this.sStyleCode = null;
            this.sStyleName = null;
            this.lStyleDesc.setText("");
            this.frParent.refreshImage();
            this.search = true;
            this.cbClr.setEnabled(true);
            if (this.cbClr.getItemCount() > 0) {
                if (initialItem != null) {
                    this.cbClr.setSelectedItem(initialItem);
                } else {
                    this.cbClr.setSelectedIndex(0);
                }
                if (this.cbClr.getItemCount() == 1) {
                    this.cbClr.setEnabled(false);
                }
                if (!this.populating) {
                    this.populating = true;
                    final FrStkEnquiry.StockType tempStockType = this.currentStockType;
                    this.currentStockType = FrStkEnquiry.StockType.NONE;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PaStkEnquiry.this.populate(tempStockType);
                        }
                    });
                }
            } else {
                this.cbClr.setEnabled(false);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    void tfBarcode_actionPerformed(ActionEvent e) {
        StyleLine style;
        if (this.tfBarcode.getText().length() > 0 && (style = new StyleLine(this.tfBarcode.getText(), false, this.sParams)).isValid()) {
            this.skipProductValidation = true;
            this.tfBarcode.populate(style.getStyleidx());
            this.reset();
            this.setClrs(0L);
            if (this.cbClr.isEnabled()) {
                this.cbClr.requestFocus();
            }
        }
    }

    private String generateClrValidationSql(String select) {
        return "SELECT " + select + " FROM CLR C " + "JOIN STYLE S ON C.STYLEIDX = S.STYLEIDX " + "JOIN SKU K ON C.CLRIDX = K.CLRIDX " + "JOIN BARCODE B ON K.SKUIDX = B.SKUIDX " + "WHERE C.CLRIDX = ? " + "AND S.\"ACTIVE\"=1 " + "AND C.\"ACTIVE\" = 1 " + "AND K.\"ACTIVE\" = 1 " + "AND B.CODE IS NOT NULL " + "AND COALESCE(S.STKFLAG, 0) <> 0 " + this.sParams.sExcludeDefSkusWhere;
    }

    private void setSubstitutes(List<Long> substituteClrIdxs) {
        if (substituteClrIdxs == null || substituteClrIdxs.size() == 0) {
            this.substitutePanel.setProducts(null);
            return;
        }
        Vector<SubstituteProductsPanel.SubstituteProduct> substituteProducts = new Vector<SubstituteProductsPanel.SubstituteProduct>();
        try (PreparedStatement sql = this.sParams.conn.prepareStatement(this.generateClrValidationSql("FIRST 1 S.STYLECODE"));){
            for (long clrIdx : substituteClrIdxs) {
                sql.setLong(1, clrIdx);
                ResultSet result = sql.executeQuery();
                Throwable throwable = null;
                try {
                    if (!result.next()) continue;
                    substituteProducts.add(new SubstituteProductsPanel.SubstituteProduct(clrIdx, result.getString("STYLECODE")));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (result == null) continue;
                    if (throwable != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    result.close();
                }
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        this.substitutePanel.setProducts(substituteProducts);
    }

    public void populateClr(long clrIdx) {
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, this.generateClrValidationSql("FIRST 1 S.STYLEIDX"), clrIdx);){
            if (!sql.next()) {
                DlgMessage.showMessage(this.frParent, SP.getRS("Invalid_Product"), SP.getRS("Error"), 0);
                return;
            }
            this.skipProductValidation = true;
            this.tfBarcode.populate(sql.getLong("STYLEIDX"));
            this.setClrs(clrIdx);
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    public void openItem(PosFrame parentFr) {
        if (this.currentStockType == FrStkEnquiry.StockType.LAYBY) {
            if (this.tblSec.getSelectedRow() < 0 || this.tblSec.getSelectedRow() >= this.tblSec.getRowCount()) {
                DlgMessage.showMessage(parentFr, StoreParams.res.getString("select_sku_trans"), StoreParams.res.getString("No_Selection"), 1);
                return;
            }
            String docknum = this.getSelectedStore().getStoreNum();
            docknum = docknum + this.tblSec.getDocketNum(this.tblSec.getSelectedRow());
            parentFr.menu.populate(this.frParent, 240, docknum);
        } else if (this.currentStockType == FrStkEnquiry.StockType.RESERVED) {
            if (this.tblSec.getSelectedRow() < 0 || this.tblSec.getSelectedRow() >= this.tblSec.getRowCount()) {
                DlgMessage.showMessage(parentFr, StoreParams.res.getString("select_sku_trans_res"), StoreParams.res.getString("No_Selection"), 1);
                return;
            }
            if (this.getSelectedStore().getWidx() != this.ownStore.getWidx()) {
                DlgMessage.showMessage(parentFr, StoreParams.res.getString("own_store"), "", 1);
                return;
            }
            long skuidx = ((StkEnquiryTableModel)this.tblStk.getModel()).getSkuidx(this.tblStk.getSelectedColumn());
            SkuReservation reservation = new SkuReservation(this.tblSec.getDocketNum(this.tblSec.getSelectedRow()), skuidx, this.sParams, false);
            reservation.setPerson(this.tblSec.getPerson(this.tblSec.getSelectedRow()));
            if (reservation.getVhidx() > 0L) {
                parentFr.menu.addReservation(parentFr, reservation);
            }
        } else if (this.currentStockType == FrStkEnquiry.StockType.SOH) {
            long skuidx = this.getSelectedSku();
            if (skuidx <= 0L) {
                DlgMessage.showMessage(parentFr, StoreParams.res.getString("select_sku_to_sell"), StoreParams.res.getString("No_Selection"), 1);
                return;
            }
            if (this.tblTotals.getSelectedRow() == 1) {
                PosFrame custOrder = parentFr.menu.openFrame(12, false, this.frParent.getUser());
                if (custOrder != null) {
                    if (!custOrder.autoSignIn(parentFr.getUser()) && !custOrder.paHead.signIn()) {
                        return;
                    }
                    if (!((PaSales)custOrder.paBody).tblStyles.isEditable()) {
                        custOrder.voidTrans(false);
                    }
                    ((PaSales)custOrder.paBody).tblStyles.addEAN(PosUtils.getDefaultBarcode(skuidx));
                    if (custOrder.transType == 714 && this.usingFloorToDoor && custOrder.hasSecurity(11170L, 0)) {
                        ((FrSales)custOrder).deliveryInfo.setDeliveryOption(DeliveryInfo.DeliveryOptions.DELIVERY);
                    }
                }
            } else {
                PosFrame sales = parentFr.menu.openFrame(1, false, this.frParent.getUser());
                if (sales != null) {
                    if (!sales.autoSignIn(parentFr.getUser()) && !sales.paHead.signIn()) {
                        return;
                    }
                    if (!((PaSales)sales.paBody).tblStyles.isEditable()) {
                        sales.voidTrans(false);
                    }
                    ((PaSales)sales.paBody).tblStyles.addEAN(PosUtils.getDefaultBarcode(skuidx));
                }
            }
        }
    }

    private long getSelectedSku() {
        int selectedCol = this.tblStk.getSelectedColumn();
        if (selectedCol == -1) {
            selectedCol = this.tblTotals.getSelectedColumn();
        }
        if (selectedCol < 3 || selectedCol >= this.tblStk.getColumnCount() - 1) {
            return 0L;
        }
        return ((StkEnquiryTableModel)this.tblStk.getModel()).getSkuidx(selectedCol);
    }

    private StkEnquiryStore getSelectedStore() {
        return ((StkEnquiryTableModel)this.tblStk.getModel()).getWhse(this.tblStk.getSelectedRow());
    }

    public void requestItem(PosFrame parentFr) {
        long skuidx = this.getSelectedSku();
        if (skuidx <= 0L) {
            DlgMessage.showMessage(parentFr, StoreParams.res.getString("select_sku_to_request"), StoreParams.res.getString("No_Selection"), 1);
            return;
        }
        StkEnquiryStore store = this.getSelectedStore();
        if (store == null) {
            DlgMessage.showMessage(parentFr, StoreParams.res.getString("invalid_store"), StoreParams.res.getString("Stop"), 0);
            return;
        }
        PosFrame transferReq = parentFr.menu.openFrame(9, false, this.frParent.getUser());
        if (transferReq != null) {
            if (!transferReq.autoSignIn(parentFr.getUser()) && !transferReq.paHead.signIn()) {
                return;
            }
            Reference selectedStore = ((PaTransferRequest)transferReq.paBody).getSelectedStore();
            if (selectedStore == null) {
                Vector<Reference> availableStores = ((PaTransferRequest)transferReq.paBody).getStores();
                boolean bFound = false;
                for (int i = 0; i < availableStores.size(); ++i) {
                    if (store.getWidx() != availableStores.elementAt(i).getIdx()) continue;
                    bFound = true;
                    ((PaTransferRequest)transferReq.paBody).setSelectedStore(availableStores.elementAt(i));
                    break;
                }
                if (!bFound) {
                    DlgMessage.showMessage(parentFr, StoreParams.res.getString("cannot_create_transfer_req"), StoreParams.res.getString("Stop"), 0);
                    return;
                }
            } else if (store.getWidx() != selectedStore.getIdx()) {
                Object[] objs = new Object[]{selectedStore.getName(), store.getStoreName()};
                DlgMessage.showMessage(parentFr, MessageFormat.format(StoreParams.res.getString("transfer_request_different_store"), objs), StoreParams.res.getString("Stop"), 0);
                return;
            }
            ((PaTransferRequest)transferReq.paBody).addSku(skuidx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stockAdjustment(PosFrame parentFr) {
        long skuidx = this.getSelectedSku();
        if (skuidx <= 0L) {
            DlgMessage.showMessage(parentFr, StoreParams.res.getString("select_sku_to_adjust_stock"), StoreParams.res.getString("No_Selection"), 1);
            return;
        }
        StkEnquiryStore store = this.getSelectedStore();
        if (store == null) {
            DlgMessage.showMessage(parentFr, StoreParams.res.getString("invalid_store"), StoreParams.res.getString("Stop"), 0);
            return;
        }
        if (this.getSelectedStore().getWidx() != this.ownStore.getWidx()) {
            DlgMessage.showMessage(parentFr, StoreParams.res.getString("Stock_Adjustment_only_on_own_store"), StoreParams.res.getString("Stock_Adjustment"), 1);
            return;
        }
        PosDialog stockAdjustmentDlg = null;
        try {
            stockAdjustmentDlg = new StockAdjustmentDlg(this.frParent, skuidx);
            if (((StockAdjustmentDlg)stockAdjustmentDlg).getResult()) {
                this.populate(FrStkEnquiry.StockType.SOH, true);
            }
        }
        finally {
            if (stockAdjustmentDlg != null) {
                stockAdjustmentDlg.dispose();
            }
        }
    }

    private class StkEnquiryTableModel
    extends AbstractTableModel {
        public static final int TOTAL_ROW = 0;
        public static final int FLOOR_TO_DOOR_ROW = 1;
        public static final int STORE_COL = 0;
        public static final int STORE_NAME_COL = 1;
        public static final int STORE_REF_COL = 2;
        public static final int FIRST_SKU_COL = 3;
        private static final String TOTAL = "-2";
        private static final String STORE = "-1";
        private static final String STORE_NAME = "-3";
        private static final String STORE_REF = "-4";
        private long clridx;
        private Vector<Long> substituteClrIdxs = new Vector();
        private FrStkEnquiry.StockType stkType = FrStkEnquiry.StockType.SOH;
        private Vector<Sku> colNames = new Vector();
        private Vector<Hashtable<Object, Object>> data = new Vector();
        private Vector<Integer> sohRowNums = new Vector();
        private Vector<Integer> transRowNums = new Vector();
        private Vector<Integer> laybyRowNums = new Vector();
        private Vector<Integer> resRowNums = new Vector();
        private Vector<Integer> incOrdRowNums = new Vector();
        private Vector<Integer> custOrdRowNums = new Vector();
        private Vector<Integer> custOrdPackedRowNums = new Vector();

        private StkEnquiryTableModel() {
        }

        public Vector<Long> getSubstituteClrs() {
            return this.substituteClrIdxs;
        }

        public void reset(long pclridx) {
            this.clridx = pclridx;
            this.substituteClrIdxs.clear();
            this.colNames.clear();
            this.sohRowNums.clear();
            this.transRowNums.clear();
            this.laybyRowNums.clear();
            this.resRowNums.clear();
            this.incOrdRowNums.clear();
            this.custOrdRowNums.clear();
            this.custOrdPackedRowNums.clear();
            this.data.clear();
            this.colNames.add(new Sku(PosUtils.longVal(STORE), StoreParams.res.getString("Store_Code")));
            this.colNames.add(new Sku(PosUtils.longVal(STORE_NAME), StoreParams.res.getString("Store_Details")));
            this.colNames.add(new Sku(PosUtils.longVal(STORE_REF), PaStkEnquiry.this.settings.getWhseRefGroup()));
            if (this.clridx > 0L) {
                try (SqlQuery sql = new SqlQuery(PaStkEnquiry.this.sParams.conn, "SELECT SKUIDX, SIZEVAL FROM SKU WHERE CLRIDX = " + this.clridx + " AND \"ACTIVE\" = 1 ORDER BY SIZESEQ");){
                    while (sql.next()) {
                        this.colNames.add(new Sku(sql.getLong(1), sql.getString(2)));
                    }
                }
                catch (SQLException e) {
                    PosUtils.logError(e);
                }
            }
            this.colNames.add(new Sku(PosUtils.longVal(TOTAL), StoreParams.res.getString("Total")));
            this.data.add(new Hashtable(this.getColumnCount()));
            this.data.elementAt(0).put(STORE, StoreParams.res.getString("Total"));
            this.data.add(new Hashtable(this.getColumnCount()));
            this.data.elementAt(1).put(STORE, StoreParams.res.getString("Floor_To_Door"));
            this.fireTableStructureChanged();
            PaStkEnquiry.this.setupTable();
        }

        public void populate(FrStkEnquiry.StockType pstkType, boolean forceRefresh) {
            if (((Clr)PaStkEnquiry.this.cbClr.getSelectedItem()).clridx == this.clridx && !forceRefresh) {
                if (this.stkType != pstkType) {
                    this.stkType = pstkType;
                    this.fireTableDataChanged();
                }
            } else {
                this.stkType = pstkType;
                this.reset(((Clr)PaStkEnquiry.this.cbClr.getSelectedItem()).clridx);
                PaStkEnquiry.this.sParams.root = PaStkEnquiry.this.sParams.OnlineQueryProvider.getOnlineQuery("stkenquiry", this.clridx + "," + PaStkEnquiry.this.ownStore.getWidx() + ",true" + "," + PaStkEnquiry.this.frParent.getUser().getMemidx()).getXML();
                if (PaStkEnquiry.this.sParams.root != null) {
                    Element root = PaStkEnquiry.this.sParams.root;
                    PaStkEnquiry.this.sParams.root = null;
                    if (root.getAttribute("clridx") != null) {
                        try {
                            if (root.getAttribute("clridx").getLongValue() == this.clridx) {
                                this.substituteClrIdxs.clear();
                                this.sohRowNums.clear();
                                this.transRowNums.clear();
                                this.laybyRowNums.clear();
                                this.resRowNums.clear();
                                this.incOrdRowNums.clear();
                                this.custOrdRowNums.clear();
                                this.custOrdPackedRowNums.clear();
                                Element substituteProducts = root.getChild("substitute_clrs");
                                if (substituteProducts != null) {
                                    for (Object product : substituteProducts.getChildren("clr")) {
                                        this.substituteClrIdxs.add(XMLUtils.getLongValue((Element)product, "clridx"));
                                    }
                                }
                                Iterator stores = root.getChildren("whse").iterator();
                                double sohGrandTotal = 0.0;
                                double transGrandTotal = 0.0;
                                double laybyGrandTotal = 0.0;
                                double resGrandTotal = 0.0;
                                double incOrdGrandTotal = 0.0;
                                double custOrdGrandTotal = 0.0;
                                double custOrdPackedGrandTotal = 0.0;
                                while (stores.hasNext()) {
                                    double sohTotal = 0.0;
                                    double transTotal = 0.0;
                                    double laybyTotal = 0.0;
                                    double resTotal = 0.0;
                                    double incOrdTotal = 0.0;
                                    double custOrdTotal = 0.0;
                                    double custOrdPackedTotal = 0.0;
                                    boolean showSoh = false;
                                    boolean showTrans = false;
                                    boolean showlayby = false;
                                    boolean showRes = false;
                                    boolean showIncOrd = false;
                                    boolean showCustOrd = false;
                                    boolean showCustOrdPacked = false;
                                    Element whse = (Element)stores.next();
                                    boolean floorToDoorWhse = whse.getAttribute("floor_to_door") != null && whse.getAttribute("floor_to_door").getValue().equals("1");
                                    Hashtable<Object, Object> row = null;
                                    StkEnquiryStore store = null;
                                    if (!floorToDoorWhse) {
                                        boolean doAddRow;
                                        store = new StkEnquiryStore(whse.getAttribute("widx").getLongValue(), PaStkEnquiry.this.settings);
                                        row = new Hashtable(this.getColumnCount());
                                        boolean bl = doAddRow = PaStkEnquiry.this.strStoreFilter.equals("") || store.getStoreCode() != null && store.getStoreCode().toUpperCase().contains(PaStkEnquiry.this.strStoreFilter) || store.getStoreName() != null && store.getStoreName().toUpperCase().contains(PaStkEnquiry.this.strStoreFilter) || store.getStoreCity() != null && store.getStoreCity().toUpperCase().contains(PaStkEnquiry.this.strStoreFilter) || store.getStoreAdrs1() != null && store.getStoreAdrs1().toUpperCase().contains(PaStkEnquiry.this.strStoreFilter) || store.getStorePostal() != null && store.getStorePostal().contains(PaStkEnquiry.this.strStoreFilter) || store.getStoreState() != null && store.getStoreState().toUpperCase().contains(PaStkEnquiry.this.strStoreFilter) || store.getStoreAdrs2() != null && store.getStoreAdrs2().toUpperCase().contains(PaStkEnquiry.this.strStoreFilter);
                                        if (!doAddRow && store.getWidx() != PaStkEnquiry.this.ownStore.getWidx()) continue;
                                        row.put(STORE, store);
                                        String name = this.buildStoreNameAddress(store);
                                        row.put(STORE_NAME, name);
                                        row.put(STORE_REF, store.getDisplayRefName());
                                    } else {
                                        row = this.data.elementAt(1);
                                    }
                                    for (Element sku : whse.getChildren("sku")) {
                                        double soh = sku.getAttribute("soh").getDoubleValue();
                                        double trans = sku.getAttribute("transit").getDoubleValue();
                                        double layby = sku.getAttribute("layby").getDoubleValue();
                                        double res = sku.getAttribute("ret_reserve").getDoubleValue();
                                        double custOrd = sku.getAttribute("custord").getDoubleValue();
                                        double custOrdPacked = sku.getAttribute("custordpacked").getDoubleValue();
                                        double incOrd = 0.0;
                                        switch (((FrStkEnquiry)PaStkEnquiry.this.frParent).getEffectiveStockType(FrStkEnquiry.StockType.INCOMING_ORDERS)) {
                                            case INCOMING_ORDERS: {
                                                incOrd = sku.getAttribute("puro").getDoubleValue() + sku.getAttribute("trans_pending").getDoubleValue() + sku.getAttribute("stk_planned_prod").getDoubleValue();
                                                break;
                                            }
                                            case PURCH_ORDERS: {
                                                incOrd = sku.getAttribute("puro").getDoubleValue();
                                                break;
                                            }
                                            case TRANS_PENDING: {
                                                incOrd = sku.getAttribute("trans_pending").getDoubleValue();
                                                break;
                                            }
                                        }
                                        sohTotal += soh;
                                        transTotal += trans;
                                        laybyTotal += layby;
                                        resTotal += res;
                                        incOrdTotal += incOrd;
                                        custOrdTotal += custOrd;
                                        custOrdPackedTotal += custOrdPacked;
                                        showSoh = showSoh || soh != 0.0;
                                        showTrans = showTrans || trans != 0.0;
                                        showlayby = showlayby || layby != 0.0;
                                        showRes = showRes || res != 0.0;
                                        showIncOrd = showIncOrd || incOrd != 0.0;
                                        showCustOrd = showCustOrd || custOrd != 0.0;
                                        showCustOrdPacked = showCustOrdPacked || custOrdPacked != 0.0;
                                        row.put(sku.getAttribute("skuidx").getValue(), new Stk(soh, trans, layby, res, incOrd, custOrd, custOrdPacked));
                                        if (floorToDoorWhse) continue;
                                        Stk skutot = (Stk)this.data.elementAt(0).get(sku.getAttribute("skuidx").getValue());
                                        if (skutot == null) {
                                            skutot = new Stk(soh, trans, layby, res, incOrd, custOrd, custOrdPacked);
                                            this.data.elementAt(0).put(sku.getAttribute("skuidx").getValue(), skutot);
                                            continue;
                                        }
                                        skutot.soh += soh;
                                        skutot.trans += trans;
                                        skutot.layby += layby;
                                        skutot.res += res;
                                        skutot.incOrd += incOrd;
                                        skutot.custOrd += custOrd;
                                        skutot.custOrdPacked += custOrdPacked;
                                    }
                                    row.put(TOTAL, new Stk(sohTotal, transTotal, laybyTotal, resTotal, incOrdTotal, custOrdTotal, custOrdPackedTotal));
                                    if (floorToDoorWhse) continue;
                                    this.data.add(row);
                                    this.addRowPointer(this.sohRowNums, sohTotal, FrStkEnquiry.StockType.SOH, store, showSoh);
                                    this.addRowPointer(this.transRowNums, transTotal, FrStkEnquiry.StockType.IN_TRANSIT, store, showTrans);
                                    this.addRowPointer(this.laybyRowNums, laybyTotal, FrStkEnquiry.StockType.LAYBY, store, showlayby);
                                    this.addRowPointer(this.resRowNums, resTotal, FrStkEnquiry.StockType.RESERVED, store, showRes);
                                    this.addRowPointer(this.incOrdRowNums, incOrdTotal, FrStkEnquiry.StockType.INCOMING_ORDERS, store, showIncOrd);
                                    this.addRowPointer(this.custOrdRowNums, custOrdTotal, FrStkEnquiry.StockType.CUST_ORDERS, store, showCustOrd);
                                    this.addRowPointer(this.custOrdPackedRowNums, custOrdPackedTotal, FrStkEnquiry.StockType.CUST_ORDERS_PACKED, store, showCustOrdPacked);
                                    sohGrandTotal += sohTotal;
                                    transGrandTotal += transTotal;
                                    laybyGrandTotal += laybyTotal;
                                    resGrandTotal += resTotal;
                                    incOrdGrandTotal += incOrdTotal;
                                    custOrdGrandTotal += custOrdTotal;
                                    custOrdPackedGrandTotal += custOrdPackedTotal;
                                }
                                this.addStorePointer(this.sohRowNums);
                                this.addStorePointer(this.transRowNums);
                                this.addStorePointer(this.laybyRowNums);
                                this.addStorePointer(this.resRowNums);
                                this.addStorePointer(this.incOrdRowNums);
                                this.addStorePointer(this.custOrdRowNums);
                                this.addStorePointer(this.custOrdPackedRowNums);
                                this.data.elementAt(0).put(TOTAL, new Stk(sohGrandTotal, transGrandTotal, laybyGrandTotal, resGrandTotal, incOrdGrandTotal, custOrdGrandTotal, custOrdPackedGrandTotal));
                                this.fireTableDataChanged();
                            }
                        }
                        catch (Exception e) {
                            PosUtils.logError(e);
                        }
                    }
                } else {
                    DlgMessage.showMessage(PaStkEnquiry.this.frParent, StoreParams.res.getString("must_be_online"), StoreParams.res.getString("Offline"), -1, 0);
                }
            }
            PaStkEnquiry.this.showPrice(PaStkEnquiry.this.tblStk.getSelectedColumn());
        }

        private String buildStoreNameAddress(StkEnquiryStore store) {
            String storeTele;
            String storePostal;
            String storeState;
            String storeCity;
            String storeAdrs2;
            String storeAdrs1;
            StringBuilder nameBuilder = new StringBuilder();
            String storeName = store.getStoreName();
            if (storeName != null) {
                nameBuilder.append(storeName);
            }
            if ((storeAdrs1 = store.getStoreAdrs1()) != null && !storeAdrs1.isEmpty()) {
                nameBuilder.append("\t-").append(storeAdrs1);
            }
            if ((storeAdrs2 = store.getStoreAdrs2()) != null && !storeAdrs2.isEmpty()) {
                nameBuilder.append(", ").append(storeAdrs2);
            }
            if ((storeCity = store.getStoreCity()) != null && !storeCity.isEmpty()) {
                nameBuilder.append(", ").append(storeCity);
            }
            if ((storeState = store.getStoreState()) != null && !storeState.isEmpty()) {
                nameBuilder.append(", ").append(storeState);
            }
            if ((storePostal = store.getStorePostal()) != null && !storePostal.isEmpty()) {
                nameBuilder.append(", ").append(storePostal);
            }
            if ((storeTele = store.getStoreTele()) != null && !storeTele.isEmpty()) {
                nameBuilder.append(" - Ph: ").append(storeTele);
            }
            return nameBuilder.toString();
        }

        private void addRowPointer(Vector<Integer> rowNums, double totalToAdd, FrStkEnquiry.StockType stockType, StkEnquiryStore storeToAdd, boolean addRow) {
            if (addRow && storeToAdd.getWidx() != PaStkEnquiry.this.ownStore.getWidx()) {
                int i;
                for (i = 0; i < rowNums.size(); ++i) {
                    double val;
                    Stk stkTotal = (Stk)this.data.elementAt(rowNums.elementAt(i)).get(TOTAL);
                    StkEnquiryStore store = (StkEnquiryStore)this.data.elementAt(rowNums.elementAt(i)).get(STORE);
                    switch (stockType) {
                        case SOH: {
                            val = stkTotal.soh;
                            break;
                        }
                        case IN_TRANSIT: {
                            val = stkTotal.trans;
                            break;
                        }
                        case LAYBY: {
                            val = stkTotal.layby;
                            break;
                        }
                        case RESERVED: {
                            val = stkTotal.res;
                            break;
                        }
                        case INCOMING_ORDERS: {
                            val = stkTotal.incOrd;
                            break;
                        }
                        case CUST_ORDERS: {
                            val = stkTotal.custOrd;
                            break;
                        }
                        case CUST_ORDERS_PACKED: {
                            val = stkTotal.custOrdPacked;
                            break;
                        }
                        default: {
                            val = 0.0;
                        }
                    }
                    if (store.getWidx() == PaStkEnquiry.this.ownStore.getWidx()) continue;
                    if (PaStkEnquiry.this.settings.getSortBy() == StkEnquirySettings.SortBy.TOTAL_STOCK) {
                        if (!(val < totalToAdd)) continue;
                        rowNums.insertElementAt(new Integer(this.data.size() - 1), i);
                        break;
                    }
                    if (PaStkEnquiry.this.settings.getSortBy() == StkEnquirySettings.SortBy.WHSE_CODE) {
                        if (storeToAdd.getStoreCode().compareTo(store.getStoreCode()) >= 0) continue;
                        rowNums.insertElementAt(new Integer(this.data.size() - 1), i);
                        break;
                    }
                    if (PaStkEnquiry.this.settings.getSortBy() == StkEnquirySettings.SortBy.WHSE_NAME) {
                        if (storeToAdd.getStoreName().compareTo(store.getStoreName()) >= 0) continue;
                        rowNums.insertElementAt(new Integer(this.data.size() - 1), i);
                        break;
                    }
                    if (PaStkEnquiry.this.settings.getSortBy() != StkEnquirySettings.SortBy.WHSE_REF) continue;
                    int stringCompare = storeToAdd.getDisplayRefName().compareTo(store.getDisplayRefName());
                    if (stringCompare == 0) {
                        if (!(val < totalToAdd)) continue;
                        rowNums.insertElementAt(new Integer(this.data.size() - 1), i);
                        break;
                    }
                    if (storeToAdd.getDisplayRefName().equals(PaStkEnquiry.this.ownStore.getDisplayRefName())) {
                        rowNums.insertElementAt(new Integer(this.data.size() - 1), i);
                        break;
                    }
                    if (stringCompare >= 0 || store.getDisplayRefName().equals(PaStkEnquiry.this.ownStore.getDisplayRefName())) continue;
                    rowNums.insertElementAt(new Integer(this.data.size() - 1), i);
                    break;
                }
                if (i == rowNums.size()) {
                    rowNums.add(new Integer(this.data.size() - 1));
                }
            } else if (storeToAdd.getWidx() == PaStkEnquiry.this.ownStore.getWidx()) {
                rowNums.insertElementAt(new Integer(this.data.size() - 1), 0);
            }
        }

        private void addStorePointer(Vector<Integer> rowNums) {
            if (rowNums.size() == 0 || ((StkEnquiryStore)this.data.elementAt(rowNums.elementAt(0)).get(STORE)).getWidx() != PaStkEnquiry.this.ownStore.getWidx()) {
                if (this.sohRowNums.size() > 0 && ((StkEnquiryStore)this.data.elementAt(this.sohRowNums.elementAt(0)).get(STORE)).getWidx() == PaStkEnquiry.this.ownStore.getWidx()) {
                    rowNums.insertElementAt(this.sohRowNums.elementAt(0), 0);
                } else if (this.transRowNums.size() > 0 && ((StkEnquiryStore)this.data.elementAt(this.transRowNums.elementAt(0)).get(STORE)).getWidx() == PaStkEnquiry.this.ownStore.getWidx()) {
                    rowNums.insertElementAt(this.transRowNums.elementAt(0), 0);
                } else if (this.laybyRowNums.size() > 0 && ((StkEnquiryStore)this.data.elementAt(this.laybyRowNums.elementAt(0)).get(STORE)).getWidx() == PaStkEnquiry.this.ownStore.getWidx()) {
                    rowNums.insertElementAt(this.laybyRowNums.elementAt(0), 0);
                } else if (this.resRowNums.size() > 0 && ((StkEnquiryStore)this.data.elementAt(this.resRowNums.elementAt(0)).get(STORE)).getWidx() == PaStkEnquiry.this.ownStore.getWidx()) {
                    rowNums.insertElementAt(this.resRowNums.elementAt(0), 0);
                } else if (this.incOrdRowNums.size() > 0 && ((StkEnquiryStore)this.data.elementAt(this.incOrdRowNums.elementAt(0)).get(STORE)).getWidx() == PaStkEnquiry.this.ownStore.getWidx()) {
                    rowNums.insertElementAt(this.incOrdRowNums.elementAt(0), 0);
                } else if (this.custOrdRowNums.size() > 0 && ((StkEnquiryStore)this.data.elementAt(this.custOrdRowNums.elementAt(0)).get(STORE)).getWidx() == PaStkEnquiry.this.ownStore.getWidx()) {
                    rowNums.insertElementAt(this.custOrdRowNums.elementAt(0), 0);
                } else if (this.custOrdPackedRowNums.size() > 0 && ((StkEnquiryStore)this.data.elementAt(this.custOrdPackedRowNums.elementAt(0)).get(STORE)).getWidx() == PaStkEnquiry.this.ownStore.getWidx()) {
                    rowNums.insertElementAt(this.custOrdPackedRowNums.elementAt(0), 0);
                } else {
                    this.data.add(new Hashtable(this.getColumnCount()));
                    this.data.elementAt(this.data.size() - 1).put(STORE, PaStkEnquiry.this.ownStore);
                    String name = this.buildStoreNameAddress(PaStkEnquiry.this.ownStore);
                    this.data.elementAt(this.data.size() - 1).put(STORE_NAME, name);
                    this.data.elementAt(this.data.size() - 1).put(STORE_REF, PaStkEnquiry.this.ownStore.getDisplayRefName());
                    rowNums.insertElementAt(new Integer(this.data.size() - 1), 0);
                }
            }
        }

        public int getDataIndex(int row) {
            if (row < 0 || row >= this.getRowCount()) {
                return -1;
            }
            switch (this.stkType) {
                case SOH: {
                    return this.sohRowNums.elementAt(row);
                }
                case IN_TRANSIT: {
                    return this.transRowNums.elementAt(row);
                }
                case LAYBY: {
                    return this.laybyRowNums.elementAt(row);
                }
                case RESERVED: {
                    return this.resRowNums.elementAt(row);
                }
                case INCOMING_ORDERS: {
                    return this.incOrdRowNums.elementAt(row);
                }
                case CUST_ORDERS: {
                    return this.custOrdRowNums.elementAt(row);
                }
                case CUST_ORDERS_PACKED: {
                    return this.custOrdPackedRowNums.elementAt(row);
                }
            }
            return -1;
        }

        @Override
        public int getRowCount() {
            switch (this.stkType) {
                case SOH: {
                    return this.sohRowNums.size();
                }
                case IN_TRANSIT: {
                    return this.transRowNums.size();
                }
                case LAYBY: {
                    return this.laybyRowNums.size();
                }
                case RESERVED: {
                    return this.resRowNums.size();
                }
                case INCOMING_ORDERS: {
                    return this.incOrdRowNums.size();
                }
                case CUST_ORDERS: {
                    return this.custOrdRowNums.size();
                }
                case CUST_ORDERS_PACKED: {
                    return this.custOrdPackedRowNums.size();
                }
            }
            return 0;
        }

        @Override
        public int getColumnCount() {
            return this.colNames.size();
        }

        public StkEnquiryStore getWhse(int row) {
            if (row >= 0) {
                Integer rownum;
                switch (this.stkType) {
                    case SOH: {
                        rownum = this.sohRowNums.elementAt(row);
                        break;
                    }
                    case IN_TRANSIT: {
                        rownum = this.transRowNums.elementAt(row);
                        break;
                    }
                    case LAYBY: {
                        rownum = this.laybyRowNums.elementAt(row);
                        break;
                    }
                    case RESERVED: {
                        rownum = this.resRowNums.elementAt(row);
                        break;
                    }
                    case INCOMING_ORDERS: {
                        rownum = this.incOrdRowNums.elementAt(row);
                        break;
                    }
                    case CUST_ORDERS: {
                        rownum = this.custOrdRowNums.elementAt(row);
                        break;
                    }
                    case CUST_ORDERS_PACKED: {
                        rownum = this.custOrdPackedRowNums.elementAt(row);
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                Object store = this.data.elementAt(rownum).get(STORE);
                if (store instanceof StkEnquiryStore) {
                    return (StkEnquiryStore)store;
                }
            }
            return null;
        }

        public long getSkuidx(int col) {
            Sku sku;
            if (col >= 3 && (sku = this.colNames.elementAt(col)) != null && sku instanceof Sku) {
                return sku.skuidx;
            }
            return 0L;
        }

        public double getSkuPrice(int col) {
            Sku sku = null;
            if (col >= 3) {
                sku = this.colNames.elementAt(col);
                if (sku == null || sku.skuidx < 0L) {
                    sku = this.colNames.elementAt(3);
                }
            } else if (this.colNames.size() > 3) {
                sku = this.colNames.elementAt(3);
            }
            if (sku != null && sku instanceof Sku && sku.skuidx > 0L) {
                return sku.skuPrice.getPrice();
            }
            return 0.0;
        }

        private Object getDataValue(int index, int col) {
            Object retval = this.data.elementAt(index).get(String.valueOf(this.colNames.elementAt(col).skuidx));
            if (retval instanceof Stk) {
                double val;
                switch (this.stkType) {
                    case SOH: {
                        val = ((Stk)retval).soh;
                        break;
                    }
                    case IN_TRANSIT: {
                        val = ((Stk)retval).trans;
                        break;
                    }
                    case LAYBY: {
                        val = ((Stk)retval).layby;
                        break;
                    }
                    case RESERVED: {
                        val = ((Stk)retval).res;
                        break;
                    }
                    case INCOMING_ORDERS: {
                        val = ((Stk)retval).incOrd;
                        break;
                    }
                    case CUST_ORDERS: {
                        val = ((Stk)retval).custOrd;
                        break;
                    }
                    case CUST_ORDERS_PACKED: {
                        val = ((Stk)retval).custOrdPacked;
                        break;
                    }
                    default: {
                        val = 0.0;
                    }
                }
                retval = val == 0.0 ? null : StoreParams.qtyFormat.format(val);
            }
            if (retval == null) {
                retval = "";
            }
            return retval;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Integer rownum = this.getDataIndex(row);
            if (rownum < 0) {
                return "";
            }
            return this.getDataValue(rownum, col);
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        @Override
        public String getColumnName(int col) {
            return this.colNames.elementAt(col).toString();
        }

        public Object getColumnTotal(int col) {
            return this.getDataValue(0, col);
        }

        public Object getColumnFloorToDoor(int col) {
            return this.getDataValue(1, col);
        }

        private class Stk {
            double soh;
            double trans;
            double layby;
            double res;
            double incOrd;
            double custOrd;
            double custOrdPacked;

            public Stk(double soh, double trans, double layby, double res, double incOrd, double custOrd, double custOrdPacked) {
                this.soh = soh;
                this.trans = trans;
                this.layby = layby;
                this.res = res;
                this.incOrd = incOrd;
                this.custOrd = custOrd;
                this.custOrdPacked = custOrdPacked;
            }
        }

        private class Sku {
            private long skuidx;
            private String sizeval;
            private SkuPrice skuPrice;

            public Sku(long skuidx, String sizeval) {
                this.skuidx = skuidx;
                this.sizeval = sizeval;
                this.skuPrice = new SkuPrice(this.skuidx);
            }

            public String toString() {
                return this.sizeval;
            }
        }
    }

    private class TransTable
    extends PosTable {
        private FrStkEnquiry.StockType tableStockType;
        private Vector<String> docknums;
        private Vector<Element> people;

        public TransTable(PosFrame pfrParent) {
            super(pfrParent, new DefaultTableModel());
            this.tableStockType = FrStkEnquiry.StockType.SOH;
            this.docknums = new Vector();
            this.people = new Vector();
            this.setSelectionMode(0);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() > 1 && TransTable.this.getSelectedRow() > -1) {
                        ((FrStkEnquiry)PaStkEnquiry.this.frParent).openItem();
                    }
                }
            });
        }

        public String getDocketNum(int row) {
            return this.docknums.elementAt(row);
        }

        public Element getPerson(int row) {
            if (row < this.people.size()) {
                return this.people.elementAt(row);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }

        private void setup(FrStkEnquiry.StockType pstkType) {
            this.tableStockType = pstkType;
            ((DefaultTableModel)this.getModel()).setColumnCount(0);
            switch (this.tableStockType) {
                case IN_TRANSIT: {
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("From"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Despatched"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Carrier_Label"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Consignment_Note_Number"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Qty"));
                    this.getColumnModel().getColumn(0).setMinWidth(100);
                    this.getColumnModel().getColumn(1).setMinWidth(100);
                    this.getColumnModel().getColumn(2).setMinWidth(100);
                    this.getColumnModel().getColumn(3).setMinWidth(100);
                    this.getColumnModel().getColumn(4).setMinWidth(50);
                    this.getColumnModel().getColumn(0).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(1).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(2).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(3).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(4).setHeaderRenderer(this.headerCenterRen);
                    this.renderer.setColumnFormat(0, null, 2);
                    this.renderer.setColumnFormat(1, null, 2);
                    this.renderer.setColumnFormat(2, null, 2);
                    this.renderer.setColumnFormat(3, null, 2);
                    this.renderer.setColumnFormat(4, StoreParams.qtyFormat, 0);
                    break;
                }
                case LAYBY: {
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Layby"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Customer"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Phone_Number"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Due_Date"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Qty"));
                    this.getColumnModel().getColumn(0).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(1).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(2).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(3).setHeaderRenderer(this.headerCenterRen);
                    this.getColumnModel().getColumn(4).setHeaderRenderer(this.headerCenterRen);
                    this.renderer.setColumnFormat(0, null, 2);
                    this.renderer.setColumnFormat(1, null, 2);
                    this.renderer.setColumnFormat(2, null, 2);
                    this.renderer.setColumnFormat(3, null, 0);
                    this.renderer.setColumnFormat(4, StoreParams.qtyFormat, 0);
                    break;
                }
                case RESERVED: {
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Reservation"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Customer"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Phone_Number"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Created_Date"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Qty"));
                    this.getColumnModel().getColumn(0).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(1).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(2).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(3).setHeaderRenderer(this.headerCenterRen);
                    this.getColumnModel().getColumn(4).setHeaderRenderer(this.headerCenterRen);
                    this.renderer.setColumnFormat(0, null, 2);
                    this.renderer.setColumnFormat(1, null, 2);
                    this.renderer.setColumnFormat(2, null, 2);
                    this.renderer.setColumnFormat(3, null, 0);
                    this.renderer.setColumnFormat(4, StoreParams.qtyFormat, 0);
                    break;
                }
                case INCOMING_ORDERS: {
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Inc_Order_Type"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("PO_Number"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("PO_From"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Due_Date"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Qty"));
                    this.getColumnModel().getColumn(0).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(1).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(2).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(3).setHeaderRenderer(this.headerCenterRen);
                    this.getColumnModel().getColumn(4).setHeaderRenderer(this.headerCenterRen);
                    this.renderer.setColumnFormat(0, null, 2);
                    this.renderer.setColumnFormat(1, null, 2);
                    this.renderer.setColumnFormat(2, null, 2);
                    this.renderer.setColumnFormat(3, null, 0);
                    this.renderer.setColumnFormat(4, StoreParams.qtyFormat, 0);
                    break;
                }
                case CUST_ORDERS: {
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Order_Number"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Reference"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Customer"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Phone_Number"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Created_Date"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Outstanding_Qty"));
                    this.getColumnModel().getColumn(0).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(1).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(2).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(3).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(4).setHeaderRenderer(this.headerCenterRen);
                    this.getColumnModel().getColumn(5).setHeaderRenderer(this.headerCenterRen);
                    this.renderer.setColumnFormat(0, null, 2);
                    this.renderer.setColumnFormat(1, null, 2);
                    this.renderer.setColumnFormat(2, null, 2);
                    this.renderer.setColumnFormat(3, null, 2);
                    this.renderer.setColumnFormat(4, null, 0);
                    this.renderer.setColumnFormat(5, StoreParams.qtyFormat, 0);
                    break;
                }
                case CUST_ORDERS_PACKED: {
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Order_Number"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Reference"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Customer"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Phone_Number"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Created_Date"));
                    ((DefaultTableModel)this.getModel()).addColumn(StoreParams.res.getString("Packed_Qty"));
                    this.getColumnModel().getColumn(0).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(1).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(2).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(3).setHeaderRenderer(this.headerLeftRen);
                    this.getColumnModel().getColumn(4).setHeaderRenderer(this.headerCenterRen);
                    this.getColumnModel().getColumn(5).setHeaderRenderer(this.headerCenterRen);
                    this.renderer.setColumnFormat(0, null, 2);
                    this.renderer.setColumnFormat(1, null, 2);
                    this.renderer.setColumnFormat(2, null, 2);
                    this.renderer.setColumnFormat(3, null, 2);
                    this.renderer.setColumnFormat(4, null, 0);
                    this.renderer.setColumnFormat(5, StoreParams.qtyFormat, 0);
                    break;
                }
            }
            ((DefaultTableModel)this.getModel()).setNumRows(0);
        }

        public void clearRows() {
            ((DefaultTableModel)this.getModel()).setNumRows(0);
            this.docknums.clear();
            this.people.clear();
        }

        public void populate(Element stkTrans) {
            try {
                Vector<Object> rowdata = null;
                String tempDateString = "";
                Carrier carrier = new Carrier(0L);
                List subStkTrans = stkTrans.getChildren("substktrans");
                for (int i = 0; i < subStkTrans.size(); ++i) {
                    String phone;
                    String name;
                    Element transaction = (Element)subStkTrans.get(i);
                    if (this.tableStockType == FrStkEnquiry.StockType.IN_TRANSIT) {
                        try {
                            PaStkEnquiry.this.dateFormatter.setTimestampInternal(XMLUtils.getValue(transaction, "trand"));
                            tempDateString = PaStkEnquiry.this.dateFormatter.toString();
                        }
                        catch (Exception e) {
                            tempDateString = "";
                        }
                        if (rowdata != null && rowdata.get(0).equals(XMLUtils.getValue(transaction, "code")) && rowdata.get(1).equals(tempDateString) && carrier.getId() == XMLUtils.getLongValue(transaction, "carrier") && rowdata.get(3).equals(XMLUtils.getValue(transaction, "connum"))) {
                            rowdata.set(4, StoreParams.qtyFormat.format(PosUtils.doubleValFormatted(rowdata.get(4).toString()) + transaction.getAttribute("qty").getDoubleValue()));
                        } else {
                            if (rowdata != null) {
                                ((DefaultTableModel)this.getModel()).addRow(rowdata);
                            }
                            rowdata = new Vector();
                            rowdata.add(XMLUtils.getValue(transaction, "code"));
                            try {
                                PaStkEnquiry.this.dateFormatter.setTimestampInternal(XMLUtils.getValue(transaction, "trand"));
                                rowdata.add(PaStkEnquiry.this.dateFormatter.toString());
                            }
                            catch (Exception e) {
                                rowdata.add("");
                            }
                            if (carrier.getId() != XMLUtils.getLongValue(transaction, "carrier")) {
                                carrier = new Carrier(XMLUtils.getLongValue(transaction, "carrier"));
                            }
                            rowdata.add(carrier.toString());
                            rowdata.add(new Link(XMLUtils.getValue(transaction, "connum"), carrier.getUrl(XMLUtils.getValue(transaction, "connum"))));
                            rowdata.add(XMLUtils.getValue(transaction, "qty"));
                        }
                    } else if (this.tableStockType == FrStkEnquiry.StockType.LAYBY) {
                        rowdata = new Vector<Object>();
                        rowdata.add(transaction.getAttribute("trans_number").getValue());
                        name = "";
                        phone = "";
                        if (transaction.getChild("person") != null) {
                            Element person = transaction.getChild("person");
                            this.people.add(person);
                            name = PersonUtils.getPerName(person);
                            phone = PersonUtils.getPhoneNum(person, PersonUtils.PhoneType.MAIN);
                        }
                        rowdata.add(name);
                        rowdata.add(phone);
                        try {
                            PaStkEnquiry.this.dateFormatter.setTimestampInternal(transaction.getAttribute("layby_due").getValue());
                            rowdata.add(PaStkEnquiry.this.dateFormatter.toString());
                        }
                        catch (Exception e) {
                            rowdata.add("");
                        }
                        rowdata.add(transaction.getAttribute("qty").getValue());
                        ((DefaultTableModel)this.getModel()).addRow(rowdata);
                    } else if (this.tableStockType == FrStkEnquiry.StockType.RESERVED) {
                        rowdata = new Vector();
                        rowdata.add(transaction.getAttribute("trans_number").getValue());
                        name = "";
                        phone = "";
                        if (transaction.getChild("person") != null) {
                            Element person = transaction.getChild("person");
                            this.people.add(person);
                            name = PersonUtils.getPerName(person);
                            phone = PersonUtils.getPhoneNum(person, PersonUtils.PhoneType.MAIN);
                        } else {
                            this.people.add(new Element("person"));
                        }
                        rowdata.add(name);
                        rowdata.add(phone);
                        try {
                            PaStkEnquiry.this.dateFormatter.setTimestampInternal(transaction.getAttribute("trand").getValue());
                            rowdata.add(PaStkEnquiry.this.dateFormatter.toString());
                        }
                        catch (Exception e) {
                            rowdata.add("");
                        }
                        rowdata.add(transaction.getAttribute("qty").getValue());
                        ((DefaultTableModel)this.getModel()).addRow(rowdata);
                    } else if (this.tableStockType == FrStkEnquiry.StockType.INCOMING_ORDERS) {
                        String type;
                        rowdata = new Vector();
                        switch (type = transaction.getAttribute("type") == null ? "" : transaction.getAttribute("type").getValue()) {
                            case "PO": {
                                type = SP.getRS("Inc_Order_Type_Purc_Ord");
                                break;
                            }
                            case "TRO": {
                                type = SP.getRS("Inc_Order_Type_Transfer_Ord");
                                break;
                            }
                            case "TRR": {
                                type = SP.getRS("Inc_Order_Type_Transfer_Req");
                                break;
                            }
                            case "PD": {
                                type = SP.getRS("Inc_Order_Type_Prod_Ord");
                                break;
                            }
                        }
                        rowdata.add(type);
                        rowdata.add(transaction.getAttribute("trans_number") == null ? "" : transaction.getAttribute("trans_number").getValue());
                        rowdata.add(transaction.getAttribute("supplier_name") == null ? "" : transaction.getAttribute("supplier_name").getValue());
                        try {
                            PaStkEnquiry.this.dateFormatter.setTimestampInternal(transaction.getAttribute("trand").getValue());
                            rowdata.add(PaStkEnquiry.this.dateFormatter.toString());
                        }
                        catch (Exception e) {
                            rowdata.add("");
                        }
                        rowdata.add(transaction.getAttribute("qty") == null ? "" : transaction.getAttribute("qty").getValue());
                        ((DefaultTableModel)this.getModel()).addRow(rowdata);
                    } else if (this.tableStockType == FrStkEnquiry.StockType.CUST_ORDERS || this.tableStockType == FrStkEnquiry.StockType.CUST_ORDERS_PACKED) {
                        rowdata = new Vector();
                        rowdata.add(transaction.getAttribute("trans_number") == null ? "" : transaction.getAttribute("trans_number").getValue());
                        rowdata.add(transaction.getAttribute("notes2") == null ? "" : transaction.getAttribute("notes2").getValue());
                        name = "";
                        phone = "";
                        if (transaction.getChild("person") != null) {
                            Element person = transaction.getChild("person");
                            this.people.add(person);
                            name = PersonUtils.getPerName(person);
                            phone = PersonUtils.getPhoneNum(person, PersonUtils.PhoneType.MAIN);
                        }
                        rowdata.add(name);
                        rowdata.add(phone);
                        try {
                            PaStkEnquiry.this.dateFormatter.setTimestampInternal(transaction.getAttribute("trand") == null ? "" : transaction.getAttribute("trand").getValue());
                            rowdata.add(PaStkEnquiry.this.dateFormatter.toString());
                        }
                        catch (Exception e) {
                            rowdata.add("");
                        }
                        rowdata.add(transaction.getAttribute("qty") == null ? "" : transaction.getAttribute("qty").getValue());
                        ((DefaultTableModel)this.getModel()).addRow(rowdata);
                    }
                    if (transaction.getAttribute("docket_number") == null) continue;
                    this.docknums.add(transaction.getAttribute("docket_number").getValue());
                }
                if (rowdata != null && this.tableStockType == FrStkEnquiry.StockType.IN_TRANSIT) {
                    ((DefaultTableModel)this.getModel()).addRow(rowdata);
                }
            }
            catch (DataConversionException e) {
                PosUtils.logError(e);
            }
        }
    }

    private class Clr {
        long clridx;
        String code;
        String name;

        public Clr(long pclridx, String pcode, String pname) {
            this.clridx = pclridx;
            this.code = pcode;
            this.name = pname;
        }

        public String toString() {
            if (this.code == null || this.code.length() == 0) {
                return "";
            }
            return StringUtils.nullToEmpty(this.code) + " - " + StringUtils.nullToEmpty(this.name);
        }
    }
}

