/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.List;
import java.util.Vector;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import jpos.Carrier;
import jpos.CostByLine;
import jpos.DlgMessage;
import jpos.FrTransferIn;
import jpos.PaTransferFoot;
import jpos.PaTransferInAbstract;
import jpos.PosDateFormatter;
import jpos.PosDouble;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosTableListener;
import jpos.PosTableModelEvent;
import jpos.PosUtils;
import jpos.Reference;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StatusBar;
import jpos.Store;
import jpos.StoreParams;
import jpos.StringField;
import jpos.StringUtils;
import jpos.StyleLine;
import jpos.StyleTable;
import jpos.SystemSettings;
import jpos.TotalsTable;
import jpos.TotalsTableModel;
import jpos.XMLUtils;
import jpos.basscom.swing.BJTextField;
import jpos.searchfields.BarcodeSearchField;
import jpos.searchfields.ClrSearchField;
import jpos.searchfields.HintTextField;
import jpos.searchfields.SearchPanel;
import jpos.searchfields.SizeSearchField;
import jpos.stockreceipt.DlgCosting;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;
import org.jdom.DataConversionException;
import org.jdom.Element;

public class PaTransferIn
extends PaTransferInAbstract {
    SizeSearchField tfSize = new SizeSearchField(){

        @Override
        public void actionValidate() {
            super.actionValidate();
            String barcode = "";
            try (SqlQuery sql = new SqlQuery(PaTransferIn.this.sParams.conn, "SELECT DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.SKUIDX = " + this.getidx());){
                if (sql.next()) {
                    barcode = sql.getString(1);
                }
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
            PaTransferIn.this.processBarcodeLater(barcode);
        }
    };
    ClrSearchField tfClr = new ClrSearchField(){

        @Override
        public void actionValidate() {
            super.actionValidate();
            try (SqlQuery sql = new SqlQuery(PaTransferIn.this.sParams.conn, "SELECT K.SKUIDX, DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.CLRIDX = " + this.getidx());){
                if (sql.next()) {
                    String apn = sql.getString(2);
                    if (sql.next()) {
                        PaTransferIn.this.tfSize.search(this.getidx(), PaTransferIn.this.tfBarcode.getText(), this.getText());
                    } else {
                        PaTransferIn.this.processBarcodeLater(apn);
                    }
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    };
    BarcodeSearchField tfBarcode = new BarcodeSearchField(TouchTextField.FontSize.LARGE){

        @Override
        public void actionSearch() {
            if (PaTransferIn.this.frParent.isLoggedIn(true)) {
                PaTransferIn.this.search = true;
                if (this.getText().equals(StoreParams.invalidBarcode) || this.getText().equals(StoreParams.noTrans) || this.getText().equals(StoreParams.invalidTrans)) {
                    this.setText("");
                }
                super.actionSearch();
                this.requestFocus();
                this.selectAll();
            }
        }

        @Override
        public void actionValidate() {
            if (!PaTransferIn.this.search) {
                return;
            }
            PaTransferIn.this.search = false;
            if (!(this.getText().equals(StoreParams.invalidBarcode) || this.getText().equals(StoreParams.noTrans) || this.getText().equals(StoreParams.invalidTrans))) {
                super.actionValidate();
                try (SqlQuery sqlClr = new SqlQuery(PaTransferIn.this.sParams.conn, "SELECT C.CLRIDX, C.CLRNAME FROM CLR C WHERE C.STYLEIDX = " + this.getidx());){
                    if (sqlClr.next()) {
                        long clridx = sqlClr.getLong(1);
                        String clrname = sqlClr.getString(2);
                        if (sqlClr.next()) {
                            PaTransferIn.this.tfClr.search(this.getidx(), this.getText());
                        } else {
                            try (SqlQuery sqlBarcode = new SqlQuery(PaTransferIn.this.sParams.conn, "SELECT K.SKUIDX, DB.CODE FROM DEFAULT_BARCODE DB, SKU K WHERE DB.SKUIDX = K.SKUIDX AND K.CLRIDX = " + clridx);){
                                if (sqlBarcode.next()) {
                                    String apn = sqlBarcode.getString(2);
                                    if (sqlBarcode.next()) {
                                        PaTransferIn.this.tfSize.search(clridx, this.getText(), clrname);
                                    } else {
                                        PaTransferIn.this.processBarcodeLater(apn);
                                    }
                                }
                            }
                        }
                    }
                    PaTransferIn.this.tfBarcode.clear();
                }
                catch (Exception e) {
                    PosUtils.logError(e);
                }
            }
        }
    };
    private SearchPanel barcodeSearchPanel = new SearchPanel(this.tfBarcode);
    private boolean search = false;
    BJTextField tfTransSearch = new BJTextField(TouchTextField.FontSize.LARGE);
    BJTextField tfPurchOrderSearch = new BJTextField(TouchTextField.FontSize.LARGE);
    BJTextField tfTransferOrderSearch = new BJTextField(TouchTextField.FontSize.LARGE);
    StyleTable tblStyles;
    private TotalsTable tblTotals;
    private long supIdx = 0L;
    LabelSubHeading lFrom = new LabelSubHeading();
    protected BJTextField tfWhse = new BJTextField(TouchTextField.FontSize.LARGE);
    protected HintTextField tfSupplier = new HintTextField(SP.getRS("Search_F12"), TouchTextField.FontSize.LARGE){

        @Override
        public void actionValidate() {
            if (this.hasValueChanged()) {
                this.doValidate();
            }
            PaTransferIn.this.supIdx = this.getidx();
            PaTransferIn.this.updateProductCosts();
        }
    };
    private SearchPanel supplierSearchPanel = new SearchPanel(this.tfSupplier);
    protected Vector<Store> transferInStores = new Vector();
    protected Vector<Reference> suppliers = new Vector();
    GridBagLayout gridBagLayout = new GridBagLayout();
    StringField tfDock = new StringField(15, TouchTextField.FontSize.LARGE);
    LabelSubHeading lFeedBack = new LabelSubHeading();
    LabelSubHeading lDock = new LabelSubHeading();
    LabelSubHeading lFeedBack2 = new LabelSubHeading();
    StoreParams sParams;
    CostByLine dlgCost = null;

    public PaTransferIn(PosFrame pfrParent) {
        this.frParent = pfrParent;
        this.sParams = this.frParent.sParams;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        String tableOn = "";
        try {
            boolean supRef = false;
            int supPos = 0;
            boolean storeRef = false;
            int storePos = 0;
            String supByCompanyWhere = "";
            String companyRef = "";
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, "select rg_ord from reftbl where tblidx = 10 and rgidx = 22");){
                if (sql.next()) {
                    supRef = true;
                    supPos = sql.getInt(1);
                }
            }
            sql = new SqlQuery(this.sParams.conn, "select rg_ord from reftbl where tblidx = 18 and rgidx = 22");
            var9_14 = null;
            try {
                if (sql.next()) {
                    storeRef = true;
                    storePos = sql.getInt(1);
                }
            }
            catch (Throwable throwable) {
                var9_14 = throwable;
                throw throwable;
            }
            finally {
                if (sql != null) {
                    if (var9_14 != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable) {
                            var9_14.addSuppressed(throwable);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
            if (supRef && storeRef) {
                sql = new SqlQuery(this.sParams.conn, "select ref" + storePos + " from whse where widx = " + this.sParams.getStoreIdx());
                var9_14 = null;
                try {
                    if (sql.next()) {
                        companyRef = sql.getString(1);
                    }
                }
                catch (Throwable throwable) {
                    var9_14 = throwable;
                    throw throwable;
                }
                finally {
                    if (sql != null) {
                        if (var9_14 != null) {
                            try {
                                sql.close();
                            }
                            catch (Throwable throwable) {
                                var9_14.addSuppressed(throwable);
                            }
                        } else {
                            sql.close();
                        }
                    }
                }
                if (companyRef != null) {
                    supByCompanyWhere = " AND SR.REF" + supPos + " = " + companyRef;
                    tableOn = "SR.REF" + supPos + " = " + companyRef + " AND ";
                }
            }
            String sqlQuery = "SELECT SR.SUPIDX, SR.CODE, SR.NAME FROM SUPPLIER SR WHERE SR.\"ACTIVE\" = 1 " + this.sParams.sRefSecWhereSUPPLIER + supByCompanyWhere + " ORDER BY SR.CODE";
            try (SqlQuery sql = new SqlQuery(this.sParams.conn, sqlQuery);){
                while (sql.next()) {
                    this.suppliers.add(new Reference(sql.getString(3), sql.getString(2), sql.getLong(1)));
                }
            }
            sql = new SqlQuery(this.sParams.conn, "SELECT W.STORENO, W.WIDX, R.CODE, R.NAME FROM WHSE W, REFCODE R WHERE R.RCIDX = W.WIDX AND R.RGIDX = 7 AND W.\"TYPE\" <> 'V' AND R.\"ACTIVE\" = 1 " + this.sParams.sWhseRefSecWhereWHSEStkReceipts + " " + "ORDER BY R.CODE");
            var10_19 = null;
            try {
                while (sql.next()) {
                    this.transferInStores.add(new Store(sql.getString(4), sql.getString(3), sql.getString(1), sql.getLong(2)));
                }
            }
            catch (Throwable throwable) {
                var10_19 = throwable;
                throw throwable;
            }
            finally {
                if (sql != null) {
                    if (var10_19 != null) {
                        try {
                            sql.close();
                        }
                        catch (Throwable throwable) {
                            var10_19.addSuppressed(throwable);
                        }
                    } else {
                        sql.close();
                    }
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        this.tfWhse.setCache(this.sParams.cacher, 985L, "3798,3797", "", "1=1 " + this.sParams.sWhseRefSecWhereWHSEStkReceipts);
        this.tfWhse.setSearchKey(123);
        this.tfWhse.searchWithEnter(true);
        this.tfWhse.setShowSearchForOneResult(true);
        String sqlQuery = tableOn + " SR.\"ACTIVE\" = 1 " + this.sParams.sRefSecWhereSUPPLIER;
        this.tfSupplier.setCache(this.sParams.cacher, 694L, "", "", sqlQuery);
        this.tfSupplier.setSearchKey(123);
        this.tfSupplier.searchWithEnter(true);
        this.tfSupplier.setShowSearchForOneResult(true);
        this.setFromField(250);
        this.tblStyles = new StyleTable(this.frParent, null);
        this.tblStyles.addTableModelListener(new PosTableListener(){

            @Override
            public void tableValueChanging(PosTableModelEvent e) {
                if (PaTransferIn.this.frParent.transnum == null && ((FrTransferIn)PaTransferIn.this.frParent).pordidx < 0L || PaTransferIn.this.frParent.transType != 250 && PaTransferIn.this.frParent.transType != 251 || ((FrTransferIn)PaTransferIn.this.frParent).canOverReceipt()) {
                    return;
                }
                if (e.getColumn() == 6) {
                    int row = e.getFirstRow();
                    double prevReceived = ((PosDouble)PaTransferIn.this.tblStyles.getValueAt(row, 5)).doubleValue();
                    Object o = e.getNewValue();
                    Double d = Double.parseDouble(o.equals("") ? "0.0" : o.toString());
                    if (d > PaTransferIn.this.tblStyles.getReqQty(row) - prevReceived) {
                        PaTransferIn.this.notifyOverReceipt();
                        e.setAllow(false);
                    }
                }
            }

            @Override
            public void tableChanged(TableModelEvent e) {
                PaTransferIn.this.update();
            }
        });
        TotalsTableModel totalsTableModel = new TotalsTableModel(this.tblStyles.getModel()){

            @Override
            public Object getValueAt(int row, int col) {
                if (row != 0) {
                    return "";
                }
                switch (col) {
                    case 0: {
                        return StoreParams.totalText;
                    }
                    case 4: {
                        return new PosDouble(PaTransferIn.this.tblStyles.getReqQty());
                    }
                    case 5: {
                        return new PosDouble(PaTransferIn.this.tblStyles.getOrigQty());
                    }
                    case 6: {
                        return new PosDouble(PaTransferIn.this.tblStyles.getQty() - PaTransferIn.this.tblStyles.getOrigQty());
                    }
                    case 7: {
                        return String.format("%.4f", Double.parseDouble(PaTransferIn.this.tblStyles.getTotalCost()));
                    }
                }
                return "";
            }
        };
        this.tblTotals = new TotalsTable(this.frParent, this.tblStyles, totalsTableModel);
        this.setLayout(this.gridBagLayout);
        this.tfBarcode.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaTransferIn.this.tfBarcode_focusGained(e);
            }
        });
        this.tfBarcode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaTransferIn.this.tfBarcode_actionPerformed(e);
            }
        });
        this.lFrom.setText(StoreParams.res.getString("Supplier"));
        this.tfWhse.setFieldWidth(200);
        this.tfSupplier.setFieldWidth(200);
        this.tfDock.setFieldWidth(120);
        this.tfDock.setHorizontalAlignment(4);
        this.tfDock.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaTransferIn.this.tfDock_focusGained(e);
            }
        });
        this.lFeedBack.setText(StoreParams.res.getString("Transfer"));
        this.lDock.setText(StoreParams.res.getString("Docket_"));
        this.add((Component)this.barcodeSearchPanel, new GridBagConstraints(0, 1, 2, 2, 1.0, 0.0, 16, 0, new Insets(0, 10, 10, 0), 0, 0));
        this.add((Component)this.tfDock, new GridBagConstraints(3, 1, 1, 1, 1.0, 0.0, 14, 0, new Insets(0, 8, 10, 8), 0, 0));
        this.add((Component)this.tfWhse, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.add((Component)this.supplierSearchPanel, new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 10, 10), 0, 0));
        this.add((Component)this.tblStyles.getScrollPane(), new GridBagConstraints(0, 3, 5, 1, 1.0, 1.0, 10, 1, new Insets(0, 10, 0, 10), 0, 0));
        this.add((Component)this.tblTotals.getScrollPane(), new GridBagConstraints(0, 4, 5, 1, 1.0, 0.0, 15, 1, new Insets(0, 10, 10, 10), 0, 0));
        this.add((Component)this.lFeedBack, new GridBagConstraints(0, 0, 3, 1, 0.0, 0.0, 16, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.lDock, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(5, 8, 0, 8), 0, 0));
        this.add((Component)this.lFrom, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 14, 0, new Insets(5, 0, 0, 10), 0, 0));
        this.add((Component)this.tfClr, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.tfSize, new GridBagConstraints(3, 3, 1, 1, 1.0, 0.0, 13, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.add((Component)this.lFeedBack2, new GridBagConstraints(0, 1, 5, 1, 0.0, 0.0, 17, 0, new Insets(0, 260, 10, 0), 0, 0));
        this.add((Component)this.tfTransSearch, new GridBagConstraints(2, 1, 1, 1, 3.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tfPurchOrderSearch, new GridBagConstraints(3, 1, 1, 1, 3.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.tfTransferOrderSearch, new GridBagConstraints(2, 1, 1, 1, 3.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.tfTransSearch.setVisible(false);
        this.tfPurchOrderSearch.setVisible(false);
        this.tfTransferOrderSearch.setVisible(false);
        this.tfClr.setVisible(false);
        this.tfSize.setVisible(false);
        this.tfTransSearch.setCache(this.sParams.cacher, this.sParams.iconn, 662L, "1089,1090,1091,1102", "", "H.\"ACTIVE\" = 1 AND NVL(H.TRANSFER_COMPLETE_FLAG, 0) = 0 AND H.TO_WIDX = " + this.sParams.getStoreIdx() + this.sParams.sWhseRefSecWhereWHSEStkReceipts);
        if (SystemSettings.getInstance().getBoolean(SystemSettings.SystemSetting.RECEIVING_PO_BY_ASN)) {
            this.tfPurchOrderSearch.setCache(this.sParams.cacher, this.sParams.iconn, 1510L, "15115", "", "P.WHSE = " + this.sParams.getStoreIdx());
        } else {
            this.tfPurchOrderSearch.setCache(this.sParams.cacher, this.sParams.iconn, 1082L, "10391", "", "P.WHSE = " + this.sParams.getStoreIdx());
        }
        this.tfTransferOrderSearch.setCache(this.sParams.cacher, this.sParams.iconn, 1474L, "14275,14281,14276", "", "AND H.TOTQ + H.totpack > 0 AND WH.WIDX = " + this.sParams.getStoreIdx());
        this.setFocusCycleRoot(true);
        Vector<Component> v = new Vector<Component>();
        v.add(this.tfBarcode);
        v.add(this.tfDock);
        v.add(this.tfWhse);
        v.add(this.tfSupplier);
        v.add(this.tblStyles);
        v.add(this.tfBarcode);
        v.add(this.frParent.paHead.signInButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
    }

    private void processBarcodeLater(final String barcode) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    PaTransferIn.this.processBarcode(barcode);
                    PaTransferIn.this.tfBarcode.setText("");
                }
                catch (BarcodeException be) {
                    PaTransferIn.this.tfBarcode.setText(be.getMessage());
                    PaTransferIn.this.tfBarcode.selectAll();
                }
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processBarcode(String barcode) throws BarcodeException {
        FrTransferIn frame = (FrTransferIn)this.frParent;
        if (barcode.length() > 50) {
            throw new BarcodeException(StoreParams.invalidBarcode);
        }
        if (!(this.frParent.transnum == null && this.frParent.transType != 248 && this.frParent.transType != 251 || barcode.isEmpty() || barcode.equals(StoreParams.invalidBarcode) || !PosUtils.isProductBarcode(barcode))) {
            try {
                Element sku;
                int i;
                String defBarcode = PosUtils.getDefaultBarcode(barcode);
                if (!defBarcode.isEmpty()) {
                    int linenum = this.tblStyles.addEAN(defBarcode);
                    if (linenum == -1) {
                        throw new BarcodeException(StoreParams.invalidBarcode);
                    }
                    if (linenum < -1) {
                        throw new BarcodeException(StoreParams.invalidBarcode);
                    }
                    if (!this.sParams.bRecptCost || !frame.getAdhoc()) return;
                    long supidx = this.tfSupplier.getidx();
                    if (supidx == -1L) {
                        supidx = 0L;
                    }
                    this.tblStyles.fetchCostingsFromOnline(linenum, supidx);
                    return;
                }
                if (barcode.length() != 20) throw new BarcodeException(StoreParams.res.getString("BarcodeInvalid"));
                if (this.frParent.transType != 250) {
                    throw new BarcodeException(StoreParams.invalidBarcode);
                }
                this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("carton", barcode).getXML();
                if (this.sParams.root == null) return;
                if (this.sParams.root.getChild("skus") == null) throw new BarcodeException(StoreParams.cartonContentInvalid);
                List skus = this.sParams.root.getChild("skus").getChildren();
                if (skus.size() <= 0) return;
                for (i = 0; i < skus.size(); ++i) {
                    sku = (Element)skus.get(i);
                    String trannum = "";
                    if (sku.getAttribute("trannum") != null) {
                        trannum = sku.getAttribute("trannum").getValue();
                    }
                    if (!trannum.equals(this.frParent.transnum)) {
                        Object[] objs = new Object[]{barcode};
                        throw new BarcodeException(StoreParams.cartonContentInvalid, MessageFormat.format(StoreParams.res.getString("CartonNotOnTrans"), objs));
                    }
                    if (sku.getAttribute("barcode") != null) continue;
                    Object[] objs = new Object[]{sku.getAttribute("desc").getValue()};
                    throw new BarcodeException(StoreParams.cartonContentInvalid, MessageFormat.format(StoreParams.res.getString("SkuWithoutBarcode"), objs));
                }
                for (i = 0; i < skus.size(); ++i) {
                    int qty;
                    sku = (Element)skus.get(i);
                    try {
                        qty = sku.getAttribute("qty").getIntValue();
                    }
                    catch (DataConversionException e) {
                        qty = 0;
                    }
                    defBarcode = PosUtils.getDefaultBarcode(sku.getAttribute("barcode").getValue());
                    while (qty > 0) {
                        int linenum = this.tblStyles.addEAN(defBarcode);
                        if (linenum == -1) {
                            throw new BarcodeException(StoreParams.invalidBarcode);
                        }
                        if (this.sParams.bRecptCost && frame.getAdhoc()) {
                            long supidx = this.tfSupplier.getidx();
                            this.tblStyles.fetchCostingsFromOnline(linenum, supidx);
                        }
                        --qty;
                    }
                }
                return;
            }
            catch (NumberFormatException n) {
                throw new BarcodeException(StoreParams.invalidBarcode);
            }
        }
        if (barcode.length() > 1 && (barcode.substring(0, 1).toUpperCase().equals("D") || barcode.substring(0, 1).toUpperCase().equals("P") || barcode.substring(0, 1).toUpperCase().equals("T") || barcode.substring(0, 1).toUpperCase().equals("C") || barcode.substring(0, 1).toUpperCase().equals("O"))) {
            Element transaction = this.findTransaction(barcode);
            if (transaction == null) {
                throw new BarcodeException(StoreParams.invalidBarcode);
            }
            if (this.populateTransaction(barcode, transaction)) return;
            this.frParent.voidTrans(false);
            throw new BarcodeException(StoreParams.invalidTrans);
        }
        if (this.frParent.transnum != null) throw new BarcodeException(StoreParams.invalidBarcode);
        throw new BarcodeException(StoreParams.noTrans);
    }

    protected void tfBarcode_actionPerformed(ActionEvent e) {
        this.frParent.setCursor(StoreParams.waitCursor);
        try {
            this.processBarcode(this.tfBarcode.getText());
            this.tfBarcode.setText("");
            this.tfBarcode.selectAll();
            this.tfBarcode.requestFocus();
        }
        catch (BarcodeException be) {
            if (be.getErrorDetail() != null) {
                DlgMessage.showMessage(this.frParent, be.getErrorDetail(), StoreParams.res.getString("Stop"), 0);
            }
            this.tfBarcode.setText(be.getMessage());
            this.tfBarcode.selectAll();
            this.tfBarcode.requestFocus();
        }
        this.frParent.setCursor(StoreParams.normalCursor);
    }

    protected void delLines() {
        int[] rows = this.tblStyles.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            if (this.tblStyles.getOrigQty(rows[i]) == 0.0) {
                this.tblStyles.delLine(rows[i], false, true);
                continue;
            }
            this.tblStyles.setRowSelectionInterval(rows[i], rows[i]);
            Object[] objs = new Object[]{"\n"};
            DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("This_line_has_already"), objs));
        }
    }

    private Element findTransaction(String number) {
        Element transaction = null;
        try {
            if (number == null || number.length() < 2) {
                return null;
            }
            if (number.substring(0, 1).toUpperCase().equals("D")) {
                if (number.length() != 12) {
                    return null;
                }
                transaction = this.sParams.OnlineQueryProvider.getOnlineQuery("trans", number.substring(1) + "\u0003" + 4).getXML();
                if (transaction == null) {
                    return null;
                }
                if (XMLUtils.getLongValue(transaction, "tr_type") != 249L) {
                    return null;
                }
                boolean bFound = false;
                long nTmpWidx = XMLUtils.getLongValue(transaction, "widx");
                for (int i = 0; i < this.transferInStores.size(); ++i) {
                    if (this.transferInStores.elementAt(i).getWidx() != nTmpWidx) continue;
                    bFound = true;
                    break;
                }
                if (!bFound) {
                    return null;
                }
            } else if (number.substring(0, 1).toUpperCase().equals("P")) {
                transaction = this.sParams.OnlineQueryProvider.getOnlineQuery("porder", number.substring(1)).getXML();
            } else if (number.substring(0, 1).toUpperCase().equals("T") || number.substring(0, 1).toUpperCase().equals("C")) {
                transaction = this.sParams.OnlineQueryProvider.getOnlineQuery("transfer", number + "," + this.sParams.getStoreIdx()).getXML();
            } else if (number.substring(0, 1).toUpperCase().equals("O")) {
                transaction = this.sParams.OnlineQueryProvider.getOnlineQuery("transferorder", number.substring(1) + "," + this.sParams.getStoreIdx()).getXML();
            }
            if (transaction != null && transaction.getAttribute("widx") == null) {
                transaction = null;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            transaction = null;
        }
        return transaction;
    }

    private boolean populateTransaction(String number, Element transaction) {
        this.frParent.voidTrans(false);
        ((PaTransferFoot)this.frParent.paFoot).bDirect.setEnabled(false);
        try {
            Element root;
            ((FrTransferIn)this.frParent).transRoot = root = (Element)transaction.clone();
            if (root.getAttribute("widx") == null) {
                return false;
            }
            if (root.getAttribute("transfer_complete_flag") != null) {
                int nCompleteFlag = root.getAttribute("transfer_complete_flag").getIntValue();
                if (nCompleteFlag == 3) {
                    Object[] objs = new Object[]{"\n"};
                    DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("transfer_cancelled"), objs), StoreParams.res.getString("Error"), 0);
                    return false;
                }
                if (nCompleteFlag > 0) {
                    Object[] objs = new Object[]{"\n"};
                    DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("transfer_complete"), objs), StoreParams.res.getString("Stop"), 0);
                    return false;
                }
            }
            if (!this.isDataUpToDate(root)) {
                DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("transfer_not_up_to_date"), "\n", "\n"), StoreParams.res.getString("Error"), 0);
                this.frParent.voidTrans(false);
                return true;
            }
            if (root.getAttribute("to_widx") == null || root.getAttribute("to_widx").getLongValue() != this.sParams.getStoreIdx()) {
                Object[] objs = new Object[]{"\n"};
                String msg = MessageFormat.format(StoreParams.res.getString("This_transfer_has"), objs);
                DlgMessage.showMessage(this.frParent, msg, StoreParams.res.getString("Stop"), 2);
                this.frParent.voidTrans(false);
                return true;
            }
            String connote = "";
            if (root.getAttribute("connum") != null) {
                connote = StringUtils.nullToEmpty(root.getAttribute("connum").getValue());
                this.lFeedBack2.setText(SP.getRS("ConNote_X", connote));
            }
            if (root.getAttribute("carrier") != null) {
                ((FrTransferIn)this.frParent).carrier = new Carrier(root.getAttribute("carrier").getLongValue());
                if (!StringUtils.isNullOrEmpty(((FrTransferIn)this.frParent).carrier.getUrl())) {
                    this.lFeedBack2.setLink(((FrTransferIn)this.frParent).carrier.getUrl(connote));
                }
            }
            if (!this.tblStyles.populate(root)) {
                Object[] objs = new Object[]{"\n"};
                DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("There_was_an_error"), objs), StoreParams.res.getString("Invalid"), 0);
                return false;
            }
            if (!StringUtils.isNullOrEmpty(number) && number.substring(0, 1).toUpperCase().equals("O")) {
                this.frParent.setTransnum(root.getAttribute("trans_number").getValue());
                this.frParent.setTransType(1);
                this.tfWhse.clear();
                if (root.getAttribute("widx") != null) {
                    Store store = this.getTransferInStore(root.getAttribute("widx").getLongValue());
                    if (store != null) {
                        this.tfWhse.setAll(store.getWidx(), store.getCode(), store.getName());
                    } else {
                        this.tfWhse.clear();
                    }
                }
            } else if (StringUtils.isNullOrEmpty(number) || !number.substring(0, 1).toUpperCase().equals("P")) {
                this.frParent.setTransnum(root.getAttribute("trans_number").getValue());
                this.frParent.setTransType(250);
                this.tfWhse.clear();
                if (root.getAttribute("widx") != null) {
                    Store store = this.getTransferInStore(root.getAttribute("widx").getLongValue());
                    if (store != null) {
                        this.tfWhse.setAll(store.getWidx(), store.getCode(), store.getName());
                    } else {
                        this.tfWhse.clear();
                    }
                }
                this.db_populateQty(root.getAttribute("trans_number").getValue(), null);
            } else {
                ((FrTransferIn)this.frParent).pordidx = root.getAttribute("pordidx").getLongValue();
                this.frParent.setTransType(251);
                this.tfSupplier.clear();
                if (root.getAttribute("widx") != null) {
                    boolean bFound = false;
                    for (int j = 0; j < this.suppliers.size(); ++j) {
                        if (this.suppliers.elementAt(j).getIdx() != root.getAttribute("widx").getLongValue()) continue;
                        this.tfSupplier.setAll(this.suppliers.elementAt(j).getIdx(), this.suppliers.elementAt(j).getCode(), this.suppliers.elementAt(j).getName());
                        bFound = true;
                        break;
                    }
                    if (!bFound) {
                        Object[] objs = new Object[]{"\n"};
                        DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("Unable_retrieve_no_supplier_sec"), objs), StoreParams.res.getString("Error"), 0);
                        return false;
                    }
                }
            }
            this.update();
            if (this.tblStyles.getReqQty() == 0.0) {
                Object[] objs = new Object[]{"\n"};
                DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("There_are_no_qtys_on"), objs));
                return false;
            }
            if (this.frParent.transType == 251 || this.frParent.transType == 250) {
                String transNum;
                String uniqueLockId = transNum = root.getAttribute("trans_number").getValue();
                if (this.frParent.transType == 250) {
                    uniqueLockId = root.getAttribute("widx").getValue() + "-" + uniqueLockId;
                }
                if (!this.frParent.lockTransaction(uniqueLockId, transNum, this.frParent.transType)) {
                    this.frParent.voidTrans(false);
                    return true;
                }
                if (!this.isDataUpToDate(root)) {
                    DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("transfer_not_up_to_date"), "\n", "\n"), StoreParams.res.getString("Error"), 0);
                    this.frParent.voidTrans(false);
                    return true;
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
        return true;
    }

    protected void update() {
        ((FrTransferIn)this.frParent).setButtons();
    }

    protected void db_populateQty(String num, String vhidx) {
        String from_widx = this.frParent.transType == 250 && this.tfWhse.getidx() > 0L ? String.valueOf(this.tfWhse.getidx()) : "";
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "SELECT H.TRANS_NUMBER, H.DOCKET_NUMBER, D.SKUIDX, D.QTY FROM RET_TRANH H, RET_TRAND D, STYLE S, CLR C, SKU K WHERE H.VHIDX = D.VHIDX AND H.TR_TYPE = " + this.frParent.transType + " AND D.SKUIDX = K.SKUIDX AND K.CLRIDX = C.CLRIDX AND C.STYLEIDX = S.STYLEIDX " + " AND H.TRANS_NUMBER = " + PosUtils.StringToSqlString(num) + (vhidx != null ? " AND H.VHIDX < " + vhidx : "") + (!from_widx.equals("") ? " AND H.FROM_WIDX = " + from_widx : "") + " ORDER BY S.STYLECODE, C.CLRCODE, K.SIZESEQ ");){
            while (sql.next()) {
                int row = this.tblStyles.addSku(sql.getLong(3), 0.0, true, true);
                this.tblStyles.addSku(sql.getLong(3), sql.getDouble(4), true, true);
                this.tblStyles.setOrigQty(row, sql.getDouble(4) + this.tblStyles.getOrigQty(row));
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    protected void setFromField(int type) {
        if (type == 251 || type == 248) {
            this.tfSupplier.setVisible(true);
            this.tfWhse.setVisible(false);
            this.lFrom.setText(StoreParams.res.getString("Supplier"));
        } else {
            this.tfSupplier.setVisible(false);
            this.tfWhse.setVisible(true);
            this.lFrom.setText(StoreParams.res.getString("From"));
        }
    }

    void tfBarcode_focusGained(FocusEvent e) {
        this.tfBarcode.selectAll();
        this.frParent.setStatusMsg(StatusBar.status_EANTransferIn);
    }

    void tfDock_focusGained(FocusEvent e) {
        this.frParent.setStatusMsg(StoreParams.res.getString("enter_docket"));
    }

    protected void receiptAll() {
        if (this.tblStyles.isEditing()) {
            this.tblStyles.getCellEditor().stopCellEditing();
        }
        for (int i = 0; i < this.tblStyles.getRowCount(); ++i) {
            double prevReceived;
            double required = ((PosDouble)this.tblStyles.getValueAt(i, 4)).doubleValue();
            if (required - (prevReceived = ((PosDouble)this.tblStyles.getValueAt(i, 5)).doubleValue()) < 0.0) {
                this.tblStyles.setValueAt(new PosDouble(0.0), i, 6);
                continue;
            }
            this.tblStyles.setValueAt(new PosDouble(required - prevReceived), i, 6);
        }
    }

    public Store getTransferInStore(long widx) {
        for (int i = 0; i < this.transferInStores.size(); ++i) {
            if (this.transferInStores.elementAt(i).getWidx() != widx) continue;
            return this.transferInStores.elementAt(i);
        }
        return null;
    }

    private boolean isDataUpToDate(Element transaction) {
        String transactionNumber;
        Timestamp localLastRecDate;
        PosDateFormatter headOfficeLastRecDate = new PosDateFormatter(null, 3, 3, 2);
        if (transaction.getAttribute("last_received_date") != null) {
            try {
                headOfficeLastRecDate.setTimestampInternal(transaction.getAttribute("last_received_date").getValue());
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        boolean isPurchaseOrder = transaction.getName().equals("porder");
        long fromWarehouse = 0L;
        if (!isPurchaseOrder && transaction.getAttribute("widx") != null) {
            try {
                fromWarehouse = transaction.getAttribute("widx").getLongValue();
            }
            catch (DataConversionException e) {
                // empty catch block
            }
        }
        if ((localLastRecDate = this.getLastReceiveDate(transactionNumber = isPurchaseOrder ? transaction.getAttributeValue("pordidx") : transaction.getAttributeValue("trans_number"), fromWarehouse, isPurchaseOrder)) == null) {
            return true;
        }
        return headOfficeLastRecDate.getTimestamp() != null && localLastRecDate.getTime() <= headOfficeLastRecDate.getTimestamp().getTime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Timestamp getLastReceiveDate(String transactionNumber, long fromWarehouse, boolean isPurchaseOrder) {
        PreparedStatement stmt = null;
        try {
            if (!isPurchaseOrder) {
                stmt = this.sParams.conn.prepareStatement("SELECT MAX(H.TRAND) AS TRAND FROM RET_TRANH H WHERE H.TR_TYPE = 250 AND H.TRANS_NUMBER = ? AND H.FROM_WIDX = ? AND H.\"ACTIVE\" = 1");
                stmt.setString(1, transactionNumber);
                stmt.setLong(2, fromWarehouse);
            } else {
                stmt = this.sParams.conn.prepareStatement("SELECT MAX(H.TRAND) AS TRAND FROM RET_TRANH H WHERE H.TR_TYPE = 251 AND H.PORDIDX = ? AND H.\"ACTIVE\" = 1");
                stmt.setString(1, transactionNumber);
            }
            try (ResultSet result = stmt.executeQuery();){
                if (result.next()) {
                    Timestamp time = result.getTimestamp("trand");
                    if (time != null) {
                        time.setTime(time.getTime() / 1000L * 1000L);
                    }
                    Timestamp timestamp = time;
                    PosUtils.closeStatement(stmt);
                    return timestamp;
                }
            }
            PosUtils.closeStatement(stmt);
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        finally {
            PosUtils.closeStatement(stmt);
        }
        return null;
    }

    public String changeCostByLines(StyleTable table, StringBuffer assocChangeType) {
        String newCost = "00.0000";
        DlgCosting costDlg = new DlgCosting(this.frParent);
        costDlg.setVisible(true);
        newCost = costDlg.cost;
        costDlg = null;
        return newCost;
    }

    public void changeCost() {
        if (this.tblStyles.getRowCount() > 0 && this.dlgCost == null) {
            boolean disableSelected = false;
            String cost = "00.0000";
            boolean canceled = false;
            if (this.tblStyles.isEditing()) {
                this.tblStyles.getCellEditor().stopCellEditing();
            }
            StringBuffer costChangeType = new StringBuffer();
            int styleCnt = 0;
            for (int i = 0; i < this.tblStyles.getRowCount(); ++i) {
                if (!(this.tblStyles.getItemAt(i) instanceof StyleLine)) continue;
                ++styleCnt;
            }
            boolean productSelected = false;
            int[] listRows = this.tblStyles.getSelectedRows();
            for (int i = 0; i < listRows.length; ++i) {
                if (!(this.tblStyles.getItemAt(listRows[i]) instanceof StyleLine)) continue;
                productSelected = true;
                break;
            }
            if (!productSelected) {
                disableSelected = true;
            }
            if (styleCnt > 1) {
                this.dlgCost = new CostByLine(this.frParent, true, costChangeType);
                if (disableSelected) {
                    this.dlgCost.bSelected.setEnabled(false);
                }
                this.dlgCost.setVisible(true);
                if (this.dlgCost.canceled) {
                    canceled = true;
                }
                this.dlgCost = null;
            } else if (disableSelected) {
                costChangeType.append("all");
            } else {
                costChangeType.append("selected");
            }
            if (canceled) {
                return;
            }
            cost = this.changeCostByLines(this.tblStyles, costChangeType);
            if (Double.valueOf(cost) == 0.0) {
                return;
            }
            Vector<StyleLine> styleLines = new Vector<StyleLine>();
            if (costChangeType.toString().equals("selected")) {
                int[] selRows = this.tblStyles.getSelectedRows();
                if (selRows.length == 0 && this.tblStyles.getRowCount() > 0) {
                    if (this.tblStyles.getItemAt(0) instanceof StyleLine) {
                        this.tblStyles.setCosting(0, cost, false);
                        this.tblStyles.model.fireTableCellUpdated(0, 7);
                    }
                } else {
                    for (int i = 0; i < selRows.length; ++i) {
                        if (!(this.tblStyles.getItemAt(selRows[i]) instanceof StyleLine)) continue;
                        this.tblStyles.setCosting(selRows[i], cost, false);
                        this.tblStyles.model.fireTableCellUpdated(selRows[i], 7);
                    }
                }
            } else if (costChangeType.toString().equals("all")) {
                for (int i = 0; i < this.tblStyles.getRowCount(); ++i) {
                    if (!(this.tblStyles.getItemAt(i) instanceof StyleLine)) continue;
                    styleLines.add((StyleLine)this.tblStyles.getItemAt(i));
                    this.tblStyles.setCosting(i, cost, false);
                    this.tblStyles.model.fireTableCellUpdated(i, 7);
                }
            } else {
                return;
            }
        }
    }

    public void processBarcodes(Vector<String> vBarcodes) {
        this.frParent.setCursor(StoreParams.waitCursor);
        for (int i = 0; i < vBarcodes.size(); ++i) {
            String barcode = vBarcodes.elementAt(i);
            try {
                if (barcode.indexOf(",") > 0) {
                    barcode = barcode.substring(0, barcode.indexOf(","));
                }
                this.processBarcode(barcode);
                continue;
            }
            catch (BarcodeException e) {
                Object[] objs = new Object[]{e.getMessage() + " " + barcode, "\n"};
                if (DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("ContinueProceed"), objs), StoreParams.res.getString("Continue_"), 0, 3) == 1) break;
            }
        }
        this.tfBarcode.setText("");
        this.tfBarcode.selectAll();
        this.tfBarcode.requestFocus();
        this.frParent.setCursor(StoreParams.normalCursor);
    }

    public void updateProductCosts() {
        Element result;
        if (this.supIdx == -1L) {
            this.supIdx = 0L;
        }
        Vector<StyleLine> searchedLines = new Vector<StyleLine>();
        long widx = this.sParams.getStoreIdx();
        String skuString = "";
        for (StyleLine line : this.tblStyles.getStyleLines()) {
            if (!line.getDefault()) continue;
            skuString = skuString + line.getSkuidx() + ",";
            searchedLines.add(line);
        }
        if (!skuString.isEmpty() && skuString.charAt(skuString.length() - 1) == ',') {
            skuString = skuString.substring(0, skuString.length() - 1);
        }
        if (SP.sParams.checkIConn() && skuString != "" && (result = SP.sParams.OnlineQueryProvider.getOnlineQuery("get_costs", Long.toString(this.supIdx) + "," + Long.toString(widx) + "," + skuString).getXML()) != null) {
            List Costs = result.getChildren();
            for (Object cost : Costs) {
                Element tempEle = (Element)cost;
                if (tempEle == null || tempEle.getAttribute("cost") == null) continue;
                double newCost = Double.parseDouble(tempEle.getAttributeValue("cost"));
                if (tempEle.getAttribute("sku") == null) continue;
                try {
                    long skuToCompare = tempEle.getAttribute("sku").getLongValue();
                    for (StyleLine line : searchedLines) {
                        if (line.getSkuidx() != skuToCompare) continue;
                        line.setCosting(String.valueOf(newCost), true);
                        break;
                    }
                    this.tblStyles.model.fireTableDataChanged();
                }
                catch (Exception e) {}
            }
        }
    }

    class BarcodeException
    extends Exception {
        String errDetail;

        public BarcodeException(String barcodeErr) {
            super(barcodeErr);
        }

        public BarcodeException(String barcodeErr, String errDetail) {
            super(barcodeErr);
            this.errDetail = errDetail;
        }

        public BarcodeException() {
            super("Unknown barcode");
        }

        public String getErrorDetail() {
            return this.errDetail;
        }
    }
}

