/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import jpos.DecimalField;
import jpos.MLengthTextArea;
import jpos.PaPCFoot;
import jpos.PosFrame;
import jpos.PosScrollPane;
import jpos.PosUtils;
import jpos.StatusBar;
import jpos.StoreParams;
import jpos.pay.PayType;
import jpos.pay.PayTypes;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchTextField;

public class PaWithDrawal
extends JPanel {
    private GridBagLayout gridBagLayout = new GridBagLayout();
    protected DecimalField tfAmt;
    protected MLengthTextArea tpNotes = new MLengthTextArea(250);
    private LabelSubHeading lAmt = new LabelSubHeading();
    private LabelSubHeading lNotes = new LabelSubHeading();
    private LabelSubHeading lSpace = new LabelSubHeading();
    private PosScrollPane scrollPane = new PosScrollPane();
    public PayType payType;
    private StoreParams sParams;
    private LabelSubHeading lSpace2 = new LabelSubHeading();
    protected LabelSubHeading lFeedBack = new LabelSubHeading();

    public PaWithDrawal(StoreParams psParams) {
        try {
            this.sParams = psParams;
            this.jbInit();
        }
        catch (Exception ex) {
            PosUtils.logError(ex);
        }
    }

    private void jbInit() throws Exception {
        this.payType = PayTypes.cashPayType;
        this.setLayout(this.gridBagLayout);
        this.tfAmt = new DecimalField(this.sParams.storeCurrency, TouchTextField.FontSize.LARGE);
        this.tpNotes.setBorder(BorderFactory.createEtchedBorder());
        this.tpNotes.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaWithDrawal.this.tpNotes_focusGained(e);
            }
        });
        this.lAmt.setHorizontalAlignment(2);
        this.lAmt.setText(StoreParams.res.getString("Total_Amount"));
        this.tfAmt.setFieldWidth(200);
        this.tfAmt.setHorizontalAlignment(2);
        this.tfAmt.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                PaWithDrawal.this.tfAmt_focusGained(e);
            }

            @Override
            public void focusLost(FocusEvent e) {
                double amountRnd = PaWithDrawal.this.payType.roundAmt(PaWithDrawal.this.tfAmt.getDouble());
                if (amountRnd != PaWithDrawal.this.tfAmt.getDouble()) {
                    PaWithDrawal.this.tfAmt.setText(amountRnd);
                }
            }
        });
        this.tfAmt.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ((PaPCFoot)((PosFrame)PaWithDrawal.this.getTopLevelAncestor()).paFoot).bComplete.requestFocus();
                }
            }
        });
        this.lNotes.setText(StoreParams.res.getString("Notes"));
        this.scrollPane.setPreferredSize(new Dimension(400, 400));
        this.add((Component)this.tfAmt, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(0, 20, 0, 10), 0, 0));
        this.add((Component)this.lAmt, new GridBagConstraints(1, 0, 3, 1, 0.0, 0.0, 18, 0, new Insets(10, 20, 0, 0), 0, 0));
        this.add((Component)this.lSpace, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lSpace2, new GridBagConstraints(4, 3, 1, 1, 1.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.lFeedBack, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    void tfAmt_focusGained(FocusEvent e) {
        ((PosFrame)this.getTopLevelAncestor()).setStatusMsg(StatusBar.status_WithdrawalAmount);
    }

    void tpNotes_focusGained(FocusEvent e) {
        ((PosFrame)this.getTopLevelAncestor()).setStatusMsg(StatusBar.status_Notes);
    }
}

