/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Robot;
import java.awt.Window;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.FocusManager;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import jpos.DecimalField;
import jpos.PosCellEditor;
import jpos.PosDialog;
import jpos.PosDouble;
import jpos.PosFrame;
import jpos.PosRenderer;
import jpos.PosScrollPane;
import jpos.PosTableListener;
import jpos.PosTableModelEvent;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.StringField;
import jpos.XPTableHeaderRenderer;
import jpos.ui.TableCellCheckbox;
import jpos.ui.TouchTable;

public class PosTable
extends TouchTable {
    private PosScrollPane scrollPane = null;
    public PosCellEditor stringEd;
    public PosCellEditor currEd;
    public PosCellEditor extendedTaxEd;
    public PosCellEditor qtyEd;
    StringField stringField;
    private boolean bInLastEditableField = false;
    private boolean bStopRobotTab;
    Component cThis = this;
    protected EventListenerList posTableListeners = new EventListenerList();
    public PosRenderer renderer = new PosRenderer(this){

        @Override
        public Color getCellForegroundAt(Object value, int viewRow, int column) {
            return PosTable.this.getDisplayForegroundAt(value, viewRow, column);
        }

        @Override
        public Font getCellFontAt(Object value, int row, int column) {
            return PosTable.this.getDisplayFontAt(value, row, column);
        }
    };
    public XPTableHeaderRenderer headerLeftRen = new XPTableHeaderRenderer(this.getTableHeader(), 2);
    public XPTableHeaderRenderer headerRightRen = new XPTableHeaderRenderer(this.getTableHeader(), 4);
    public XPTableHeaderRenderer headerCenterRen = new XPTableHeaderRenderer(this.getTableHeader(), 0);
    StoreParams sParams;
    private Window parentWindow = null;

    public PosTable(Window pParent, AbstractTableModel pModel) {
        super(pModel);
        this.parentWindow = pParent;
        this.sParams = SP.sParams;
        this.init();
    }

    private void setLastAction() {
        if (this.parentWindow instanceof PosFrame) {
            ((PosFrame)this.parentWindow).setLastAction();
        } else if (this.parentWindow instanceof PosDialog) {
            ((PosDialog)this.parentWindow).setLastAction();
        }
    }

    private void init() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                PosTable.this.setLastAction();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PosTable.this.setLastAction();
            }
        });
        this.setScrollPane(new PosScrollPane());
        this.getTableHeader().setReorderingAllowed(false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (!PosTable.this.isEditing()) {
                    PosTable.this.cellEdit(PosTable.this.getSelectedRow(), PosTable.this.getSelectedColumn());
                }
                if (!(PosTable.this.bStopRobotTab || PosTable.this.getSelectedRow() <= -1 || PosTable.this.getSelectedColumn() != 0 || PosTable.this.getRowCount() <= 0 || PosTable.this.isCellEditable(PosTable.this.getSelectedRow(), PosTable.this.getSelectedColumn()) || e.getOppositeComponent() == null || e.getOppositeComponent().getClass().getName().startsWith("jpos.StyleTable") || e.getOppositeComponent().getClass().getName().startsWith("jpos.PosTable") || e.getOppositeComponent().getClass().getName().startsWith("jpos.PaEndOfDay") || !PosTable.this.isAnyCellEditable())) {
                    try {
                        Robot rob = new Robot();
                        rob.keyPress(9);
                    }
                    catch (Exception ex) {
                        PosUtils.logError(ex);
                    }
                }
                if (PosTable.this.getSelectedRow() > -1 && PosTable.this.getSelectedColumn() > -1 && PosTable.this.isCellEditable(PosTable.this.getSelectedRow(), PosTable.this.getSelectedColumn()) && PosTable.this.getSelectedRow() == PosTable.this.getRowCount() - 1 && PosTable.this.getSelectedColumn() == PosTable.this.getColumnCount() - 1) {
                    PosTable.this.bInLastEditableField = true;
                } else {
                    PosTable.this.bInLastEditableField = false;
                }
                PosTable.this.stopRobotTab(false);
            }

            @Override
            public void focusLost(FocusEvent e) {
                if (PosTable.this.isEditing() && e.isTemporary()) {
                    PosTable.this.getCellEditor().stopCellEditing();
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 9) {
                    PosTable.this.tabPressed(e);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() == 9 && PosTable.this.getRowCount() == 0) {
                    PosTable.this.tabPressed(e);
                }
            }
        });
        this.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    PosTable.this.cellEdit(PosTable.this.getSelectedRow(), PosTable.this.getSelectedColumn());
                }
            }
        });
        this.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    PosTable.this.cellEdit(PosTable.this.getSelectedRow(), PosTable.this.getSelectedColumn());
                }
            }
        });
        this.setAutoResizeMode(4);
        DecimalField decimalField = new DecimalField(this.sParams.storeCurrency){

            @Override
            public void processKeyEvent(KeyEvent e) {
                super.processKeyEvent(e);
                if (e.getID() == 401 && e.getKeyCode() == 9) {
                    PosTable.this.tabPressed(e);
                }
            }
        };
        this.currEd = new PosCellEditor(decimalField);
        this.currEd.setClickCountToStart(1);
        DecimalField extendedTaxField = new DecimalField(StoreParams.extendedTaxFormat, 4){

            @Override
            public void processKeyEvent(KeyEvent e) {
                super.processKeyEvent(e);
                if (e.getID() == 401 && e.getKeyCode() == 9) {
                    PosTable.this.tabPressed(e);
                }
            }
        };
        this.extendedTaxEd = new PosCellEditor(extendedTaxField);
        this.extendedTaxEd.setClickCountToStart(1);
        DecimalField qtyField = new DecimalField(StoreParams.qtyFormat, 4){

            @Override
            public void processKeyEvent(KeyEvent e) {
                super.processKeyEvent(e);
                if (e.getID() == 401 && e.getKeyCode() == 9) {
                    PosTable.this.tabPressed(e);
                }
            }
        };
        qtyField.setHorizontalAlignment(0);
        this.qtyEd = new PosCellEditor(qtyField);
        this.qtyEd.setClickCountToStart(1);
        this.setDefaultEditor(PosDouble.class, this.qtyEd);
        this.stringField = new StringField(){

            @Override
            public void processKeyEvent(KeyEvent e) {
                super.processKeyEvent(e);
                if (e.getID() == 401 && e.getKeyCode() == 9) {
                    PosTable.this.tabPressed(e);
                }
            }
        };
        this.stringEd = new PosCellEditor(this.stringField);
        this.stringEd.setClickCountToStart(1);
        this.setDefaultEditor(String.class, this.stringEd);
        this.setDefaultRenderer(Object.class, this.renderer);
        this.setDefaultEditor(Boolean.class, new PosCellEditor(new TableCellCheckbox()));
        this.setDefaultRenderer(Boolean.class, new TableCellCheckbox());
        this.renderer.setPrintZero(false);
        this.setRowSelectionAllowed(true);
    }

    public void setScrollPane(PosScrollPane scrollPane) {
        this.scrollPane = scrollPane;
        scrollPane.getViewport().add((Component)this, null);
    }

    protected void cellEdit(int viewRow, int col) {
        Component ed;
        if (viewRow < this.getRowCount() && col < this.getColumnCount() && viewRow >= 0 && col >= 0 && this.editCellAt(viewRow, col) && (ed = this.getEditorComponent()) != null) {
            ed.requestFocus();
        }
    }

    public void addTableModelListener(TableModelListener listener) {
        if (listener instanceof PosTableListener) {
            this.posTableListeners.add(PosTableListener.class, (PosTableListener)listener);
        }
        this.getModel().addTableModelListener(listener);
    }

    public Object fireTableValueChangingEvent(Object aValue, int viewRow, int column) throws Exception {
        Object[] listeners = this.posTableListeners.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            PosTableModelEvent event = new PosTableModelEvent(this.dataModel, this.convertRowIndexToModel(viewRow), column, aValue);
            ((PosTableListener)listeners[i + 1]).tableValueChanging(event);
            if (!event.getAllow()) {
                throw new Exception("Not Allowed");
            }
            if (!event.getHasChanged()) continue;
            return event.getNewValue();
        }
        return aValue;
    }

    @Override
    public void setValueAt(Object aValue, int viewRow, int column) {
        if (this.getCellEditor() instanceof PosCellEditor) {
            try {
                aValue = this.fireTableValueChangingEvent(aValue, viewRow, column);
            }
            catch (Exception e) {
                ((PosCellEditor)this.getCellEditor()).setAbortStopCellEditing(true);
                return;
            }
        }
        super.setValueAt(aValue, viewRow, column);
    }

    public Color getDisplayForegroundAt(Object value, int viewRow, int column) {
        return this.renderer.defaultColour;
    }

    public Font getDisplayFontAt(Object value, int row, int column) {
        return this.renderer.getFont();
    }

    protected void tabPressed(KeyEvent e) {
        boolean bFocusGone = false;
        e.consume();
        int row = this.getSelectedRow();
        int col = this.getSelectedColumn();
        if (!this.isAnyCellEditable()) {
            if (e.isShiftDown()) {
                FocusManager.getCurrentManager().focusPreviousComponent(this);
            } else {
                FocusManager.getCurrentManager().focusNextComponent(this);
            }
            return;
        }
        if (e.isShiftDown()) {
            if (row < 0 || row == 0 && col == 0) {
                if (this.isEditing()) {
                    this.getCellEditor().stopCellEditing();
                }
                this.setColumnSelectionInterval(0, 0);
                FocusManager.getCurrentManager().focusPreviousComponent(this);
                bFocusGone = true;
            } else if (col > 0) {
                if (!this.isCellEditable(row, col)) {
                    this.setColumnSelectionInterval(col - 1, col - 1);
                }
            } else {
                if (row > 0) {
                    this.setRowSelectionInterval(row - 1, row - 1);
                }
                this.setColumnSelectionInterval(this.getColumnCount() - 1, this.getColumnCount() - 1);
            }
        } else if (row < 0 || row == this.getRowCount() - 1 && col == this.getColumnCount() - 1 && !this.isCellEditable(row, col) || this.bInLastEditableField) {
            if (this.isEditing()) {
                this.getCellEditor().stopCellEditing();
            }
            if (this.bInLastEditableField) {
                this.setRowSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
                this.setColumnSelectionInterval(0, 0);
                this.bInLastEditableField = false;
            } else {
                this.setColumnSelectionInterval(0, 0);
            }
            for (int selectedRow = this.getSelectedRow(); selectedRow >= 0; --selectedRow) {
                if (!this.isRowEditable(selectedRow)) continue;
                this.setRowSelectionInterval(selectedRow, selectedRow);
                break;
            }
            FocusManager.getCurrentManager().focusNextComponent(this);
            bFocusGone = true;
        } else if (col < this.getColumnCount() - 1 || col < this.getColumnCount() && this.isCellEditable(row, col)) {
            if (!this.isCellEditable(row, col)) {
                this.setColumnSelectionInterval(col + 1, col + 1);
            }
        } else {
            if (row + 1 < this.getRowCount()) {
                this.setRowSelectionInterval(row + 1, row + 1);
            } else {
                this.setRowSelectionInterval(this.getRowCount() - 1, this.getRowCount() - 1);
            }
            this.setColumnSelectionInterval(0, 0);
        }
        if (!bFocusGone && !this.isCellEditable(row = this.getSelectedRow(), col = this.getSelectedColumn())) {
            this.tabPressed(e);
        }
    }

    public boolean isAnyCellEditable() {
        for (int i = 0; i < this.getRowCount(); ++i) {
            for (int j = 0; j < this.getColumnCount(); ++j) {
                if (!this.isCellEditable(i, j)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRowEditable(int viewRow) {
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.isCellEditable(viewRow, i)) continue;
            return true;
        }
        return false;
    }

    public void selectFirstRow() {
        if (this.getRowCount() > 0) {
            this.setRowSelectionInterval(0, 0);
        }
        if (this.getColumnCount() > 0) {
            this.setColumnSelectionInterval(0, 0);
        }
    }

    public void selectRow(int viewRow) {
        if (viewRow > -1 && this.getRowCount() > viewRow) {
            this.setRowSelectionInterval(viewRow, viewRow);
            if (this.getColumnCount() > 0) {
                this.setColumnSelectionInterval(0, 0);
            }
        }
    }

    public void setRowSelectionIntervalLater(final int startRow, final int endRow) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PosTable.this.setRowSelectionInterval(startRow, endRow);
            }
        });
    }

    public void stopRobotTab(boolean bpStopRobotTab) {
        this.bStopRobotTab = bpStopRobotTab;
    }

    public Window getParentWindow() {
        return this.parentWindow;
    }

    public PosScrollPane getScrollPane() {
        return this.scrollPane;
    }
}

