/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import ReceiptPrinter.Receipt;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.List;
import jpos.DlgMessage;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import org.jdom.Element;

public class SpecialOrderReceiptProcessor {
    public static Element loadSpecialOrderFromPurchaseOrder(long pordidx) {
        Element specialOrder = null;
        if (pordidx > -1L) {
            SP.sParams.root = SP.sParams.OnlineQueryProvider.getOnlineQuery("specordp", "" + pordidx).getXML();
            if (SP.sParams.root != null) {
                try {
                    specialOrder = SP.sParams.root;
                    SP.sParams.root = null;
                }
                catch (Exception ex) {
                    PosUtils.logError(ex);
                }
            }
        }
        return specialOrder;
    }

    public static void printSpecialOrder(PosFrame parent, Element specialOrder) {
        if (specialOrder != null && specialOrder.getAttribute("vhidx") != null) {
            boolean bPrinted = false;
            long vhidx = 0L;
            Element lastTrans = null;
            try {
                List subtrans = specialOrder.getChildren("subtrans");
                lastTrans = (Element)subtrans.get(subtrans.size() - 1);
                if (lastTrans.getAttribute("widx") != null && PosUtils.longVal(lastTrans.getAttribute("widx").getValue()) == SP.sParams.getStoreIdx()) {
                    try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT VHIDX FROM RET_TRANH WHERE DOCKET_NUMBER = ?");){
                        stmt.setString(1, lastTrans.getAttribute("docket_number").getValue());
                        try (ResultSet result = stmt.executeQuery();){
                            if (result.next()) {
                                vhidx = result.getLong(1);
                                specialOrder.setAttribute("fromtransin", "1");
                                Receipt receipt = new Receipt(parent, StoreParams.res.getString("Printing_Receipt"), false, SP.sParams.getDocketConnection(), vhidx, true);
                                receipt.PrintSpecialOrder(specialOrder);
                                bPrinted = true;
                            }
                        }
                    }
                }
                if (!bPrinted) {
                    DlgMessage.showMessage(parent, MessageFormat.format(StoreParams.res.getString("CouldNotPrintSpecialOrder"), "\n"), StoreParams.res.getString("Error"), 0);
                }
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }
}

