/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import jpos.PosUtils;
import jpos.SP;
import jpos.StkEnquirySettings;

public class StkEnquiryStore {
    private long widx;
    private StkEnquirySettings settings;
    private String storeCode = "";
    private String storeNum = "";
    private String storeName = "";
    private String refCode = "";
    private String refName = "";
    private String storeAdrs1 = "";
    private String storeAdrs2 = "";
    private String storeCity = "";
    private String storePostal = "";
    private String storeState = "";
    private String storeTele = "";
    private long rcidx = 0L;

    public StkEnquiryStore(long widx, StkEnquirySettings settings) {
        this.widx = widx;
        this.settings = settings;
        this.loadStore();
    }

    private void loadStore() {
        String whseCol = this.settings.getWhseRefCol();
        try (PreparedStatement stmt = SP.sParams.conn.prepareStatement("SELECT STORE.CODE, STORE.NAME, W.STORENO, DISPLAY_REF.RCIDX, DISPLAY_REF.CODE, DISPLAY_REF.NAME, L.ADRS1, L.ADRS2, L.CITY, L.POSTCODE, L.STATE, PH.PHONENUM FROM REFCODE STORE JOIN  WHSE W ON W.WIDX = STORE.RCIDX LEFT OUTER JOIN REFCODE DISPLAY_REF ON W." + whseCol + " = DISPLAY_REF.RCIDX " + "LEFT JOIN locn L ON STORE.LINKIDX = L.LOCNIDX AND L.ACTIVE = 1 " + "LEFT JOIN PHONENUM PH on PH.LOCNIDX = L.LOCNIDX AND PH.ACTIVE = 1 AND PH.PHONETYIDX = 154" + "WHERE W.WIDX = ? ");){
            stmt.setLong(1, this.widx);
            try (ResultSet r = stmt.executeQuery();){
                if (r.next()) {
                    this.storeCode = r.getString(1);
                    this.storeName = r.getString(2);
                    this.storeNum = r.getString(3);
                    this.rcidx = r.getLong(4);
                    this.refCode = r.getString(5);
                    this.refName = r.getString(6);
                    this.storeAdrs1 = r.getString(7);
                    this.storeAdrs1 = r.getString(8);
                    this.storeCity = r.getString(9);
                    this.storePostal = r.getString(10);
                    this.storeState = r.getString(11);
                    this.storeTele = r.getString(12);
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public long getWidx() {
        return this.widx;
    }

    public String getStoreCode() {
        return this.storeCode == null ? "" : this.storeCode;
    }

    public String getStoreName() {
        return this.storeName == null ? "" : this.storeName;
    }

    public String getStoreNum() {
        return this.storeNum == null ? "" : this.storeNum;
    }

    public String getDisplayRefCode() {
        return this.refCode == null ? "" : this.refCode;
    }

    public String getDisplayRefName() {
        return this.refName == null ? "" : this.refName;
    }

    public long getDisplayRcidx() {
        return this.rcidx;
    }

    public String toString() {
        return this.getStoreCode();
    }

    public String getStoreAdrs1() {
        return this.storeAdrs1;
    }

    public String getStoreAdrs2() {
        return this.storeAdrs2;
    }

    public String getStoreCity() {
        return this.storeCity;
    }

    public String getStoreTele() {
        return this.storeTele;
    }

    public String getStorePostal() {
        return this.storePostal;
    }

    public String getStoreState() {
        return this.storeState;
    }
}

