/*
 * Decompiled with CFR 0.152.
 */
package jpos;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.border.Border;
import jpos.DlgMessage;
import jpos.DlgReason;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StockAdjustmentSku;
import jpos.StoreParams;
import jpos.SystemSettings;
import jpos.basscom.utils.Utils;
import jpos.ui.DialogButton;
import jpos.ui.LabelHeading;
import jpos.ui.LabelNormal;
import jpos.ui.LabelSubHeading;
import jpos.ui.TouchButton;
import jpos.ui.TouchTextField;
import org.jdom.Element;

public class StockAdjustmentDlg
extends PosDialog {
    private StockAdjustmentSku stockAdjustSku;
    private StringBuffer reasonNotes = new StringBuffer();
    private boolean result = false;
    private boolean promptForReference = false;
    private long referenceToPromptFor = 0L;
    private boolean notesMandatory = true;
    private final String STOCK_ADJ_X_UNITS_TEXT = StoreParams.res.getString("Stock_Adjustment_X_Units");
    private final String STOCK_ADJ_X_UNIT_TEXT = StoreParams.res.getString("Stock_Adjustment_X_Unit");
    private LabelHeading headingLabel;
    private LabelSubHeading productDetailsLabel;
    private LabelNormal bookStockLabel;
    private LabelNormal adjustedBookStockLabel;
    private LabelNormal stockAdjustmentXUnitsLabel;
    private LabelNormal footNoteLabel;
    private TouchTextField bookStockField;
    private TouchTextField adjustedBookStockField;
    private DialogButton okButton;
    private DialogButton cancelButton;
    private TouchButton incrementButton;
    private TouchButton decrementButton;
    private long unitsLimitPerAdjustment = 0L;
    private long startStockValue = 0L;

    public StockAdjustmentDlg(PosFrame parentFrame, long skuidx) {
        super(parentFrame, StoreParams.res.getString("Stock_Adjustment"), true);
        try {
            this.initialiseScreen();
            this.loadParameterSettings();
            if (this.populate(skuidx)) {
                this.pack();
                PosUtils.centreWindow(this);
                this.setVisible(true);
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void loadParameterSettings() {
        String parameter = SystemSettings.getInstance().getText(SystemSettings.SystemSetting.DEFAULT_STOCK_ADJ_REFERENCES);
        if (parameter != null && !parameter.isEmpty()) {
            Vector<String> values = new Vector<String>();
            Utils.stringTokenize(parameter, ",", values);
            if (values.size() >= 4) {
                this.promptForReference = PosUtils.booleanVal(values.elementAt(0));
                this.referenceToPromptFor = PosUtils.longVal(values.elementAt(1));
                this.notesMandatory = PosUtils.booleanVal(values.elementAt(2));
            }
            if (values.size() >= 5) {
                this.unitsLimitPerAdjustment = PosUtils.longVal(values.elementAt(4));
            }
        }
    }

    private void initialiseScreen() {
        JPanel panelMain = new JPanel(new GridBagLayout());
        JPanel panelHeader = new JPanel(new GridBagLayout());
        JPanel panelBody = new JPanel(new GridBagLayout());
        JPanel panelFooter = new JPanel(new GridBagLayout());
        this.headingLabel = new LabelHeading(this.getTitle());
        this.productDetailsLabel = new LabelSubHeading();
        this.bookStockLabel = new LabelNormal(StoreParams.res.getString("Book_Stock_asterisk"));
        this.adjustedBookStockLabel = new LabelNormal(StoreParams.res.getString("Adjusted_Book_Stock"));
        this.stockAdjustmentXUnitsLabel = new LabelNormal();
        this.footNoteLabel = new LabelNormal(StoreParams.res.getString("Book_Stock_Calcualtion_Description"));
        this.bookStockField = new TouchTextField("");
        this.bookStockField.setFieldWidth(80);
        this.bookStockField.setEditable(false);
        this.adjustedBookStockField = new TouchTextField("");
        this.adjustedBookStockField.setFieldWidth(80);
        this.adjustedBookStockField.setDocument(PosUtils.createIntegerValidationDocument(true));
        this.adjustedBookStockField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockAdjustmentDlg.this.updateAdjustmentUnitsDisplay();
            }
        });
        this.adjustedBookStockField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent e) {
                StockAdjustmentDlg.this.updateAdjustmentUnitsDisplay();
            }

            @Override
            public void focusGained(FocusEvent e) {
                StockAdjustmentDlg.this.adjustedBookStockField.selectAll();
            }
        });
        this.okButton = new DialogButton("");
        this.okButton.setText(StoreParams.res.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockAdjustmentDlg.this.okDialog();
            }
        });
        this.cancelButton = new DialogButton("");
        this.cancelButton.setText(StoreParams.res.getString("Cancel"));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockAdjustmentDlg.this.cancelDialog();
            }
        });
        Border incrementButtonBorder = this.adjustedBookStockField.getBorder();
        this.incrementButton = new TouchButton(""){

            @Override
            public int getButtonWidth() {
                return 20;
            }

            @Override
            public int getButtonHeight() {
                return 20;
            }
        };
        this.incrementButton.setIcon(new ImageIcon(SP.sParams.imagepath + "up.gif"));
        this.incrementButton.setBorder(incrementButtonBorder);
        this.incrementButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockAdjustmentDlg.this.adjustBook(1);
            }
        });
        this.decrementButton = new TouchButton(""){

            @Override
            public int getButtonWidth() {
                return 20;
            }

            @Override
            public int getButtonHeight() {
                return 20;
            }
        };
        this.decrementButton.setIcon(new ImageIcon(SP.sParams.imagepath + "down.gif"));
        this.decrementButton.setBorder(incrementButtonBorder);
        this.decrementButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StockAdjustmentDlg.this.adjustBook(-1);
            }
        });
        this.getContentPane().add(panelMain);
        panelMain.add((Component)panelHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelBody, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        panelMain.add((Component)panelFooter, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 16, 2, new Insets(0, 0, 0, 0), 0, 0));
        panelHeader.add((Component)this.headingLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 20, 0, 20), 0, 0));
        panelHeader.add((Component)this.productDetailsLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 20, 20, 20), 0, 0));
        panelBody.add((Component)this.bookStockLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 20, 10, 20), 0, 0));
        panelBody.add((Component)this.adjustedBookStockLabel, new GridBagConstraints(0, 1, 1, 2, 1.0, 1.0, 17, 0, new Insets(10, 20, 10, 20), 0, 0));
        panelBody.add((Component)this.bookStockField, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 13, 0, new Insets(10, 20, 10, 0), 0, 0));
        panelBody.add((Component)this.adjustedBookStockField, new GridBagConstraints(1, 1, 1, 2, 1.0, 1.0, 13, 0, new Insets(10, 20, 10, 0), 0, 0));
        panelBody.add((Component)this.incrementButton, new GridBagConstraints(2, 1, 1, 1, 1.0, 1.0, 16, 0, new Insets(10, 0, 0, 20), 0, 0));
        panelBody.add((Component)this.decrementButton, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 10, 20), 0, 0));
        panelFooter.add((Component)this.stockAdjustmentXUnitsLabel, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 11, 0, new Insets(20, 20, 20, 20), 0, 0));
        panelFooter.add((Component)this.okButton, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 13, 0, new Insets(10, 0, 10, 15), 0, 0));
        panelFooter.add((Component)this.cancelButton, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 0, new Insets(10, 15, 10, 0), 0, 0));
        panelFooter.add((Component)this.footNoteLabel, new GridBagConstraints(0, 2, 2, 1, 1.0, 1.0, 15, 0, new Insets(10, 20, 10, 20), 0, 0));
        this.setFocusCycleRoot(true);
        Vector<Component> tabOrder = new Vector<Component>();
        tabOrder.add(this.adjustedBookStockField);
        tabOrder.add(this.incrementButton);
        tabOrder.add(this.decrementButton);
        tabOrder.add(this.okButton);
        tabOrder.add(this.cancelButton);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(tabOrder);
        this.setFocusTraversalPolicy(ftp);
    }

    private boolean populate(long skuidx) {
        this.stockAdjustSku = StockAdjustmentSku.loadStockAdjustmentSku(skuidx);
        if (this.stockAdjustSku == null) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Stock_Adjustment_failed_to_load"), this.getTitle(), 0);
            return false;
        }
        if (!this.stockAdjustSku.getStocked()) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Stock_Adjustment_non_stocked_product"), this.getTitle(), 0);
            return false;
        }
        this.productDetailsLabel.setText(this.stockAdjustSku.toString());
        String book = this.getBookStockOnline();
        if (book != null) {
            this.startStockValue = PosUtils.longVal(book);
            this.bookStockField.setText(book);
            this.adjustedBookStockField.setText(book);
            this.updateAdjustmentUnitsDisplay();
            return true;
        }
        DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("failed_to_fetch_book_stock"), "\n"), this.getTitle(), 0);
        return false;
    }

    private boolean save() {
        long adjustment = this.getAdjustment();
        if (adjustment == 0L) {
            return true;
        }
        if (PosUtils.longVal(this.adjustedBookStockField.getText()) < 0L) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Negative_Stock_Adjustment_Error"), this.getTitle(), 0);
            this.adjustedBookStockField.requestFocus();
            return false;
        }
        if (Math.abs(adjustment) > 1000L) {
            DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Max_Stock_Adjustment_Error"), this.getTitle(), 0);
            this.adjustedBookStockField.requestFocus();
            return false;
        }
        StringBuffer selectedReferenceCode = new StringBuffer();
        long referenceGroup = this.promptForReference && this.referenceToPromptFor > 0L ? this.referenceToPromptFor : -1L;
        String extraWhere = "";
        try (SqlQuery sql = new SqlQuery(this.sParams.conn, "select blobtext from blobtext bt, sysparam s where bt.blobidx = s.parlnkidx and s.paridx = 701 and bt.blobtext IS NOT NULL");){
            if (sql.next() && !sql.getString(1).isEmpty()) {
                extraWhere = " r.rcidx in (" + sql.getString(1) + ") ";
            }
        }
        catch (SQLException e) {
            this.dispose();
        }
        DlgReason dlgReason = new DlgReason(this.frParent, StoreParams.res.getString("Stock_Adjustment_Reason"), true, referenceGroup, selectedReferenceCode, this.reasonNotes, true, extraWhere, 230, this.notesMandatory, false);
        dlgReason.setVisible(true);
        if (selectedReferenceCode.toString().equals("-1")) {
            return false;
        }
        try {
            String payload = String.valueOf(SP.sParams.getStoreIdx()) + "," + String.valueOf(this.stockAdjustSku.getSkuidx()) + "," + String.valueOf(adjustment) + "," + String.valueOf(this.frParent.getUser().getMemidx()) + "," + selectedReferenceCode.toString() + "," + this.reasonNotes.toString();
            this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("stkadjustment", payload).getXML();
            if (this.sParams.root != null) {
                Element sku = this.sParams.root.getChild("sku");
                if (sku != null && sku.getAttribute("result") != null && !sku.getAttributeValue("result").equals("-1")) {
                    DlgMessage.showMessage(this.frParent, StoreParams.res.getString("Stock_Adjustment_Complete"), this.getTitle(), 1);
                    return true;
                }
                if (sku != null && sku.getAttribute("message") != null && sku.getAttributeValue("message").length() > 0) {
                    DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("Stock_Adjustment_Error"), "\n", sku.getAttributeValue("message")), this.getTitle(), 0);
                    return false;
                }
                DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("Stock_Adjustment_Error"), "", ""), this.getTitle(), 0);
                return false;
            }
            return false;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return false;
        }
    }

    private String getBookStockOnline() {
        try {
            this.sParams.root = this.sParams.OnlineQueryProvider.getOnlineQuery("bookstk", String.valueOf(SP.sParams.getStoreIdx()) + "," + String.valueOf(this.stockAdjustSku.getSkuidx())).getXML();
            if (this.sParams.root != null) {
                String book = "";
                Element sku = this.sParams.root.getChild("sku");
                if (sku != null && sku.getAttribute("book") != null) {
                    book = sku.getAttributeValue("book");
                }
                if (book.length() == 0) {
                    return "0";
                }
                return book;
            }
            return null;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return null;
        }
    }

    private void adjustBook(int adjustment) {
        long currentAdjustedValue = PosUtils.longVal(this.adjustedBookStockField.getText());
        this.adjustedBookStockField.setText(String.valueOf(currentAdjustedValue += (long)adjustment));
        this.updateAdjustmentUnitsDisplay();
    }

    private void updateAdjustmentUnitsDisplay() {
        long adjustment = this.getAdjustment();
        if (Math.abs(adjustment) == 1L) {
            this.stockAdjustmentXUnitsLabel.setText(MessageFormat.format(this.STOCK_ADJ_X_UNIT_TEXT, String.valueOf(adjustment)));
        } else {
            this.stockAdjustmentXUnitsLabel.setText(MessageFormat.format(this.STOCK_ADJ_X_UNITS_TEXT, String.valueOf(adjustment)));
        }
    }

    public long getAdjustment() {
        return PosUtils.longVal(this.adjustedBookStockField.getText()) - PosUtils.longVal(this.bookStockField.getText());
    }

    public boolean getResult() {
        return this.result;
    }

    @Override
    public void cancelDialog() {
        this.setVisible(false);
    }

    @Override
    public void okDialog() {
        if (this.unitsLimitPerAdjustment > 0L && Math.abs(this.startStockValue - PosUtils.longVal(this.adjustedBookStockField.getText())) > this.unitsLimitPerAdjustment) {
            DlgMessage.showMessage(this.frParent, MessageFormat.format(StoreParams.res.getString("stock_adjustment_units_limit"), this.unitsLimitPerAdjustment), this.getTitle(), 0);
            return;
        }
        this.result = this.save();
        if (this.result) {
            this.setVisible(false);
        }
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }
}

