/*
 * Decompiled with CFR 0.152.
 */
package jpos.UareU;

import JCP.JcpApi;
import JCP.JcpObject;
import JCP.JcpRequestResult;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import jpos.PosUtils;
import jpos.StoreParams;
import jpos.UareU.IUareUFingerprintListener;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public final class UareUFingerprintProvider
extends JcpObject {
    private int fingerprintProviderID = -1;
    private StoreParams storeParams;
    private Vector<IUareUFingerprintListener> listeners = new Vector();

    public UareUFingerprintProvider(StoreParams storeparams) {
        this.storeParams = storeparams;
    }

    public StoreParams getStoreParams() {
        return this.storeParams;
    }

    public boolean registerFingerprintListener(IUareUFingerprintListener listener) {
        if (this.listeners.indexOf(listener) > -1) {
            return true;
        }
        try {
            if (this.startFingerprintScanner()) {
                this.listeners.add(listener);
                return true;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        return false;
    }

    public void unregisterFingerprintListener(IUareUFingerprintListener listener) {
        int index = this.listeners.indexOf(listener);
        if (index == -1) {
            return;
        }
        this.listeners.removeElementAt(index);
        if (this.listeners.size() == 0) {
            try {
                this.stopFingerprintScanner();
            }
            catch (Exception e) {
                PosUtils.logError(e);
            }
        }
    }

    private int getFingerprintProviderInstance() {
        if (this.fingerprintProviderID == -1) {
            try {
                JcpRequestResult result = JcpApi.CreateObject((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (String)"Bass.Ap21.Pos.PosPlatformExchange.FingerprintProvider", (Object[])new Object[0]);
                if (!result.getSuccess()) {
                    throw new Exception(result.getCustomMessage() + "\r\n" + result.getErrorMessage() + "\r\n" + result.getStackTrace());
                }
                this.fingerprintProviderID = result.getRequestResultAsInt();
            }
            catch (Exception e) {
                PosUtils.logError(e);
                this.fingerprintProviderID = -1;
            }
        }
        return this.fingerprintProviderID;
    }

    public EnrollmentResult performEnrollment(String key) throws Exception {
        if (this.getFingerprintProviderInstance() > 0) {
            JcpRequestResult result = JcpApi.InvokeMethod((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.fingerprintProviderID, (String)"PerformEnrollment", (Object[])new Object[]{key});
            if (result.getSuccess()) {
                Element element = this.processResult(result);
                if (element != null) {
                    if (element.getName().equalsIgnoreCase("OK")) {
                        return EnrollmentResult.ENROLLED;
                    }
                    if (element.getName().equalsIgnoreCase("DUPLICATE")) {
                        return EnrollmentResult.DUPLICATE;
                    }
                }
                return EnrollmentResult.CANCELLED;
            }
            throw new Exception(result.getErrorMessage());
        }
        return EnrollmentResult.ERROR;
    }

    private Element processResult(JcpRequestResult result) {
        try {
            String resultString = result.getRequestResultAsXmlString();
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build((Reader)new StringReader(resultString));
            Element returnXml = doc.getRootElement();
            if (returnXml.getName().equalsIgnoreCase("Error")) {
                returnXml = returnXml.getChild("Exceptions").getChild("Exception");
                throw new Exception(String.format("Unexpected exception returned, %s: %s\n%s", returnXml.getAttribute("type").getValue(), returnXml.getAttribute("message").getValue(), returnXml.getAttribute("stack_trace").getValue()));
            }
            return returnXml;
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return null;
        }
    }

    public void doOnFingerPrintScanned(String key) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            this.listeners.get(i).onFingerPrintScanned(key);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public void dispose() {
        if (this.fingerprintProviderID > 0) {
            JcpApi.ReleaseObject((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.fingerprintProviderID);
            this.fingerprintProviderID = -1;
        }
    }

    private boolean startFingerprintScanner() throws Exception {
        if (this.getFingerprintProviderInstance() > 0) {
            JcpRequestResult result = JcpApi.InvokeMethod((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.fingerprintProviderID, (String)"StartFingerprintScanner", (Object[])new Object[0]);
            if (result.getSuccess()) {
                Element element = this.processResult(result);
                if (element == null) {
                    return false;
                }
                if (element.getName().equalsIgnoreCase("NO_SCANNER")) {
                    return false;
                }
                return element.getName().equalsIgnoreCase("OK");
            }
            throw new Exception(result.getErrorMessage());
        }
        return false;
    }

    public boolean stopFingerprintScanner() throws Exception {
        if (this.getFingerprintProviderInstance() > 0) {
            JcpRequestResult result = JcpApi.InvokeMethod((String)"{CB6D6C10-5013-4E46-B8C3-2E7A58763C79}", (int)this.fingerprintProviderID, (String)"StopFingerprintScanner", (Object[])new Object[0]);
            if (result.getSuccess()) {
                Element element = this.processResult(result);
                if (element == null) {
                    return false;
                }
                return element.getName().equalsIgnoreCase("OK");
            }
            throw new Exception(result.getErrorMessage());
        }
        return false;
    }

    public static enum EnrollmentResult {
        ENROLLED(1),
        CANCELLED(2),
        DUPLICATE(3),
        ERROR(4);

        private final int value;

        private EnrollmentResult(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

