/*
 * Decompiled with CFR 0.152.
 */
package jpos.associations;

import jpos.SP;
import jpos.associations.Association;
import jpos.associations.IOrderCellValue;

public enum AssociationColumn implements IOrderCellValue
{
    name(0, SP.getRS("Name"), 200, true, Association::getName),
    contactPerson(1, SP.getRS("Contact_Person"), 250, true, Association::getContactPerson),
    address1(2, SP.getRS("Address1"), 150, true, Association::getAddress1),
    address2(3, SP.getRS("Address2"), 150, true, Association::getAddress2),
    city(4, SP.getRS("City"), 150, true, Association::getCity),
    postcode(5, SP.getRS("Post_Code"), 150, true, Association::getPostcode);

    private final int id;
    private final String assocName;
    private final int width;
    private final boolean resizable;
    private final IOrderCellValue func;

    private AssociationColumn(int id, String name, int width, boolean resizable, IOrderCellValue func) {
        this.id = id;
        this.assocName = name;
        this.width = width;
        this.resizable = resizable;
        this.func = func;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.assocName;
    }

    public int getWidth() {
        return this.width;
    }

    public boolean isResizable() {
        return this.resizable;
    }

    @Override
    public Object getValue(Association session) {
        return this.func.getValue(session);
    }

    public static AssociationColumn getById(int id) {
        for (AssociationColumn col : AssociationColumn.values()) {
            if (col.getId() != id) continue;
            return col;
        }
        return null;
    }
}

