/*
 * Decompiled with CFR 0.152.
 */
package jpos.associations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import jpos.StringUtils;
import jpos.associations.Association;
import jpos.associations.AssociationColumn;

public class AssociationTableModel
extends AbstractTableModel {
    List<AssociationsPickPair> visibleAssociations = new ArrayList<AssociationsPickPair>();
    List<Association> allAssociations = new ArrayList<Association>();
    List<AssociationColumn> columns = new ArrayList<AssociationColumn>();
    String previousFilter = "";

    @Override
    public int getRowCount() {
        return this.visibleAssociations.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return false;
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (row >= this.visibleAssociations.size() || row < 0) {
            return "";
        }
        AssociationColumn column = this.getColumnType(col);
        if (column == null) {
            return "";
        }
        Association association = this.visibleAssociations.get(row).getKey();
        if (association != null) {
            return column.getValue(association);
        }
        return "";
    }

    @Override
    public String getColumnName(int col) {
        AssociationColumn column = this.getColumnType(col);
        return column != null ? column.getName() : "";
    }

    public AssociationColumn getColumnType(int col) {
        if (col >= this.columns.size() || col < 0) {
            return null;
        }
        return this.columns.get(col);
    }

    public void addAssociation(Association association) {
        this.allAssociations.add(association);
        this.resetFilter();
    }

    public void removeAssociation(Association association) {
        this.allAssociations.remove(association);
        this.visibleAssociations.remove(association);
        this.resetFilter();
    }

    public void addAssociations(List<Association> associations, boolean overwrite) {
        if (overwrite) {
            this.allAssociations = new ArrayList<Association>(associations);
        } else {
            this.allAssociations.addAll(associations);
        }
        this.resetFilter();
    }

    public void addColumn(AssociationColumn column) {
        this.columns.add(column);
        this.fireTableStructureChanged();
    }

    public Association getAssociation(int row) {
        if (row >= this.visibleAssociations.size() || row < 0) {
            return null;
        }
        return this.visibleAssociations.get(row).getKey();
    }

    public int getAssociationRow(Association association) {
        for (int i = 0; i < this.visibleAssociations.size(); ++i) {
            if (this.visibleAssociations.get(i).getKey() != association) continue;
            return i;
        }
        return -1;
    }

    private void resetFilter() {
        this.visibleAssociations.clear();
        for (Association association : this.allAssociations) {
            this.visibleAssociations.add(new AssociationsPickPair(association));
        }
        this.fireTableDataChanged();
    }

    public void filter(String searchString) {
        if ((searchString = StringUtils.nullToEmpty(searchString).trim().toUpperCase()).isEmpty()) {
            this.resetFilter();
        } else if (this.previousFilter.isEmpty() || !searchString.contains(this.previousFilter)) {
            this.applyFilter(searchString, false);
        } else if (searchString.startsWith(this.previousFilter)) {
            String[] words = searchString.split("\\s+");
            if (words.length > 0) {
                this.applyFilter(words[words.length - 1], true);
            }
        } else {
            this.applyFilter(searchString, true);
        }
        this.previousFilter = searchString;
    }

    private void applyFilter(String searchString, boolean onExistingFilter) {
        if (onExistingFilter) {
            Iterator<AssociationsPickPair> iterator = this.visibleAssociations.iterator();
            while (iterator.hasNext()) {
                AssociationsPickPair sessionPick = iterator.next();
                if (sessionPick.getKey().search(searchString)) continue;
                iterator.remove();
            }
        } else {
            this.visibleAssociations.clear();
            for (Association session : this.allAssociations) {
                if (!session.search(searchString)) continue;
                this.visibleAssociations.add(new AssociationsPickPair(session));
            }
        }
        this.fireTableDataChanged();
    }

    private static class AssociationsPickPair
    implements Map.Entry<Association, Boolean> {
        Association association;
        boolean pick;

        @Override
        public Association getKey() {
            return this.association;
        }

        @Override
        public Boolean getValue() {
            return this.pick;
        }

        @Override
        public Boolean setValue(Boolean value) {
            if (this.pick == value) {
                return false;
            }
            this.pick = value;
            return true;
        }

        public AssociationsPickPair(Association association) {
            this.association = association;
            this.pick = false;
        }
    }
}

