/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.swing;

import java.awt.Container;
import java.awt.Window;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;
import jpos.DlgMessage;
import jpos.StringUtils;
import jpos.basscom.cache.Cacher;
import jpos.basscom.swing.BJTable;
import jpos.basscom.swing.BJTextField;
import jpos.basscom.swing.BUtils;
import jpos.basscom.swing.event.BTblSearchListener;
import jpos.basscom.swing.event.BTblValidateListener;
import jpos.basscom.utils.TypConv;
import jpos.basscom.utils.Utils;

public class BJTableRefPlus
extends BJTable {
    static ResourceBundle res = ResourceBundle.getBundle("TransJavaCommon");
    private Connection connivDB;
    private Cacher cacher;
    private BJTextField searchField;
    private Vector<String> vivDBTbl = new Vector();
    private Vector<String> vivDBTblDesc = new Vector();
    private Vector<String> vivDBTblCol = new Vector();
    private Vector<String> vivRgidx = new Vector();
    private Vector<String> vivPRgidx = new Vector();
    private Vector<String> vivMand = new Vector();
    private Vector<String> vivParent = new Vector();
    private Vector<String> vivShortName = new Vector();
    private Vector<String> vivLongName = new Vector();
    private Vector<String> vivCacheidx = new Vector();
    private Vector<String> vivExtraTables = new Vector();
    private Vector<String> vivExtraWhere = new Vector();
    private Vector<String> vivTblIdx = new Vector();
    private Vector<String> vivRG_ORD = new Vector();
    private Vector<String> vivValIDX = new Vector();
    private Vector<String> vivCacheKeyCol = new Vector();
    private Vector<String> vivCacheCodeCol = new Vector();
    private Vector<String> vivCacheSel = new Vector();
    private Vector<String> vivCacheFrom = new Vector();
    private Vector<String> vivCacheWhere = new Vector();

    public BJTableRefPlus(int pDBType) {
        super(pDBType);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    public BJTableRefPlus() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.addBTblValidateListener(new BTblValidateListener(){

            @Override
            public void actionValidate(int row, int col) {
                BJTableRefPlus.this.this_actionValidate(row, col);
            }
        });
        this.addBTblSearchListener(new BTblSearchListener(){

            @Override
            public void actionSearch(int row, int col) {
                BJTableRefPlus.this.this_actionSearch(row, col);
            }

            @Override
            public void actionShiftSearch(int row, int col) {
            }
        });
        this.setupTable();
    }

    public void setCacher(Cacher cacher) {
        this.cacher = cacher;
    }

    public void setConnection(Connection connDB) {
        this.connivDB = connDB;
    }

    public void setSearchField(BJTextField searchField) {
        this.searchField = searchField;
    }

    public boolean validateMand() {
        return this.validateMand(true);
    }

    public boolean validateMand(boolean bShowMsg) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            Container parent;
            if (!this.vivMand.get(i).equals("1") || this.vivValIDX.get(i) != null && !this.vivValIDX.get(i).equals("")) continue;
            Object[] objs = new Object[]{this.vivShortName.get(i)};
            String msg = MessageFormat.format(res.getString("Reference_0_is"), objs);
            if (bShowMsg && (parent = this.getTopLevelAncestor()) instanceof Window) {
                DlgMessage.showMessage((Window)this.getTopLevelAncestor(), msg, res.getString("Mandatory_reference"), 2);
            }
            this.setRowSelectionInterval(i, i);
            this.setColumnSelectionInterval(1, 1);
            this.editCellAt(i, 1);
            return false;
        }
        return true;
    }

    public Long getIdxByCacheidx(String cacheidx) {
        try {
            if (this.vivCacheidx.indexOf(cacheidx) > -1) {
                return Long.valueOf(this.vivValIDX.elementAt(this.vivCacheidx.indexOf(cacheidx)));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public Long getIdxByRgidx(String rgidx) {
        try {
            if (this.vivRgidx.indexOf(rgidx) > -1) {
                return Long.valueOf(this.vivValIDX.elementAt(this.vivRgidx.indexOf(rgidx)));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public Long getIdx(int rownum) {
        try {
            if (rownum > -1 && rownum < this.vivValIDX.size()) {
                return Long.valueOf(this.vivValIDX.elementAt(rownum));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public Long getIdxByTblRG_ORG(int pTblidx, int pRG_ORD) {
        try {
            for (int row = 0; row < this.vivTblIdx.size(); ++row) {
                if (!this.vivTblIdx.get(row).equals(String.valueOf(pTblidx)) || !this.vivRG_ORD.get(row).equals(String.valueOf(pRG_ORD))) continue;
                return Long.valueOf(this.vivValIDX.get(row));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public void getIdxsByTbl(String[] pIdxs, int pTblidx) {
        int NUMREFS;
        int cnt = 0;
        int n = NUMREFS = pTblidx == 99 ? 20 : 10;
        for (int row = 0; row < this.vivTblIdx.size() && cnt < NUMREFS; ++row) {
            if (!this.vivTblIdx.get(row).equals(String.valueOf(pTblidx))) continue;
            if (this.vivValIDX.get(row) != null && !this.vivValIDX.get(row).equals("")) {
                pIdxs[TypConv.toInt((String)this.vivRG_ORD.get((int)row)) - 1] = this.vivValIDX.get(row);
                while (cnt < TypConv.toInt(this.vivRG_ORD.get(row)) - 1) {
                    pIdxs[cnt] = "null";
                    ++cnt;
                }
            } else {
                pIdxs[cnt] = "null";
            }
            ++cnt;
        }
        while (cnt < NUMREFS) {
            pIdxs[cnt] = "null";
            ++cnt;
        }
    }

    public void getIdxs(String[] pIdxs) {
        int NUMREFS;
        int cnt = 0;
        int row = 0;
        int n = this.vivTblIdx.get(row).equals("99") ? 20 : (NUMREFS = this.vivTblIdx.get(row).equals("") ? 0 : 10);
        while (row < this.vivTblIdx.size() && cnt < pIdxs.length) {
            int i;
            int diff;
            if (row == 0 || this.vivTblIdx.get(row).equals(this.vivTblIdx.get(row - 1)) && !this.vivTblIdx.get(row).equals("")) {
                int n2 = row > 0 ? TypConv.toInt(this.vivRG_ORD.get(row)) - TypConv.toInt(this.vivRG_ORD.get(row - 1)) : (diff = this.vivRG_ORD.get(row).equals("") ? 0 : TypConv.toInt(this.vivRG_ORD.get(row)) - 1);
                if (diff > 100) {
                    diff = diff - 100 + NUMREFS;
                }
                for (i = cnt + 1; i < cnt + diff && i < pIdxs.length; ++i) {
                    pIdxs[i] = "null";
                }
                cnt += diff;
            } else if (!this.vivTblIdx.get(row).equals(this.vivTblIdx.get(row - 1))) {
                diff = 0;
                if (TypConv.toInt(this.vivRG_ORD.get(row - 1)) < NUMREFS) {
                    diff = NUMREFS - TypConv.toInt(this.vivRG_ORD.get(row - 1));
                }
                NUMREFS = this.vivTblIdx.get(row).equals("99") ? 20 : (this.vivTblIdx.get(row).equals("") ? 0 : 10);
                diff += this.vivRG_ORD.get(row).equals("") ? 1 : TypConv.toInt(this.vivRG_ORD.get(row));
                for (i = cnt + 1; i < diff + cnt && i < pIdxs.length; ++i) {
                    pIdxs[i] = "null";
                }
                cnt += diff;
            }
            if (cnt >= pIdxs.length) break;
            pIdxs[cnt] = this.vivValIDX.get(row) != null && !this.vivValIDX.get(row).equals("") ? this.vivValIDX.get(row) : "null";
            ++row;
        }
        ++cnt;
        while (cnt < pIdxs.length) {
            pIdxs[cnt] = "null";
            ++cnt;
        }
    }

    public int[] getTblIdxs() {
        int[] idxs = new int[this.vivTblIdx.size()];
        for (int i = 0; i < this.vivTblIdx.size(); ++i) {
            if (i != 0 && idxs[i - 1] == TypConv.toInt(this.vivTblIdx.get(i))) continue;
            idxs[i] = TypConv.toInt(this.vivTblIdx.get(i));
        }
        return idxs;
    }

    public boolean tblUsed(int tblidx) {
        for (int i = 0; i < this.vivTblIdx.size(); ++i) {
            if (tblidx != TypConv.toInt(this.vivTblIdx.get(i))) continue;
            return true;
        }
        return false;
    }

    public void populateIdxsByTbl(String[] pIdxs, int pTblidx) {
        int cnt = 0;
        int NUMREFS = pTblidx == 99 ? 20 : 10;
        boolean cacheSet = false;
        for (int row = 0; row < this.vivTblIdx.size() && cnt < pIdxs.length; ++row) {
            if (this.vivTblIdx.get(row).equals(String.valueOf(pTblidx))) {
                if (this.vivRG_ORD.get(row).equals(String.valueOf(cnt + 1))) {
                    if (pIdxs[cnt] != null && !pIdxs[cnt].equals("null")) {
                        if (!cacheSet) {
                            long cacheidx;
                            cacheSet = true;
                            String sTables = "";
                            if (this.vivExtraTables.get(row) != null) {
                                sTables = this.vivExtraTables.get(row).toString();
                            }
                            String sWhere = "";
                            if (this.vivExtraWhere.get(row) != null) {
                                sWhere = this.vivExtraWhere.get(row).toString();
                            }
                            if ((cacheidx = (long)TypConv.toInt(this.vivCacheidx.get(row).toString())) > 0L) {
                                this.searchField.setCache(this.cacher, cacheidx, "", sTables, sWhere, false);
                            }
                        }
                        if (this.searchField.getCacheidx() > 0L && this.searchField.populate(pIdxs[cnt])) {
                            this.setCellValueAt(this.searchField.getText(), row, 1);
                            this.vivValIDX.set(row, this.searchField.getidxStr());
                        } else {
                            this.vivValIDX.set(row, "");
                            this.setCellValueAt("", row, 1);
                        }
                    } else {
                        this.vivValIDX.set(row, "");
                        this.setCellValueAt("", row, 1);
                    }
                    if (this.vivRG_ORD.size() > row + 1) {
                        cnt = TypConv.toInt(this.vivRG_ORD.get(row + 1)) - 1;
                    }
                } else if (this.vivRG_ORD.size() > row + 1) {
                    cnt = TypConv.toInt(this.vivRG_ORD.get(row + 1)) - 1;
                }
            }
            if (cnt <= 100) continue;
            cnt = cnt - 100 + NUMREFS;
        }
    }

    public void populateIdxs(String[] pIdxs) {
        int cnt = 0;
        int row = 0;
        int NUMREFS = this.vivTblIdx.get(row).equals("99") ? 20 : (this.vivTblIdx.get(row).equals("") ? 0 : 10);
        boolean cacheSet = false;
        while (row < this.vivTblIdx.size() && cnt < pIdxs.length) {
            if (row == 0 || this.vivTblIdx.get(row).equals(this.vivTblIdx.get(row - 1)) && !this.vivTblIdx.get(row).equals("")) {
                int diff;
                int n = row > 0 ? TypConv.toInt(this.vivRG_ORD.get(row)) - TypConv.toInt(this.vivRG_ORD.get(row - 1)) : (diff = this.vivRG_ORD.get(row).equals("") ? 0 : TypConv.toInt(this.vivRG_ORD.get(row)) - 1);
                if (diff > 100) {
                    diff = diff - 100 + NUMREFS;
                }
                cnt += diff;
            } else if (!this.vivTblIdx.get(row).equals(this.vivTblIdx.get(row - 1))) {
                if (TypConv.toInt(this.vivRG_ORD.get(row - 1)) < NUMREFS) {
                    int diff = NUMREFS - TypConv.toInt(this.vivRG_ORD.get(row - 1));
                    cnt += diff;
                }
                NUMREFS = this.vivTblIdx.get(row).equals("99") ? 20 : (this.vivTblIdx.get(row).equals("") ? 0 : 10);
                int diff = this.vivRG_ORD.get(row).equals("") ? 1 : TypConv.toInt(this.vivRG_ORD.get(row));
                cnt += diff;
            }
            if (cnt >= pIdxs.length) break;
            if (pIdxs[cnt] != null && !pIdxs[cnt].equals("null")) {
                if (!cacheSet || this.searchField.getCacheidx() != (long)TypConv.toInt(this.vivCacheidx.get(row).toString()) || !this.searchField.getwhere().equals(this.vivExtraWhere.get(row))) {
                    long cacheidx;
                    cacheSet = true;
                    String sTables = "";
                    if (this.vivExtraTables.get(row) != null) {
                        sTables = this.vivExtraTables.get(row).toString();
                    }
                    String sWhere = "";
                    if (this.vivExtraWhere.get(row) != null) {
                        sWhere = this.vivExtraWhere.get(row).toString();
                    }
                    if ((cacheidx = (long)TypConv.toInt(this.vivCacheidx.get(row).toString())) > 0L) {
                        this.searchField.setCache(this.cacher, cacheidx, "", sTables, sWhere, false);
                    }
                }
                if (this.searchField.getCacheidx() > 0L && this.searchField.populate(pIdxs[cnt])) {
                    this.setCellValueAt(this.searchField.getText(), row, 1);
                    this.vivValIDX.set(row, this.searchField.getidxStr());
                } else {
                    this.vivValIDX.set(row, "");
                    this.setCellValueAt("", row, 1);
                }
            } else {
                this.vivValIDX.set(row, "");
                this.setCellValueAt("", row, 1);
            }
            ++row;
        }
        while (row < this.vivTblIdx.size()) {
            this.vivValIDX.set(row, "");
            this.setCellValueAt("", row, 1);
            ++row;
        }
    }

    private void setupTable() {
        String[] saN = new String[2];
        String[] saT = new String[2];
        int[] naA = new int[2];
        int[] naW = new int[2];
        int[] naCT = new int[2];
        saN[0] = "colRowHdr";
        saT[0] = res.getString("Name");
        naA[0] = 2;
        naW[0] = 130;
        naCT[0] = 0;
        saN[1] = "colVal";
        saT[1] = res.getString("Value");
        naA[1] = 2;
        naW[1] = 100;
        naCT[1] = 0;
        this.setUp(saN, saT, naA, naW, naCT, 2, false, true, false);
    }

    public void addRefGrp(long npRgidx, String spDBTbl, String spDBTblDesc, String spDBTblCol, boolean bpMand) {
        this.addRefGrp(npRgidx, spDBTbl, spDBTblDesc, spDBTblCol, false, bpMand ? "1" : "0", "", "");
    }

    private void addRefGrp(long npRgidx, String spDBTbl, String spDBTblDesc, String spDBTblCol, boolean bParent, String spMand, String spTblIdx, String spRG_ORD) {
        Vector<Vector<String>> vTmp;
        String sSql = "SELECT REFGRP.S_NAME, REFGRP.L_NAME, COALESCE(REFGRP.RPGIDX,0) FROM REFGRP WHERE REFGRP.RGIDX = " + npRgidx;
        if (!BUtils.queryStmt(this.connivDB, sSql, 3, vTmp = new Vector<Vector<String>>())) {
            return;
        }
        this.vivMand.add(spMand);
        this.vivTblIdx.add(spTblIdx);
        this.vivRG_ORD.add(spRG_ORD);
        this.vivShortName.add(vTmp.elementAt(0).elementAt(0));
        this.vivLongName.add(vTmp.elementAt(0).elementAt(1));
        this.vivPRgidx.add(vTmp.elementAt(0).elementAt(2));
        if (bParent) {
            this.vivParent.add("true");
        } else {
            this.vivParent.add("false");
        }
        int nPRgidx = 0;
        if (vTmp.elementAt(0).elementAt(2) != null) {
            nPRgidx = TypConv.toInt(vTmp.elementAt(0).elementAt(2).toString());
        }
        this.vivRgidx.add(String.valueOf(npRgidx));
        this.vivDBTbl.add(spDBTbl);
        this.vivDBTblDesc.add(spDBTblDesc);
        this.vivDBTblCol.add(spDBTblCol);
        this.vivCacheidx.add(String.valueOf(281));
        this.vivExtraTables.add("");
        this.vivExtraWhere.add("R.\"ACTIVE\" = 1 AND R.RGIDX = " + npRgidx);
        this.vivValIDX.add("");
        this.addCacheInfo(281L, "", "R.\"ACTIVE\" = 1 AND R.RGIDX = " + npRgidx);
        this.addARow();
        if (nPRgidx > 0 && bParent) {
            this.addRefGrp(nPRgidx, "R" + nPRgidx, "+ " + spDBTblDesc, "RPCIDX", true, "0", "", "");
        }
    }

    public void addRefObj(int npTblidx, String spDBTbl, String spDBTblDesc) {
        this.addRefObj(npTblidx, spDBTbl, spDBTblDesc, true);
    }

    public void addRefObj(int npTblidx, String spDBTbl, String spDBTblDesc, boolean bpIncludeInt) {
        this.addRefObj(npTblidx, spDBTbl, spDBTblDesc, bpIncludeInt, "");
    }

    public void addRefObj(int npTblidx, String spDBTbl, String spDBTblDesc, boolean bpIncludeInt, String GoupsToInclude) {
        String sExtraWhere1 = "";
        String sExtraWhere2 = "";
        if (GoupsToInclude != null && GoupsToInclude.length() > 0) {
            sExtraWhere1 = " AND T.RGIDX IN(" + GoupsToInclude + ") ";
            sExtraWhere2 = " AND I.RGIDX IN(" + GoupsToInclude + ") ";
        }
        long[] naTmp = new long[]{0L};
        String[] saTmp = new String[]{""};
        Utils.getSysParam(this.connivDB, 176L, naTmp, saTmp);
        long nBatchTrack = naTmp[0];
        Utils.getSysParam(this.connivDB, 32L, naTmp, saTmp);
        long nPackType = naTmp[0];
        String sSql = null;
        if (this.DBType == 0) {
            sSql = "SELECT T.RGIDX, T.RG_ORD, 'REF' || T.RG_ORD, '', COALESCE(T.MAND, 0), T.RG_ORD+100 FROM REFTBL T WHERE T.RGIDX > 0 AND T.TBLIDX = " + npTblidx + " " + sExtraWhere1 + " ";
            sSql = bpIncludeInt ? sSql + "UNION SELECT I.RGIDX, I.RG_ORD, I.COLNAME, I.EXTRA, COALESCE(I.MAND, 0), I.RG_ORD FROM REFTBLINT I WHERE  I.TBLIDX = " + npTblidx + " " + sExtraWhere2 + " " + "ORDER BY 2" : sSql + "ORDER BY 2";
        } else if (this.DBType == 1) {
            sSql = "SELECT T.RGIDX, T.RG_ORD, CAST('REF' || T.RG_ORD AS VARCHAR(25)), CAST('' AS VARCHAR(20)), T.MAND, CAST(T.RG_ORD+100 AS NUMERIC) FROM REFTBL T WHERE T.RGIDX > 0 AND T.TBLIDX = " + npTblidx + " " + sExtraWhere1 + " ";
            sSql = bpIncludeInt ? sSql + "UNION SELECT I.RGIDX, I.RG_ORD, I.COLNAME, I.EXTRA, I.MAND, I.RG_ORD FROM REFTBLINT I WHERE  I.TBLIDX = " + npTblidx + " " + sExtraWhere2 + " " + "ORDER BY 2" : sSql + "ORDER BY 2";
        }
        Vector<Vector<String>> vTmp = new Vector<Vector<String>>();
        if (!BUtils.queryStmt(this.connivDB, sSql, 5, vTmp)) {
            return;
        }
        for (Vector<String> vRow : vTmp) {
            int nRgidx = 0;
            if (vRow.get(0) != null) {
                nRgidx = TypConv.toInt(vRow.get(0));
            }
            String sRG_ORD = "";
            if (vRow.get(1) != null) {
                sRG_ORD = vRow.get(1);
            }
            String sDBCol = "";
            if (vRow.get(2) != null) {
                sDBCol = vRow.get(2);
            }
            String sExtra = "";
            if (vRow.get(2) != null) {
                sExtra = vRow.get(3);
            }
            if (!sExtra.equals("")) {
                sDBCol = sExtra + " " + sDBCol;
            }
            if (nRgidx == 29 && nPackType == 0L || nRgidx == 315 && nBatchTrack == 0L) continue;
            this.addRefGrp(nRgidx, spDBTbl, spDBTblDesc, sDBCol, false, vRow.get(4), String.valueOf(npTblidx), sRG_ORD);
        }
    }

    public void addDate(String spDBTbl, String spDBTblDesc, String spDBTblCol) {
        this.vivShortName.add("");
        this.vivLongName.add("");
        this.vivPRgidx.add(String.valueOf(0));
        this.vivRgidx.add(String.valueOf(0));
        this.vivDBTbl.add(spDBTbl);
        this.vivDBTblDesc.add(spDBTblDesc);
        this.vivDBTblCol.add(spDBTblCol);
        this.vivParent.add("false");
        this.vivCacheidx.add(String.valueOf(0));
        this.vivExtraTables.add("");
        this.vivExtraWhere.add("");
        this.vivValIDX.add("");
        this.addCacheInfo(0L, "", "");
        this.addARow();
    }

    public void addCache(long npCacheidx, String spDBTbl, String spDBTblDesc, String spDBTblCol, String spExtraTables, String spExtraWhere) {
        this.addCache(npCacheidx, spDBTbl, spDBTblDesc, spDBTblCol, spExtraTables, spExtraWhere, false);
    }

    public void addCache(long npCacheidx, String spDBTbl, String spDBTblDesc, String spDBTblCol, String spExtraTables, String spExtraWhere, boolean bpMand) {
        Vector<Vector<String>> vTmp;
        String sSql = "SELECT NAME FROM \"CACHE\" WHERE CACHEIDX = " + npCacheidx;
        if (!BUtils.queryStmt(this.connivDB, sSql, 1, vTmp = new Vector<Vector<String>>())) {
            return;
        }
        this.vivShortName.add(vTmp.elementAt(0).elementAt(0));
        this.vivLongName.add(vTmp.elementAt(0).elementAt(0));
        if (bpMand) {
            this.vivMand.add("1");
        } else {
            this.vivMand.add("0");
        }
        this.vivPRgidx.add("0");
        this.vivRgidx.add("0");
        this.vivDBTbl.add(spDBTbl);
        this.vivDBTblDesc.add(spDBTblDesc);
        this.vivDBTblCol.add(spDBTblCol);
        this.vivParent.add("false");
        this.vivCacheidx.add(String.valueOf(npCacheidx));
        this.vivExtraTables.add(spExtraTables);
        this.vivExtraWhere.add(spExtraWhere);
        this.vivValIDX.add("");
        this.addCacheInfo(npCacheidx, spExtraTables, spExtraWhere);
        this.addARow();
    }

    private void addCacheInfo(long npCacheidx, String spExtraTables, String spExtraWhere) {
        String sKeyCol = "";
        String sCodeCol = "";
        String sSel = "";
        String sFrom = "";
        String sWhere = "";
        if (npCacheidx > 0L) {
            try {
                this.cacher.getCProvider().loadCacheSql(npCacheidx, "", "", "");
                sKeyCol = this.cacher.getCProvider().getUniqueidxName(npCacheidx);
                sCodeCol = this.cacher.getCProvider().getColName(1L, npCacheidx);
                sSel = this.cacher.getCProvider().getCacheSelect(npCacheidx, "", spExtraTables, spExtraWhere);
                sFrom = this.cacher.getCProvider().getCacheFrom(npCacheidx, "", spExtraTables, spExtraWhere);
                sWhere = this.cacher.getCProvider().getCacheWhere(npCacheidx, "", spExtraTables, spExtraWhere);
            }
            catch (Exception e) {
                Utils.logError(e);
            }
        }
        this.vivCacheKeyCol.add(sKeyCol);
        this.vivCacheCodeCol.add(sCodeCol);
        this.vivCacheSel.add(sSel);
        this.vivCacheFrom.add(sFrom);
        this.vivCacheWhere.add(sWhere);
    }

    private void addARow() {
        this.addNewRow();
        int row = this.getLastRow();
        String sTmp = this.vivDBTblDesc.get(row).toString();
        if (!sTmp.equals("")) {
            sTmp = sTmp + " ";
        }
        sTmp = sTmp + this.vivShortName.get(row).toString();
        this.setRowHdrValueAt(sTmp, row);
        this.setCellValueAt("", row, "colVal");
    }

    public void clear() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            this.setCellValueAt("", row, "colVal");
            this.vivValIDX.set(row, "");
        }
    }

    private void this_actionSearch(int row, int col) {
        if (this.connivDB == null || this.cacher == null || this.searchField == null) {
            return;
        }
        int cacheidx = 0;
        if (this.vivCacheidx.get(row) == null) {
            return;
        }
        String sTables = "";
        if (this.vivExtraTables.get(row) != null) {
            sTables = this.vivExtraTables.get(row).toString();
        }
        String sWhere = "";
        if (this.vivExtraWhere.get(row) != null) {
            sWhere = this.vivExtraWhere.get(row).toString();
        }
        if ((cacheidx = TypConv.toInt(this.vivCacheidx.get(row).toString())) <= 0) {
            if (this.getColumnName(col).equals("colVal")) {
                this.vivValIDX.set(row, this.getCellValueAt(row, "colVal"));
            }
            return;
        }
        this.searchField.setVal(this.getCellValueAt(row, col));
        this.searchField.setidxStr(this.vivValIDX.get(row));
        this.searchField.setCache(this.cacher, cacheidx, "", sTables, sWhere, false);
        this.searchField.doSearch("");
        this.setCellValueAt(this.searchField.getText(), row, col);
        if (this.getColumnName(col).equals("colVal")) {
            this.vivValIDX.set(row, this.searchField.getidxStr());
        }
    }

    private void this_actionValidate(int row, int col) {
        if (this.connivDB == null || this.cacher == null || this.searchField == null) {
            return;
        }
        int cacheidx = 0;
        if (this.vivCacheidx.get(row) == null) {
            return;
        }
        String sTables = "";
        if (this.vivExtraTables.get(row) != null) {
            sTables = this.vivExtraTables.get(row).toString();
        }
        String sWhere = "";
        if (this.vivExtraWhere.get(row) != null) {
            sWhere = this.vivExtraWhere.get(row).toString();
        }
        if ((cacheidx = TypConv.toInt(this.vivCacheidx.get(row).toString())) <= 0) {
            if (this.getColumnName(col).equals("colVal")) {
                this.vivValIDX.set(row, this.getCellValueAt(row, "colVal"));
            }
            return;
        }
        String newValue = this.getCellValueAt(row, col);
        if (!this.searchField.getText().equals(StringUtils.nullToEmpty(newValue))) {
            this.searchField.setVal(newValue);
            this.searchField.setidxStr(this.vivValIDX.get(row));
            this.searchField.setCache(this.cacher, cacheidx, "", sTables, sWhere, false);
            if (!this.searchField.doValidate()) {
                if (this.getColumnName(col).equals("colVal")) {
                    this.setCellValueAt("", row, col);
                    this.vivValIDX.set(row, "");
                }
                return;
            }
        }
        this.requestFocus();
        this.setCellValueAt(this.searchField.getText(), row, col);
        if (this.getColumnName(col).equals("colVal")) {
            this.vivValIDX.set(row, this.searchField.getidxStr());
        }
    }
}

