/*
 * Decompiled with CFR 0.152.
 */
package jpos.basscom.swing;

import java.awt.Container;
import java.awt.Window;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ResourceBundle;
import java.util.Vector;
import jpos.PosDateFormatter;
import jpos.StringUtils;
import jpos.basscom.cache.Cacher;
import jpos.basscom.components.ToServ;
import jpos.basscom.swing.BJDateField;
import jpos.basscom.swing.BJTable;
import jpos.basscom.swing.BJTextField;
import jpos.basscom.swing.BUtils;
import jpos.basscom.swing.event.BTblSearchListener;
import jpos.basscom.swing.event.BTblValidateListener;
import jpos.basscom.utils.TypConv;
import jpos.basscom.utils.Utils;

public class BJTableSel
extends BJTable {
    static ResourceBundle res = ResourceBundle.getBundle("TransJavaCommon");
    private Connection connivDB;
    private Cacher cacher;
    private ToServ toserv;
    private BJTextField searchField;
    private boolean isBusy = false;
    private boolean usingLongName = false;
    private boolean isValidationOk = true;
    private Vector<String> vivDBTbl = new Vector();
    private Vector<String> vivDBTblDesc = new Vector();
    private Vector<String> vivDBTblCol = new Vector();
    private Vector<String> vivRgidx = new Vector();
    private Vector<String> vivPRgidx = new Vector();
    private Vector<String> vivParent = new Vector();
    private Vector<String> vivShortName = new Vector();
    private Vector<String> vivLongName = new Vector();
    private Vector<String> vivCacheidx = new Vector();
    private Vector<String> vivExtraTables = new Vector();
    private Vector<String> vivExtraWhere = new Vector();
    private Vector<String> vivFromIDX = new Vector();
    private Vector<String> vivToIDX = new Vector();
    private Vector<String> vivInclIDX = new Vector();
    private Vector<String> vivExclIDX = new Vector();
    private Vector<String> vivCacheKeyCol = new Vector();
    private Vector<String> vivCacheKeyColType = new Vector();
    private Vector<String> vivCacheCodeCol = new Vector();
    private Vector<String> vivCacheCodeColType = new Vector();
    private Vector<String> vivCacheSel = new Vector();
    private Vector<String> vivCacheFrom = new Vector();
    private Vector<String> vivCacheWhere = new Vector();
    private Vector<String> vivTable = new Vector();
    private Vector<String> vivWhere = new Vector();

    public BJTableSel(int pDBType) {
        super(pDBType);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    public BJTableSel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            Utils.logError(e);
        }
    }

    private void jbInit() throws Exception {
        this.addBTblValidateListener(new BTblValidateListener(){

            @Override
            public void actionValidate(int row, int col) {
                BJTableSel.this.isValidationOk = BJTableSel.this.this_actionValidate(row, col);
            }
        });
        this.addBTblSearchListener(new BTblSearchListener(){

            @Override
            public void actionSearch(int row, int col) {
                BJTableSel.this.isValidationOk = BJTableSel.this.this_actionSearch(row, col);
            }

            @Override
            public void actionShiftSearch(int row, int col) {
            }
        });
        this.setupTable();
    }

    public void setToServ(ToServ toserv) {
        this.toserv = toserv;
    }

    public void setCacher(Cacher cacher) {
        this.cacher = cacher;
    }

    public void setConnection(Connection connDB) {
        this.connivDB = connDB;
    }

    public void setSearchField(BJTextField searchField) {
        this.searchField = searchField;
    }

    public void setUsingLongName(boolean useLongName) {
        this.usingLongName = useLongName;
    }

    private void setupTable() {
        String[] saColumnName = new String[TableColumn.values().length];
        String[] saColumnTitle = new String[TableColumn.values().length];
        int[] naColumnAlignment = new int[TableColumn.values().length];
        int[] naColumnWidth = new int[TableColumn.values().length];
        int[] naColumnType = new int[TableColumn.values().length];
        for (TableColumn col : TableColumn.values()) {
            saColumnName[((TableColumn)col).index] = col.name;
            saColumnTitle[((TableColumn)col).index] = col.title;
            naColumnAlignment[((TableColumn)col).index] = col.alignment;
            naColumnWidth[((TableColumn)col).index] = col.width;
            naColumnType[((TableColumn)col).index] = col.type;
        }
        this.setUp(saColumnName, saColumnTitle, naColumnAlignment, naColumnWidth, naColumnType, TableColumn.values().length, false, true, false);
    }

    public void addRefGrp(long npRgidx, String spDBTbl, String spDBTblDesc, String spDBTblCol) {
        this.addRefGrp(npRgidx, spDBTbl, spDBTblDesc, spDBTblCol, false, 0L, 0L);
    }

    public void addRefGrp(long npRgidx, String spDBTbl, String spDBTblDesc, String spDBTblCol, long npSecTblIdx, long npWidx) {
        this.addRefGrp(npRgidx, spDBTbl, spDBTblDesc, spDBTblCol, false, npSecTblIdx, npWidx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addRefGrp(long npRgidx, String spDBTbl, String spDBTblDesc, String spDBTblCol, boolean bParent, long npSecTblIdx, long npWidx) {
        Vector<Vector<String>> vTmp;
        String sExtraWhere = "";
        String sSql = "SELECT REFGRP.S_NAME, REFGRP.L_NAME, COALESCE(REFGRP.RPGIDX,0) FROM REFGRP WHERE REFGRP.RGIDX = " + npRgidx;
        if (!BUtils.queryStmt(this.connivDB, sSql, 3, vTmp = new Vector<Vector<String>>())) {
            return;
        }
        if (vTmp.size() == 0) {
            return;
        }
        this.vivShortName.add(vTmp.get(0).get(0));
        this.vivLongName.add(vTmp.get(0).get(1));
        this.vivPRgidx.add(vTmp.get(0).get(2));
        if (bParent) {
            this.vivParent.add("true");
        } else {
            this.vivParent.add("false");
        }
        long nParentRgidx = 0L;
        if (vTmp.get(0).get(2) != null) {
            nParentRgidx = TypConv.toLong(vTmp.get(0).get(2));
        }
        this.vivRgidx.add(String.valueOf(npRgidx));
        this.vivDBTbl.add(spDBTbl);
        this.vivDBTblDesc.add(spDBTblDesc);
        this.vivDBTblCol.add(spDBTblCol);
        this.vivCacheidx.add(String.valueOf(281));
        this.vivExtraTables.add("");
        if (npSecTblIdx > 0L) {
            Statement stmt = null;
            try {
                stmt = this.connivDB.createStatement();
                sExtraWhere = Utils.GetWhseRGSecWhereSQL(stmt, npWidx, npRgidx, Utils.getWorkgroupTypeForRefObject((int)npSecTblIdx), "R");
            }
            catch (Exception e) {
                Utils.logError(e);
            }
            finally {
                Utils.closeStatement(stmt);
            }
            if (sExtraWhere != null && sExtraWhere.length() > 0) {
                sExtraWhere = " AND " + sExtraWhere;
            }
        }
        this.vivExtraWhere.add("R.\"ACTIVE\" = 1 AND R.RGIDX = " + npRgidx + " " + sExtraWhere);
        this.vivFromIDX.add("");
        this.vivToIDX.add("");
        this.vivInclIDX.add("");
        this.vivExclIDX.add("");
        this.addCacheInfo(281L, "", "R.\"ACTIVE\" = 1 AND R.RGIDX = " + npRgidx + " " + sExtraWhere);
        this.addARow();
        if (nParentRgidx > 0L) {
            this.addRefGrp(nParentRgidx, "R" + nParentRgidx, "+ " + spDBTblDesc, "RPCIDX", true, npSecTblIdx, npWidx);
        }
    }

    public void addRefObj(long npTblidx, String spDBTbl, String spDBTblDesc) {
        this.addRefObj(npTblidx, spDBTbl, spDBTblDesc, 0L, 0L);
    }

    public void addRefObj(long npTblidx, String spDBTbl, String spDBTblDesc, long npSecTblIdx, long npWidx) {
        long[] naTmp = new long[]{0L};
        String[] saTmp = new String[]{""};
        Utils.getSysParam(this.connivDB, 176L, naTmp, saTmp);
        long nBatchTrack = naTmp[0];
        Utils.getSysParam(this.connivDB, 32L, naTmp, saTmp);
        long nPackType = naTmp[0];
        String sSql = null;
        if (this.DBType == 0) {
            sSql = "SELECT T.RGIDX, T.RG_ORD+100, 'REF' || T.RG_ORD, '' FROM REFTBL T WHERE T.RGIDX > 0 AND T.TBLIDX = " + npTblidx + " " + "UNION " + "SELECT I.RGIDX, I.RG_ORD, I.COLNAME, I.EXTRA " + "FROM REFTBLINT I " + "WHERE  I.TBLIDX = " + npTblidx + " " + "ORDER BY 2";
        } else if (this.DBType == 1) {
            sSql = "SELECT T.RGIDX, CAST(T.RG_ORD+100 AS NUMERIC), CAST('REF' || T.RG_ORD AS VARCHAR(25)), CAST('' AS VARCHAR(20)) FROM REFTBL T WHERE T.RGIDX > 0 AND T.TBLIDX = " + npTblidx + " " + "UNION " + "SELECT I.RGIDX, I.RG_ORD, I.COLNAME, I.EXTRA " + "FROM REFTBLINT I " + "WHERE  I.TBLIDX = " + npTblidx + " " + "ORDER BY 2";
        }
        Vector<Vector<String>> vTmp = new Vector<Vector<String>>();
        if (!BUtils.queryStmt(this.connivDB, sSql, 4, vTmp)) {
            return;
        }
        for (Vector<String> vRow : vTmp) {
            long nRgidx = 0L;
            if (vRow.get(0) != null) {
                nRgidx = TypConv.toLong(vRow.get(0));
            }
            String sDBCol = "";
            if (vRow.get(2) != null) {
                sDBCol = vRow.get(2);
            }
            String sExtra = "";
            if (vRow.get(3) != null) {
                sExtra = vRow.get(3);
            }
            if (!sExtra.equals("")) {
                sDBCol = sExtra + " " + sDBCol;
            }
            if (nRgidx == 29L && nPackType == 0L || nRgidx == 315L && nBatchTrack == 0L) continue;
            this.addRefGrp(nRgidx, spDBTbl, spDBTblDesc, sDBCol, npSecTblIdx, npWidx);
        }
    }

    public void addDate(String spDBTbl, String spDBTblDesc, String spDBTblCol) {
        this.vivShortName.add("");
        this.vivLongName.add("");
        this.vivPRgidx.add(String.valueOf(0));
        this.vivRgidx.add(String.valueOf(0));
        this.vivDBTbl.add(spDBTbl);
        this.vivDBTblDesc.add(spDBTblDesc);
        this.vivDBTblCol.add(spDBTblCol);
        this.vivParent.add("false");
        this.vivCacheidx.add(String.valueOf(0));
        this.vivExtraTables.add("");
        this.vivExtraWhere.add("");
        this.vivFromIDX.add("");
        this.vivToIDX.add("");
        this.vivInclIDX.add("");
        this.vivExclIDX.add("");
        this.addCacheInfo(0L, "", "");
        this.addARow();
    }

    public void addCache(long npCacheidx, String spDBTbl, String spDBTblDesc, String spDBTblCol, String spExtraTables, String spExtraWhere) {
        Vector<Vector<String>> vTmp;
        String sSql = "SELECT NAME FROM \"CACHE\" WHERE CACHEIDX = " + npCacheidx;
        if (!BUtils.queryStmt(this.connivDB, sSql, 1, vTmp = new Vector<Vector<String>>())) {
            return;
        }
        if (vTmp.size() > 0) {
            this.vivShortName.add(vTmp.get(0).get(0));
            this.vivLongName.add(vTmp.get(0).get(0));
            this.vivPRgidx.add(String.valueOf(0));
            this.vivRgidx.add(String.valueOf(0));
            this.vivDBTbl.add(spDBTbl);
            this.vivDBTblDesc.add(spDBTblDesc);
            this.vivDBTblCol.add(spDBTblCol);
            this.vivParent.add("false");
            this.vivCacheidx.add(String.valueOf(npCacheidx));
            this.vivExtraTables.add(spExtraTables);
            this.vivExtraWhere.add(spExtraWhere);
            this.vivFromIDX.add("");
            this.vivToIDX.add("");
            this.vivInclIDX.add("");
            this.vivExclIDX.add("");
            this.addCacheInfo(npCacheidx, spExtraTables, spExtraWhere);
            this.addARow();
        }
    }

    private void addCacheInfo(long npCacheidx, String spExtraTables, String spExtraWhere) {
        String sKeyCol = "";
        String sCodeCol = "";
        String sKeyColType = "D";
        String sCodeColType = "D";
        String sSel = "";
        String sFrom = "";
        String sWhere = "";
        if (npCacheidx > 0L) {
            try {
                this.cacher.getCProvider().loadCacheSql(npCacheidx, "", "", "");
                sKeyCol = this.cacher.getCProvider().getUniqueidxName(npCacheidx);
                sCodeCol = this.cacher.getCProvider().getColName(1L, npCacheidx);
                sSel = this.cacher.getCProvider().getCacheSelect(npCacheidx, "", spExtraTables, spExtraWhere);
                sFrom = this.cacher.getCProvider().getCacheFrom(npCacheidx, "", spExtraTables, spExtraWhere);
                sWhere = this.cacher.getCProvider().getCacheWhere(npCacheidx, "", spExtraTables, spExtraWhere);
                String sTmp1 = sKeyCol.trim();
                int nTmp = sTmp1.indexOf(".");
                if (nTmp > -1) {
                    sTmp1 = sTmp1.substring(nTmp + 1);
                }
                String sSql = "SELECT CT.TBLNAME FROM   \"CACHE\" C, CACHE_TBL CT WHERE  C.CACHEIDX = " + npCacheidx + " AND " + "C.KEYTBLIDX = CT.CTBLIDX";
                String sTmp2 = "";
                Vector<Vector<String>> vTmp = new Vector<Vector<String>>();
                if (BUtils.queryStmt(this.connivDB, sSql, 1, vTmp)) {
                    sTmp2 = vTmp.get(0).get(0);
                }
                sKeyColType = this.toserv != null ? "N" : BUtils.getColumnType(this.connivDB, sTmp2, sTmp1);
                sTmp1 = sCodeCol.trim();
                nTmp = sTmp1.indexOf(".");
                if (nTmp > -1) {
                    sTmp1 = sTmp1.substring(nTmp + 1);
                }
                sSql = "SELECT CT.TBLNAME FROM   \"CACHE\" C, CACHE_TBL CT WHERE  C.CACHEIDX = " + npCacheidx + " AND " + "C.CODETBLIDX = CT.CTBLIDX";
                sTmp2 = "";
                if (BUtils.queryStmt(this.connivDB, sSql, 1, vTmp)) {
                    sTmp2 = vTmp.get(0).get(0);
                }
                sCodeColType = this.toserv != null ? "S" : BUtils.getColumnType(this.connivDB, sTmp2, sTmp1);
            }
            catch (Exception e) {
                Utils.logError(e);
            }
        }
        this.vivCacheKeyCol.add(sKeyCol);
        this.vivCacheKeyColType.add(sKeyColType);
        this.vivCacheCodeCol.add(sCodeCol);
        this.vivCacheCodeColType.add(sCodeColType);
        this.vivCacheSel.add(sSel);
        this.vivCacheFrom.add(sFrom);
        this.vivCacheWhere.add(sWhere);
    }

    private void addARow() {
        this.addNewRow();
        int row = this.getLastRow();
        String sTmp = this.vivDBTblDesc.get(row).toString();
        if (!sTmp.equals("")) {
            sTmp = sTmp + " ";
        }
        sTmp = sTmp + (this.usingLongName ? this.vivLongName.get(row).toString() : this.vivShortName.get(row).toString());
        this.setRowHdrValueAt(sTmp, row);
        this.setCellValueAt("", row, TableColumn.FROM.name);
        this.setCellValueAt("", row, TableColumn.TO.name);
        this.setCellValueAt("true", row, TableColumn.NULLS.name);
    }

    public void clear() {
        for (int row = 0; row < this.getRowCount(); ++row) {
            this.setCellValueAt("", row, TableColumn.FROM.name);
            this.vivFromIDX.set(row, "");
            this.setCellValueAt("", row, TableColumn.TO.name);
            this.vivToIDX.set(row, "");
            this.setCellValueAt("", row, TableColumn.INCLUDE.name);
            this.vivInclIDX.set(row, "");
            this.setCellValueAt("", row, TableColumn.EXCLUDE.name);
            this.vivExclIDX.set(row, "");
            this.setCellValueAt("true", row, TableColumn.NULLS.name);
            this.vivTable.clear();
            this.vivWhere.clear();
        }
    }

    public void extract(int sqlFormat) {
        this.vivWhere.clear();
        this.vivWhere.setSize(this.getRowCount());
        this.vivTable.clear();
        for (int row = this.getRowCount() - 1; row > -1; --row) {
            this.extract(row, sqlFormat);
        }
    }

    public String getWhere() {
        String sWhere = "";
        String sTmpWhere = "";
        for (int row = 0; row < this.vivWhere.size(); ++row) {
            if (TypConv.toBoolean(this.vivParent.get(row).toString()) || (sTmpWhere = this.vivWhere.get(row).toString()).equals("")) continue;
            sWhere = sWhere.equals("") ? "(" + sTmpWhere + ")" : sWhere + " AND (" + sTmpWhere + ")";
        }
        return sWhere;
    }

    public String getWhere(String spDBTbl) {
        String sWhere = "";
        String sTmpWhere = "";
        for (int row = 0; row < this.vivWhere.size(); ++row) {
            if (TypConv.toBoolean(this.vivParent.get(row).toString()) || !this.vivDBTbl.get(row).toString().equals(spDBTbl) || (sTmpWhere = this.vivWhere.get(row).toString()).equals("")) continue;
            sWhere = sWhere.equals("") ? "(" + sTmpWhere + ")" : sWhere + " AND (" + sTmpWhere + ")";
        }
        return sWhere;
    }

    public String getReadableSelections() {
        String sWhere = "";
        String sExc = "";
        for (int row = 0; row < this.getRowCount(); ++row) {
            String sRowHdr = this.getCellValueAt(row, TableColumn.ROW_HEADER.name).trim();
            String sFrom = this.getCellValueAt(row, TableColumn.FROM.name).trim();
            String sTo = this.getCellValueAt(row, TableColumn.TO.name).trim();
            String sInc = this.getCellValueAt(row, TableColumn.INCLUDE.name).trim();
            sExc = this.getCellValueAt(row, TableColumn.EXCLUDE.name).trim();
            if (!(sFrom != null && sFrom.length() > 0 || sTo != null && sTo.length() > 0 || sInc != null && sInc.length() > 0) && (sExc == null || sExc.length() <= 0)) continue;
            if (sWhere.length() > 0) {
                sWhere = sWhere + "\n";
            }
            sWhere = sWhere + sRowHdr + " ";
            if (sFrom != null && sFrom.length() > 0) {
                sWhere = sWhere + res.getString("From") + ": " + sFrom + " ";
            }
            if (sTo != null && sTo.length() > 0) {
                sWhere = sWhere + res.getString("To") + ": " + sTo + " ";
            }
            if (sInc != null && sInc.length() > 0) {
                sWhere = sFrom != null && sFrom.length() > 0 || sTo != null && sTo.length() > 0 ? sWhere + res.getString("Including") + ": " + sInc + " " : sWhere + sInc + " ";
            }
            if (sExc == null || sExc.length() <= 0) continue;
            sWhere = sWhere + res.getString("Excluding") + ": " + sExc + " ";
        }
        return sWhere;
    }

    public String getTables() {
        String sTable = "";
        for (int cnt = 0; cnt < this.vivTable.size(); ++cnt) {
            if (!sTable.equals("")) {
                sTable = sTable + ", ";
            }
            sTable = sTable + this.vivTable.get(cnt).toString();
        }
        return sTable;
    }

    private void extract(int row, int sqlFormat) {
        String sTmp;
        String sFrom = this.getCellValueAt(row, TableColumn.FROM.name);
        String sTo = this.getCellValueAt(row, TableColumn.TO.name);
        String sInclIDX = "";
        if (this.vivInclIDX.get(row) != null) {
            sInclIDX = this.vivInclIDX.get(row).toString();
        }
        String sExclIDX = "";
        if (this.vivExclIDX.get(row) != null) {
            sExclIDX = this.vivExclIDX.get(row).toString();
        }
        boolean bNull = TypConv.toBoolean(this.getCellValueAt(row, TableColumn.NULLS.name).toString());
        String sCKeyCol = this.vivCacheKeyCol.get(row).toString();
        String sCKeyColType = this.vivCacheKeyColType.get(row).toString();
        String sCCodeCol = this.vivCacheCodeCol.get(row).toString();
        String sCCodeColType = this.vivCacheCodeColType.get(row).toString();
        String sCFrom = this.vivCacheFrom.get(row).toString();
        String sCWhere = this.vivCacheWhere.get(row).toString();
        String sDBTbl = this.vivDBTbl.get(row).toString();
        String sDBTblCol = this.vivDBTblCol.get(row).toString();
        if (!sDBTbl.equals("")) {
            sDBTblCol = sDBTbl + "." + sDBTblCol;
        }
        boolean bParentExists = false;
        if (TypConv.toLong(this.vivPRgidx.get(row).toString()) > 0L && row + 1 < this.getRowCount() && TypConv.toLong(this.vivPRgidx.get(row).toString()) == TypConv.toLong(this.vivRgidx.get(row + 1).toString()) && !this.vivWhere.get(row + 1).toString().equals("")) {
            bParentExists = true;
        }
        boolean bParent = TypConv.toBoolean(this.vivParent.get(row).toString());
        String sWhere = "";
        if (!sFrom.equals("") || !sTo.equals("")) {
            if (sCKeyColType.equals("N") || sCKeyColType.equals("S")) {
                sWhere = sDBTblCol + " IN (";
                sWhere = sWhere + "SELECT DISTINCT " + sCKeyCol + " " + "FROM " + sCFrom;
                sWhere = sCWhere.equals("") ? sWhere + "WHERE" : sWhere + " " + sCWhere;
                if (!sFrom.equals("")) {
                    if (sCCodeColType.equals("D")) {
                        sFrom = Utils.StrToDBX(this.convertDateToInternal(sFrom));
                    } else if (sCCodeColType.equals("S")) {
                        sFrom = Utils.StrToDBX(sFrom);
                    }
                    if (!sWhere.equals("")) {
                        sWhere = sWhere + " AND";
                    }
                    sWhere = sCCodeColType.equals("D") ? (sqlFormat == 0 ? sWhere + " TRUNC_DATE(" + sCCodeCol + ") >= TO_DATE(" + sFrom + ",'YYYY-MM-DD')" : sWhere + " TRUNC_DATE(" + sCCodeCol + ") >= CAST(" + sFrom + " AS DATE)") : sWhere + " " + sCCodeCol + " >= " + sFrom;
                }
                if (!sTo.equals("")) {
                    if (sCCodeColType.equals("D")) {
                        sTo = Utils.StrToDBX(this.convertDateToInternal(sTo));
                    } else if (sCCodeColType.equals("S")) {
                        sTo = Utils.StrToDBX(sTo);
                    }
                    if (!sWhere.equals("")) {
                        sWhere = sWhere + " AND";
                    }
                    sWhere = sCCodeColType.equals("D") ? (sqlFormat == 0 ? sWhere + " TRUNC_DATE(" + sCCodeCol + ") <= TO_DATE(" + sTo + ",'YYYY-MM-DD')" : sWhere + " TRUNC_DATE(" + sCCodeCol + ") <= CAST(" + sTo + " AS DATE)") : sWhere + " " + sCCodeCol + " <= " + sTo;
                }
                sWhere = sWhere + ")";
            } else if (sCKeyColType.equals("D")) {
                if (!sFrom.equals("")) {
                    sFrom = Utils.StrToDBX(this.convertDateToInternal(sFrom));
                    sWhere = sqlFormat == 0 ? sWhere + " TRUNC_DATE(" + sDBTblCol + ") >= TO_DATE(" + sFrom + ",'YYYY-MM-DD')" : sWhere + " TRUNC_DATE(" + sDBTblCol + ") >= CAST(" + sFrom + " AS DATE)";
                }
                if (!sTo.equals("")) {
                    if (!sWhere.equals("")) {
                        sWhere = sWhere + " AND";
                    }
                    sTo = Utils.StrToDBX(this.convertDateToInternal(sTo));
                    sWhere = sqlFormat == 0 ? sWhere + " TRUNC_DATE(" + sDBTblCol + ") <= TO_DATE(" + sTo + ",'YYYY-MM-DD')" : sWhere + " TRUNC_DATE(" + sDBTblCol + ") <= CAST(" + sTo + " AS DATE)";
                }
            }
        }
        if (!sInclIDX.equals("")) {
            sTmp = "";
            if (sCKeyColType.equals("N")) {
                sTmp = sInclIDX;
            } else if (sCKeyColType.equals("S")) {
                sTmp = Utils.StrToDBX(sInclIDX);
            } else if (sCKeyColType.equals("D")) {
                sTmp = Utils.StrToDBX(this.convertDateToInternal(sInclIDX));
                sTmp = sqlFormat == 0 ? "TO_DATE(" + sTmp + ",'YYYY-MM-DD')" : "CAST(" + sTmp + " AS DATE)";
            }
            sTmp = sInclIDX.indexOf(",") == -1 ? " = " + sTmp : " IN (" + sTmp + ")";
            sWhere = sWhere.equals("") ? (sCKeyColType.equals("D") ? "TRUNC_DATE(" + sDBTblCol + ") " + sTmp : sDBTblCol + sTmp) : (sCKeyColType.equals("D") ? "(" + sWhere + ") OR TRUNC_DATE(" + sDBTblCol + ") " + sTmp : (bParent ? "(" + sWhere + " OR " + sDBTblCol + sTmp + ")" : "(" + sWhere + ") OR " + sDBTblCol + sTmp));
        }
        if (!sExclIDX.equals("")) {
            sTmp = "";
            if (sCKeyColType.equals("N")) {
                sTmp = sExclIDX;
            } else if (sCKeyColType.equals("S")) {
                sTmp = Utils.StrToDBX(sExclIDX);
            } else if (sCKeyColType.equals("D")) {
                sTmp = Utils.StrToDBX(this.convertDateToInternal(sExclIDX));
                sTmp = sqlFormat == 0 ? "TO_DATE(" + sTmp + ",'YYYY-MM-DD')" : "CAST(" + sTmp + " AS DATE)";
            }
            sTmp = sExclIDX.indexOf(",") == -1 ? " != " + sTmp : " NOT IN (" + sTmp + ")";
            sWhere = sWhere.equals("") ? (sCKeyColType.equals("D") ? "TRUNC_DATE(" + sDBTblCol + ") " + sTmp : sDBTblCol + sTmp) : (sCKeyColType.equals("D") ? "(" + sWhere + ") AND TRUNC_DATE(" + sDBTblCol + ") " + sTmp : "(" + sWhere + ") AND " + sDBTblCol + sTmp);
        }
        if (bNull) {
            if (!sWhere.equals("")) {
                sWhere = "(" + sWhere + ") OR " + sDBTblCol + " IS NULL";
            }
        } else if (sWhere.equals("")) {
            sWhere = sDBTblCol + " IS NOT NULL";
        }
        if (bParentExists) {
            String sPDBTbl = this.vivDBTbl.get(row + 1).toString();
            String sPWhere = this.vivWhere.get(row + 1).toString();
            if (!sWhere.equals("")) {
                sWhere = sWhere + " AND ";
            }
            sWhere = sWhere + sDBTblCol + " IN (SELECT " + sPDBTbl + ".RCIDX FROM REFCODE " + sPDBTbl + " WHERE " + sPDBTbl + ".\"ACTIVE\" = 1 AND " + sPWhere + ")";
        }
        this.vivWhere.set(row, sWhere);
        if (!sWhere.equals("") && this.vivTable.indexOf(sDBTbl) == -1) {
            this.vivTable.add(sDBTbl);
        }
    }

    private void setNull(int row) {
        String sFrom = this.getCellValueAt(row, TableColumn.FROM.name);
        String sTo = this.getCellValueAt(row, TableColumn.TO.name);
        String sInclIDX = "";
        if (this.vivInclIDX.get(row) != null) {
            sInclIDX = this.vivInclIDX.get(row).toString();
        }
        String sExclIDX = "";
        if (this.vivExclIDX.get(row) != null) {
            sExclIDX = this.vivExclIDX.get(row).toString();
        }
        if (sFrom.equals("") && sTo.equals("") && sInclIDX.equals("") && sExclIDX.equals("")) {
            this.setCellValueAt("true", row, TableColumn.NULLS.name);
        } else if (sFrom.equals("") && sTo.equals("") && sInclIDX.equals("") && !sExclIDX.equals("")) {
            this.setCellValueAt("true", row, TableColumn.NULLS.name);
        } else {
            this.setCellValueAt("false", row, TableColumn.NULLS.name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean this_actionSearch(int row, int col) {
        if (this.isBusy) {
            return false;
        }
        this.isBusy = true;
        try {
            Container parent2;
            String val;
            String sCodeColType;
            if (this.connivDB == null || this.cacher == null || this.searchField == null) {
                boolean bl = true;
                return bl;
            }
            if (this.getColumnName(col).equals(TableColumn.NULLS.name)) {
                boolean bl = true;
                return bl;
            }
            long cacheidx = 0L;
            if (this.vivCacheidx.get(row) == null) {
                boolean bl = true;
                return bl;
            }
            String sTables = "";
            if (this.vivExtraTables.get(row) != null) {
                sTables = this.vivExtraTables.get(row).toString();
            }
            String sWhere = "";
            if (this.vivExtraWhere.get(row) != null) {
                sWhere = this.vivExtraWhere.get(row).toString();
            }
            if ((sCodeColType = this.vivCacheCodeColType.get(row).toString()).equals("D") && !(val = BJDateField.search(parent2 = this.searchField.getTopLevelAncestor(), this.getCellValueAt(row, col))).equals("")) {
                this.setCellValueAt(val, row, col);
            }
            if ((cacheidx = TypConv.toLong(this.vivCacheidx.get(row).toString())) <= 0L) {
                if (this.getColumnName(col).equals(TableColumn.FROM.name)) {
                    this.vivFromIDX.set(row, this.getCellValueAt(row, TableColumn.FROM.name));
                } else if (this.getColumnName(col).equals(TableColumn.TO.name)) {
                    this.vivToIDX.set(row, this.getCellValueAt(row, TableColumn.TO.name));
                } else if (this.getColumnName(col).equals(TableColumn.INCLUDE.name)) {
                    this.vivInclIDX.set(row, this.getCellValueAt(row, TableColumn.INCLUDE.name));
                } else if (this.getColumnName(col).equals(TableColumn.EXCLUDE.name)) {
                    this.vivExclIDX.set(row, this.getCellValueAt(row, TableColumn.EXCLUDE.name));
                }
                this.setNull(row);
                boolean parent2 = true;
                return parent2;
            }
            this.searchField.setVal(this.getCellValueAt(row, col));
            if (this.getColumnName(col).equals(TableColumn.FROM.name)) {
                this.searchField.setidxStr(this.vivFromIDX.get(row));
            } else if (this.getColumnName(col).equals(TableColumn.TO.name)) {
                this.searchField.setidxStr(this.vivToIDX.get(row));
            } else if (this.getColumnName(col).equals(TableColumn.INCLUDE.name)) {
                this.searchField.setidxStr(this.vivInclIDX.get(row));
            } else if (this.getColumnName(col).equals(TableColumn.EXCLUDE.name)) {
                this.searchField.setidxStr(this.vivExclIDX.get(row));
            }
            if (this.getColumnName(col).equals(TableColumn.INCLUDE.name) || this.getColumnName(col).equals(TableColumn.EXCLUDE.name)) {
                this.searchField.setCache(this.cacher, this.toserv, cacheidx, "", sTables, sWhere, true);
            } else {
                this.searchField.setCache(this.cacher, this.toserv, cacheidx, "", sTables, sWhere, false);
            }
            String oldVal = this.searchField.getText();
            this.searchField.doSearch("");
            if (oldVal.equals(this.searchField.getText())) {
                this.setCellValueAt("", row, col);
                this.setCellFocus(row, col);
                boolean bl = false;
                return bl;
            }
            this.setCellValueAt(this.searchField.getText(), row, col);
            if (this.getColumnName(col).equals(TableColumn.FROM.name)) {
                this.vivFromIDX.set(row, this.searchField.getidxStr());
            } else if (this.getColumnName(col).equals(TableColumn.TO.name)) {
                this.vivToIDX.set(row, this.searchField.getidxStr());
            } else if (this.getColumnName(col).equals(TableColumn.INCLUDE.name)) {
                this.vivInclIDX.set(row, this.searchField.getidxStr());
            } else if (this.getColumnName(col).equals(TableColumn.EXCLUDE.name)) {
                this.vivExclIDX.set(row, this.searchField.getidxStr());
            }
            this.setNull(row);
            boolean bl = true;
            return bl;
        }
        finally {
            this.isBusy = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean this_actionValidate(int row, int col) {
        if (this.isBusy) {
            return false;
        }
        this.isBusy = true;
        try {
            if (this.connivDB == null || this.cacher == null || this.searchField == null) {
                boolean bl = true;
                return bl;
            }
            if (this.getColumnName(col).equals(TableColumn.NULLS.name)) {
                boolean bl = true;
                return bl;
            }
            long cacheidx = 0L;
            if (this.vivCacheidx.get(row) == null) {
                boolean bl = true;
                return bl;
            }
            String sTables = "";
            if (this.vivExtraTables.get(row) != null) {
                sTables = this.vivExtraTables.get(row).toString();
            }
            String sWhere = "";
            if (this.vivExtraWhere.get(row) != null) {
                sWhere = this.vivExtraWhere.get(row).toString();
            }
            String sCodeColType = this.vivCacheCodeColType.get(row).toString();
            String val = "";
            if (sCodeColType.equals("D")) {
                if (!this.getCellValueAt(row, col).equals("")) {
                    Container parent = this.getTopLevelAncestor();
                    if (parent instanceof Window) {
                        val = BJDateField.validate((Window)parent, this.getCellValueAt(row, col));
                    }
                    if (val.equals("") || val.equals("INVALID")) {
                        this.setCellValueAt(val, row, col);
                        this.setCellFocus(row, col);
                        boolean bl = false;
                        return bl;
                    }
                }
                this.setCellValueAt(val, row, col);
            }
            if ((cacheidx = TypConv.toLong(this.vivCacheidx.get(row).toString())) <= 0L) {
                if (this.getColumnName(col).equals(TableColumn.FROM.name)) {
                    this.vivFromIDX.set(row, this.getCellValueAt(row, TableColumn.FROM.name));
                } else if (this.getColumnName(col).equals(TableColumn.TO.name)) {
                    this.vivToIDX.set(row, this.getCellValueAt(row, TableColumn.TO.name));
                } else if (this.getColumnName(col).equals(TableColumn.INCLUDE.name)) {
                    this.vivInclIDX.set(row, this.getCellValueAt(row, TableColumn.INCLUDE.name));
                } else if (this.getColumnName(col).equals(TableColumn.EXCLUDE.name)) {
                    this.vivExclIDX.set(row, this.getCellValueAt(row, TableColumn.EXCLUDE.name));
                }
                this.setNull(row);
                boolean parent = true;
                return parent;
            }
            String newValue = this.getCellValueAt(row, col);
            if (!this.searchField.getText().equals(StringUtils.nullToEmpty(newValue))) {
                this.searchField.setVal(newValue);
                if (this.getColumnName(col).equals(TableColumn.FROM.name)) {
                    this.searchField.setidxStr(this.vivFromIDX.get(row));
                } else if (this.getColumnName(col).equals(TableColumn.TO.name)) {
                    this.searchField.setidxStr(this.vivToIDX.get(row));
                } else if (this.getColumnName(col).equals(TableColumn.INCLUDE.name)) {
                    this.searchField.setidxStr(this.vivInclIDX.get(row));
                } else if (this.getColumnName(col).equals(TableColumn.EXCLUDE.name)) {
                    this.searchField.setidxStr(this.vivExclIDX.get(row));
                }
                if (this.getColumnName(col).equals("colInclude") || this.getColumnName(col).equals("colExclude")) {
                    this.searchField.setCache(this.cacher, this.toserv, cacheidx, "", sTables, sWhere, true);
                } else {
                    this.searchField.setCache(this.cacher, this.toserv, cacheidx, "", sTables, sWhere, false);
                }
                if (!this.searchField.doValidate()) {
                    this.setCellValueAt("", row, col);
                    this.setCellFocus(row, col);
                    boolean bl = false;
                    return bl;
                }
            }
            this.requestFocus();
            this.setCellValueAt(this.searchField.getText(), row, col);
            this.doLoseFocus();
            if (this.getColumnName(col).equals(TableColumn.FROM.name)) {
                this.vivFromIDX.set(row, this.searchField.getidxStr());
            } else if (this.getColumnName(col).equals(TableColumn.TO.name)) {
                this.vivToIDX.set(row, this.searchField.getidxStr());
            } else if (this.getColumnName(col).equals(TableColumn.INCLUDE.name)) {
                this.vivInclIDX.set(row, this.searchField.getidxStr());
            } else if (this.getColumnName(col).equals(TableColumn.EXCLUDE.name)) {
                this.vivExclIDX.set(row, this.searchField.getidxStr());
            }
            this.setNull(row);
            boolean bl = true;
            return bl;
        }
        finally {
            this.isBusy = false;
        }
    }

    public boolean isBusy() {
        return this.isBusy;
    }

    public boolean isUsingLongName() {
        return this.usingLongName;
    }

    public boolean isValidationOk() {
        return this.isValidationOk;
    }

    private String convertDateToInternal(String localeDate) {
        try {
            PosDateFormatter formatter = new PosDateFormatter(null, 3, 3, 0);
            formatter.setTimestamp(localeDate);
            return formatter.toStringInternal();
        }
        catch (Exception e) {
            Utils.logError(e);
            return "";
        }
    }

    public void hideColumn(TableColumn column) {
        if (column != null) {
            this.hideColumn(column.index);
        }
    }

    public static enum TableColumn {
        ROW_HEADER("colRowHdr", 0, res.getString("Name"), 2, 150, 0),
        FROM("colFrom", 1, res.getString("From"), 2, 100, 0),
        TO("colTo", 2, res.getString("To"), 2, 100, 0),
        INCLUDE("colIncl", 3, res.getString("Plus_Only"), 2, 100, 0),
        EXCLUDE("colExcl", 4, res.getString("Exclude"), 2, 100, 0),
        NULLS("colNull", 5, res.getString("Nulls"), 2, 30, 4);

        private final String name;
        private int index;
        private final String title;
        private final int alignment;
        private final int width;
        private final int type;

        private TableColumn(String name, int index, String title, int alignment, int width, int type) {
            this.name = name;
            this.index = index;
            this.title = title;
            this.alignment = alignment;
            this.width = width;
            this.type = type;
        }
    }
}

