/*
 * Decompiled with CFR 0.152.
 */
package jpos.coupons;

import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import java.util.Vector;
import java.util.function.Consumer;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.XMLUtils;
import jpos.coupons.Coupon;
import jpos.coupons.RedemptionFailureReason;
import org.jdom.Element;

public class CouponManager {
    private Coupon currentCoupon;
    private Vector<Coupon> coupons = new Vector();
    private String requestId;
    private boolean requestIdPending;
    private String lastError;
    private boolean cleanupNextReset;
    private String thirdPartyCouponCode;

    public CouponManager() {
        this.reset(1L, false);
    }

    public Coupon getCoupon() {
        return this.currentCoupon;
    }

    public Vector<Coupon> getCoupons() {
        return this.coupons;
    }

    public String getLastError() {
        return this.lastError;
    }

    public void setThirdPartyCouponCode(String thirdPartyCouponCode) {
        this.thirdPartyCouponCode = thirdPartyCouponCode;
    }

    public String getThirdPartyCouponCode() {
        return this.thirdPartyCouponCode;
    }

    public boolean tryRedeemCoupon(String couponCode, String perIdx, long memIdx) {
        this.currentCoupon = null;
        boolean success = this.requestRedeem(couponCode, perIdx, memIdx);
        if (success && this.currentCoupon != null && !CouponManager.checkPromoExists(this.currentCoupon.getPromoIdx())) {
            this.cancel(memIdx);
            this.lastError = SP.getRS("Coupons_PromoNotExists", "\n");
            return false;
        }
        return success;
    }

    public void reset(long memIdx) {
        this.reset(memIdx, true);
    }

    public void reset(long memIdx, boolean canCleanup) {
        try {
            this.cancel(memIdx);
            if (canCleanup && this.cleanupNextReset) {
                this.cleanup();
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
        this.currentCoupon = null;
        this.requestId = UUID.randomUUID().toString();
        this.requestIdPending = false;
    }

    public void cancel(long memIdx) {
        if (this.requestIdPending) {
            this.requestCancel(memIdx);
            if (this.requestIdPending) {
                this.cleanupNextReset = true;
            }
        }
        this.currentCoupon = null;
    }

    public boolean finalise(long vhIdx, long memIdx) {
        boolean success;
        boolean bl = success = this.currentCoupon == null || this.requestConfirm(vhIdx, memIdx, true);
        if (this.requestIdPending) {
            this.cleanupNextReset = true;
        }
        this.requestIdPending = false;
        this.reset(memIdx, false);
        return success;
    }

    public void updateThirdPartyCoupon(long vhIdx, String source) {
        if (!this.thirdPartyCouponCode.isEmpty()) {
            try {
                SqlQuery.executeUpdate(SP.sParams.conn, "UPDATE RET_TRANH SET THIRD_PARTY_COUPON_CODE = ?, THIRD_PARTY_COUPON_SOURCE = ? WHERE VHIDX = ?", this.thirdPartyCouponCode, source, vhIdx);
                this.setThirdPartyCouponCode("");
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
        }
    }

    private boolean requestRedeem(String couponCode, String perIdx, long memIdx) {
        if (!this.checkState()) {
            return false;
        }
        this.recordRequest(memIdx);
        Element response = SP.sParams.OnlineQueryProvider.getOnlineQuery("coupon_redemption_request", String.format("%s,%s,%s,%s,%s", SP.sParams.getStoreIdx(), perIdx, this.requestId, couponCode, CouponManager.getMemIdxParameter(memIdx))).getXML();
        return this.handleResponse(response, resp -> {
            this.currentCoupon = new Coupon(XMLUtils.getLongValue(response, "coupon_id"), XMLUtils.getValue(response, "coupon_code"), XMLUtils.getValue(response, "coupon_name"), XMLUtils.getLongValue(response, "coupon_campaignid"), XMLUtils.getLongValue(response, "coupon_promoidx"));
        });
    }

    public boolean requestGetCoupons(long perIdx) {
        if (!this.checkState()) {
            return false;
        }
        Element response = SP.sParams.OnlineQueryProvider.getOnlineQuery("get_coupons", String.format("%s,%s", SP.sParams.getStoreIdx(), String.valueOf(perIdx))).getXML();
        return this.handleResponse(response, resp -> {
            this.coupons = this.loadCouponsFromXml((Element)resp);
        });
    }

    private Vector<Coupon> loadCouponsFromXml(Element couponsXml) {
        if (couponsXml != null) {
            Vector<Coupon> data = new Vector<Coupon>();
            Element coupons = couponsXml.getChild("coupons");
            if (coupons != null) {
                List couponList = coupons.getChildren("coupon");
                for (Object obj : couponList) {
                    Element coupon = (Element)obj;
                    data.add(new Coupon(XMLUtils.getLongValue(coupon, "coupon_id"), XMLUtils.getValue(coupon, "coupon_code"), XMLUtils.getValue(coupon, "coupon_name"), XMLUtils.getLongValue(coupon, "coupon_campaignid"), XMLUtils.getLongValue(coupon, "coupon_promoidx"), XMLUtils.getDate(coupon, "valid_to")));
                }
                return data;
            }
        }
        return null;
    }

    private boolean requestCancel(long memIdx) {
        if (!this.checkState()) {
            return false;
        }
        Element response = SP.sParams.OnlineQueryProvider.getOnlineQuery("coupon_redemption_cancel", String.format("%s,%s", this.requestId, CouponManager.getMemIdxParameter(memIdx))).getXML();
        return this.handleResponse(response, resp -> this.flagRequestAsResolved(false));
    }

    private boolean requestConfirm(long vhidx, long memIdx, boolean updateTransaction) {
        if (updateTransaction) {
            this.updateTransaction(vhidx);
        }
        this.flagRequestForCommit(vhidx);
        if (!this.checkState()) {
            return false;
        }
        Element response = SP.sParams.OnlineQueryProvider.getOnlineQuery("coupon_redemption_confirm", String.format("%s,%s", this.requestId, CouponManager.getMemIdxParameter(memIdx))).getXML();
        return this.handleResponse(response, resp -> this.flagRequestAsResolved(true));
    }

    private boolean handleResponse(Element response, Consumer<Element> successAction) {
        if (response != null) {
            String result = XMLUtils.getValue(response, "result");
            if (result.equals("true")) {
                if (successAction != null) {
                    successAction.accept(response);
                }
                return true;
            }
            boolean expectedError = false;
            String error = XMLUtils.getValue(response, "error_code");
            if (!StringUtils.isNullOrEmpty(error)) {
                error = RedemptionFailureReason.getErrorMessage(error);
                expectedError = true;
            } else {
                error = StringUtils.nullOrEmptyToValue(XMLUtils.getValue(response, "error_message"), SP.getRS("Coupons_UnknownError"));
            }
            this.lastError = error;
            this.updateErrorOnRequest(error, expectedError);
            return false;
        }
        this.lastError = SP.getRS("Coupons_NoResponse");
        this.updateErrorOnRequest(this.lastError, false);
        return false;
    }

    private boolean checkState() {
        if (!SP.sParams.checkIConn()) {
            this.lastError = SP.getRS("Offline");
            return false;
        }
        return true;
    }

    private static String getMemIdxParameter(long memIdx) {
        return String.valueOf(memIdx > 0L ? memIdx : 1L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean checkPromoExists(long promoIdx) {
        if (promoIdx <= 0L) {
            return false;
        }
        try (SqlQuery qry = new SqlQuery(SP.sParams.conn, "SELECT 1 FROM PROMO WHERE PROIDX = ?", promoIdx);){
            boolean bl = qry.next();
            return bl;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
            return false;
        }
    }

    private void recordRequest(long memIdx) {
        this.requestIdPending = true;
        try {
            SqlQuery.executeUpdate(SP.sParams.conn, "UPDATE OR INSERT INTO COUPON_REQUEST (REQUEST_ID, LAST_REQUEST_DATE, TILL_NAME, MEMIDX, PENDING, NEEDS_COMMIT, VHIDX, CANCEL_DATE, COMMIT_DATE, LAST_ERROR, LAST_ERROR_DATE) VALUES (?, CURRENT_TIMESTAMP, ?, ?, 1, 0, NULL, NULL, NULL, NULL, NULL)", this.requestId, SP.sParams.tillnum, memIdx);
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    private void flagRequestForCommit(long vhIdx) {
        try {
            SqlQuery.executeUpdate(SP.sParams.conn, "UPDATE COUPON_REQUEST SET LAST_REQUEST_DATE = CURRENT_TIMESTAMP, NEEDS_COMMIT = 1, VHIDX = ? WHERE REQUEST_ID = ?", vhIdx, this.requestId);
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    private void updateTransaction(long vhIdx) {
        if (this.currentCoupon != null) {
            try {
                SqlQuery.executeUpdate(SP.sParams.conn, "UPDATE RET_TRANH SET COUPON_CAMPAIGN_IDX = ?, COUPON_IDX = ? WHERE VHIDX = ?", this.currentCoupon.getCampaignId(), this.currentCoupon.getId(), vhIdx);
            }
            catch (SQLException e) {
                PosUtils.logError(e);
            }
        }
    }

    private void flagRequestAsResolved(boolean committed) {
        this.requestIdPending = false;
        try {
            SqlQuery.executeUpdate(SP.sParams.conn, "UPDATE COUPON_REQUEST SET PENDING = 0, NEEDS_COMMIT = 0, " + (committed ? "COMMIT_DATE = CURRENT_TIMESTAMP " : "CANCEL_DATE = CURRENT_TIMESTAMP ") + "WHERE REQUEST_ID = ?", this.requestId);
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    private void updateErrorOnRequest(String error, boolean expectedError) {
        if (expectedError) {
            this.requestIdPending = false;
        }
        try {
            SqlQuery.executeUpdate(SP.sParams.conn, "UPDATE COUPON_REQUEST SET " + (expectedError ? "PENDING = 0, NEEDS_COMMIT = 0, " : "") + "LAST_ERROR = ?, " + "LAST_ERROR_DATE = CURRENT_TIMESTAMP " + "WHERE REQUEST_ID = ?", StringUtils.truncate(error, 4000), this.requestId);
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    private void cleanup() {
        if (!SP.sParams.checkIConn()) {
            return;
        }
        boolean failureOccurred = false;
        Coupon prevCurrentCoupon = this.currentCoupon;
        String prevRequestId = this.requestId;
        boolean prevRequestIdPending = this.requestIdPending;
        String prevLastError = this.lastError;
        try (SqlQuery qry = new SqlQuery(SP.sParams.conn, "SELECT REQUEST_ID, NEEDS_COMMIT, VHIDX, CASE WHEN LAST_REQUEST_DATE > CURRENT_TIMESTAMP - 1 THEN 1 ELSE 0 END AS STILL_RELEVANT FROM COUPON_REQUEST WHERE PENDING = 1 AND TILL_NAME = ? ORDER BY LAST_REQUEST_DATE", SP.sParams.tillnum);){
            while (qry.next()) {
                this.currentCoupon = null;
                this.requestId = qry.getString("REQUEST_ID");
                this.requestIdPending = true;
                this.lastError = null;
                if (qry.getBoolean("NEEDS_COMMIT")) {
                    this.requestConfirm(qry.getLong("VHIDX"), 1L, false);
                } else if (!qry.getBoolean("STILL_RELEVANT")) {
                    this.updateErrorOnRequest("Pending for more than 24 hours. No longer relevant.", true);
                } else {
                    this.requestCancel(1L);
                }
                if (!this.requestIdPending) continue;
                failureOccurred = true;
            }
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
        this.currentCoupon = prevCurrentCoupon;
        this.requestId = prevRequestId;
        this.requestIdPending = prevRequestIdPending;
        this.lastError = prevLastError;
        this.cleanupNextReset = failureOccurred;
    }

    public static void cleanupPendingRequests() {
        try {
            CouponManager manager = new CouponManager();
            manager.cleanup();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }
}

