/*
 * Decompiled with CFR 0.152.
 */
package jpos.coupons;

import jpos.SP;

public enum RedemptionFailureReason {
    InvalidCouponCode("Coupons_RedemptionFailureReason_InvalidCouponCode"),
    NotActive("Coupons_RedemptionFailureReason_NotActive"),
    NotEnabled("Coupons_RedemptionFailureReason_NotEnabled"),
    NotYetValid("Coupons_RedemptionFailureReason_NotYetValid"),
    Expired("Coupons_RedemptionFailureReason_Expired"),
    AlreadyRedeemed("Coupons_RedemptionFailureReason_AlreadyRedeemed"),
    RedemptionPending("Coupons_RedemptionFailureReason_RedemptionPending"),
    MaximumRedemptionsExceeded("Coupons_RedemptionFailureReason_MaximumRedemptionsExceeded"),
    NotValidForPerson("Coupons_RedemptionFailureReason_NotValidForPerson"),
    NotValidForStore("Coupons_RedemptionFailureReason_NotValidForStore"),
    RequestAlreadyFinalised("Coupons_RedemptionFailureReason_RequestAlreadyFinalised"),
    InvalidRequestId("Coupons_RedemptionFailureReason_InvalidRequestId");

    private static final String defaultTranslationKey = "Coupons_RedemptionFailureReason_Default";
    private String translationKey;

    private RedemptionFailureReason(String translationKey) {
        this.translationKey = translationKey;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public static RedemptionFailureReason getReason(String reasonCode) {
        for (RedemptionFailureReason reason : RedemptionFailureReason.values()) {
            if (!reason.name().equalsIgnoreCase(reasonCode)) continue;
            return reason;
        }
        return null;
    }

    public static String getErrorMessage(String reasonCode) {
        RedemptionFailureReason reason = RedemptionFailureReason.getReason(reasonCode);
        if (reason != null) {
            return SP.getRS(reason.getTranslationKey());
        }
        return SP.getRS(defaultTranslationKey, reasonCode);
    }
}

