/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import jpos.PosUtils;
import jpos.SP;
import jpos.SqlQuery;
import jpos.StringUtils;
import jpos.XMLUtils;
import jpos.custorder.DeliveryMethod;
import jpos.person.Country;
import jpos.person.PersonUtils;
import org.jdom.Element;

public class DeliveryInfo {
    private boolean userEdited = false;
    private DeliveryOptions deliveryOption = DeliveryOptions.CUSTOMER_PICKUP;
    private DeliveryMethod deliveryMethod = null;
    private String contactName = null;
    private String company = null;
    private String addressLine1 = null;
    private String addressLine2 = null;
    private String city = null;
    private String state = null;
    private String postcode = null;
    private Country country = new Country();
    private String phone = null;
    private String email = null;
    private int unattendedDeliveryOption = 0;
    private String deliveryInstructions = null;

    public DeliveryOptions getDeliveryOption() {
        return this.deliveryOption;
    }

    public void setDeliveryOption(DeliveryOptions deliveryOption) {
        this.deliveryOption = deliveryOption;
    }

    public DeliveryMethod getDeliveryMethod() {
        return this.deliveryMethod;
    }

    public void setDeliveryMethod(DeliveryMethod deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
    }

    public String getContactName() {
        return StringUtils.nullToEmpty(this.contactName);
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public String getCompany() {
        return StringUtils.nullToEmpty(this.company);
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getAddressLine1() {
        return StringUtils.nullToEmpty(this.addressLine1);
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
    }

    public String getAddressLine2() {
        return StringUtils.nullToEmpty(this.addressLine2);
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
    }

    public String getCity() {
        return StringUtils.nullToEmpty(this.city);
    }

    public void setCity(String city) {
        this.city = city;
    }

    public String getState() {
        return StringUtils.nullToEmpty(this.state);
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getPostcode() {
        return StringUtils.nullToEmpty(this.postcode);
    }

    public void setPostcode(String postcode) {
        this.postcode = postcode;
    }

    public Country getCountry() {
        return this.country;
    }

    public void setCountry(Country country) {
        this.country = country;
    }

    public String getDeliveryInstructions() {
        return StringUtils.nullToEmpty(this.deliveryInstructions);
    }

    public void setDeliveryInstructions(String deliveryInstructions) {
        this.deliveryInstructions = deliveryInstructions;
    }

    public int getUnattendedDeliveryOption() {
        return this.unattendedDeliveryOption;
    }

    public void setUnattendedDeliveryOption(int unattendedDeliveryOption) {
        this.unattendedDeliveryOption = unattendedDeliveryOption;
    }

    public String getPhone() {
        return StringUtils.nullToEmpty(this.phone);
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getEmail() {
        return StringUtils.nullToEmpty(this.email);
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public boolean isUserEdited() {
        return this.userEdited;
    }

    public void setUserEdited(boolean userEdited) {
        this.userEdited = userEdited;
    }

    public void populateFromPerson(Element person) {
        this.contactName = PersonUtils.getPerName(person);
        Element locn = person.getChild("locn");
        if (locn != null) {
            this.company = XMLUtils.getValue(locn, "tradename");
            this.addressLine1 = XMLUtils.getValue(locn, "adrs1");
            this.addressLine2 = XMLUtils.getValue(locn, "adrs2");
            this.city = XMLUtils.getValue(locn, "city");
            this.state = XMLUtils.getValue(locn, "state");
            this.postcode = XMLUtils.getValue(locn, "postcode");
            this.country = new Country(XMLUtils.getValue(locn, "country"));
        }
        this.phone = PersonUtils.getPhoneNum(person, PersonUtils.PhoneType.MAIN);
        this.email = PersonUtils.getPhoneNum(person, PersonUtils.PhoneType.EMAIL);
        this.userEdited = false;
    }

    public void saveToDatabase(long vhidx) {
        try (SqlQuery sql = new SqlQuery(SP.sParams.conn, "SELECT 1 FROM DELIVERY_INFO WHERE VHIDX = " + vhidx);){
            Throwable throwable;
            PreparedStatement stmt;
            if (sql.next()) {
                stmt = SP.sParams.conn.prepareStatement("DELETE FROM DELIVERY_INFO WHERE VHIDX = ?");
                throwable = null;
                try {
                    stmt.setLong(1, vhidx);
                    stmt.executeUpdate();
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (stmt != null) {
                        if (throwable != null) {
                            try {
                                stmt.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            stmt.close();
                        }
                    }
                }
            }
            stmt = SP.sParams.conn.prepareStatement("INSERT INTO DELIVERY_INFO(VHIDX, CONTACT_NAME, COMPANY, ADDRS1, ADDRS2, CITY, STATE, POSTCODE, COUNTRY, PHONE, EMAIL, DELIVERY_METHOD_IDX, DELIVERY_INSTRUCTIONS) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
            throwable = null;
            try {
                stmt.setLong(1, vhidx);
                stmt.setString(2, this.contactName);
                stmt.setString(3, this.company);
                stmt.setString(4, this.addressLine1);
                stmt.setString(5, this.addressLine2);
                stmt.setString(6, this.city);
                stmt.setString(7, this.state);
                stmt.setString(8, this.postcode);
                stmt.setString(9, this.country.getName());
                stmt.setString(10, this.phone);
                stmt.setString(11, this.email);
                stmt.setLong(12, this.deliveryMethod.getId());
                stmt.setString(13, this.deliveryInstructions);
                stmt.executeUpdate();
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (stmt != null) {
                    if (throwable != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    public void populateFromDatabase(long vhidx) {
        this.populateFromDatabase(vhidx, SP.sParams.conn);
    }

    public void populateFromDatabase(long vhidx, Connection conn) {
        try (SqlQuery sql = new SqlQuery(conn, "SELECT D.VHIDX, D.CONTACT_NAME, D.COMPANY, D.ADDRS1, D.ADDRS2, D.CITY, D.STATE, D.POSTCODE, D.COUNTRY, D.PHONE, D.EMAIL, D.DELIVERY_INSTRUCTIONS, R.RCIDX, R.CODE, R.NAME, R.EXTEND FROM DELIVERY_INFO D JOIN REFCODE R ON D.DELIVERY_METHOD_IDX = R.RCIDX WHERE D.VHIDX = " + vhidx);){
            if (sql.next()) {
                this.contactName = sql.getString("CONTACT_NAME");
                this.company = sql.getString("COMPANY");
                this.addressLine1 = sql.getString("ADDRS1");
                this.addressLine2 = sql.getString("ADDRS2");
                this.city = sql.getString("CITY");
                this.state = sql.getString("STATE");
                this.postcode = sql.getString("POSTCODE");
                this.country = new Country(sql.getString("COUNTRY"));
                this.phone = sql.getString("PHONE");
                this.email = sql.getString("EMAIL");
                this.deliveryInstructions = sql.getString("DELIVERY_INSTRUCTIONS");
                this.deliveryMethod = new DeliveryMethod(sql.getLong("RCIDX"), sql.getString("CODE"), sql.getString("NAME"), sql.getString("EXTEND"));
                this.deliveryOption = DeliveryOptions.DELIVERY;
            } else {
                this.deliveryOption = DeliveryOptions.CUSTOMER_PICKUP;
                this.deliveryMethod = null;
                this.contactName = null;
                this.company = null;
                this.addressLine1 = null;
                this.addressLine2 = null;
                this.city = null;
                this.state = null;
                this.postcode = null;
                this.country = new Country();
                this.phone = null;
                this.email = null;
                this.deliveryInstructions = null;
            }
            this.userEdited = false;
        }
        catch (SQLException e) {
            PosUtils.logError(e);
        }
    }

    public static enum DeliveryOptions {
        CUSTOMER_PICKUP,
        DELIVERY,
        SPLIT;

    }
}

