/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import com.teamdev.jxbrowser.browser.event.ConsoleMessageReceived;
import com.teamdev.jxbrowser.js.ConsoleMessage;
import com.teamdev.jxbrowser.js.ConsoleMessageLevel;
import com.teamdev.jxbrowser.js.JsAccessible;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.text.MessageFormat;
import jpos.PosDialog;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.Settings;
import jpos.StoreParams;
import jpos.browser.BrowserControl;
import jpos.custorder.DeliveryInfo;
import jpos.custorder.DeliveryInfoInterface;
import jpos.kleber.KleberUtils;

public class DeliveryInfoDlg
extends PosDialog
implements AutoCloseable {
    private static final int WIDTH = 670;
    private static final int HEIGHT = 810;
    private static final int DEBUG_WIDTH = 800;
    private BrowserControl browserControl;
    private DeliveryInfo deliveryInfo;
    private String heading;
    private boolean result = false;
    @JsAccessible
    public DeliveryInfoInterface deliveryInfoInterface;

    public DeliveryInfoDlg(PosFrame frame, DeliveryInfo deliveryInfo, int deliverItems, int totalItems) throws Exception {
        super(frame, SP.getRS("Delivery_Info"), true);
        this.deliveryInfo = deliveryInfo;
        this.heading = this.getHeading(deliverItems, totalItems);
        Connection conn = null;
        try {
            conn = StoreParams.createNewConnection();
            this.setLayout(new GridBagLayout());
            this.browserControl = new BrowserControl(true);
            this.deliveryInfoInterface = new DeliveryInfoInterface(this, deliveryInfo, this.heading, KleberUtils.getInstance(this.sParams));
            this.browserControl.setBoundObject("viewType", 1);
            this.browserControl.setBoundObject("kleberUtils", new KleberUtils(this.sParams));
            this.browserControl.setBoundObject("deliveryInterface", this.deliveryInfoInterface);
            if (!Settings.showBrowserDebugger()) {
                this.browserControl.getBrowser().on(ConsoleMessageReceived.class, event -> {
                    ConsoleMessage consoleMessage = event.consoleMessage();
                    if (consoleMessage.level() == ConsoleMessageLevel.LEVEL_ERROR) {
                        PosUtils.logError("Error in Delivery Info UI: " + consoleMessage.message() + "\nLine: " + consoleMessage.lineNumber() + "\n" + consoleMessage.source());
                    }
                });
            }
            this.add((Component)this.browserControl, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            if (Settings.getReactAppPort() > 0) {
                this.browserControl.loadURL("http://127.0.0.1:" + Settings.getReactAppPort());
            } else {
                this.browserControl.loadFromJar("/jpos/browser/react_app/build/index.html");
            }
            this.resizeDialog(frame, Settings.showBrowserDebugger() ? 1470 : 670, 0.9f, 810);
            this.browserControl.initialiseSplitterPosition(1, 670);
        }
        catch (Exception e) {
            if (conn != null) {
                conn.close();
            }
            if (this.browserControl != null) {
                this.browserControl.disposeBrowserObjects();
            }
            throw e;
        }
    }

    private String getHeading(int deliverItems, int totalItems) {
        if (deliverItems == totalItems) {
            return SP.getRS("Deliver_all_to");
        }
        return MessageFormat.format(SP.getRS("Deliver_x_of_y_to"), deliverItems, totalItems);
    }

    @Override
    public void close() throws Exception {
        if (this.browserControl != null) {
            this.browserControl.disposeBrowserObjects();
        }
    }

    @Override
    public void cancelDialog() {
        this.result = false;
        this.dispose();
    }

    @Override
    public void okDialog() {
        this.result = true;
        this.dispose();
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }

    public boolean getResult() {
        return this.result;
    }

    @Override
    public boolean this_keyPressed(KeyEvent e) {
        if (e.getKeyCode() != 82 || !e.isControlDown() || !Settings.showBrowserDebugger()) {
            return false;
        }
        this.browserControl.reload();
        return true;
    }

    private void resizeDialog(Window frParent, int width, float scaleHeight, int maxHeight) {
        Rectangle parentRect = frParent.getBounds();
        int height = Math.min((int)((float)parentRect.height * scaleHeight), maxHeight);
        int x = (int)((float)parentRect.x + (float)parentRect.width / 2.0f - (float)width / 2.0f);
        int y = (int)((float)parentRect.y + (float)parentRect.height / 2.0f - (float)height / 2.0f);
        this.setBounds(x, y, width, height);
    }
}

