/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import jpos.FrSales;
import jpos.PosDialog;
import jpos.PosFocusTraversalPolicy;
import jpos.PosFrame;
import jpos.PosUtils;
import jpos.SP;
import jpos.StoreParams;
import jpos.ui.DialogButton;
import jpos.ui.LabelNormal;
import jpos.ui.TouchTextArea;

public class DlgRejectOrderConfirmation
extends PosDialog {
    private FrSales sales;
    private long vhidx;
    private long memidx;
    private boolean isCustPickup;
    private DialogButton bOK = new DialogButton("");
    private DialogButton bCancel = new DialogButton("");
    private LabelNormal lConfirmationMessage = new LabelNormal();

    public DlgRejectOrderConfirmation(PosFrame salesFrame, String title, boolean modal, long vhidx, long memidx, boolean isCustPickup) {
        super(salesFrame, title, modal);
        this.sales = (FrSales)salesFrame;
        this.vhidx = vhidx;
        this.memidx = memidx;
        this.isCustPickup = isCustPickup;
        try {
            this.jbInitDlgComponents();
        }
        catch (Exception e) {
            PosUtils.logError(e);
        }
    }

    private void jbInitDlgComponents() throws Exception {
        this.bOK.setText(StoreParams.res.getString("ok"));
        this.bOK.addActionListener(e -> this.okDialog());
        this.bCancel.setText(StoreParams.res.getString("cancel"));
        this.bCancel.addActionListener(e -> this.cancelDialog());
        JPanel messagePanel = new JPanel();
        JLabel lImage = new JLabel();
        TouchTextArea jTextArea = new TouchTextArea();
        jTextArea.setEditable(false);
        jTextArea.setFocusable(false);
        jTextArea.setBackground(UIManager.getColor("Panel.background"));
        if (this.isCustPickup) {
            jTextArea.setText(SP.getRS("Confirm_Reassign_Pickup_Order_Message"));
        } else {
            jTextArea.setText(SP.getRS("Confirm_Reassign_Order_Message"));
        }
        messagePanel.setLayout(new GridBagLayout());
        messagePanel.add((Component)lImage, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 11, 0, new Insets(10, 10, 0, 0), 0, 0));
        messagePanel.add((Component)jTextArea, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(10, 10, 0, 10), 1, 1));
        lImage.setIcon(new ImageIcon("images/Inform.gif"));
        lImage.paint(lImage.getGraphics());
        this.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)messagePanel, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.bOK, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.getContentPane().add((Component)this.bCancel, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.setResizable(false);
        Vector<Component> v = new Vector<Component>();
        v.add(this.bOK);
        v.add(this.bCancel);
        PosFocusTraversalPolicy ftp = new PosFocusTraversalPolicy(v);
        this.setFocusTraversalPolicy(ftp);
        this.pack();
        PosUtils.centreWindow(this);
    }

    @Override
    public void cancelDialog() {
        this.dispose();
    }

    @Override
    public void okDialog() {
        this.setCursor(StoreParams.waitCursor);
        if (this.sales.isLoggedIn(false) && this.sales.rejectCustOrder(this.vhidx, this.memidx)) {
            this.sales.voidTrans(false);
            this.setCursor(StoreParams.normalCursor);
            this.dispose();
            return;
        }
        this.setCursor(StoreParams.normalCursor);
    }

    @Override
    protected boolean myKeyPressed(KeyEvent e) {
        return false;
    }
}

