/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;
import jpos.ErrorHandler;
import jpos.PosUtils;

public class ShippingLabelFilePurge {
    private static ShippingLabelFilePurge instance = null;
    private static Hashtable<String, Date> lastCalls = new Hashtable();

    public static ShippingLabelFilePurge getDefault() {
        if (instance == null) {
            instance = new ShippingLabelFilePurge();
        }
        return instance;
    }

    public void purgeFolder(String folderName, int daysToKeep) {
        if (this.alreadyCalledToday(folderName)) {
            return;
        }
        try {
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(5, -daysToKeep);
            Date purgeDate = c.getTime();
            File folder = new File(folderName);
            File[] listOfFiles = folder.listFiles();
            for (int i = 0; i < listOfFiles.length; ++i) {
                if (!listOfFiles[i].isFile()) continue;
                c.setTimeInMillis(listOfFiles[i].lastModified());
                if (!c.getTime().before(purgeDate) || listOfFiles[i].delete()) continue;
                ErrorHandler.frErrors.logToFileOnly(String.format("Failed to purge file: ShippingLabelFilePurge.purgeFolder(folderName = %s, daysToKeep = %s)", folderName, daysToKeep));
            }
        }
        catch (Exception e) {
            PosUtils.logError(String.format("Failed to purge file: ShippingLabelFilePurge.purgeFolder(folderName = %s, daysToKeep = %s)", folderName, daysToKeep));
            PosUtils.logError(e);
        }
    }

    private boolean alreadyCalledToday(String folderName) {
        if (!lastCalls.containsKey(folderName = folderName.toLowerCase())) {
            lastCalls.put(folderName, new Date());
            return false;
        }
        return !lastCalls.get(folderName).before(new Date());
    }
}

