/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.text.SimpleDateFormat;
import java.time.format.DateTimeFormatter;
import java.util.Base64;
import java.util.Date;
import java.util.Iterator;
import javax.net.ssl.HttpsURLConnection;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import jpos.PosUtils;
import jpos.SP;
import jpos.StringUtils;
import jpos.basscom.utils.Utils;
import jpos.custorder.DespatchInfo;
import jpos.custorder.Despatcher;
import jpos.custorder.Pack;
import jpos.custorder.ShippingLabelFilePurge;
import jpos.custorder.UnattendedDeliveryOptions;
import jpos.labelprinting.TemplateParser;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class Temando
extends Despatcher {
    String apiUrl = "";
    String apiUsername = "";
    String apiPassword = "";
    String origDescription = "";

    public Temando(String apiUrl, String apiUsername, String apiPassword) {
        this.apiUrl = apiUrl;
        this.apiUsername = apiUsername;
        this.apiPassword = apiPassword;
    }

    @Override
    public String getDespatcherTitle() {
        if (this.isManualMode()) {
            return SP.getRS("Manual_Despatch");
        }
        return SP.getRS("Temando_Despatch");
    }

    @Override
    public String getSwitchModeButtonText() {
        if (!this.isManualMode()) {
            return SP.getRS("Manual_Switch");
        }
        return SP.getRS("Temando_Switch");
    }

    @Override
    public boolean hasCredentials() {
        return !StringUtils.isNullOrEmpty(this.apiUrl) && !StringUtils.isNullOrEmpty(this.apiUsername) && !StringUtils.isNullOrEmpty(this.apiPassword);
    }

    public String DefaultAddressField(String field) {
        if (StringUtils.isNullOrEmpty(field)) {
            return "n/a";
        }
        return field;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendPost(DespatchInfo despatchInfo) throws Exception {
        try {
            Object expr3;
            XPathExpression expr22;
            Document doc;
            InputSource is;
            String inputLine;
            BufferedReader in;
            Serializable response;
            Double goodsValue;
            this.printError = "";
            String carrierName = "";
            despatchInfo.setDespatchSuccessful(false);
            Base64.Decoder decoder = Base64.getDecoder();
            Base64.Encoder encoder = Base64.getEncoder();
            String authorisationHeader = encoder.encodeToString(("Basic " + this.apiUsername + ":" + this.apiPassword).getBytes()).trim();
            URL url = new URL(this.apiUrl);
            String host = url.getHost();
            String protocol = url.getProtocol();
            final String serverUrl = protocol + "://" + host;
            this.lastGeneratedLabelFilename = this.generateLabelsFilename(despatchInfo);
            FileOutputStream labelFile = this.CreateNewFileStream(this.lastGeneratedLabelFilename);
            if (!StringUtils.isNullOrEmpty(this.printError)) {
                boolean bl = false;
                return bl;
            }
            this.lastGeneratedConsignmentFilename = this.generateConsignmentFilename(despatchInfo);
            FileOutputStream consignmentFile = this.CreateNewFileStream(this.lastGeneratedConsignmentFilename);
            if (!StringUtils.isNullOrEmpty(this.printError)) {
                boolean bl = false;
                return bl;
            }
            FileOutputStream invoiceFile = null;
            if (!despatchInfo.getCountry().equals(despatchInfo.getCountryOfOrigin())) {
                this.lastGeneratedInvoiceFilename = this.generateInvoiceFilename(despatchInfo);
                invoiceFile = this.CreateNewFileStream(this.lastGeneratedInvoiceFilename);
                if (!StringUtils.isNullOrEmpty(this.printError)) {
                    boolean bl = false;
                    return bl;
                }
            }
            HttpURLConnection con = protocol.toLowerCase().startsWith("https") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            StringBuffer anythings = new StringBuffer();
            for (Pack pack : despatchInfo.getPacks()) {
                if (pack.getCount() <= 0) continue;
                if (!(pack.getLength() > 0.0 && pack.getWidth() > 0.0 && pack.getDepth() > 0.0 && pack.getWeight() > 0.0)) {
                    this.printError = SP.getRS("Pack_Type_X_is_not_configured_correctly_it_must_have_length_width_depth_and_weight_setup", pack.getName());
                    boolean bl = false;
                    return bl;
                }
                TemplateParser anythingTemplater = new TemplateParser(Temando.getTemplate("Anything"));
                anythingTemplater.replaceToken("length", Double.toString(pack.getLength()));
                anythingTemplater.replaceToken("width", Double.toString(pack.getWidth()));
                anythingTemplater.replaceToken("height", Double.toString(pack.getDepth()));
                anythingTemplater.replaceToken("packaging", pack.getAlternativeName());
                anythingTemplater.replaceToken("weight", Double.toString(pack.getWeight() * 1000.0));
                anythingTemplater.replaceToken("quantity", Double.toString(pack.getCount()));
                anythingTemplater.replaceToken("countryOfOrigin", despatchInfo.getCountryOfOrigin().getCode());
                anythings.append(anythingTemplater.toString());
            }
            StringBuffer quoteFilter = new StringBuffer();
            String quoteFilterCarrierId = despatchInfo.getThirdPartyRefocde("Temando", despatchInfo.getCarrierIdx());
            String quoteFilterDeliveryMethod = despatchInfo.getThirdPartyRefocde("Temando", despatchInfo.getServiceTypeIdx());
            if (!StringUtils.isNullOrEmpty(quoteFilterCarrierId) && !StringUtils.isNullOrEmpty(quoteFilterCarrierId)) {
                TemplateParser quoteFilterTemplater = new TemplateParser(Temando.getTemplate("QuoteFilter"));
                quoteFilterTemplater.replaceToken("carrierId", this.escapeXml(quoteFilterCarrierId));
                if (!StringUtils.isNullOrEmpty(quoteFilterDeliveryMethod)) {
                    quoteFilterTemplater.replaceToken("deliveryMethod", this.escapeXml(quoteFilterDeliveryMethod));
                } else {
                    quoteFilterTemplater.removeXMLTag("deliveryMethods", false);
                }
                quoteFilter.append(quoteFilterTemplater.toString());
            }
            TemplateParser quoteTemplater = new TemplateParser(Temando.getTemplate("Quote"));
            quoteTemplater.replaceToken("apihost", serverUrl);
            quoteTemplater.replaceToken("anythings", anythings.toString());
            this.origDescription = this.apiUsername.equals("TEMANDOTEST") ? (despatchInfo.getCountryOfOrigin().equals("NZ") ? "PL - 162 Queen" : "James M's Store") : despatchInfo.getDespatchLocation();
            quoteTemplater.replaceToken("originDescription", this.escapeXml(this.origDescription));
            String domesticOrInternational = "Domestic";
            if (!despatchInfo.getCountry().equals(despatchInfo.getCountryOfOrigin())) {
                domesticOrInternational = "International";
            }
            quoteTemplater.replaceToken("domesticOrInternational", domesticOrInternational);
            quoteTemplater.replaceToken("destinationCountry", this.escapeXml(despatchInfo.getCountry().getCode()));
            quoteTemplater.replaceToken("destinationPostcode", despatchInfo.getPostcode());
            quoteTemplater.replaceToken("destinationSuburb", this.escapeXml(despatchInfo.getCity()));
            quoteTemplater.replaceToken("isPOBox", this.escapeXml(despatchInfo.isPoBox() ? "Y" : "N"));
            TemplateParser anytimeTemplater = null;
            if (despatchInfo.getExpectedDeliveryDate() != null) {
                anytimeTemplater = new TemplateParser(Temando.getTemplate("Anytime"));
                anytimeTemplater.replaceToken("expectedDeliveryDate", despatchInfo.getExpectedDeliveryDate().format(DateTimeFormatter.ISO_DATE));
                quoteTemplater.replaceToken("anytime", anytimeTemplater.toString());
            }
            if ((goodsValue = Double.valueOf(despatchInfo.getGoodsValue() - despatchInfo.getNonStockedValue())) == 0.0) {
                goodsValue = 0.01;
            }
            quoteTemplater.replaceToken("goodsValue", Utils.formatNumber(goodsValue, "0.##"));
            quoteTemplater.replaceToken("quoteFilter", quoteFilter.toString());
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-type", "text/xml;charset=utf-8");
            con.setRequestProperty("Authorization", authorisationHeader);
            con.setDoOutput(true);
            try (OutputStreamWriter wr = new OutputStreamWriter(con.getOutputStream(), "UTF-8");){
                this.logTemandoCommunications(despatchInfo, "GetQuote", quoteTemplater.toString());
                quoteTemplater.replaceToken("username", this.apiUsername);
                quoteTemplater.replaceToken("password", this.apiPassword);
                wr.write(quoteTemplater.toString());
                wr.flush();
            }
            int responseCode = con.getResponseCode();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            XPathFactory xPathfactory = XPathFactory.newInstance();
            XPath xpath = xPathfactory.newXPath();
            xpath.setNamespaceContext(new NamespaceContext(){

                @Override
                public String getNamespaceURI(String prefix) {
                    if (prefix.equals("SOAP-ENV")) {
                        return "http://schemas.xmlsoap.org/soap/envelope/";
                    }
                    if (prefix.equals("ns1")) {
                        return serverUrl + "/schema/2009_06/server.xsd";
                    }
                    return "";
                }

                @Override
                public String getPrefix(String namespaceURI) {
                    return null;
                }

                public Iterator<?> getPrefixes(String namespaceURI) {
                    return null;
                }
            });
            String bookingTemplate = Temando.getTemplate("Booking");
            if (!despatchInfo.getReturnAddressExists()) {
                bookingTemplate = this.removeXMLNode(bookingTemplate, "returnto");
            }
            TemplateParser bookingTemplater = new TemplateParser(bookingTemplate);
            if (responseCode == 200) {
                response = new StringBuffer();
                in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                Throwable throwable = null;
                try {
                    while ((inputLine = in.readLine()) != null) {
                        ((StringBuffer)response).append(inputLine);
                    }
                    this.logTemandoCommunications(despatchInfo, "GetQuoteResponse", ((StringBuffer)response).toString());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in != null) {
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
                is = new InputSource();
                is.setCharacterStream(new StringReader(((StringBuffer)response).toString()));
                doc = builder.parse(is);
                bookingTemplater.replaceToken("apihost", protocol + "://" + host);
                bookingTemplater.replaceToken("anythings", anythings.toString());
                if (anytimeTemplater != null) {
                    bookingTemplater.replaceToken("anytime", anytimeTemplater.toString());
                }
                bookingTemplater.replaceToken("destinationCountry", this.escapeXml(despatchInfo.getCountry().getCode()));
                bookingTemplater.replaceToken("destinationSuburb", this.escapeXml(despatchInfo.getCity()));
                bookingTemplater.replaceToken("destinationPostcode", this.escapeXml(despatchInfo.getPostcode()));
                bookingTemplater.replaceToken("destinationState", this.escapeXml(despatchInfo.getState()));
                bookingTemplater.replaceToken("destinationResUnattended", this.escapeXml(despatchInfo.getUnattendedDeliveryOption() == UnattendedDeliveryOptions.AuthorityToLeave ? "Y" : "N"));
                bookingTemplater.replaceToken("contactName", this.escapeXml(despatchInfo.getCustomerName()));
                bookingTemplater.replaceToken("companyName", this.escapeXml(despatchInfo.getCompanyName()));
                bookingTemplater.replaceToken("destinationStreet", this.escapeXml(this.formatStreet(despatchInfo.getAddressLine1(), despatchInfo.getAddressLine2())));
                String bestPhoneNumber = despatchInfo.getBestPhoneNumber();
                bookingTemplater.replaceToken("destinationPhone", StringUtils.isNullOrEmpty(bestPhoneNumber) ? "n/a" : this.escapeXml(bestPhoneNumber));
                bookingTemplater.replaceToken("destinationEmail", StringUtils.isNullOrEmpty(despatchInfo.getEmail()) ? "n/a" : this.escapeXml(despatchInfo.getEmail()));
                if (despatchInfo.getReturnAddressExists()) {
                    bookingTemplater.replaceToken("returnToContactName", this.escapeXml(this.DefaultAddressField(despatchInfo.getReturnContactName())));
                    bookingTemplater.replaceToken("returnToCompanyName", this.escapeXml(this.DefaultAddressField(despatchInfo.getReturnCompanyName())));
                    bookingTemplater.replaceToken("returnToCountry", this.escapeXml(this.DefaultAddressField(despatchInfo.getReturnCountry().getCode())));
                    bookingTemplater.replaceToken("returnToSuburb", this.escapeXml(this.DefaultAddressField(despatchInfo.getReturnCity())));
                    bookingTemplater.replaceToken("returnToPostcode", this.escapeXml(this.DefaultAddressField(despatchInfo.getReturnPostcode())));
                    if (!StringUtils.isNullOrEmpty(despatchInfo.getReturnState()) && despatchInfo.getReturnState() != "n/a") {
                        bookingTemplater.replaceToken("returnToState", this.escapeXml(despatchInfo.getReturnState()));
                    } else {
                        bookingTemplater.replaceToken("returnToState", "");
                    }
                    bookingTemplater.removeXMLTag("state", true);
                    bookingTemplater.replaceToken("returnToStreet", this.escapeXml(this.formatStreet(despatchInfo.getReturnAddressLine1(), despatchInfo.getReturnAddressLine2())));
                    bookingTemplater.replaceToken("returnToPhone", this.escapeXml(this.DefaultAddressField(despatchInfo.getReturnPhone())));
                    bookingTemplater.replaceToken("returnToEmail", this.escapeXml(this.DefaultAddressField(despatchInfo.getReturnEmail())));
                }
                bookingTemplater.replaceToken("originDescription", this.escapeXml(this.origDescription));
                bookingTemplater.replaceToken("domesticOrInternational", domesticOrInternational);
                bookingTemplater.replaceToken("isPOBox", this.escapeXml(despatchInfo.isPoBox() ? "Y" : "N"));
                goodsValue = despatchInfo.getGoodsValue() - despatchInfo.getNonStockedValue();
                if (goodsValue == 0.0) {
                    goodsValue = 0.01;
                }
                bookingTemplater.replaceToken("goodsValue", Utils.formatNumber(goodsValue, "0.##"));
                bookingTemplater.replaceToken("deliveryInstructions", this.escapeXml(StringUtils.truncate(despatchInfo.getDeliveryInstructions(), 30)));
                bookingTemplater.replaceToken("custOrderNo", despatchInfo.getCustomerOrderNumber());
                expr22 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:getQuotesResponse/quotes/quote");
                Object result = expr22.evaluate(doc, XPathConstants.NODESET);
                NodeList quoteList = (NodeList)result;
                if (quoteList.getLength() == 0) {
                    this.printError = SP.getRS("The_freight_system_cannot_deliver_to_this_address");
                    boolean bl = false;
                    return bl;
                }
            } else {
                StringBuffer response2 = new StringBuffer();
                try (BufferedReader in2 = new BufferedReader(new InputStreamReader(con.getErrorStream()));){
                    String inputLine2;
                    while ((inputLine2 = in2.readLine()) != null) {
                        response2.append(inputLine2);
                    }
                    this.logTemandoCommunications(despatchInfo, "GetQuoteResponseError", response2.toString());
                }
                InputSource is2 = new InputSource();
                is2.setCharacterStream(new StringReader(response2.toString()));
                Document doc2 = builder.parse(is2);
                XPathExpression expr3 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/SOAP-ENV:Fault/faultstring/text()");
                this.printError = (String)expr3.evaluate(doc2, XPathConstants.STRING);
                boolean expr22 = false;
                return expr22;
            }
            expr22 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:getQuotesResponse/quotes/*[1]/totalPrice");
            bookingTemplater.replaceToken("totalPrice", this.escapeXml((String)expr22.evaluate(doc, XPathConstants.STRING)));
            expr22 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:getQuotesResponse/quotes/*[1]/basePrice");
            bookingTemplater.replaceToken("basePrice", this.escapeXml((String)expr22.evaluate(doc, XPathConstants.STRING)));
            expr22 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:getQuotesResponse/quotes/*[1]/tax");
            bookingTemplater.replaceToken("tax", this.escapeXml((String)expr22.evaluate(doc, XPathConstants.STRING)));
            expr22 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:getQuotesResponse/quotes/*[1]/currency");
            bookingTemplater.replaceToken("currency", this.escapeXml((String)expr22.evaluate(doc, XPathConstants.STRING)));
            expr22 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:getQuotesResponse/quotes/*[1]/deliveryMethod");
            bookingTemplater.replaceToken("deliveryMethod", this.escapeXml((String)expr22.evaluate(doc, XPathConstants.STRING)));
            expr22 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:getQuotesResponse/quotes/*[1]/etaFrom");
            bookingTemplater.replaceToken("etaFrom", this.escapeXml((String)expr22.evaluate(doc, XPathConstants.STRING)));
            expr22 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:getQuotesResponse/quotes/*[1]/etaTo");
            bookingTemplater.replaceToken("etaTo", this.escapeXml((String)expr22.evaluate(doc, XPathConstants.STRING)));
            expr22 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:getQuotesResponse/quotes/*[1]/guaranteedEta");
            bookingTemplater.replaceToken("guaranteedEta", this.escapeXml((String)expr22.evaluate(doc, XPathConstants.STRING)));
            expr22 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:getQuotesResponse/quotes/*[1]/carrier/id");
            bookingTemplater.replaceToken("carrierId", this.escapeXml((String)expr22.evaluate(doc, XPathConstants.STRING)));
            expr22 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:getQuotesResponse/quotes/*[1]/carrier/companyName");
            carrierName = (String)expr22.evaluate(doc, XPathConstants.STRING);
            con = protocol.toLowerCase().startsWith("https") ? (HttpsURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection();
            con.setRequestMethod("POST");
            con.setRequestProperty("Content-type", "text/xml;charset=utf-8");
            con.setRequestProperty("Authorization", authorisationHeader);
            con.setDoOutput(true);
            OutputStreamWriter wr = new OutputStreamWriter(con.getOutputStream(), "UTF-8");
            response = null;
            try {
                this.logTemandoCommunications(despatchInfo, "GetBooking", bookingTemplater.toString());
                bookingTemplater.replaceToken("username", this.apiUsername);
                bookingTemplater.replaceToken("password", this.apiPassword);
                wr.write(bookingTemplater.toString());
                wr.flush();
            }
            catch (Throwable is2) {
                response = is2;
                throw is2;
            }
            finally {
                if (wr != null) {
                    if (response != null) {
                        try {
                            wr.close();
                        }
                        catch (Throwable is2) {
                            ((Throwable)response).addSuppressed(is2);
                        }
                    } else {
                        wr.close();
                    }
                }
            }
            responseCode = con.getResponseCode();
            if (responseCode == 200) {
                response = new StringBuffer();
                in = new BufferedReader(new InputStreamReader(con.getInputStream()));
                expr3 = null;
                try {
                    while ((inputLine = in.readLine()) != null) {
                        ((StringBuffer)response).append(inputLine);
                    }
                    this.logTemandoCommunications(despatchInfo, "GetBookingResponse", ((StringBuffer)response).toString());
                }
                catch (Throwable expr22) {
                    expr3 = expr22;
                    throw expr22;
                }
                finally {
                    if (in != null) {
                        if (expr3 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable expr22) {
                                ((Throwable)expr3).addSuppressed(expr22);
                            }
                        } else {
                            in.close();
                        }
                    }
                }
                is = new InputSource();
                is.setCharacterStream(new StringReader(((StringBuffer)response).toString()));
                doc = builder.parse(is);
                expr3 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:makeBookingResponse/consignmentNumber/text()");
                despatchInfo.setConnoteNumber((String)expr3.evaluate(doc, XPathConstants.STRING));
                expr3 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:makeBookingResponse/anytime/readyDate/text()");
                String readyDate = (String)expr3.evaluate(doc, XPathConstants.STRING);
                expr3 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:makeBookingResponse/anytime/readyTime/text()");
                readyDate = readyDate + " " + (String)expr3.evaluate(doc, XPathConstants.STRING);
                despatchInfo.setReadyDateTime(readyDate);
                despatchInfo.setCarrierName(carrierName);
                despatchInfo.setFinalServiceTypeIdx("");
                expr3 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:makeBookingResponse/labelDocument/text()");
                byte[] label = decoder.decode((String)expr3.evaluate(doc, XPathConstants.STRING));
                this.writeToDisk(label, labelFile);
                expr3 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:makeBookingResponse/consignmentDocument/text()");
                byte[] consignment = decoder.decode((String)expr3.evaluate(doc, XPathConstants.STRING));
                this.writeToDisk(consignment, consignmentFile);
                if (invoiceFile != null) {
                    expr3 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/ns1:makeBookingResponse/commercialInvoiceDocument/text()");
                    byte[] invoice = decoder.decode((String)expr3.evaluate(doc, XPathConstants.STRING));
                    this.writeToDisk(invoice, invoiceFile);
                }
                despatchInfo.setDespatchSuccessful(true);
                boolean bl = true;
                return bl;
            }
            response = new StringBuffer();
            in = new BufferedReader(new InputStreamReader(con.getErrorStream()));
            expr3 = null;
            try {
                while ((inputLine = in.readLine()) != null) {
                    ((StringBuffer)response).append(inputLine);
                }
                this.logTemandoCommunications(despatchInfo, "GetBookingResponseError", ((StringBuffer)response).toString());
            }
            catch (Throwable throwable) {
                expr3 = throwable;
                throw throwable;
            }
            finally {
                if (in != null) {
                    if (expr3 != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)expr3).addSuppressed(throwable);
                        }
                    } else {
                        in.close();
                    }
                }
            }
            is = new InputSource();
            is.setCharacterStream(new StringReader(((StringBuffer)response).toString()));
            doc = builder.parse(is);
            expr3 = xpath.compile("/SOAP-ENV:Envelope/SOAP-ENV:Body/SOAP-ENV:Fault/faultstring/text()");
            this.printError = (String)expr3.evaluate(doc, XPathConstants.STRING);
            if (this.printError.equals("")) {
                this.printError = "Bad Request: Response Code = " + responseCode;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ShippingLabelFilePurge.getDefault().purgeFolder(SP.sParams.getDeliveryLabelLogDirectory(), 180);
            ShippingLabelFilePurge.getDefault().purgeFolder(SP.sParams.getDeliveryLabelDirectory(), 180);
        }
    }

    private String formatStreet(String street1, String street2) {
        if (!street1.trim().isEmpty() && !street2.trim().isEmpty()) {
            return String.format("%s, %s", street1.trim(), street2.trim());
        }
        if (!street1.trim().isEmpty()) {
            return street1.trim();
        }
        return street2.trim();
    }

    private FileOutputStream CreateNewFileStream(String filename) {
        try {
            return new FileOutputStream(filename);
        }
        catch (FileNotFoundException e) {
            this.printError = SP.getRS("Cannot_open_file_X_is_it_in_use_by_another_program", filename);
            return null;
        }
    }

    private void writeToDisk(byte[] content, FileOutputStream fileStream) throws IOException {
        try (BufferedOutputStream bos = new BufferedOutputStream(fileStream);){
            bos.write(content);
            bos.flush();
        }
    }

    private void logTemandoCommunications(DespatchInfo despatchInfo, String filetype, String content) {
        try (BufferedWriter writer = Files.newBufferedWriter(Paths.get(String.format("%s%s%s_%s_%s.xml", SP.sParams.getDeliveryLabelLogDirectory(), File.separator, despatchInfo.getOrderNumber(), new SimpleDateFormat("HHmmssSSS").format(new Date()), filetype), new String[0]), new OpenOption[0]);){
            writer.write(content);
        }
        catch (IOException e) {
            PosUtils.logError(e);
        }
    }

    public String escapeXml(String s) {
        String result = s.replaceAll("[\\u2018\\u2019]", "'").replaceAll("[\\u201C\\u201D]", "\"");
        return result.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;");
    }

    @Override
    public boolean requestDespatch(DespatchInfo despatchInfo) {
        try {
            return this.sendPost(despatchInfo);
        }
        catch (UnknownHostException e) {
            this.printError = SP.getRS("Cannot_contact_server_X", e.getMessage());
            PosUtils.logError(e);
        }
        catch (ConnectException e) {
            this.printError = SP.getRS("Cannot_contact_server_X", this.apiUrl);
            PosUtils.logError(e);
        }
        catch (Exception e) {
            this.printError = e.toString();
            PosUtils.logError(e);
        }
        PosUtils.logError(this.printError);
        return false;
    }

    private static String getTemplate(String name) throws IOException {
        StringBuffer fileData = new StringBuffer();
        InputStream is = fileData.getClass().getResource("/jpos/custorder/temando" + name + ".xml").openStream();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
            String line = null;
            while ((line = reader.readLine()) != null) {
                fileData.append(line);
                fileData.append("\n");
            }
            String string = fileData.toString();
            return string;
        }
    }

    public String removeXMLNode(String template, String node) {
        int indexStart = template.indexOf("<" + node + ">");
        if (indexStart == -1) {
            return template;
        }
        int indexEnd = template.indexOf("</" + node + ">");
        if (indexEnd == -1) {
            return template;
        }
        String newContent = template.substring(0, indexStart) + template.substring(indexEnd + node.length() + 3, template.length() - 1);
        return newContent;
    }

    @Override
    public boolean canDoDynamicCarrierAllocation() {
        return false;
    }
}

