/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.auspost;

import java.awt.Window;
import java.util.Vector;
import jpos.PosTable;
import jpos.custorder.auspost.ShipmentTableModel;

public class ShipmentTable
extends PosTable {
    ShipmentTableModel model;

    public ShipmentTable(Window parent, ShipmentTableModel model) {
        super(parent, model);
        this.model = model;
        this.init();
    }

    private void init() {
        this.hideColumn(0);
        this.hideColumn(1);
        this.hideColumn(2);
        this.setColumnSize(3, 140);
        this.setColumnSize(4, 120);
        this.setColumnSize(5, 140);
        this.setColumnSize(6, 140);
        this.setColumnSize(7, 60);
        this.getColumnModel().getColumn(4).setHeaderRenderer(this.headerLeftRen);
        this.getColumnModel().getColumn(3).setHeaderRenderer(this.headerLeftRen);
        this.getColumnModel().getColumn(5).setHeaderRenderer(this.headerLeftRen);
        this.getColumnModel().getColumn(6).setHeaderRenderer(this.headerLeftRen);
        this.getColumnModel().getColumn(7).setHeaderRenderer(this.headerCenterRen);
        this.renderer.setColumnFormat(4, null, 2);
        this.renderer.setColumnFormat(3, null, 2);
        this.renderer.setColumnFormat(5, null, 2);
        this.renderer.setColumnFormat(6, null, 2);
        this.renderer.setColumnFormat(7, null, 0);
    }

    private void hideColumn(int column) {
        this.getColumnModel().getColumn(column).setPreferredWidth(0);
        this.getColumnModel().getColumn(column).setMinWidth(0);
        this.getColumnModel().getColumn(column).setMaxWidth(0);
    }

    private void setColumnSize(int column, int min, int max, int pref) {
        this.getColumnModel().getColumn(column).setPreferredWidth(pref);
        this.getColumnModel().getColumn(column).setMinWidth(min);
        this.getColumnModel().getColumn(column).setMaxWidth(max);
    }

    private void setColumnSize(int column, int size) {
        this.setColumnSize(column, size, size, size);
    }

    public void populate() {
        this.model.populate();
    }

    @Override
    public void selectAll() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        this.model.selectAll();
    }

    public void unselectAll() {
        if (this.isEditing()) {
            this.getCellEditor().stopCellEditing();
        }
        this.model.unselectAll();
    }

    public int getSelectedCount() {
        int result = 0;
        for (int i = 0; i < this.model.getRowCount(); ++i) {
            boolean isSelected = (Boolean)this.model.getValueAt(i, 7);
            if (!isSelected) continue;
            ++result;
        }
        return result;
    }

    public Vector<CarrierShipments> getSelectedShipmentId() {
        int i;
        Vector<CarrierShipments> shipments = new Vector<CarrierShipments>();
        Vector<String> carriers = new Vector<String>();
        for (i = 0; i < this.model.getRowCount(); ++i) {
            String carrierIdx = (String)this.model.getValueAt(i, 1);
            if (carriers.contains(carrierIdx)) continue;
            carriers.add(carrierIdx);
        }
        for (i = 0; i < carriers.size(); ++i) {
            CarrierShipments carrier = new CarrierShipments((String)carriers.elementAt(i));
            String carrierIdx = (String)carriers.elementAt(i);
            for (int j = 0; j < this.model.getRowCount(); ++j) {
                String rowCarrierIdx = (String)this.model.getValueAt(j, 1);
                boolean isSelected = (Boolean)this.model.getValueAt(j, 7);
                if (!rowCarrierIdx.equals(carrierIdx) || !isSelected) continue;
                carrier.shipments.add((String)this.model.getValueAt(j, 0));
            }
            if (carrier.shipments.isEmpty()) continue;
            shipments.add(carrier);
        }
        return shipments;
    }

    class CarrierShipments {
        public String carrierIdx;
        public Vector<String> shipments;

        public CarrierShipments(String carrierIdx) {
            this.carrierIdx = carrierIdx;
            this.shipments = new Vector();
        }
    }
}

