/*
 * Decompiled with CFR 0.152.
 */
package jpos.custorder.outstanding;

import com.teamdev.jxbrowser.callback.Callback;
import com.teamdev.jxbrowser.navigation.callback.StartNavigationCallback;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import jpos.PosUtils;
import jpos.browser.BrowserControl;
import jpos.custorder.outstanding.CustomerOrder;
import jpos.custorder.outstanding.OrderType;
import jpos.labelprinting.TemplateParser;
import jpos.ui.Colours;

public class OrderPanel
extends JPanel
implements AutoCloseable {
    private BrowserControl browserControl;
    private String despatchTemplate = OrderPanel.loadTemplate("despatchOrderTemplate.html");
    private String pickupTemplate = OrderPanel.loadTemplate("pickupOrderTemplate.html");

    public OrderPanel() {
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createLineBorder(Colours.GREY));
        this.browserControl = new BrowserControl();
        this.browserControl.getBrowser().navigation().set(StartNavigationCallback.class, (Callback)((StartNavigationCallback)params -> {
            if (params.url().startsWith("mailto:") && Desktop.isDesktopSupported()) {
                Desktop desktop = Desktop.getDesktop();
                if (desktop != null) {
                    try {
                        URI uri = new URI(params.url());
                        desktop.mail(uri);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return StartNavigationCallback.Response.ignore();
            }
            return StartNavigationCallback.Response.start();
        }));
        this.add((Component)this.browserControl, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public void close() {
        if (this.browserControl != null) {
            this.browserControl.disposeBrowserObjects();
        }
    }

    public void loadOrder(CustomerOrder order) {
        TemplateParser parser = new TemplateParser(order.getOrderType() == OrderType.CustomerPickup ? this.pickupTemplate : this.despatchTemplate);
        parser.replaceToken("orderType", OrderPanel.escapeHTML(order.getOrderTypeString()));
        parser.replaceToken("orderStatus", OrderPanel.escapeHTML(order.getOrderStatusString()));
        parser.replaceToken("transNum", OrderPanel.escapeHTML(order.getTransNum()));
        parser.replaceToken("custOrderNum", OrderPanel.escapeHTML(order.getCustOrderNum()));
        parser.replaceToken("docketNum", OrderPanel.escapeHTML(order.getDocketNum()));
        parser.replaceToken("orderDate", OrderPanel.escapeHTML(order.getOrderDateString()));
        parser.replaceToken("customer", OrderPanel.escapeHTML(order.getCustomer()));
        parser.replaceToken("phone", OrderPanel.escapeHTML(order.getPhone()));
        parser.replaceToken("mobile", OrderPanel.escapeHTML(order.getMobile()));
        parser.replaceToken("email", OrderPanel.escapeHTML(order.getEmail()));
        parser.replaceToken("address", OrderPanel.escapeHTML(order.getAddress()));
        parser.replaceToken("qtyToPack", Long.toString(order.getQtyToPack()));
        parser.replaceToken("qtyReadyForPickup", Long.toString(order.getTotalOutstandingQty() - order.getQtyToPack()));
        parser.replaceToken("carrier", OrderPanel.escapeHTML(order.getCarrier()));
        parser.replaceToken("serviceType", OrderPanel.escapeHTML(order.getServiceType()));
        parser.replaceToken("sla", OrderPanel.escapeHTML(order.getSLA()));
        this.browserControl.loadHTML(parser.toString());
    }

    public void clearOrder() {
        this.browserControl.loadHTML("<html />");
    }

    public static String escapeHTML(String string) {
        return string.replaceAll("&", "&amp;").replaceAll(">", "&gt;").replaceAll("<", "&lt;").replaceAll("\"", "&quot;").replaceAll("'", "&apos;").replaceAll("\n", "<br />");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String loadTemplate(String file) {
        StringBuffer fileData = new StringBuffer();
        try {
            InputStream is = fileData.getClass().getResource("/jpos/custorder/outstanding/" + file).openStream();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is));){
                String line = null;
                while ((line = reader.readLine()) != null) {
                    fileData.append(line);
                    fileData.append("\n");
                }
                String string = fileData.toString();
                return string;
            }
        }
        catch (Exception e) {
            PosUtils.logError(e);
            return "<html><body><span>Unable to load template.</span></body></html>";
        }
    }
}

